/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.types.lang;

import java.util.Iterator;
import kotlin.KotlinPackage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.CallableDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.annotations.Annotated;
import org.jetbrains.jet.lang.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.constants.ArrayValue;
import org.jetbrains.jet.lang.resolve.constants.CompileTimeConstant;
import org.jetbrains.jet.lang.resolve.constants.EnumValue;
import org.jetbrains.jet.lang.types.lang.InlineOption;
import org.jetbrains.jet.lang.types.lang.InlineStrategy;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;

public class InlineUtil {
    public static boolean hasNoinlineAnnotation(@NotNull CallableDescriptor valueParameterDescriptor) {
        if (valueParameterDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueParameterDescriptor", "org/jetbrains/jet/lang/types/lang/InlineUtil", "hasNoinlineAnnotation"));
        }
        return KotlinBuiltIns.containsAnnotation(valueParameterDescriptor, KotlinBuiltIns.getNoinlineClassAnnotationFqName());
    }

    @NotNull
    public static InlineStrategy getInlineType(@NotNull DeclarationDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/lang/types/lang/InlineUtil", "getInlineType"));
        }
        ClassDescriptor inlineAnnotation = KotlinBuiltIns.getInstance().getInlineClassAnnotation();
        AnnotationDescriptor annotation2 = descriptor.getAnnotations().findAnnotation(DescriptorUtils.getFqNameSafe(inlineAnnotation));
        if (annotation2 == null) {
            InlineStrategy inlineStrategy = InlineStrategy.NOT_INLINE;
            if (inlineStrategy == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/InlineUtil", "getInlineType"));
            }
            return inlineStrategy;
        }
        CompileTimeConstant<?> argument = InlineUtil.getAnnotationSingleArgument(descriptor, inlineAnnotation);
        if (argument == null) {
            InlineStrategy inlineStrategy = InlineStrategy.AS_FUNCTION;
            if (inlineStrategy == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/InlineUtil", "getInlineType"));
            }
            return inlineStrategy;
        }
        assert (argument instanceof EnumValue) : "Inline annotation parameter should be enum entry but was: " + argument;
        String name = ((EnumValue)argument).getValue().getName().asString();
        InlineStrategy inlineStrategy = name.equals(InlineStrategy.IN_PLACE.name()) ? InlineStrategy.IN_PLACE : InlineStrategy.AS_FUNCTION;
        if (inlineStrategy == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/InlineUtil", "getInlineType"));
        }
        return inlineStrategy;
    }

    public static boolean hasOnlyLocalContinueAndBreak(@NotNull ValueParameterDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/lang/types/lang/InlineUtil", "hasOnlyLocalContinueAndBreak"));
        }
        return InlineUtil.hasInlineOption(descriptor, InlineOption.LOCAL_CONTINUE_AND_BREAK);
    }

    public static boolean hasOnlyLocalReturn(@NotNull ValueParameterDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/lang/types/lang/InlineUtil", "hasOnlyLocalReturn"));
        }
        return InlineUtil.hasInlineOption(descriptor, InlineOption.ONLY_LOCAL_RETURN);
    }

    private static boolean hasInlineOption(@NotNull ValueParameterDescriptor descriptor, @NotNull InlineOption option) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/lang/types/lang/InlineUtil", "hasInlineOption"));
        }
        if (option == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "option", "org/jetbrains/jet/lang/types/lang/InlineUtil", "hasInlineOption"));
        }
        CompileTimeConstant<?> argument = InlineUtil.getAnnotationSingleArgument(descriptor, KotlinBuiltIns.getInstance().getInlineOptionsClassAnnotation());
        if (argument instanceof ArrayValue) {
            Object values = ((ArrayValue)argument).getValue();
            Iterator i$ = values.iterator();
            while (i$.hasNext()) {
                CompileTimeConstant value = (CompileTimeConstant)i$.next();
                if (!(value instanceof EnumValue) || !((EnumValue)value).getValue().getName().asString().equals(option.name())) continue;
                return true;
            }
        }
        return false;
    }

    @Nullable
    private static CompileTimeConstant<?> getAnnotationSingleArgument(@NotNull Annotated annotated, @NotNull ClassDescriptor annotationClass) {
        if (annotated == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotated", "org/jetbrains/jet/lang/types/lang/InlineUtil", "getAnnotationSingleArgument"));
        }
        if (annotationClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotationClass", "org/jetbrains/jet/lang/types/lang/InlineUtil", "getAnnotationSingleArgument"));
        }
        AnnotationDescriptor annotation2 = annotated.getAnnotations().findAnnotation(DescriptorUtils.getFqNameSafe(annotationClass));
        if (annotation2 != null) {
            return KotlinPackage.firstOrNull(annotation2.getAllValueArguments().values());
        }
        return null;
    }
}

