/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.types.typesApproximation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.KotlinPackage;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KObject;
import kotlin.jvm.internal.KotlinSyntheticClass;
import kotlin.reflect.jvm.internal.InternalPackage;
import kotlin.reflect.jvm.internal.KClassImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.annotations.Annotations;
import org.jetbrains.jet.lang.resolve.calls.inference.CapturedTypeConstructor;
import org.jetbrains.jet.lang.resolve.calls.inference.InferencePackage$CapturedTypeConstructor$704f7c7a;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.JetTypeImpl;
import org.jetbrains.jet.lang.types.LazyType;
import org.jetbrains.jet.lang.types.TypeConstructor;
import org.jetbrains.jet.lang.types.TypeProjection;
import org.jetbrains.jet.lang.types.TypeProjectionImpl;
import org.jetbrains.jet.lang.types.TypeSubstitution;
import org.jetbrains.jet.lang.types.TypeSubstitutor;
import org.jetbrains.jet.lang.types.TypeUtils;
import org.jetbrains.jet.lang.types.Variance;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;
import org.jetbrains.jet.lang.types.typesApproximation.ApproximationBounds;
import org.jetbrains.jet.lang.types.typesApproximation.TypeArgument;
import org.jetbrains.jet.lang.types.typesApproximation.TypesApproximationPackage$CapturedTypeApproximation$a539b880;
import org.jetbrains.jet.lang.types.typesApproximation.TypesApproximationPackage$CapturedTypeApproximation$a539b880$WhenMappings;
import org.jetbrains.jet.lang.types.typesApproximation.TypesApproximationPackage$CapturedTypeApproximation$a539b880$approximateCapturedTypes$1;
import org.jetbrains.jet.lang.types.typesApproximation.TypesApproximationPackage$CapturedTypeApproximation$a539b880$approximateCapturedTypesIfNecessary$1;
import org.jetbrains.jet.lang.types.typesApproximation.TypesApproximationPackage$CapturedTypeApproximation$a539b880$toTypeProjection$2;

@KotlinSyntheticClass(abiVersion=19, kind=KotlinSyntheticClass.Kind.PACKAGE_PART)
public final class TypesApproximationPackage$CapturedTypeApproximation$a539b880 {
    @NotNull
    static final JetType NULLABLE_ANY = KotlinBuiltIns.getInstance().getNullableAnyType();
    @NotNull
    static final JetType NOTHING = KotlinBuiltIns.getInstance().getNothingType();
    @NotNull
    static final JetType NULLABLE_NOTHING = KotlinBuiltIns.getInstance().getNullableNothingType();

    @NotNull
    public static final JetType getNULLABLE_ANY() {
        JetType jetType = NULLABLE_ANY;
        if (jetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/typesApproximation/TypesApproximationPackage$CapturedTypeApproximation$a539b880", "getNULLABLE_ANY"));
        }
        return jetType;
    }

    @NotNull
    public static final JetType getNOTHING() {
        JetType jetType = NOTHING;
        if (jetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/typesApproximation/TypesApproximationPackage$CapturedTypeApproximation$a539b880", "getNOTHING"));
        }
        return jetType;
    }

    @NotNull
    public static final JetType getNULLABLE_NOTHING() {
        JetType jetType = NULLABLE_NOTHING;
        if (jetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/typesApproximation/TypesApproximationPackage$CapturedTypeApproximation$a539b880", "getNULLABLE_NOTHING"));
        }
        return jetType;
    }

    @NotNull
    public static final TypeProjection toTypeProjection(@JetValueParameter(name="$receiver") TypeArgument $receiver) {
        TypeProjectionImpl typeProjectionImpl;
        boolean bl = $receiver.getIsConsistent();
        if (KotlinPackage.getASSERTIONS_ENABLED() && !bl) {
            String string = "Only consistent enhanced type propection can be converted to type projection";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        TypesApproximationPackage$CapturedTypeApproximation$a539b880$toTypeProjection$2 typesApproximationPackage$CapturedTypeApproximation$a539b880$toTypeProjection$2 = new TypesApproximationPackage$CapturedTypeApproximation$a539b880$toTypeProjection$2($receiver);
        if (Intrinsics.areEqual($receiver.getInProjection(), $receiver.getOutProjection())) {
            typeProjectionImpl = new TypeProjectionImpl($receiver.getInProjection());
        } else if ((!Intrinsics.areEqual($receiver.getInProjection(), NOTHING) ? Intrinsics.areEqual($receiver.getInProjection(), NULLABLE_NOTHING) : true) ? Intrinsics.areEqual($receiver.getTypeParameter().getVariance(), Variance.IN_VARIANCE) ^ true : false) {
            typeProjectionImpl = new TypeProjectionImpl(typesApproximationPackage$CapturedTypeApproximation$a539b880$toTypeProjection$2.invoke(Variance.OUT_VARIANCE), $receiver.getOutProjection());
        } else if (Intrinsics.areEqual($receiver.getOutProjection(), NULLABLE_ANY)) {
            typeProjectionImpl = new TypeProjectionImpl(typesApproximationPackage$CapturedTypeApproximation$a539b880$toTypeProjection$2.invoke(Variance.IN_VARIANCE), $receiver.getInProjection());
        } else {
            throw (Throwable)((Object)new AssertionError((Object)("Enhanced type projection can't be converted to type projection: " + $receiver)));
        }
        TypeProjection typeProjection = typeProjectionImpl;
        if (typeProjection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/typesApproximation/TypesApproximationPackage$CapturedTypeApproximation$a539b880", "toTypeProjection"));
        }
        return typeProjection;
    }

    @NotNull
    public static final TypeArgument toTypeArgument(@JetValueParameter(name="$receiver") TypeProjection $receiver, @JetValueParameter(name="typeParameter") @NotNull TypeParameterDescriptor typeParameter) {
        TypeArgument typeArgument;
        if (typeParameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeParameter", "org/jetbrains/jet/lang/types/typesApproximation/TypesApproximationPackage$CapturedTypeApproximation$a539b880", "toTypeArgument"));
        }
        Intrinsics.checkParameterIsNotNull(typeParameter, "typeParameter");
        Variance variance = TypeSubstitutor.combine(typeParameter.getVariance(), $receiver.getProjectionKind());
        Intrinsics.checkExpressionValueIsNotNull(variance, "TypeSubstitutor.combine(\u2026e(), getProjectionKind())");
        switch (TypesApproximationPackage$CapturedTypeApproximation$a539b880$WhenMappings.$EnumSwitchMapping$0[variance.ordinal()]) {
            case 1: {
                JetType jetType = $receiver.getType();
                Intrinsics.checkExpressionValueIsNotNull(jetType, "getType()");
                JetType jetType2 = $receiver.getType();
                Intrinsics.checkExpressionValueIsNotNull(jetType2, "getType()");
                typeArgument = new TypeArgument(typeParameter, jetType, jetType2);
                break;
            }
            case 2: {
                JetType jetType = $receiver.getType();
                Intrinsics.checkExpressionValueIsNotNull(jetType, "getType()");
                JetType jetType3 = NULLABLE_ANY;
                Intrinsics.checkExpressionValueIsNotNull(jetType3, "NULLABLE_ANY");
                typeArgument = new TypeArgument(typeParameter, jetType, jetType3);
                break;
            }
            case 3: {
                JetType jetType = NOTHING;
                Intrinsics.checkExpressionValueIsNotNull(jetType, "NOTHING");
                JetType jetType4 = $receiver.getType();
                Intrinsics.checkExpressionValueIsNotNull(jetType4, "getType()");
                typeArgument = new TypeArgument(typeParameter, jetType, jetType4);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        if (typeArgument == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/typesApproximation/TypesApproximationPackage$CapturedTypeApproximation$a539b880", "toTypeArgument"));
        }
        return typeArgument;
    }

    @Nullable
    public static final TypeProjection approximateCapturedTypesIfNecessary(@JetValueParameter(name="typeProjection", type="?") @Nullable TypeProjection typeProjection) {
        if (typeProjection == null) {
            return null;
        }
        JetType type2 = typeProjection.getType();
        if (type2 instanceof LazyType) {
            return typeProjection;
        }
        if (!TypeUtils.containsSpecialType(type2, TypesApproximationPackage$CapturedTypeApproximation$a539b880$approximateCapturedTypesIfNecessary$1.INSTANCE$)) {
            return typeProjection;
        }
        Variance howThisTypeIsUsed = typeProjection.getProjectionKind();
        if (Intrinsics.areEqual(howThisTypeIsUsed, Variance.OUT_VARIANCE)) {
            JetType jetType = type2;
            Intrinsics.checkExpressionValueIsNotNull(jetType, "type");
            ApproximationBounds<JetType> approximation = TypesApproximationPackage$CapturedTypeApproximation$a539b880.approximateCapturedTypes(jetType);
            return new TypeProjectionImpl(howThisTypeIsUsed, approximation.getUpper());
        }
        return TypesApproximationPackage$CapturedTypeApproximation$a539b880.substituteCapturedTypes(typeProjection);
    }

    @Nullable
    public static final TypeProjection substituteCapturedTypes(@JetValueParameter(name="typeProjection") @NotNull TypeProjection typeProjection) {
        if (typeProjection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeProjection", "org/jetbrains/jet/lang/types/typesApproximation/TypesApproximationPackage$CapturedTypeApproximation$a539b880", "substituteCapturedTypes"));
        }
        Intrinsics.checkParameterIsNotNull(typeProjection, "typeProjection");
        TypeSubstitutor typeSubstitutor2 = TypeSubstitutor.create((TypeSubstitution)((Object)new KObject(){
            public static final /* synthetic */ KClassImpl $kotlinClass;

            static {
                $kotlinClass = InternalPackage.kClassFromKotlin(substituteCapturedTypes.typeSubstitutor.1.class);
            }

            @Nullable
            public TypeProjection get(@JetValueParameter(name="typeConstructor", type="?") @Nullable TypeConstructor typeConstructor2) {
                TypeConstructor typeConstructor3 = typeConstructor2;
                if (!(typeConstructor3 instanceof CapturedTypeConstructor)) {
                    typeConstructor3 = null;
                }
                CapturedTypeConstructor capturedTypeConstructor = (CapturedTypeConstructor)typeConstructor3;
                return capturedTypeConstructor != null ? capturedTypeConstructor.getTypeProjection() : null;
            }

            public boolean isEmpty() {
                return false;
            }
        }));
        return typeSubstitutor2.substituteWithoutApproximation(typeProjection);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public static final ApproximationBounds<JetType> approximateCapturedTypes(@JetValueParameter(name="type") @NotNull JetType type2) {
        boolean bl;
        ArrayList<TypeArgument> upperBoundArguments;
        ArrayList<TypeArgument> lowerBoundArguments;
        block10: {
            if (type2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/jet/lang/types/typesApproximation/TypesApproximationPackage$CapturedTypeApproximation$a539b880", "approximateCapturedTypes"));
            }
            Intrinsics.checkParameterIsNotNull(type2, "type");
            TypeConstructor typeConstructor2 = type2.getConstructor();
            if (InferencePackage$CapturedTypeConstructor$704f7c7a.isCaptured(type2)) {
                ApproximationBounds<JetType> approximationBounds;
                TypeConstructor typeConstructor3 = typeConstructor2;
                if (typeConstructor3 == null) {
                    throw new TypeCastException("org.jetbrains.jet.lang.types.TypeConstructor! cannot be cast to org.jetbrains.jet.lang.resolve.calls.inference.CapturedTypeConstructor");
                }
                TypeProjection typeProjection = ((CapturedTypeConstructor)typeConstructor3).getTypeProjection();
                TypesApproximationPackage$CapturedTypeApproximation$a539b880$approximateCapturedTypes$1 typesApproximationPackage$CapturedTypeApproximation$a539b880$approximateCapturedTypes$1 = new TypesApproximationPackage$CapturedTypeApproximation$a539b880$approximateCapturedTypes$1(type2);
                JetType bound = typesApproximationPackage$CapturedTypeApproximation$a539b880$approximateCapturedTypes$1.invoke(typeProjection.getType());
                Variance variance = typeProjection.getProjectionKind();
                if (variance == null) throw (Throwable)((Object)new AssertionError((Object)("Only nontrivial projections should have been captured, not: " + typeProjection)));
                switch (TypesApproximationPackage$CapturedTypeApproximation$a539b880$WhenMappings.$EnumSwitchMapping$1[variance.ordinal()]) {
                    case 1: {
                        JetType jetType = bound;
                        Intrinsics.checkExpressionValueIsNotNull(jetType, "bound");
                        JetType jetType2 = NULLABLE_ANY;
                        Intrinsics.checkExpressionValueIsNotNull(jetType2, "NULLABLE_ANY");
                        approximationBounds = new ApproximationBounds<JetType>(jetType, jetType2);
                        break;
                    }
                    case 2: {
                        JetType jetType = typesApproximationPackage$CapturedTypeApproximation$a539b880$approximateCapturedTypes$1.invoke(NOTHING);
                        Intrinsics.checkExpressionValueIsNotNull(jetType, "NOTHING.makeNullableIfNeeded()");
                        JetType jetType3 = bound;
                        Intrinsics.checkExpressionValueIsNotNull(jetType3, "bound");
                        approximationBounds = new ApproximationBounds<JetType>(jetType, jetType3);
                        break;
                    }
                    default: {
                        throw (Throwable)((Object)new AssertionError((Object)("Only nontrivial projections should have been captured, not: " + typeProjection)));
                    }
                }
                if (approximationBounds != null) return approximationBounds;
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/typesApproximation/TypesApproximationPackage$CapturedTypeApproximation$a539b880", "approximateCapturedTypes"));
            }
            if (type2.getArguments().isEmpty()) {
                ApproximationBounds<JetType> approximationBounds = new ApproximationBounds<JetType>(type2, type2);
                if (approximationBounds != null) return approximationBounds;
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/typesApproximation/TypesApproximationPackage$CapturedTypeApproximation$a539b880", "approximateCapturedTypes"));
            }
            lowerBoundArguments = new ArrayList<TypeArgument>();
            upperBoundArguments = new ArrayList<TypeArgument>();
            Iterable iterable = type2.getArguments();
            Iterable iterable2 = typeConstructor2.getParameters();
            Intrinsics.checkExpressionValueIsNotNull(iterable2, "typeConstructor.getParameters()");
            for (Pair bound : KotlinPackage.zip(iterable, iterable2)) {
                TypeParameterDescriptor typeParameter;
                TypeProjection typeProjection = (TypeProjection)bound.component1();
                TypeParameterDescriptor typeParameterDescriptor = typeParameter = (TypeParameterDescriptor)bound.component2();
                Intrinsics.checkExpressionValueIsNotNull(typeParameterDescriptor, "typeParameter");
                ApproximationBounds<TypeArgument> approximationBounds = TypesApproximationPackage$CapturedTypeApproximation$a539b880.approximateProjection(TypesApproximationPackage$CapturedTypeApproximation$a539b880.toTypeArgument(typeProjection, typeParameterDescriptor));
                TypeArgument lower = approximationBounds.component1();
                TypeArgument upper = approximationBounds.component2();
                approximationBounds = null;
                lowerBoundArguments.add(lower);
                upperBoundArguments.add(upper);
            }
            Iterable iterable3 = lowerBoundArguments;
            Iterator iterator2 = iterable3.iterator();
            while (iterator2.hasNext()) {
                Object t = iterator2.next();
                TypeArgument it = (TypeArgument)t;
                if (!(!it.getIsConsistent())) continue;
                bl = true;
                break block10;
            }
            bl = false;
        }
        boolean lowerBoundIsTrivial = bl;
        JetType jetType = lowerBoundIsTrivial ? NOTHING : TypesApproximationPackage$CapturedTypeApproximation$a539b880.replaceTypeArguments(type2, (List<? extends TypeArgument>)lowerBoundArguments);
        Intrinsics.checkExpressionValueIsNotNull(jetType, "if (lowerBoundIsTrivial)\u2026ents(lowerBoundArguments)");
        ApproximationBounds<JetType> approximationBounds = new ApproximationBounds<JetType>(jetType, TypesApproximationPackage$CapturedTypeApproximation$a539b880.replaceTypeArguments(type2, (List<? extends TypeArgument>)upperBoundArguments));
        if (approximationBounds != null) return approximationBounds;
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/typesApproximation/TypesApproximationPackage$CapturedTypeApproximation$a539b880", "approximateCapturedTypes"));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final JetType replaceTypeArguments(@JetValueParameter(name="$receiver") JetType $receiver, @JetValueParameter(name="newTypeArguments") @NotNull List<? extends TypeArgument> newTypeArguments) {
        Collection<TypeProjection> collection;
        JetTypeImpl jetTypeImpl;
        boolean bl;
        if (newTypeArguments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newTypeArguments", "org/jetbrains/jet/lang/types/typesApproximation/TypesApproximationPackage$CapturedTypeApproximation$a539b880", "replaceTypeArguments"));
        }
        Intrinsics.checkParameterIsNotNull(newTypeArguments, "newTypeArguments");
        boolean bl2 = bl = $receiver.getArguments().size() == newTypeArguments.size();
        if (KotlinPackage.getASSERTIONS_ENABLED() && !bl) {
            String string = "Incorrect type arguments " + newTypeArguments;
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        Iterable iterable = newTypeArguments;
        boolean bl3 = $receiver.isMarkedNullable();
        TypeConstructor typeConstructor2 = $receiver.getConstructor();
        Annotations annotations2 = $receiver.getAnnotations();
        JetTypeImpl jetTypeImpl2 = jetTypeImpl;
        JetTypeImpl jetTypeImpl3 = jetTypeImpl;
        Iterable iterable2 = iterable;
        Collection collection2 = new ArrayList();
        for (Object t : iterable2) {
            void it;
            TypeArgument typeArgument = (TypeArgument)t;
            collection = collection2;
            TypeProjection typeProjection = TypesApproximationPackage$CapturedTypeApproximation$a539b880.toTypeProjection((TypeArgument)it);
            collection.add(typeProjection);
        }
        collection = (ArrayList)collection2;
        jetTypeImpl2(annotations2, typeConstructor2, bl3, (List<? extends TypeProjection>)collection, $receiver.getMemberScope());
        JetType jetType = jetTypeImpl3;
        if (jetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/typesApproximation/TypesApproximationPackage$CapturedTypeApproximation$a539b880", "replaceTypeArguments"));
        }
        return jetType;
    }

    @NotNull
    public static final ApproximationBounds<TypeArgument> approximateProjection(@JetValueParameter(name="typeArgument") @NotNull TypeArgument typeArgument) {
        if (typeArgument == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeArgument", "org/jetbrains/jet/lang/types/typesApproximation/TypesApproximationPackage$CapturedTypeApproximation$a539b880", "approximateProjection"));
        }
        Intrinsics.checkParameterIsNotNull(typeArgument, "typeArgument");
        ApproximationBounds<JetType> approximationBounds = TypesApproximationPackage$CapturedTypeApproximation$a539b880.approximateCapturedTypes(typeArgument.getInProjection());
        JetType inLower = approximationBounds.component1();
        JetType inUpper = approximationBounds.component2();
        JetType outLower = null;
        ApproximationBounds<JetType> approximationBounds2 = TypesApproximationPackage$CapturedTypeApproximation$a539b880.approximateCapturedTypes(typeArgument.getOutProjection());
        outLower = approximationBounds2.component1();
        JetType outUpper = approximationBounds2.component2();
        approximationBounds2 = null;
        ApproximationBounds<TypeArgument> approximationBounds3 = new ApproximationBounds<TypeArgument>(new TypeArgument(typeArgument.getTypeParameter(), inUpper, outLower), new TypeArgument(typeArgument.getTypeParameter(), inLower, outUpper));
        if (approximationBounds3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/typesApproximation/TypesApproximationPackage$CapturedTypeApproximation$a539b880", "approximateProjection"));
        }
        return approximationBounds3;
    }
}

