/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.plugin;

import com.intellij.util.NotNullFunction;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.psi.JetDeclaration;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.jet.lang.psi.JetNamedFunction;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.annotations.AnnotationsPackage;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.TypeProjection;
import org.jetbrains.jet.lang.types.checker.JetTypeChecker;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;

public class MainFunctionDetector {
    private final NotNullFunction<JetNamedFunction, FunctionDescriptor> getFunctionDescriptor;

    public MainFunctionDetector(final @NotNull BindingContext bindingContext) {
        if (bindingContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bindingContext", "org/jetbrains/jet/plugin/MainFunctionDetector", "<init>"));
        }
        this.getFunctionDescriptor = new NotNullFunction<JetNamedFunction, FunctionDescriptor>(){

            @Override
            @NotNull
            public FunctionDescriptor fun(JetNamedFunction function) {
                SimpleFunctionDescriptor functionDescriptor = bindingContext.get(BindingContext.FUNCTION, function);
                if (functionDescriptor == null) {
                    throw new IllegalStateException("No descriptor resolved for " + function + " " + function.getText());
                }
                SimpleFunctionDescriptor simpleFunctionDescriptor = functionDescriptor;
                if (simpleFunctionDescriptor == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/plugin/MainFunctionDetector$1", "fun"));
                }
                return simpleFunctionDescriptor;
            }
        };
    }

    public MainFunctionDetector(@NotNull NotNullFunction<JetNamedFunction, FunctionDescriptor> functionResolver) {
        if (functionResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionResolver", "org/jetbrains/jet/plugin/MainFunctionDetector", "<init>"));
        }
        this.getFunctionDescriptor = functionResolver;
    }

    public boolean hasMain(@NotNull List<JetDeclaration> declarations) {
        if (declarations == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declarations", "org/jetbrains/jet/plugin/MainFunctionDetector", "hasMain"));
        }
        return this.findMainFunction(declarations) != null;
    }

    public boolean isMain(@NotNull JetNamedFunction function) {
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "org/jetbrains/jet/plugin/MainFunctionDetector", "isMain"));
        }
        if (!"main".equals(function.getName())) {
            return false;
        }
        FunctionDescriptor functionDescriptor = this.getFunctionDescriptor.fun(function);
        List<ValueParameterDescriptor> parameters2 = functionDescriptor.getValueParameters();
        if (parameters2.size() != 1) {
            return false;
        }
        ValueParameterDescriptor parameter = parameters2.get(0);
        JetType parameterType = parameter.getType();
        KotlinBuiltIns kotlinBuiltIns = KotlinBuiltIns.getInstance();
        if (!KotlinBuiltIns.isArray(parameterType)) {
            return false;
        }
        List<TypeProjection> typeArguments = parameterType.getArguments();
        if (typeArguments.size() != 1) {
            return false;
        }
        JetType typeArgument = typeArguments.get(0).getType();
        if (!JetTypeChecker.DEFAULT.equalTypes(typeArgument, kotlinBuiltIns.getStringType())) {
            return false;
        }
        if (DescriptorUtils.isTopLevelDeclaration(functionDescriptor)) {
            return true;
        }
        DeclarationDescriptor containingDeclaration = functionDescriptor.getContainingDeclaration();
        return containingDeclaration instanceof ClassDescriptor && ((ClassDescriptor)containingDeclaration).getKind().isSingleton() && AnnotationsPackage.hasPlatformStaticAnnotation(functionDescriptor);
    }

    @Nullable
    public JetNamedFunction getMainFunction(@NotNull Collection<JetFile> files) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "org/jetbrains/jet/plugin/MainFunctionDetector", "getMainFunction"));
        }
        for (JetFile file : files) {
            JetNamedFunction mainFunction = this.findMainFunction(file.getDeclarations());
            if (mainFunction == null) continue;
            return mainFunction;
        }
        return null;
    }

    @Nullable
    private JetNamedFunction findMainFunction(@NotNull List<JetDeclaration> declarations) {
        if (declarations == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declarations", "org/jetbrains/jet/plugin/MainFunctionDetector", "findMainFunction"));
        }
        for (JetDeclaration declaration : declarations) {
            JetNamedFunction candidateFunction;
            if (!(declaration instanceof JetNamedFunction) || !this.isMain(candidateFunction = (JetNamedFunction)declaration)) continue;
            return candidateFunction;
        }
        return null;
    }
}

