/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.utils;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Processor;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.KotlinPackage;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KObject;
import kotlin.jvm.internal.KotlinClass;
import kotlin.platform.platformStatic;
import kotlin.reflect.jvm.internal.InternalPackage;
import kotlin.reflect.jvm.internal.KClassImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.utils.LibraryUtils;

@KotlinClass(abiVersion=19, data={"\"\u0010)aA*\u001b2sCJLX\u000b^5mg*\u0019qN]4\u000b\u0013),GO\u0019:bS:\u001c(b\u00016fi*)Q\u000f^5mg*\u0019\u0011I\\=\u000b\r-|G\u000f\\5o\u0015\u0019Q5kX#Y)*11\u000b\u001e:j]\u001eTAA[1wC*!A.\u00198h\u0015}Yu\n\u0016'J\u001d~S5kX'P\tVcUiX!U)JK%)\u0016+F?:\u000bU*\u0012\u0006\u0005\u001d\u0006lWM\u0003\u0006BiR\u0014\u0018NY;uKNTA!\u001e;jY*\u0019!.\u0019:\u000b\u001f\u0005#HO]5ckR,7\u000f\n(b[\u0016TQcS(U\u0019&suLS*`\u001b>#U\u000bT#`\u001d\u0006kUI\u0003\rhKR\\u\n\u0016'J\u001d~S5kX'P\tVcUi\u0018(B\u001b\u0016S1\u0001T(H\u0015\u0019aunZ4fe*\u00191m\\7\u000b\u0011%tG/\u001a7mS*Tqa\u001c9f]\u0006\u0004\u0018N\u0003\u0006eS\u0006<gn\\:uS\u000eTqc[8uY&tgF\u001b<n]Ac\u0017\r\u001e4pe6$\u0016\u0010]3\u000b\u001b5\u000be*\u0013$F'R{\u0006+\u0011+I\u0015\u001diU\tV!J\u001d\u001aS\u0011#T#U\u0003&sei\u0018*F'>+&kQ#T\u0015m!\u0016\n\u0016'F?.{E\u000bT%O?*\u000be+Q*D%&\u0003Fk\u0018'J\u0005*qB+\u0013+M\u000b~[u\n\u0016'J\u001d~S\u0015IV!T\u0007JK\u0005\u000bV0T)\u0012c\u0015J\u0011\u0006\u0014G\",7m[!uiJL'-\u001e;f-\u0006dW/\u001a\u0006\bY&\u0014'/\u0019:z\u0015\u00111\u0015\u000e\\3\u000b\u0005%|'\u0002C3ya\u0016\u001cG/\u001a3\u000b\u001b\u0005$HO]5ckR,g*Y7f\u0015\u001d\u0011un\u001c7fC:T\u0001dY8qs*\u001bh)\u001b7fg\u001a\u0013x.\u001c#je\u0016\u001cGo\u001c:z\u0015\r!\u0017N\u001d\u0006\u0014_V$\b/\u001e;MS\n\u0014\u0018M]=KgB\u000bG\u000f\u001b\u0006\u0005+:LGO\u0003\rd_BL(j\u001d$jY\u0016\u001chI]8n\u0019&\u0014'/\u0019:jKNT\u0011\u0002\\5ce\u0006\u0014\u0018.Z:\u000b\t1K7\u000f\u001e\u0006\u0013G>\u0004\u0018PS:GS2,7O\u0012:p[jK\u0007O\u0003\u0003gS2,'BC4fi*\u000b'OR5mK*a1\r\\1tg\u0016\u001c(k\\8ug*Ya+\u001b:uk\u0006dg)\u001b7f\u0015\r1hm\u001d\u0006\bU\u0006\u0014h*Y7f\u0015U9W\r^&pi2LgNS:N_\u0012,H.\u001a(b[\u0016T\u0001dZ3u\u001b\u0006t\u0017NZ3ti\u001a\u0013x.\u001c#je\u0016\u001cGo\u001c:z\u0015!i\u0015M\\5gKN$(BE4fi6\u000bg.\u001b4fgR4%o\\7KCJTQdZ3u\u001b\u0006t\u0017NZ3ti\u001a\u0013x.\u001c&be>\u0013H)\u001b:fGR|'/\u001f\u0006,O\u0016$X*\u00198jM\u0016\u001cH/T1j]\u0006#HO]5ckR,7O\u0012:p[*\u000b'o\u0014:ESJ,7\r^8ss*\u0001r-\u001a;Tk\u001e<Wm\u001d;fIB\u000bG\u000f\u001b\u0006\u0005a\u0006$\bNC\rjg.{G\u000f\\5o\u0015\u00064\u0018m]2sSB$H*\u001b2sCJL(\u0002H5t\u0017>$H.\u001b8KCZ\f7o\u0019:jaR\u001cF\u000f\u001a'jEJ\f'/\u001f\u0006\u0010iJ\fg/\u001a:tK\u0006\u00138\r[5wK*yBh\u00197bgNlsN\u00196fGRlcm\u001c:.\u0019&\u0014'/\u0019:z+RLGn\u001d k\u0004)\u0011\u0001#\u0001\u0006\u0005\u0011\u0001\u0001\"A\u0003\u0003\t\u0003A\u0019!\u0002\u0002\u0005\u0003!\u0011Qa\u0001C\u0002\u0011\u0001a\u0001!B\u0001\t\u0007\u0015\u0019AQ\u0001E\u0003\u0019\u0001)1\u0001\"\u0002\t\t1\u0001Q!\u0001E\u0005\u000b\t!A\u0001C\u0003\u0006\u0005\u0011%\u0001\u0002B\u0003\u0003\t\u0011Aq!\u0002\u0002\u0005\f!=Qa\u0001\u0003\u0007\u0011\u001ba\u0001!B\u0002\u0005\u000e!1A\u0002A\u0003\u0003\t\u0019A\u0001\"B\u0001\t\u0016\u0015\u0011A\u0001\u0003\u0005\f\u000b\t!\t\u0002c\u0006\u0006\u0005\u0011I\u0001\u0002D\u0003\u0004\t'A!\u0002\u0004\u0001\u0006\u0005\u0011M\u0001BC\u0003\u0003\t\u0011A\u0011#B\u0002\u0005\u0017!\u0005B\u0002A\u0003\u0004\t\u000bA)\u0003\u0004\u0001\u0006\u0005\u0011Y\u0001\u0012E\u0003\u0004\t\u000bAI\u0003\u0004\u0001\u0006\u0007\u0011\u0015\u0001B\u0006\u0007\u0001\u000b\t!Y\u0001\u0003\f\u0006\u0005\u0011I\u0001\"G\u0003\u0004\t;A\t\u0004\u0004\u0001\u0006\u0005\u0011u\u0001\u0012G\u0003\u0004\t\u0019A1\u0004\u0004\u0001\u0006\u0005\u00111\u0001bG\u0003\u0003\t\u0019Ai!B\u0002\u0005\u0005!}B\u0002\u0001\u0003d\u00031\u0011\u0011sBC\u0007\t\r\u000fA2E\r\u0003\u000b\u0005A!!\u000e\u0001\u001a\u0005\u0015\t\u0001bA\u0017\f\t\u0005$\u0002tA\u0011\u0003\u000b\u0005A9!V\u0002\u0005\u000b\r!9!C\u0001\t\u000b5ZA!\u0019\u0003\u0019\f\u0005\u0012Q!\u0001\u0005\b+\u000e!Qa\u0001C\u0006\u0013\u0005Ay!L\b\u0005GRA\n\"\t\u0002\u0006\u0003!\u001dQk\u0001\u0005\u0006\u0007\u0011E\u0011\"\u0001\u0005\u0006\u001b\r!\u0011\"C\u0001\t\u000b5\u0002B!\u0019\u0003\u0019\u0014\u0005:Q!\u0001\u0005\u000b!3)2!B\u0001\t\u00151\u0005Qk\u0001\u0003\u0006\u0007\u0011M\u0011\"\u0001E\u000b[-!\u0011\r\u0006\r\u000eC\t)\u0011\u0001c\u0002V\u0007\u0011)1\u0001B\u0007\n\u0003!)Qf\u0003\u0003b)am\u0011EA\u0003\u0002\u0011\u000f)6\u0001B\u0003\u0004\t7I\u0011\u0001C\u0003.\u0017\u0011\tG\u0003\u0007\b\"\u0005\u0015\t\u0001rA+\u0004\t\u0015\u0019AAD\u0005\u0002\u0011\u0015i3\u0002Ba\r1;\t#!B\u0001\t\bU\u001bA!B\u0002\u0005\u001e%\t\u0001\"B\u0017\f\t\u0005g\u0001dD\u0011\u0003\u000b\u0005A9!V\u0002\u0005\u000b\r!q\"C\u0001\t\u000b52C!\u0001M\u0010;\u001b!\u0001\u0001\u0003\t\u000e\u0005\u0015\t\u0001r\u0003)\u0004\u0001u5A\u0001\u0001E\u0012\u001b\t)\u0011\u0001c\u0002Q\u0007\u0003ij\u0001\u0002\u0001\t%5\u0011Q!\u0001\u0005\b!\u000e\t\u0011EA\u0003\u0002\u00111\t6!\u0003C\u0010\u0013\u0005!\t!D\u0001\t\u001a5\t\u0001\"B\u0007\u0002\u0011\u001fiK\u0004B\u0001\u0019'u5A\u0001\u0001E\u0014\u001b\t)\u0011\u0001c\u0006Q\u0007\u0001ij\u0001\u0002\u0001\t)5\u0011Q!\u0001E\u0004!\u000e\u0005\u0011EA\u0003\u0002\u00115\t6a\u0002\u0003\u0014\u0013\u0005!\u0001!D\u0001\t\u001a5\t\u0001\"BW!\t\u000fAR#(\u0006\u0005\u0001!-RBB\u0003\u0002\u00117I1!\u0003\u0002\u0006\u0003!\u001d\u0001k\u0001\u0001\u001e\u000e\u0011\u0001\u0001\u0002F\u0007\u0003\u000b\u0005A9\u0001UB\u0001C\t)\u0011\u0001C\u0007R\u0007\u001d!Q#C\u0001\u0005\u00015\t\u0001BD\u0007\u0002\u0011\u0015iK\u0004B\u0001\u0019.u5A\u0001\u0001\u0005\u0018\u001b\t)\u0011\u0001c\u0006Q\u0007\u0001ij\u0001\u0002\u0001\t)5\u0011Q!\u0001E\u0004!\u000e\u0005\u0011EA\u0003\u0002\u00115\t6a\u0002C\u0017\u0013\u0005!\u0001!D\u0001\t\u001a5\t\u0001\"BW\"\t\u000fAz#(\u0006\u0005\u0001!ARBB\u0003\u0002\u00117I1!\u0003\u0002\u0006\u0003!y\u0001k\u0001\u0001\u001e\u000e\u0011\u0001\u00012G\u0007\u0003\u000b\u0005A9\u0001UB\u0001C\r)\u0011\u0001C\b\r\u0002E\u001bq\u0001b\f\n\u0003!}Q\"\u0001\u0005\u000f\u001b\u0005AQ!\f\u000b\u0005\baQRT\u0002\u0003\u0001\u0011Ai!!B\u0001\t\u0018A\u001b\u0001!I\u0002\u0006\u0003!\u001dA\u0012A)\u0004\u000b\u0011Q\u0012\"\u0001\u0005\u0006\u001b\u0005AI\"\f\u000b\u0005\u0003aURT\u0002\u0003\u0001\u0011Ai!!B\u0001\t\u0018A\u001b\u0001!I\u0002\u0006\u0003!\u0001B\u0012A)\u0004\u000b\u0011U\u0012\"\u0001E\u0011\u001b\u0005AI\"\f\u000b\u0005\u0003a]RT\u0002\u0003\u0001\u0011Ai!!B\u0001\t\u0018A\u001b\u0001!I\u0002\u0006\u0003!\u0001B\u0012A)\u0004\u000b\u0011]\u0012\"\u0001E\u0011\u001b\u0005AI\"\f\u000b\u0005\u0003aaRT\u0002\u0003\u0001\u0011Ai!!B\u0001\t\u0018A\u001b\u0001!I\u0002\u0006\u0003!\u0001B\u0012A)\u0004\u000b\u0011a\u0012\"\u0001E\u0011\u001b\u0005AI\"\f\u000b\u0005\u0003aeRT\u0002\u0003\u0001\u0011Ai!!B\u0001\t\u0018A\u001b\u0001!I\u0002\u0006\u0003!5A\u0012A)\u0004\u000b\u0011e\u0012\"\u0001\u0005\u0012\u001b\u0005AI\"\f\u000b\u0005\u0003aiRT\u0002\u0003\u0001\u0011wi!!B\u0001\t\bA\u001b\u0001!I\u0002\u0006\u0003!\u001dA\u0012A)\u0004\u000b\u0011i\u0012\"\u0001\u0005\u0006\u001b\u0005AQ!L\n\u0005\baqRT\u0002\u0003\u0001\u0011Ai!!B\u0001\t\u0018A\u001b\u0001!\t\u0002\u0006\u0003!a\u0011kA\u0003\u0005=%\tA\u0011A\u0007\u0002\u00113i3\u0003b\u0002\u0019>u5A\u0001\u0001\u0005\u0011\u001b\t)\u0011\u0001c\u0006Q\u0007\u0001\t#!B\u0001\t\u0019E\u001bQ\u0001\"\u0010\n\u0003\u0011\u0005Q\"\u0001E\r[s!\u0019\u0001G\u0010\u001e\u000e\u0011\u0001\u0001bF\u0007\u0003\u000b\u0005A9\u0002U\u0002\u0001;\u001b!\u0001\u0001\u0003\u000b\u000e\u0005\u0015\t\u0001r\u0001)\u0004\u0002\u0005\u0012Q!\u0001\u0005\u000e#\u000e9AaH\u0005\u0002\t\u0001i\u0011\u0001#\u0007\u000e\u0003!)Q\u0007\u0001"})
public final class LibraryUtils
implements KObject {
    public static final /* synthetic */ KClassImpl $kotlinClass;
    private static final Logger LOG;
    @NotNull
    public static final String KOTLIN_JS_MODULE_NAME = "Kotlin-JS-Module-Name";
    private static String TITLE_KOTLIN_JAVASCRIPT_STDLIB;
    private static String TITLE_KOTLIN_JAVASCRIPT_LIB;
    private static final String JS_EXT = ".js";
    private static final String METAINF = "META-INF/";
    private static final String MANIFEST_PATH = "META-INF/MANIFEST.MF";
    private static final String METAINF_RESOURCES = "META-INF/resources/";
    private static final Attributes.Name KOTLIN_JS_MODULE_ATTRIBUTE_NAME;
    public static final LibraryUtils INSTANCE$;

    static {
        $kotlinClass = InternalPackage.kClassFromKotlin(LibraryUtils.class);
        new LibraryUtils();
    }

    @NotNull
    public final String getKOTLIN_JS_MODULE_NAME() {
        String string = KOTLIN_JS_MODULE_NAME;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/utils/LibraryUtils", "getKOTLIN_JS_MODULE_NAME"));
        }
        return string;
    }

    @platformStatic
    @Nullable
    public static final VirtualFile getJarFile(@JetValueParameter(name="classesRoots") @NotNull List<? extends VirtualFile> classesRoots, @JetValueParameter(name="jarName") @NotNull String jarName) {
        if (classesRoots == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classesRoots", "org/jetbrains/jet/utils/LibraryUtils", "getJarFile"));
        }
        if (jarName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jarName", "org/jetbrains/jet/utils/LibraryUtils", "getJarFile"));
        }
        Intrinsics.checkParameterIsNotNull(classesRoots, "classesRoots");
        Intrinsics.checkParameterIsNotNull(jarName, "jarName");
        for (VirtualFile virtualFile : classesRoots) {
            if (!Intrinsics.areEqual(virtualFile.getName(), jarName)) continue;
            return virtualFile;
        }
        return null;
    }

    @platformStatic
    @Nullable
    public static final String getKotlinJsModuleName(@JetValueParameter(name="library") @NotNull File library) {
        if (library == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "library", "org/jetbrains/jet/utils/LibraryUtils", "getKotlinJsModuleName"));
        }
        Intrinsics.checkParameterIsNotNull(library, "library");
        Attributes attributes = INSTANCE$.getManifestMainAttributesFromJarOrDirectory(library);
        return attributes != null ? attributes.getValue(KOTLIN_JS_MODULE_ATTRIBUTE_NAME) : null;
    }

    @platformStatic
    public static final boolean isKotlinJavascriptLibrary(@JetValueParameter(name="library") @NotNull File library) {
        if (library == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "library", "org/jetbrains/jet/utils/LibraryUtils", "isKotlinJavascriptLibrary"));
        }
        Intrinsics.checkParameterIsNotNull(library, "library");
        Attributes.Name name = Attributes.Name.SPECIFICATION_TITLE;
        Intrinsics.checkExpressionValueIsNotNull(name, "Attributes.Name.SPECIFICATION_TITLE");
        return INSTANCE$.checkAttributeValue(library, TITLE_KOTLIN_JAVASCRIPT_LIB, name);
    }

    @platformStatic
    public static final boolean isKotlinJavascriptStdLibrary(@JetValueParameter(name="library") @NotNull File library) {
        if (library == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "library", "org/jetbrains/jet/utils/LibraryUtils", "isKotlinJavascriptStdLibrary"));
        }
        Intrinsics.checkParameterIsNotNull(library, "library");
        Attributes.Name name = Attributes.Name.IMPLEMENTATION_TITLE;
        Intrinsics.checkExpressionValueIsNotNull(name, "Attributes.Name.IMPLEMENTATION_TITLE");
        return INSTANCE$.checkAttributeValue(library, TITLE_KOTLIN_JAVASCRIPT_STDLIB, name);
    }

    @platformStatic
    public static final void copyJsFilesFromLibraries(@JetValueParameter(name="libraries") @NotNull List<? extends String> libraries, @JetValueParameter(name="outputLibraryJsPath") @NotNull String outputLibraryJsPath) {
        if (libraries == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libraries", "org/jetbrains/jet/utils/LibraryUtils", "copyJsFilesFromLibraries"));
        }
        if (outputLibraryJsPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outputLibraryJsPath", "org/jetbrains/jet/utils/LibraryUtils", "copyJsFilesFromLibraries"));
        }
        Intrinsics.checkParameterIsNotNull(libraries, "libraries");
        Intrinsics.checkParameterIsNotNull(outputLibraryJsPath, "outputLibraryJsPath");
        for (String string : libraries) {
            File file = new File(string);
            boolean bl = file.exists();
            if (KotlinPackage.getASSERTIONS_ENABLED() && !bl) {
                String string2 = "Library " + string + " not found";
                throw (Throwable)((Object)new AssertionError((Object)string2));
            }
            if (file.isDirectory()) {
                INSTANCE$.copyJsFilesFromDirectory(file, outputLibraryJsPath);
                continue;
            }
            INSTANCE$.copyJsFilesFromZip(file, outputLibraryJsPath);
        }
    }

    private final void copyJsFilesFromDirectory(@JetValueParameter(name="dir") File dir, @JetValueParameter(name="outputLibraryJsPath") String outputLibraryJsPath) {
        FileUtil.processFilesRecursively(dir, new Processor<File>(dir, outputLibraryJsPath){
            public static final /* synthetic */ KClassImpl $kotlinClass;
            final /* synthetic */ File $dir;
            final /* synthetic */ String $outputLibraryJsPath;

            static {
                $kotlinClass = InternalPackage.kClassFromKotlin(copyJsFilesFromDirectory.1.class);
            }

            public boolean process(@JetValueParameter(name="file") @NotNull File file) {
                boolean bl;
                boolean bl2;
                if (file == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/jet/utils/LibraryUtils$copyJsFilesFromDirectory$1", "process"));
                }
                Intrinsics.checkParameterIsNotNull(file, "file");
                String relativePath = FileUtil.getRelativePath(this.$dir, file);
                boolean bl3 = bl2 = relativePath != null;
                if (KotlinPackage.getASSERTIONS_ENABLED() && !bl2) {
                    String string = "relativePath should not be null " + this.$dir + " " + file;
                    throw (Throwable)((Object)new AssertionError((Object)string));
                }
                if (file.isFile()) {
                    String string = relativePath;
                    if (string == null) {
                        Intrinsics.throwNpe();
                    }
                    bl = KotlinPackage.endsWith(string, LibraryUtils.getJS_EXT$b$1(LibraryUtils.INSTANCE$));
                } else {
                    bl = false;
                }
                if (bl) {
                    String string = relativePath;
                    Intrinsics.checkExpressionValueIsNotNull(string, "relativePath");
                    relativePath = LibraryUtils.getSuggestedPath$b$2(LibraryUtils.INSTANCE$, string);
                    if (relativePath == null) {
                        return true;
                    }
                    try {
                        File copyFile = new File(this.$outputLibraryJsPath, relativePath);
                        FileUtil.copy(file, copyFile);
                    }
                    catch (IOException ex) {
                        LibraryUtils.getLOG$b$0(LibraryUtils.INSTANCE$).error("Could not copy " + relativePath + " from " + this.$dir + ": " + ex.getMessage());
                    }
                }
                return true;
            }
            {
                this.$dir = $captured_local_variable$0;
                this.$outputLibraryJsPath = $captured_local_variable$1;
            }
        });
    }

    private final void copyJsFilesFromZip(@JetValueParameter(name="file") File file, @JetValueParameter(name="outputLibraryJsPath") String outputLibraryJsPath) {
        try {
            this.traverseArchive(file, outputLibraryJsPath);
        }
        catch (IOException ex) {
            LOG.error("Could not extract javascript files from  " + file.getName() + ": " + ex.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void traverseArchive(@JetValueParameter(name="file") File file, @JetValueParameter(name="outputLibraryJsPath") String outputLibraryJsPath) throws IOException {
        ZipFile zipFile = new ZipFile(file.getPath());
        try {
            Enumeration<? extends ZipEntry> zipEntries = zipFile.entries();
            while (zipEntries.hasMoreElements()) {
                ZipEntry entry = zipEntries.nextElement();
                String entryName = entry.getName();
                if (!(!entry.isDirectory() ? KotlinPackage.endsWith(entryName, JS_EXT) : false)) continue;
                String string = entryName;
                Intrinsics.checkExpressionValueIsNotNull(string, "entryName");
                String relativePath = this.getSuggestedPath(string);
                if (relativePath == null) continue;
                InputStream stream2 = zipFile.getInputStream(entry);
                String content = FileUtil.loadTextAndClose(stream2);
                File outputFile = new File(outputLibraryJsPath, relativePath);
                FileUtil.writeToFile(outputFile, content);
            }
        }
        finally {
            zipFile.close();
        }
    }

    private final String getSuggestedPath(@JetValueParameter(name="path") String path) {
        String systemIndependentPath = FileUtil.toSystemIndependentName(path);
        if (KotlinPackage.startsWith(systemIndependentPath, METAINF)) {
            if (KotlinPackage.startsWith(systemIndependentPath, METAINF_RESOURCES)) {
                return KotlinPackage.substring(path, METAINF_RESOURCES.length());
            }
            return null;
        }
        return path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Manifest getManifestFromJar(@JetValueParameter(name="library") File library) {
        if (!library.canRead()) {
            return null;
        }
        try {
            JarFile jarFile = new JarFile(library);
            try {
                Manifest manifest = jarFile.getManifest();
                return manifest;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                jarFile.close();
            }
        }
        catch (IOException ignored) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Manifest getManifestFromDirectory(@JetValueParameter(name="library") File library) {
        boolean bl = !(!library.canRead()) ? !library.isDirectory() : true;
        if (bl) {
            return null;
        }
        File manifestFile = new File(library, MANIFEST_PATH);
        if (!manifestFile.exists()) {
            return null;
        }
        try {
            FileInputStream inputStream = new FileInputStream(manifestFile);
            try {
                Manifest manifest = new Manifest(inputStream);
                return manifest;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                inputStream.close();
            }
        }
        catch (IOException ignored) {
            LOG.warn("IOException " + ignored);
            return null;
        }
    }

    private final Manifest getManifestFromJarOrDirectory(@JetValueParameter(name="library") File library) {
        return library.isDirectory() ? this.getManifestFromDirectory(library) : this.getManifestFromJar(library);
    }

    private final Attributes getManifestMainAttributesFromJarOrDirectory(@JetValueParameter(name="library") File library) {
        Manifest manifest = this.getManifestFromJarOrDirectory(library);
        return manifest != null ? manifest.getMainAttributes() : null;
    }

    private final boolean checkAttributeValue(@JetValueParameter(name="library") File library, @JetValueParameter(name="expected") String expected, @JetValueParameter(name="attributeName") Attributes.Name attributeName) {
        Attributes attributes;
        Attributes attributes2 = attributes = this.getManifestMainAttributesFromJarOrDirectory(library);
        String value = attributes2 != null ? attributes2.getValue(attributeName) : null;
        return value != null ? Intrinsics.areEqual(value, expected) : false;
    }

    LibraryUtils() {
        INSTANCE$ = this;
        LOG = Logger.getInstance(LibraryUtils.class);
        KOTLIN_JS_MODULE_NAME = KOTLIN_JS_MODULE_NAME;
        JS_EXT = JS_EXT;
        METAINF = METAINF;
        MANIFEST_PATH = METAINF + "MANIFEST.MF";
        METAINF_RESOURCES = METAINF + "resources/";
        KOTLIN_JS_MODULE_ATTRIBUTE_NAME = new Attributes.Name(KOTLIN_JS_MODULE_NAME);
        String jsStdLib = "";
        String jsLib = "";
        InputStream manifestProperties = LibraryUtils.class.getResourceAsStream("/manifest.properties");
        if (manifestProperties != null) {
            try {
                Properties properties2 = new Properties();
                properties2.load(manifestProperties);
                String string = properties2.getProperty("manifest.impl.title.kotlin.javascript.stdlib");
                Intrinsics.checkExpressionValueIsNotNull(string, "properties.getProperty(\"\u2026otlin.javascript.stdlib\")");
                jsStdLib = string;
                String string2 = properties2.getProperty("manifest.spec.title.kotlin.javascript.lib");
                Intrinsics.checkExpressionValueIsNotNull(string2, "properties.getProperty(\"\u2026e.kotlin.javascript.lib\")");
                jsLib = string2;
            }
            catch (IOException e) {
                LOG.error(e);
            }
        } else {
            LOG.error("Resource 'manifest.properties' not found.");
        }
        TITLE_KOTLIN_JAVASCRIPT_STDLIB = jsStdLib;
        TITLE_KOTLIN_JAVASCRIPT_LIB = jsLib;
    }

    @NotNull
    public static final /* synthetic */ Logger getLOG$b$0(@JetValueParameter(name="$this", type="?") LibraryUtils $this) {
        LibraryUtils libraryUtils = $this;
        Logger logger = LOG;
        if (logger == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/utils/LibraryUtils", "getLOG$b$0"));
        }
        return logger;
    }

    @NotNull
    public static final /* synthetic */ String getJS_EXT$b$1(@JetValueParameter(name="$this", type="?") LibraryUtils $this) {
        LibraryUtils libraryUtils = $this;
        String string = JS_EXT;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/utils/LibraryUtils", "getJS_EXT$b$1"));
        }
        return string;
    }

    @Nullable
    public static final /* synthetic */ String getSuggestedPath$b$2(@JetValueParameter(name="$this", type="?") LibraryUtils $this, @JetValueParameter(name="path") @NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "org/jetbrains/jet/utils/LibraryUtils", "getSuggestedPath$b$2"));
        }
        return $this.getSuggestedPath(path);
    }
}

