/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.analyze;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.analyzer.AnalysisResult;
import org.jetbrains.jet.context.ContextPackage;
import org.jetbrains.jet.context.GlobalContextImpl;
import org.jetbrains.jet.di.InjectorForTopDownAnalyzerForJs;
import org.jetbrains.jet.lang.PlatformToKotlinClassMap;
import org.jetbrains.jet.lang.descriptors.ModuleDescriptor;
import org.jetbrains.jet.lang.descriptors.impl.ModuleDescriptorImpl;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.jet.lang.resolve.AnalyzingUtils;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.BindingTraceContext;
import org.jetbrains.jet.lang.resolve.DelegatingBindingTrace;
import org.jetbrains.jet.lang.resolve.ImportPath;
import org.jetbrains.jet.lang.resolve.TopDownAnalysisParameters;
import org.jetbrains.jet.lang.resolve.lazy.declarations.FileBasedDeclarationProviderFactory;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;
import org.jetbrains.k2js.config.Config;

public final class TopDownAnalyzerFacadeForJS {
    public static final List<ImportPath> DEFAULT_IMPORTS = ImmutableList.of(new ImportPath("java.lang.*"), new ImportPath("kotlin.*"), new ImportPath("kotlin.js.*"));

    private TopDownAnalyzerFacadeForJS() {
    }

    @NotNull
    public static BindingContext analyzeFiles(@NotNull Collection<JetFile> files, @NotNull Config config) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "org/jetbrains/k2js/analyze/TopDownAnalyzerFacadeForJS", "analyzeFiles"));
        }
        if (config == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "config", "org/jetbrains/k2js/analyze/TopDownAnalyzerFacadeForJS", "analyzeFiles"));
        }
        BindingContext bindingContext = TopDownAnalyzerFacadeForJS.analyzeFiles(files, Predicates.<PsiFile>alwaysTrue(), config).getBindingContext();
        if (bindingContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/analyze/TopDownAnalyzerFacadeForJS", "analyzeFiles"));
        }
        return bindingContext;
    }

    @NotNull
    public static AnalysisResult analyzeFiles(@NotNull Collection<JetFile> files, @NotNull Predicate<PsiFile> filesToAnalyzeCompletely, @NotNull Config config) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "org/jetbrains/k2js/analyze/TopDownAnalyzerFacadeForJS", "analyzeFiles"));
        }
        if (filesToAnalyzeCompletely == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filesToAnalyzeCompletely", "org/jetbrains/k2js/analyze/TopDownAnalyzerFacadeForJS", "analyzeFiles"));
        }
        if (config == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "config", "org/jetbrains/k2js/analyze/TopDownAnalyzerFacadeForJS", "analyzeFiles"));
        }
        BindingContext libraryContext = config.getLibraryContext();
        BindingTrace trace = libraryContext == null ? new BindingTraceContext() : new DelegatingBindingTrace(libraryContext, "trace with preanalyzed library");
        ModuleDescriptorImpl module = TopDownAnalyzerFacadeForJS.createJsModule("<module>");
        module.addDependencyOnModule(module);
        module.addDependencyOnModule(KotlinBuiltIns.getInstance().getBuiltInsModule());
        ModuleDescriptor libraryModule = config.getLibraryModule();
        if (libraryModule != null) {
            module.addDependencyOnModule((ModuleDescriptorImpl)libraryModule);
        }
        module.seal();
        AnalysisResult analysisResult = TopDownAnalyzerFacadeForJS.analyzeFilesWithGivenTrace(files, trace, module, filesToAnalyzeCompletely, config);
        if (analysisResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/analyze/TopDownAnalyzerFacadeForJS", "analyzeFiles"));
        }
        return analysisResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static AnalysisResult analyzeFilesWithGivenTrace(@NotNull Collection<JetFile> files, @NotNull BindingTrace trace, @NotNull ModuleDescriptorImpl module, @NotNull Predicate<PsiFile> filesToAnalyzeCompletely, @NotNull Config config) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "org/jetbrains/k2js/analyze/TopDownAnalyzerFacadeForJS", "analyzeFilesWithGivenTrace"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/k2js/analyze/TopDownAnalyzerFacadeForJS", "analyzeFilesWithGivenTrace"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/k2js/analyze/TopDownAnalyzerFacadeForJS", "analyzeFilesWithGivenTrace"));
        }
        if (filesToAnalyzeCompletely == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filesToAnalyzeCompletely", "org/jetbrains/k2js/analyze/TopDownAnalyzerFacadeForJS", "analyzeFilesWithGivenTrace"));
        }
        if (config == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "config", "org/jetbrains/k2js/analyze/TopDownAnalyzerFacadeForJS", "analyzeFilesWithGivenTrace"));
        }
        Project project = config.getProject();
        Predicate<PsiFile> completely = Predicates.and(TopDownAnalyzerFacadeForJS.notLibFiles(config.getLibFiles()), filesToAnalyzeCompletely);
        GlobalContextImpl globalContext = ContextPackage.GlobalContext();
        TopDownAnalysisParameters topDownAnalysisParameters = TopDownAnalysisParameters.create(globalContext.getStorageManager(), globalContext.getExceptionTracker(), completely, false, false);
        Collection<JetFile> allFiles = config.getLibraryModule() != null ? files : Config.withJsLibAdded(files, config);
        InjectorForTopDownAnalyzerForJs injector = new InjectorForTopDownAnalyzerForJs(project, topDownAnalysisParameters, trace, module, new FileBasedDeclarationProviderFactory(topDownAnalysisParameters.getStorageManager(), allFiles));
        injector.getLazyTopDownAnalyzer().analyzeFiles(topDownAnalysisParameters, allFiles, Collections.emptyList());
        AnalysisResult analysisResult = AnalysisResult.success(trace.getBindingContext(), module);
        AnalysisResult analysisResult2 = analysisResult;
        if (analysisResult2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/analyze/TopDownAnalyzerFacadeForJS", "analyzeFilesWithGivenTrace"));
        }
        return analysisResult2;
        finally {
            injector.destroy();
        }
    }

    public static void checkForErrors(@NotNull Collection<JetFile> allFiles, @NotNull BindingContext bindingContext) {
        if (allFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "allFiles", "org/jetbrains/k2js/analyze/TopDownAnalyzerFacadeForJS", "checkForErrors"));
        }
        if (bindingContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bindingContext", "org/jetbrains/k2js/analyze/TopDownAnalyzerFacadeForJS", "checkForErrors"));
        }
        AnalyzingUtils.throwExceptionOnErrors(bindingContext);
        for (JetFile file : allFiles) {
            AnalyzingUtils.checkForSyntacticErrors(file);
        }
    }

    @NotNull
    private static Predicate<PsiFile> notLibFiles(final @NotNull List<JetFile> jsLibFiles) {
        if (jsLibFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jsLibFiles", "org/jetbrains/k2js/analyze/TopDownAnalyzerFacadeForJS", "notLibFiles"));
        }
        Predicate<PsiFile> predicate = new Predicate<PsiFile>(){

            @Override
            public boolean apply(@Nullable PsiFile file) {
                assert (file instanceof JetFile);
                boolean notLibFile = !jsLibFiles.contains(file);
                return notLibFile;
            }
        };
        if (predicate == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/analyze/TopDownAnalyzerFacadeForJS", "notLibFiles"));
        }
        return predicate;
    }

    @NotNull
    public static ModuleDescriptorImpl createJsModule(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/k2js/analyze/TopDownAnalyzerFacadeForJS", "createJsModule"));
        }
        ModuleDescriptorImpl moduleDescriptorImpl = new ModuleDescriptorImpl(Name.special(name), DEFAULT_IMPORTS, PlatformToKotlinClassMap.EMPTY);
        if (moduleDescriptorImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/analyze/TopDownAnalyzerFacadeForJS", "createJsModule"));
        }
        return moduleDescriptorImpl;
    }
}

