/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.callTranslator;

import com.google.dart.compiler.backend.js.ast.JsExpression;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.KotlinPackage;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinSyntheticClass;
import kotlin.test.TestPackage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.descriptors.CallableDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.VariableDescriptor;
import org.jetbrains.jet.lang.psi.Call;
import org.jetbrains.jet.lang.psi.JetElement;
import org.jetbrains.jet.lang.resolve.calls.CallResolverUtil;
import org.jetbrains.jet.lang.resolve.calls.model.ResolvedCall;
import org.jetbrains.jet.lang.resolve.calls.model.VariableAsFunctionResolvedCall;
import org.jetbrains.jet.lang.resolve.calls.tasks.ExplicitReceiverKind;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.k2js.translate.callTranslator.CallTranslator;
import org.jetbrains.k2js.translate.callTranslator.CallTranslatorPackage$CallInfo$0d17f0c0;
import org.jetbrains.k2js.translate.callTranslator.CallTranslatorPackage$CallTranslator$e336e694$computeExplicitReceiversForInvoke$1;
import org.jetbrains.k2js.translate.callTranslator.CallTranslatorPackage$FunctionCallCases$2e2eedb5;
import org.jetbrains.k2js.translate.callTranslator.ExplicitReceivers;
import org.jetbrains.k2js.translate.context.TranslationContext;

@KotlinSyntheticClass(abiVersion=19, kind=KotlinSyntheticClass.Kind.PACKAGE_PART)
public final class CallTranslatorPackage$CallTranslator$e336e694 {
    public static final boolean expectedReceivers(@JetValueParameter(name="$receiver") ResolvedCall<? extends CallableDescriptor> $receiver) {
        return Intrinsics.areEqual((Object)$receiver.getExplicitReceiverKind(), (Object)ExplicitReceiverKind.NO_EXPLICIT_RECEIVER) ^ true;
    }

    @NotNull
    public static final JsExpression translateCall(@JetValueParameter(name="context") @NotNull TranslationContext context2, @JetValueParameter(name="resolvedCall") @NotNull ResolvedCall<? extends FunctionDescriptor> resolvedCall, @JetValueParameter(name="explicitReceivers") @NotNull ExplicitReceivers explicitReceivers) {
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/callTranslator/CallTranslatorPackage$CallTranslator$e336e694", "translateCall"));
        }
        if (resolvedCall == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolvedCall", "org/jetbrains/k2js/translate/callTranslator/CallTranslatorPackage$CallTranslator$e336e694", "translateCall"));
        }
        if (explicitReceivers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "explicitReceivers", "org/jetbrains/k2js/translate/callTranslator/CallTranslatorPackage$CallTranslator$e336e694", "translateCall"));
        }
        Intrinsics.checkParameterIsNotNull(context2, "context");
        Intrinsics.checkParameterIsNotNull(resolvedCall, "resolvedCall");
        Intrinsics.checkParameterIsNotNull(explicitReceivers, "explicitReceivers");
        if (resolvedCall instanceof VariableAsFunctionResolvedCall) {
            KotlinPackage.assert(explicitReceivers.getExtensionReceiver() == null, "VariableAsFunctionResolvedCall must have one receiver");
            ResolvedCall<VariableDescriptor> variableCall = ((VariableAsFunctionResolvedCall)((Object)resolvedCall)).getVariableCall();
            if (CallTranslatorPackage$CallTranslator$e336e694.expectedReceivers(variableCall)) {
                JsExpression newReceiver = CallTranslator.INSTANCE$.translateGet(context2, variableCall, explicitReceivers.getExtensionOrDispatchReceiver());
                JsExpression jsExpression = CallTranslatorPackage$CallTranslator$e336e694.translateFunctionCall(context2, ((VariableAsFunctionResolvedCall)((Object)resolvedCall)).getFunctionCall(), new ExplicitReceivers(newReceiver, null, 2));
                if (jsExpression == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/callTranslator/CallTranslatorPackage$CallTranslator$e336e694", "translateCall"));
                }
                return jsExpression;
            }
            JsExpression dispatchReceiver = CallTranslator.INSTANCE$.translateGet(context2, variableCall, null);
            if (explicitReceivers.getExtensionOrDispatchReceiver() == null) {
                JsExpression jsExpression = CallTranslatorPackage$CallTranslator$e336e694.translateFunctionCall(context2, ((VariableAsFunctionResolvedCall)((Object)resolvedCall)).getFunctionCall(), new ExplicitReceivers(dispatchReceiver, null, 2));
                if (jsExpression == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/callTranslator/CallTranslatorPackage$CallTranslator$e336e694", "translateCall"));
                }
                return jsExpression;
            }
            JsExpression jsExpression = CallTranslatorPackage$CallTranslator$e336e694.translateFunctionCall(context2, ((VariableAsFunctionResolvedCall)((Object)resolvedCall)).getFunctionCall(), new ExplicitReceivers(dispatchReceiver, explicitReceivers.getExtensionOrDispatchReceiver()));
            if (jsExpression == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/callTranslator/CallTranslatorPackage$CallTranslator$e336e694", "translateCall"));
            }
            return jsExpression;
        }
        Call call = resolvedCall.getCall();
        boolean bl = Intrinsics.areEqual((Object)call.getCallType(), (Object)Call.CallType.INVOKE) ? !CallResolverUtil.isInvokeCallOnVariable(call) : false;
        if (bl) {
            ExplicitReceivers explicitReceiversForInvoke = CallTranslatorPackage$CallTranslator$e336e694.computeExplicitReceiversForInvoke(context2, resolvedCall, explicitReceivers);
            JsExpression jsExpression = CallTranslatorPackage$CallTranslator$e336e694.translateFunctionCall(context2, resolvedCall, explicitReceiversForInvoke);
            if (jsExpression == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/callTranslator/CallTranslatorPackage$CallTranslator$e336e694", "translateCall"));
            }
            return jsExpression;
        }
        JsExpression jsExpression = CallTranslatorPackage$CallTranslator$e336e694.translateFunctionCall(context2, resolvedCall, explicitReceivers);
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/callTranslator/CallTranslatorPackage$CallTranslator$e336e694", "translateCall"));
        }
        return jsExpression;
    }

    @NotNull
    public static final JsExpression translateFunctionCall(@JetValueParameter(name="context") @NotNull TranslationContext context2, @JetValueParameter(name="resolvedCall") @NotNull ResolvedCall<? extends FunctionDescriptor> resolvedCall, @JetValueParameter(name="explicitReceivers") @NotNull ExplicitReceivers explicitReceivers) {
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/callTranslator/CallTranslatorPackage$CallTranslator$e336e694", "translateFunctionCall"));
        }
        if (resolvedCall == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolvedCall", "org/jetbrains/k2js/translate/callTranslator/CallTranslatorPackage$CallTranslator$e336e694", "translateFunctionCall"));
        }
        if (explicitReceivers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "explicitReceivers", "org/jetbrains/k2js/translate/callTranslator/CallTranslatorPackage$CallTranslator$e336e694", "translateFunctionCall"));
        }
        Intrinsics.checkParameterIsNotNull(context2, "context");
        Intrinsics.checkParameterIsNotNull(resolvedCall, "resolvedCall");
        Intrinsics.checkParameterIsNotNull(explicitReceivers, "explicitReceivers");
        JsExpression jsExpression = CallTranslatorPackage$FunctionCallCases$2e2eedb5.translateFunctionCall(CallTranslatorPackage$CallInfo$0d17f0c0.getCallInfo(context2, resolvedCall, explicitReceivers));
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/callTranslator/CallTranslatorPackage$CallTranslator$e336e694", "translateFunctionCall"));
        }
        return jsExpression;
    }

    @NotNull
    public static final ExplicitReceivers computeExplicitReceiversForInvoke(@JetValueParameter(name="context") @NotNull TranslationContext context2, @JetValueParameter(name="resolvedCall") @NotNull ResolvedCall<? extends FunctionDescriptor> resolvedCall, @JetValueParameter(name="explicitReceivers") @NotNull ExplicitReceivers explicitReceivers) {
        ExplicitReceivers explicitReceivers2;
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/callTranslator/CallTranslatorPackage$CallTranslator$e336e694", "computeExplicitReceiversForInvoke"));
        }
        if (resolvedCall == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolvedCall", "org/jetbrains/k2js/translate/callTranslator/CallTranslatorPackage$CallTranslator$e336e694", "computeExplicitReceiversForInvoke"));
        }
        if (explicitReceivers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "explicitReceivers", "org/jetbrains/k2js/translate/callTranslator/CallTranslatorPackage$CallTranslator$e336e694", "computeExplicitReceiversForInvoke"));
        }
        Intrinsics.checkParameterIsNotNull(context2, "context");
        Intrinsics.checkParameterIsNotNull(resolvedCall, "resolvedCall");
        Intrinsics.checkParameterIsNotNull(explicitReceivers, "explicitReceivers");
        JetElement callElement = resolvedCall.getCall().getCallElement();
        KotlinPackage.assert(explicitReceivers.getExtensionReceiver() == null, "'Invoke' call must have one receiver: " + callElement);
        CallTranslatorPackage$CallTranslator$e336e694$computeExplicitReceiversForInvoke$1 callTranslatorPackage$CallTranslator$e336e694$computeExplicitReceiversForInvoke$1 = new CallTranslatorPackage$CallTranslator$e336e694$computeExplicitReceiversForInvoke$1(context2);
        ReceiverValue dispatchReceiver = resolvedCall.getDispatchReceiver();
        ReceiverValue extensionReceiver2 = resolvedCall.getExtensionReceiver();
        if (dispatchReceiver.exists() ? extensionReceiver2.exists() : false) {
            TestPackage.assertNotNull(explicitReceivers.getExtensionOrDispatchReceiver(), "No explicit receiver for 'invoke' resolved call with both receivers: " + callElement);
        } else {
            KotlinPackage.assert(explicitReceivers.getExtensionOrDispatchReceiver() == null, "Non trivial explicit receiver " + explicitReceivers.getExtensionOrDispatchReceiver() + "\n" + " for 'invoke' resolved call: " + callElement + "\n" + ("Dispatch receiver: " + dispatchReceiver + " Extension receiver: " + extensionReceiver2));
        }
        ReceiverValue receiverValue = dispatchReceiver;
        Intrinsics.checkExpressionValueIsNotNull(receiverValue, "dispatchReceiver");
        JsExpression dispatchReceiverExpression = callTranslatorPackage$CallTranslator$e336e694$computeExplicitReceiversForInvoke$1.invoke(receiverValue);
        Pair<Boolean, Boolean> pair = new Pair<Boolean, Boolean>(dispatchReceiver.exists(), extensionReceiver2.exists());
        if (Intrinsics.areEqual(pair, new Pair<Boolean, Boolean>(true, true))) {
            explicitReceivers2 = new ExplicitReceivers(dispatchReceiverExpression, explicitReceivers.getExtensionOrDispatchReceiver());
        } else if (Intrinsics.areEqual(pair, new Pair<Boolean, Boolean>(true, false))) {
            explicitReceivers2 = new ExplicitReceivers(dispatchReceiverExpression, null, 2);
        } else if (Intrinsics.areEqual(pair, new Pair<Boolean, Boolean>(false, true))) {
            ReceiverValue receiverValue2 = extensionReceiver2;
            Intrinsics.checkExpressionValueIsNotNull(receiverValue2, "extensionReceiver");
            explicitReceivers2 = new ExplicitReceivers(callTranslatorPackage$CallTranslator$e336e694$computeExplicitReceiversForInvoke$1.invoke(receiverValue2), null, 2);
        } else {
            throw (Throwable)((Object)new AssertionError((Object)("'Invoke' resolved call without receivers: " + callElement)));
        }
        if (explicitReceivers2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/callTranslator/CallTranslatorPackage$CallTranslator$e336e694", "computeExplicitReceiversForInvoke"));
        }
        return explicitReceivers2;
    }
}

