/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.utils;

import com.google.dart.compiler.backend.js.ast.JsBinaryOperation;
import com.google.dart.compiler.backend.js.ast.JsBlock;
import com.google.dart.compiler.backend.js.ast.JsExpression;
import com.google.dart.compiler.backend.js.ast.JsIf;
import com.google.dart.compiler.backend.js.ast.JsNameRef;
import com.google.dart.compiler.backend.js.ast.JsNode;
import com.google.dart.compiler.backend.js.ast.JsReturn;
import com.google.dart.compiler.backend.js.ast.JsStatement;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.psi.JetDeclarationWithBody;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;
import org.jetbrains.k2js.translate.context.TranslationContext;
import org.jetbrains.k2js.translate.general.AbstractTranslator;
import org.jetbrains.k2js.translate.general.Translation;
import org.jetbrains.k2js.translate.utils.BindingUtils;
import org.jetbrains.k2js.translate.utils.JsAstUtils;
import org.jetbrains.k2js.translate.utils.mutator.LastExpressionMutator;
import org.jetbrains.k2js.translate.utils.mutator.Mutator;

public final class FunctionBodyTranslator
extends AbstractTranslator {
    @NotNull
    private final FunctionDescriptor descriptor;
    @NotNull
    private final JetDeclarationWithBody declaration;

    @NotNull
    public static JsBlock translateFunctionBody(@NotNull FunctionDescriptor descriptor, @NotNull JetDeclarationWithBody declarationWithBody, @NotNull TranslationContext functionBodyContext) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/k2js/translate/utils/FunctionBodyTranslator", "translateFunctionBody"));
        }
        if (declarationWithBody == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declarationWithBody", "org/jetbrains/k2js/translate/utils/FunctionBodyTranslator", "translateFunctionBody"));
        }
        if (functionBodyContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionBodyContext", "org/jetbrains/k2js/translate/utils/FunctionBodyTranslator", "translateFunctionBody"));
        }
        JsBlock jsBlock = new FunctionBodyTranslator(descriptor, declarationWithBody, functionBodyContext).translate();
        if (jsBlock == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/utils/FunctionBodyTranslator", "translateFunctionBody"));
        }
        return jsBlock;
    }

    @NotNull
    public static List<JsStatement> setDefaultValueForArguments(@NotNull FunctionDescriptor descriptor, @NotNull TranslationContext functionBodyContext) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/k2js/translate/utils/FunctionBodyTranslator", "setDefaultValueForArguments"));
        }
        if (functionBodyContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionBodyContext", "org/jetbrains/k2js/translate/utils/FunctionBodyTranslator", "setDefaultValueForArguments"));
        }
        ArrayList<JsStatement> result2 = new ArrayList<JsStatement>();
        for (ValueParameterDescriptor valueParameter : descriptor.getValueParameters()) {
            if (!valueParameter.hasDefaultValue()) continue;
            JsNameRef jsNameRef = functionBodyContext.getNameForDescriptor(valueParameter).makeRef();
            JetExpression defaultArgument = BindingUtils.getDefaultArgument(valueParameter);
            JsBlock defaultArgBlock = new JsBlock();
            JsExpression defaultValue = Translation.translateAsExpression(defaultArgument, functionBodyContext, defaultArgBlock);
            JsStatement assignStatement = JsAstUtils.assignment(jsNameRef, defaultValue).makeStmt();
            JsStatement thenStatement = JsAstUtils.mergeStatementInBlockIfNeeded(assignStatement, defaultArgBlock);
            JsBinaryOperation checkArgIsUndefined = JsAstUtils.equality(jsNameRef, functionBodyContext.namer().getUndefinedExpression());
            JsIf jsIf = JsAstUtils.newJsIf(checkArgIsUndefined, thenStatement);
            result2.add(jsIf);
        }
        ArrayList<JsStatement> arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/utils/FunctionBodyTranslator", "setDefaultValueForArguments"));
        }
        return arrayList;
    }

    private FunctionBodyTranslator(@NotNull FunctionDescriptor descriptor, @NotNull JetDeclarationWithBody declaration, @NotNull TranslationContext context2) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/k2js/translate/utils/FunctionBodyTranslator", "<init>"));
        }
        if (declaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "org/jetbrains/k2js/translate/utils/FunctionBodyTranslator", "<init>"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/utils/FunctionBodyTranslator", "<init>"));
        }
        super(context2);
        this.descriptor = descriptor;
        this.declaration = declaration;
    }

    @NotNull
    private JsBlock translate() {
        JetExpression jetBodyExpression = this.declaration.getBodyExpression();
        assert (jetBodyExpression != null) : "Cannot translate a body of an abstract function.";
        JsBlock jsBlock = new JsBlock(FunctionBodyTranslator.setDefaultValueForArguments(this.descriptor, this.context()));
        jsBlock.getStatements().addAll(this.mayBeWrapWithReturn(Translation.translateExpression(jetBodyExpression, this.context(), jsBlock)).getStatements());
        JsBlock jsBlock2 = jsBlock;
        if (jsBlock2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/utils/FunctionBodyTranslator", "translate"));
        }
        return jsBlock2;
    }

    @NotNull
    private JsBlock mayBeWrapWithReturn(@NotNull JsNode body) {
        if (body == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "body", "org/jetbrains/k2js/translate/utils/FunctionBodyTranslator", "mayBeWrapWithReturn"));
        }
        if (!this.mustAddReturnToGeneratedFunctionBody()) {
            JsBlock jsBlock = JsAstUtils.convertToBlock(body);
            if (jsBlock == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/utils/FunctionBodyTranslator", "mayBeWrapWithReturn"));
            }
            return jsBlock;
        }
        JsBlock jsBlock = JsAstUtils.convertToBlock(FunctionBodyTranslator.lastExpressionReturned(body));
        if (jsBlock == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/utils/FunctionBodyTranslator", "mayBeWrapWithReturn"));
        }
        return jsBlock;
    }

    private boolean mustAddReturnToGeneratedFunctionBody() {
        JetType functionReturnType = this.descriptor.getReturnType();
        assert (functionReturnType != null) : "Function return typed type must be resolved.";
        return !this.declaration.hasBlockBody() && !KotlinBuiltIns.isUnit(functionReturnType);
    }

    @NotNull
    private static JsNode lastExpressionReturned(@NotNull JsNode body) {
        if (body == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "body", "org/jetbrains/k2js/translate/utils/FunctionBodyTranslator", "lastExpressionReturned"));
        }
        JsStatement jsStatement = LastExpressionMutator.mutateLastExpression(body, new Mutator(){

            @Override
            @NotNull
            public JsNode mutate(@NotNull JsNode node) {
                if (node == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/k2js/translate/utils/FunctionBodyTranslator$1", "mutate"));
                }
                if (!(node instanceof JsExpression)) {
                    JsNode jsNode = node;
                    if (jsNode == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/utils/FunctionBodyTranslator$1", "mutate"));
                    }
                    return jsNode;
                }
                JsReturn jsReturn = new JsReturn((JsExpression)node);
                if (jsReturn == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/utils/FunctionBodyTranslator$1", "mutate"));
                }
                return jsReturn;
            }
        });
        if (jsStatement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/utils/FunctionBodyTranslator", "lastExpressionReturned"));
        }
        return jsStatement;
    }
}

