/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.ExtensionsArea;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PluginManagerCoreProxy {
    @Nullable
    public static IdeaPluginDescriptorImpl loadDescriptorFromDir(@NotNull File file, @NotNull String fileName) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/ide/plugins/PluginManagerCoreProxy", "loadDescriptorFromDir"));
        }
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "com/intellij/ide/plugins/PluginManagerCoreProxy", "loadDescriptorFromDir"));
        }
        return PluginManagerCore.loadDescriptorFromDir(file, fileName);
    }

    @Nullable
    public static IdeaPluginDescriptorImpl loadDescriptorFromJar(@NotNull File file, @NotNull String fileName) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/ide/plugins/PluginManagerCoreProxy", "loadDescriptorFromJar"));
        }
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "com/intellij/ide/plugins/PluginManagerCoreProxy", "loadDescriptorFromJar"));
        }
        return PluginManagerCore.loadDescriptorFromJar(file, fileName);
    }

    public static void registerExtensionPointsAndExtensions(ExtensionsArea area, List<IdeaPluginDescriptorImpl> loadedPlugins) {
        for (IdeaPluginDescriptorImpl descriptor : loadedPlugins) {
            descriptor.registerExtensionPoints(area);
        }
        HashSet<String> epNames = ContainerUtil.newHashSet();
        for (ExtensionPoint point : area.getExtensionPoints()) {
            epNames.add(point.getName());
        }
        for (IdeaPluginDescriptorImpl descriptor : loadedPlugins) {
            for (String epName : epNames) {
                descriptor.registerExtensions(area, epName);
            }
        }
    }
}

