/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SingleRootFileViewProvider;
import com.intellij.psi.impl.PsiManagerImpl;
import com.intellij.psi.impl.file.impl.FileManager;
import com.intellij.util.containers.ConcurrentWeakValueHashMap;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class EmptyFileManager
implements FileManager {
    private final PsiManagerImpl myManager;
    private final ConcurrentWeakValueHashMap<VirtualFile, FileViewProvider> myVFileToViewProviderMap = new ConcurrentWeakValueHashMap();

    EmptyFileManager(PsiManagerImpl manager) {
        this.myManager = manager;
    }

    @Override
    public void dispose() {
    }

    @Override
    public PsiFile findFile(@NotNull VirtualFile vFile) {
        if (vFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vFile", "com/intellij/psi/impl/EmptyFileManager", "findFile"));
        }
        return null;
    }

    @Override
    public PsiDirectory findDirectory(@NotNull VirtualFile vFile) {
        if (vFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vFile", "com/intellij/psi/impl/EmptyFileManager", "findDirectory"));
        }
        return null;
    }

    @Override
    public void reloadFromDisk(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/EmptyFileManager", "reloadFromDisk"));
        }
    }

    @Override
    public PsiFile getCachedPsiFile(@NotNull VirtualFile vFile) {
        if (vFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vFile", "com/intellij/psi/impl/EmptyFileManager", "getCachedPsiFile"));
        }
        return null;
    }

    @Override
    public void cleanupForNextTest() {
        this.myVFileToViewProviderMap.clear();
    }

    @Override
    public FileViewProvider findViewProvider(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/EmptyFileManager", "findViewProvider"));
        }
        return (FileViewProvider)this.myVFileToViewProviderMap.get(file);
    }

    @Override
    public FileViewProvider findCachedViewProvider(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/EmptyFileManager", "findCachedViewProvider"));
        }
        return (FileViewProvider)this.myVFileToViewProviderMap.get(file);
    }

    @Override
    @NotNull
    public FileViewProvider createFileViewProvider(@NotNull VirtualFile file, boolean eventSystemEnabled) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/EmptyFileManager", "createFileViewProvider"));
        }
        SingleRootFileViewProvider singleRootFileViewProvider = new SingleRootFileViewProvider(this.myManager, file, eventSystemEnabled);
        if (singleRootFileViewProvider == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/EmptyFileManager", "createFileViewProvider"));
        }
        return singleRootFileViewProvider;
    }

    @Override
    public void setViewProvider(@NotNull VirtualFile virtualFile, FileViewProvider singleRootFileViewProvider) {
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/psi/impl/EmptyFileManager", "setViewProvider"));
        }
        if (!(virtualFile instanceof VirtualFileWindow)) {
            if (singleRootFileViewProvider == null) {
                this.myVFileToViewProviderMap.remove(virtualFile);
            } else {
                this.myVFileToViewProviderMap.put((Object)virtualFile, (Object)singleRootFileViewProvider);
            }
        }
    }

    @Override
    @NotNull
    public List<PsiFile> getAllCachedFiles() {
        List<PsiFile> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/EmptyFileManager", "getAllCachedFiles"));
        }
        return list;
    }
}

