/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.java.stubs.impl;

import com.intellij.psi.PsiMethod;
import com.intellij.psi.impl.cache.TypeInfo;
import com.intellij.psi.impl.compiled.StubBuildingVisitor;
import com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import com.intellij.psi.impl.java.stubs.PsiMethodStub;
import com.intellij.psi.impl.java.stubs.PsiParameterListStub;
import com.intellij.psi.impl.java.stubs.PsiParameterStub;
import com.intellij.psi.impl.java.stubs.impl.PsiModifierListStubImpl;
import com.intellij.psi.stubs.StubBase;
import com.intellij.psi.stubs.StubElement;
import com.intellij.util.BitUtil;
import com.intellij.util.cls.ClsFormatException;
import com.intellij.util.io.StringRef;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiMethodStubImpl
extends StubBase<PsiMethod>
implements PsiMethodStub {
    private final TypeInfo myReturnType;
    private final byte myFlags;
    private final StringRef myName;
    private StringRef myDefaultValueText;

    public PsiMethodStubImpl(StubElement parent, StringRef name, byte flags, String signature, @NotNull List<String> args, @Nullable List<String> throwables, String desc, int modifiersMask) {
        if (args == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "args", "com/intellij/psi/impl/java/stubs/impl/PsiMethodStubImpl", "<init>"));
        }
        super(parent, PsiMethodStubImpl.isAnnotationMethod(flags) ? JavaStubElementTypes.ANNOTATION_METHOD : JavaStubElementTypes.METHOD);
        this.myName = name;
        this.myDefaultValueText = null;
        new PsiModifierListStubImpl((StubElement)this, modifiersMask);
        String returnType = null;
        boolean parsedViaGenericSignature = false;
        if (signature != null) {
            try {
                returnType = StubBuildingVisitor.parseMethodViaGenericSignature(signature, this, args, throwables);
                parsedViaGenericSignature = true;
            }
            catch (ClsFormatException clsFormatException) {
                // empty catch block
            }
        }
        if (returnType == null) {
            returnType = StubBuildingVisitor.parseMethodViaDescription(desc, this, args);
        }
        this.myReturnType = TypeInfo.fromString(returnType);
        this.myFlags = (byte)(flags | (parsedViaGenericSignature ? 32 : 0));
    }

    public PsiMethodStubImpl(StubElement parent, StringRef name, @NotNull TypeInfo returnType, byte flags, StringRef defaultValueText) {
        if (returnType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "returnType", "com/intellij/psi/impl/java/stubs/impl/PsiMethodStubImpl", "<init>"));
        }
        super(parent, PsiMethodStubImpl.isAnnotationMethod(flags) ? JavaStubElementTypes.ANNOTATION_METHOD : JavaStubElementTypes.METHOD);
        this.myReturnType = returnType;
        this.myFlags = flags;
        this.myName = name;
        this.myDefaultValueText = defaultValueText;
    }

    @Override
    public boolean isConstructor() {
        return (this.myFlags & 1) != 0;
    }

    @Override
    public boolean isVarArgs() {
        return (this.myFlags & 2) != 0;
    }

    public boolean isParsedViaGenericSignature() {
        return BitUtil.isSet((int)this.myFlags, 32);
    }

    @Override
    public boolean isAnnotationMethod() {
        return PsiMethodStubImpl.isAnnotationMethod(this.myFlags);
    }

    public static boolean isAnnotationMethod(byte flags) {
        return (flags & 4) != 0;
    }

    @Override
    public String getDefaultValueText() {
        return StringRef.toString(this.myDefaultValueText);
    }

    @Override
    @NotNull
    public TypeInfo getReturnTypeText(boolean doResolve) {
        TypeInfo typeInfo = doResolve ? this.myReturnType.applyAnnotations(this) : this.myReturnType;
        if (typeInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/java/stubs/impl/PsiMethodStubImpl", "getReturnTypeText"));
        }
        return typeInfo;
    }

    @Override
    public boolean isDeprecated() {
        return (this.myFlags & 8) != 0;
    }

    @Override
    public boolean hasDeprecatedAnnotation() {
        return (this.myFlags & 0x10) != 0;
    }

    @Override
    public PsiParameterStub findParameter(int idx) {
        StubElement list = null;
        for (StubElement child : this.getChildrenStubs()) {
            if (!(child instanceof PsiParameterListStub)) continue;
            list = (PsiParameterListStub)child;
            break;
        }
        if (list != null) {
            List<StubElement> params = list.getChildrenStubs();
            return (PsiParameterStub)params.get(idx);
        }
        throw new RuntimeException("No parameter(s) [yet?]");
    }

    @Override
    public String getName() {
        return StringRef.toString(this.myName);
    }

    public byte getFlags() {
        return this.myFlags;
    }

    public void setDefaultValueText(String defaultValueText) {
        this.myDefaultValueText = StringRef.fromString(defaultValueText);
    }

    public static byte packFlags(boolean isConstructor, boolean isAnnotationMethod, boolean isVarargs, boolean isDeprecated, boolean hasDeprecatedAnnotation) {
        byte flags = 0;
        if (isConstructor) {
            flags = (byte)(flags | 1);
        }
        if (isAnnotationMethod) {
            flags = (byte)(flags | 4);
        }
        if (isVarargs) {
            flags = (byte)(flags | 2);
        }
        if (isDeprecated) {
            flags = (byte)(flags | 8);
        }
        if (hasDeprecatedAnnotation) {
            flags = (byte)(flags | 0x10);
        }
        return flags;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("PsiMethodStub[");
        if (this.isConstructor()) {
            builder.append("cons ");
        }
        if (this.isAnnotationMethod()) {
            builder.append("annotation ");
        }
        if (this.isVarArgs()) {
            builder.append("varargs ");
        }
        if (this.isDeprecated() || this.hasDeprecatedAnnotation()) {
            builder.append("deprecated ");
        }
        builder.append(this.myName).append(":").append(this.myReturnType);
        String defaultValue = this.getDefaultValueText();
        if (defaultValue != null) {
            builder.append(" default=").append(defaultValue);
        }
        builder.append("]");
        return builder.toString();
    }
}

