/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.diff;

import com.intellij.openapi.util.Ref;
import com.intellij.util.ThreeState;
import com.intellij.util.diff.DiffTreeChangeBuilder;
import com.intellij.util.diff.FlyweightCapableTreeStructure;
import com.intellij.util.diff.ShallowNodeComparator;
import java.util.ArrayList;
import java.util.List;

public class DiffTree<OT, NT> {
    private final FlyweightCapableTreeStructure<OT> myOldTree;
    private final FlyweightCapableTreeStructure<NT> myNewTree;
    private final ShallowNodeComparator<OT, NT> myComparator;
    private final DiffTreeChangeBuilder<OT, NT> myConsumer;
    private final List<Ref<OT[]>> myOldChildrenLists = new ArrayList<Ref<OT[]>>();
    private final List<Ref<NT[]>> myNewChildrenLists = new ArrayList<Ref<NT[]>>();

    private DiffTree(FlyweightCapableTreeStructure<OT> oldTree, FlyweightCapableTreeStructure<NT> newTree, ShallowNodeComparator<OT, NT> comparator2, DiffTreeChangeBuilder<OT, NT> consumer) {
        this.myOldTree = oldTree;
        this.myNewTree = newTree;
        this.myComparator = comparator2;
        this.myConsumer = consumer;
    }

    public static <OT, NT> void diff(FlyweightCapableTreeStructure<OT> oldTree, FlyweightCapableTreeStructure<NT> newTree, ShallowNodeComparator<OT, NT> comparator2, DiffTreeChangeBuilder<OT, NT> consumer) {
        super.build(oldTree.getRoot(), newTree.getRoot(), 0);
    }

    private void build(OT oldN, NT newN, int level) {
        OT oldNode = this.myOldTree.prepareForGetChildren(oldN);
        NT newNode = this.myNewTree.prepareForGetChildren(newN);
        if (level >= this.myNewChildrenLists.size()) {
            this.myNewChildrenLists.add(new Ref());
            this.myOldChildrenLists.add(new Ref());
        }
        Ref<T[]> oldChildrenR = this.myOldChildrenLists.get(level);
        int oldSize = this.myOldTree.getChildren(oldNode, oldChildrenR);
        T[] oldChildren = oldChildrenR.get();
        Ref<T[]> newChildrenR = this.myNewChildrenLists.get(level);
        int newSize = this.myNewTree.getChildren(newNode, newChildrenR);
        T[] newChildren = newChildrenR.get();
        this.compareLevel(level, oldNode, oldSize, oldChildren, newNode, newSize, newChildren);
        this.disposeLevel(oldChildren, oldSize, newChildren, newSize);
    }

    private void compareLevel(int level, OT oldNode, int oldSize, OT[] oldChildren, NT newNode, int newSize, NT[] newChildren) {
        NT newChild1;
        OT oldChild1;
        CompareResult c11;
        if (Math.abs(oldSize - newSize) > 20) {
            this.myConsumer.nodeReplaced(oldNode, newNode);
            return;
        }
        ShallowNodeComparator<OT, NT> comparator2 = this.myComparator;
        if (oldSize == 0 && newSize == 0) {
            if (!comparator2.hashCodesEqual(oldNode, newNode) || !comparator2.typesEqual(oldNode, newNode)) {
                this.myConsumer.nodeReplaced(oldNode, newNode);
            }
            return;
        }
        while (oldSize > 0 && newSize > 0 && ((c11 = this.looksEqual(comparator2, oldChild1 = oldChildren[oldSize - 1], newChild1 = newChildren[newSize - 1])) == CompareResult.EQUAL || c11 == CompareResult.DRILL_DOWN_NEEDED)) {
            if (c11 == CompareResult.DRILL_DOWN_NEEDED) {
                this.build(oldChild1, newChild1, level + 1);
            }
            --oldSize;
            --newSize;
        }
        int oldIndex = 0;
        int newIndex = 0;
        while (oldIndex < oldSize || newIndex < newSize) {
            Object oldChild12 = oldIndex < oldSize ? (Object)oldChildren[oldIndex] : null;
            OT oldChild2 = oldIndex < oldSize - 1 ? (OT)oldChildren[oldIndex + 1] : null;
            Object newChild12 = newIndex < newSize ? (Object)newChildren[newIndex] : null;
            NT newChild2 = newIndex < newSize - 1 ? (NT)newChildren[newIndex + 1] : null;
            CompareResult c112 = this.looksEqual(comparator2, oldChild12, newChild12);
            if (c112 == CompareResult.EQUAL || c112 == CompareResult.DRILL_DOWN_NEEDED) {
                if (c112 == CompareResult.DRILL_DOWN_NEEDED) {
                    this.build(oldChild12, newChild12, level + 1);
                }
                ++oldIndex;
                ++newIndex;
                continue;
            }
            if (c112 == CompareResult.TYPE_ONLY) {
                CompareResult c21 = this.looksEqual(comparator2, oldChild2, newChild12);
                if (c21 == CompareResult.EQUAL || c21 == CompareResult.DRILL_DOWN_NEEDED) {
                    this.myConsumer.nodeDeleted(oldNode, oldChild12);
                    ++oldIndex;
                    continue;
                }
                CompareResult c12 = this.looksEqual(comparator2, oldChild12, newChild2);
                if (c12 == CompareResult.EQUAL || c12 == CompareResult.DRILL_DOWN_NEEDED) {
                    this.myConsumer.nodeInserted(oldNode, newChild12, newIndex);
                    ++newIndex;
                    continue;
                }
                this.myConsumer.nodeReplaced(oldChild12, newChild12);
                ++oldIndex;
                ++newIndex;
                continue;
            }
            CompareResult c12 = this.looksEqual(comparator2, oldChild12, newChild2);
            if (c12 == CompareResult.EQUAL || c12 == CompareResult.DRILL_DOWN_NEEDED || c12 == CompareResult.TYPE_ONLY) {
                this.myConsumer.nodeInserted(oldNode, newChild12, newIndex);
                ++newIndex;
                continue;
            }
            CompareResult c21 = this.looksEqual(comparator2, oldChild2, newChild12);
            if (c21 == CompareResult.EQUAL || c21 == CompareResult.DRILL_DOWN_NEEDED || c21 == CompareResult.TYPE_ONLY) {
                this.myConsumer.nodeDeleted(oldNode, oldChild12);
                ++oldIndex;
                continue;
            }
            if (oldChild12 == null) {
                this.myConsumer.nodeInserted(oldNode, newChild12, newIndex);
                ++newIndex;
                continue;
            }
            if (newChild12 == null) {
                this.myConsumer.nodeDeleted(oldNode, oldChild12);
                ++oldIndex;
                continue;
            }
            this.myConsumer.nodeReplaced(oldChild12, newChild12);
            ++oldIndex;
            ++newIndex;
        }
    }

    private CompareResult looksEqual(ShallowNodeComparator<OT, NT> comparator2, OT oldChild1, NT newChild1) {
        if (oldChild1 == null || newChild1 == null) {
            return oldChild1 == newChild1 ? CompareResult.EQUAL : CompareResult.NOT_EQUAL;
        }
        if (!comparator2.typesEqual(oldChild1, newChild1)) {
            return CompareResult.NOT_EQUAL;
        }
        ThreeState ret = comparator2.deepEqual(oldChild1, newChild1);
        if (ret == ThreeState.YES) {
            return CompareResult.EQUAL;
        }
        if (ret == ThreeState.UNSURE) {
            return CompareResult.DRILL_DOWN_NEEDED;
        }
        return CompareResult.TYPE_ONLY;
    }

    private void disposeLevel(OT[] oldChildren, int oldSize, NT[] newChildren, int newSize) {
        this.myOldTree.disposeChildren(oldChildren, oldSize);
        this.myNewTree.disposeChildren(newChildren, newSize);
    }

    private static enum CompareResult {
        EQUAL,
        DRILL_DOWN_NEEDED,
        TYPE_ONLY,
        NOT_EQUAL;

    }
}

