/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.lang;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.win32.IdeaWin32;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.lang.ClassPath;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sun.misc.Resource;

public class UrlClassLoader
extends ClassLoader {
    private final List<URL> myURLs;
    private final ClassPath myClassPath;
    private final boolean myAllowBootstrapResources;

    public static Builder build() {
        return new Builder();
    }

    protected UrlClassLoader(@NotNull Builder builder) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/util/lang/UrlClassLoader", "<init>"));
        }
        super(builder.myParent);
        this.myURLs = ContainerUtil.map(builder.myURLs, new Function<URL, URL>(){

            @Override
            public URL fun(URL url) {
                return UrlClassLoader.internProtocol(url);
            }
        });
        this.myClassPath = new ClassPath(this.myURLs, builder.myLockJars, builder.myUseCache, builder.myAcceptUnescaped, builder.myPreload);
        this.myAllowBootstrapResources = builder.myAllowBootstrapResources;
    }

    public static URL internProtocol(@NotNull URL url) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/util/lang/UrlClassLoader", "internProtocol"));
        }
        try {
            String protocol = url.getProtocol();
            if ("file".equals(protocol) || "jar".equals(protocol)) {
                return new URL(protocol.intern(), url.getHost(), url.getPort(), url.getFile());
            }
            return url;
        }
        catch (MalformedURLException e) {
            Logger.getInstance(UrlClassLoader.class).error(e);
            return null;
        }
    }

    protected Class findClass(String name) throws ClassNotFoundException {
        Resource res = this.myClassPath.getResource(name.replace('.', '/').concat(".class"), false);
        if (res == null) {
            throw new ClassNotFoundException(name);
        }
        try {
            return this.defineClass(name, res);
        }
        catch (IOException e) {
            throw new ClassNotFoundException(name, e);
        }
    }

    @Nullable
    protected Class _findClass(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/util/lang/UrlClassLoader", "_findClass"));
        }
        Resource res = this.myClassPath.getResource(name.replace('.', '/').concat(".class"), false);
        if (res == null) {
            return null;
        }
        try {
            return this.defineClass(name, res);
        }
        catch (IOException e) {
            return null;
        }
    }

    private Class defineClass(String name, Resource res) throws IOException {
        String pkgName;
        Package pkg;
        int i = name.lastIndexOf(46);
        if (i != -1 && (pkg = this.getPackage(pkgName = name.substring(0, i))) == null) {
            try {
                this.definePackage(pkgName, null, null, null, null, null, null, null);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        byte[] b = res.getBytes();
        return this._defineClass(name, b);
    }

    protected Class _defineClass(String name, byte[] b) {
        return this.defineClass(name, b, 0, b.length);
    }

    @Override
    @Nullable
    public URL findResource(String name) {
        return this.findResourceImpl(name);
    }

    protected URL findResourceImpl(String name) {
        Resource res = this._getResource(name);
        return res != null ? res.getURL() : null;
    }

    @Nullable
    private Resource _getResource(String name) {
        String n = name;
        if (n.startsWith("/")) {
            n = n.substring(1);
        }
        return this.myClassPath.getResource(n, true);
    }

    @Override
    @Nullable
    public InputStream getResourceAsStream(String name) {
        if (this.myAllowBootstrapResources) {
            return super.getResourceAsStream(name);
        }
        try {
            Resource res = this._getResource(name);
            if (res == null) {
                return null;
            }
            return res.getInputStream();
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    protected Enumeration<URL> findResources(String name) throws IOException {
        return this.myClassPath.getResources(name, true);
    }

    public static void loadPlatformLibrary(@NotNull String libName) {
        if (libName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libName", "com/intellij/util/lang/UrlClassLoader", "loadPlatformLibrary"));
        }
        String libFileName = UrlClassLoader.mapLibraryName(libName);
        String libPath = PathManager.getBinPath() + "/" + libFileName;
        if (!new File(libPath).exists()) {
            String platform = UrlClassLoader.getPlatformName();
            libPath = PathManager.getHomePath() + "/community/bin/" + platform + libFileName;
            if (!(new File(libPath).exists() || new File(libPath = PathManager.getHomePath() + "/bin/" + platform + libFileName).exists() || new File(libPath = PathManager.getHomePathFor(IdeaWin32.class) + "/bin/" + libFileName).exists())) {
                File libDir = new File(PathManager.getBinPath());
                throw new UnsatisfiedLinkError("'" + libFileName + "' not found in '" + libDir + "' among " + Arrays.toString(libDir.list()));
            }
        }
        System.load(libPath);
    }

    private static String mapLibraryName(String libName) {
        String baseName = libName;
        if (SystemInfo.is64Bit) {
            baseName = baseName.replace("32", "") + "64";
        }
        String fileName = System.mapLibraryName(baseName);
        if (SystemInfo.isMac) {
            fileName = fileName.replace(".jnilib", ".dylib");
        }
        return fileName;
    }

    private static String getPlatformName() {
        if (SystemInfo.isWindows) {
            return "win/";
        }
        if (SystemInfo.isMac) {
            return "mac/";
        }
        if (SystemInfo.isLinux) {
            return "linux/";
        }
        return "";
    }

    static {
        boolean parallelLoader = Boolean.parseBoolean(System.getProperty("idea.parallel.class.loader", "false"));
        if (parallelLoader) {
            try {
                Method registerAsParallelCapable = ClassLoader.class.getDeclaredMethod("registerAsParallelCapable", new Class[0]);
                registerAsParallelCapable.setAccessible(true);
                registerAsParallelCapable.invoke(null, new Object[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static final class Builder {
        private List<URL> myURLs = ContainerUtil.emptyList();
        private ClassLoader myParent = null;
        private boolean myLockJars = false;
        private boolean myUseCache = false;
        private boolean myAcceptUnescaped = false;
        private boolean myPreload = true;
        private boolean myAllowBootstrapResources = false;

        private Builder() {
        }

        public Builder urls(List<URL> urls) {
            this.myURLs = urls;
            return this;
        }

        public Builder allowLock() {
            this.myLockJars = true;
            return this;
        }

        public Builder useCache() {
            this.myUseCache = true;
            return this;
        }
    }
}

