/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.asJava;

import com.intellij.lang.Language;
import com.intellij.psi.PsiAnnotationOwner;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiParameter;
import com.intellij.util.ArrayUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.KotlinLightElement;
import org.jetbrains.kotlin.asJava.KotlinLightMethod;
import org.jetbrains.kotlin.asJava.KotlinLightModifierList;
import org.jetbrains.kotlin.asJava.LightParameter;
import org.jetbrains.kotlin.idea.JetLanguage;
import org.jetbrains.kotlin.psi.JetClass;
import org.jetbrains.kotlin.psi.JetNamedFunction;
import org.jetbrains.kotlin.psi.JetParameter;
import org.jetbrains.kotlin.psi.JetProperty;
import org.jetbrains.kotlin.psi.JetPropertyAccessor;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilPackage;

public class KotlinLightParameter
extends LightParameter
implements KotlinLightElement<JetParameter, PsiParameter> {
    private final PsiModifierList modifierList;
    private final PsiParameter delegate;
    private final int index;
    private final KotlinLightMethod method;

    private static String getName(PsiParameter delegate2, int index2) {
        String name = delegate2.getName();
        return name != null ? name : "p" + index2;
    }

    public KotlinLightParameter(final PsiParameter delegate2, int index2, KotlinLightMethod method) {
        super(KotlinLightParameter.getName(delegate2, index2), delegate2.getType(), method, (Language)JetLanguage.INSTANCE);
        this.delegate = delegate2;
        this.index = index2;
        this.method = method;
        this.modifierList = new KotlinLightModifierList(method.getManager(), ArrayUtil.EMPTY_STRING_ARRAY){

            @Override
            public PsiAnnotationOwner getDelegate() {
                return delegate2.getModifierList();
            }
        };
    }

    @Override
    @NotNull
    public PsiModifierList getModifierList() {
        PsiModifierList psiModifierList = this.modifierList;
        if (psiModifierList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/asJava/KotlinLightParameter", "getModifierList"));
        }
        return psiModifierList;
    }

    @Override
    @NotNull
    public PsiParameter getDelegate() {
        PsiParameter psiParameter = this.delegate;
        if (psiParameter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/asJava/KotlinLightParameter", "getDelegate"));
        }
        return psiParameter;
    }

    @Override
    @Nullable
    public JetParameter getOrigin() {
        int jetIndex;
        Object declaration = this.method.getOrigin();
        if (declaration == null) {
            return null;
        }
        int n = jetIndex = PsiUtilPackage.isExtensionDeclaration(declaration) ? this.index - 1 : this.index;
        if (jetIndex < 0) {
            return null;
        }
        if (declaration instanceof JetNamedFunction) {
            List<JetParameter> paramList = ((JetNamedFunction)declaration).getValueParameters();
            return jetIndex < paramList.size() ? paramList.get(jetIndex) : null;
        }
        if (declaration instanceof JetClass) {
            List<JetParameter> paramList = ((JetClass)declaration).getPrimaryConstructorParameters();
            return jetIndex < paramList.size() ? paramList.get(jetIndex) : null;
        }
        if (jetIndex != 0) {
            return null;
        }
        JetPropertyAccessor setter = null;
        if (declaration instanceof JetPropertyAccessor) {
            JetPropertyAccessor accessor = (JetPropertyAccessor)declaration;
            setter = accessor.isSetter() ? accessor : null;
        } else if (declaration instanceof JetProperty) {
            setter = ((JetProperty)declaration).getSetter();
        }
        return setter != null ? setter.getParameter() : null;
    }

    @Override
    @NotNull
    public Language getLanguage() {
        JetLanguage jetLanguage = JetLanguage.INSTANCE;
        if (jetLanguage == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/asJava/KotlinLightParameter", "getLanguage"));
        }
        return jetLanguage;
    }
}

