/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen;

import com.intellij.psi.tree.IElementType;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import kotlin.Function1;
import kotlin.Unit;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.PrimitiveType;
import org.jetbrains.kotlin.codegen.ArgumentGenerator;
import org.jetbrains.kotlin.codegen.AsmUtil;
import org.jetbrains.kotlin.codegen.Callable;
import org.jetbrains.kotlin.codegen.CallableMethod;
import org.jetbrains.kotlin.codegen.CoercionValue;
import org.jetbrains.kotlin.codegen.ExpressionCodegen;
import org.jetbrains.kotlin.codegen.FieldInfo;
import org.jetbrains.kotlin.codegen.FrameMap;
import org.jetbrains.kotlin.codegen.FunctionCallStackValue;
import org.jetbrains.kotlin.codegen.OperationStackValue;
import org.jetbrains.kotlin.codegen.intrinsics.IntrinsicMethod;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.kotlin.codegen.state.JetTypeMapper;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.lexer.JetTokens;
import org.jetbrains.kotlin.psi.JetArrayAccessExpression;
import org.jetbrains.kotlin.psi.JetExpression;
import org.jetbrains.kotlin.resolve.annotations.AnnotationsPackage;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedValueArgument;
import org.jetbrains.kotlin.resolve.jvm.AsmTypes;
import org.jetbrains.kotlin.resolve.jvm.jvmSignature.JvmMethodParameterKind;
import org.jetbrains.kotlin.resolve.jvm.jvmSignature.JvmMethodParameterSignature;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.org.objectweb.asm.Label;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.commons.InstructionAdapter;
import org.jetbrains.org.objectweb.asm.commons.Method;

public abstract class StackValue {
    public static final Local LOCAL_0 = StackValue.local(0, AsmTypes.OBJECT_TYPE);
    private static final StackValue UNIT = StackValue.operation(AsmTypes.UNIT_TYPE, new Function1<InstructionAdapter, Unit>(){

        @Override
        public Unit invoke(InstructionAdapter v) {
            v.visitFieldInsn(178, AsmTypes.UNIT_TYPE.getInternalName(), "INSTANCE$", AsmTypes.UNIT_TYPE.getDescriptor());
            return null;
        }
    });
    @NotNull
    public final Type type;
    private final boolean canHaveSideEffects;

    protected StackValue(@NotNull Type type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/codegen/StackValue", "<init>"));
        }
        this(type2, true);
    }

    protected StackValue(@NotNull Type type2, boolean canHaveSideEffects) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/codegen/StackValue", "<init>"));
        }
        this.type = type2;
        this.canHaveSideEffects = canHaveSideEffects;
    }

    public void moveToTopOfStack(@NotNull Type type2, @NotNull InstructionAdapter v, int depth) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/codegen/StackValue", "moveToTopOfStack"));
        }
        if (v == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "v", "org/jetbrains/kotlin/codegen/StackValue", "moveToTopOfStack"));
        }
        this.put(type2, v);
    }

    public void put(@NotNull Type type2, @NotNull InstructionAdapter v) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/codegen/StackValue", "put"));
        }
        if (v == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "v", "org/jetbrains/kotlin/codegen/StackValue", "put"));
        }
        this.put(type2, v, false);
    }

    public void put(@NotNull Type type2, @NotNull InstructionAdapter v, boolean skipReceiver) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/codegen/StackValue", "put"));
        }
        if (v == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "v", "org/jetbrains/kotlin/codegen/StackValue", "put"));
        }
        if (!skipReceiver) {
            this.putReceiver(v, true);
        }
        this.putSelector(type2, v);
    }

    public abstract void putSelector(@NotNull Type var1, @NotNull InstructionAdapter var2);

    public boolean isNonStaticAccess(boolean isRead) {
        return false;
    }

    public void putReceiver(@NotNull InstructionAdapter v, boolean isRead) {
        if (v == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "v", "org/jetbrains/kotlin/codegen/StackValue", "putReceiver"));
        }
    }

    public void dup(@NotNull InstructionAdapter v, boolean withReceiver) {
        if (v == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "v", "org/jetbrains/kotlin/codegen/StackValue", "dup"));
        }
        if (!Type.VOID_TYPE.equals(this.type)) {
            AsmUtil.dup(v, this.type);
        }
    }

    public void store(@NotNull StackValue value, @NotNull InstructionAdapter v) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/kotlin/codegen/StackValue", "store"));
        }
        if (v == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "v", "org/jetbrains/kotlin/codegen/StackValue", "store"));
        }
        this.store(value, v, false);
    }

    public boolean canHaveSideEffects() {
        return this.canHaveSideEffects;
    }

    public void store(@NotNull StackValue value, @NotNull InstructionAdapter v, boolean skipReceiver) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/kotlin/codegen/StackValue", "store"));
        }
        if (v == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "v", "org/jetbrains/kotlin/codegen/StackValue", "store"));
        }
        if (!skipReceiver) {
            this.putReceiver(v, false);
        }
        value.put(value.type, v);
        this.storeSelector(value.type, v);
    }

    protected void storeSelector(@NotNull Type topOfStackType, @NotNull InstructionAdapter v) {
        if (topOfStackType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "topOfStackType", "org/jetbrains/kotlin/codegen/StackValue", "storeSelector"));
        }
        if (v == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "v", "org/jetbrains/kotlin/codegen/StackValue", "storeSelector"));
        }
        throw new UnsupportedOperationException("Cannot store to value " + this);
    }

    public void condJump(@NotNull Label label, boolean jumpIfFalse, @NotNull InstructionAdapter v) {
        if (label == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "label", "org/jetbrains/kotlin/codegen/StackValue", "condJump"));
        }
        if (v == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "v", "org/jetbrains/kotlin/codegen/StackValue", "condJump"));
        }
        this.put(this.type, v);
        this.coerceTo(Type.BOOLEAN_TYPE, v);
        if (jumpIfFalse) {
            v.ifeq(label);
        } else {
            v.ifne(label);
        }
    }

    @NotNull
    public static Local local(int index2, @NotNull Type type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/codegen/StackValue", "local"));
        }
        Local local = new Local(index2, type2);
        if (local == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/StackValue", "local"));
        }
        return local;
    }

    @NotNull
    public static StackValue shared(int index2, @NotNull Type type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/codegen/StackValue", "shared"));
        }
        Shared shared = new Shared(index2, type2);
        if (shared == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/StackValue", "shared"));
        }
        return shared;
    }

    @NotNull
    public static StackValue onStack(@NotNull Type type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/codegen/StackValue", "onStack"));
        }
        StackValue stackValue = type2 == Type.VOID_TYPE ? StackValue.none() : new OnStack(type2);
        if (stackValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/StackValue", "onStack"));
        }
        return stackValue;
    }

    @NotNull
    public static StackValue constant(@Nullable Object value, @NotNull Type type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/codegen/StackValue", "constant"));
        }
        Constant constant = new Constant(value, type2);
        if (constant == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/StackValue", "constant"));
        }
        return constant;
    }

    @NotNull
    public static StackValue cmp(@NotNull IElementType opToken, @NotNull Type type2, StackValue left, StackValue right) {
        if (opToken == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "opToken", "org/jetbrains/kotlin/codegen/StackValue", "cmp"));
        }
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/codegen/StackValue", "cmp"));
        }
        NumberCompare numberCompare = type2.getSort() == 10 ? new ObjectCompare(opToken, type2, left, right) : new NumberCompare(opToken, type2, left, right);
        if (numberCompare == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/StackValue", "cmp"));
        }
        return numberCompare;
    }

    @NotNull
    public static StackValue not(@NotNull StackValue stackValue) {
        if (stackValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stackValue", "org/jetbrains/kotlin/codegen/StackValue", "not"));
        }
        Invert invert = new Invert(stackValue);
        if (invert == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/StackValue", "not"));
        }
        return invert;
    }

    @NotNull
    public static StackValue arrayElement(@NotNull Type type2, StackValue array, StackValue index2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/codegen/StackValue", "arrayElement"));
        }
        ArrayElement arrayElement = new ArrayElement(type2, array, index2);
        if (arrayElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/StackValue", "arrayElement"));
        }
        return arrayElement;
    }

    @NotNull
    public static StackValue collectionElement(StackValue collectionElementReceiver, Type type2, ResolvedCall<FunctionDescriptor> getter, ResolvedCall<FunctionDescriptor> setter, ExpressionCodegen codegen, GenerationState state) {
        CollectionElement collectionElement = new CollectionElement(collectionElementReceiver, type2, getter, setter, codegen, state);
        if (collectionElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/StackValue", "collectionElement"));
        }
        return collectionElement;
    }

    @NotNull
    public static Field field(@NotNull Type type2, @NotNull Type owner, @NotNull String name, boolean isStatic, @NotNull StackValue receiver) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/codegen/StackValue", "field"));
        }
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "org/jetbrains/kotlin/codegen/StackValue", "field"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/codegen/StackValue", "field"));
        }
        if (receiver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiver", "org/jetbrains/kotlin/codegen/StackValue", "field"));
        }
        Field field = new Field(type2, owner, name, isStatic, receiver);
        if (field == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/StackValue", "field"));
        }
        return field;
    }

    @NotNull
    public static Field field(@NotNull Field field, @NotNull StackValue newReceiver) {
        if (field == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "org/jetbrains/kotlin/codegen/StackValue", "field"));
        }
        if (newReceiver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newReceiver", "org/jetbrains/kotlin/codegen/StackValue", "field"));
        }
        Field field2 = new Field(field.type, field.owner, field.name, field.isStaticPut, newReceiver);
        if (field2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/StackValue", "field"));
        }
        return field2;
    }

    @NotNull
    public static StackValue changeReceiverForFieldAndSharedVar(@NotNull StackValueWithSimpleReceiver stackValue, @Nullable StackValue newReceiver) {
        if (stackValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stackValue", "org/jetbrains/kotlin/codegen/StackValue", "changeReceiverForFieldAndSharedVar"));
        }
        if (newReceiver != null && !stackValue.isStaticPut) {
            if (stackValue instanceof Field) {
                Field field = StackValue.field((Field)stackValue, newReceiver);
                if (field == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/StackValue", "changeReceiverForFieldAndSharedVar"));
                }
                return field;
            }
            if (stackValue instanceof FieldForSharedVar) {
                FieldForSharedVar fieldForSharedVar = StackValue.fieldForSharedVar((FieldForSharedVar)stackValue, newReceiver);
                if (fieldForSharedVar == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/StackValue", "changeReceiverForFieldAndSharedVar"));
                }
                return fieldForSharedVar;
            }
        }
        StackValueWithSimpleReceiver stackValueWithSimpleReceiver = stackValue;
        if (stackValueWithSimpleReceiver == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/StackValue", "changeReceiverForFieldAndSharedVar"));
        }
        return stackValueWithSimpleReceiver;
    }

    @NotNull
    public static Property property(@NotNull PropertyDescriptor descriptor, @NotNull Type backingFieldOwner, @NotNull Type type2, boolean isStaticBackingField, @Nullable String fieldName, @Nullable CallableMethod getter, @Nullable CallableMethod setter, GenerationState state, @NotNull StackValue receiver) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/StackValue", "property"));
        }
        if (backingFieldOwner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "backingFieldOwner", "org/jetbrains/kotlin/codegen/StackValue", "property"));
        }
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/codegen/StackValue", "property"));
        }
        if (receiver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiver", "org/jetbrains/kotlin/codegen/StackValue", "property"));
        }
        Property property2 = new Property(descriptor, backingFieldOwner, getter, setter, isStaticBackingField, fieldName, type2, state, receiver);
        if (property2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/StackValue", "property"));
        }
        return property2;
    }

    @NotNull
    public static StackValue expression(Type type2, JetExpression expression, ExpressionCodegen generator) {
        Expression expression2 = new Expression(type2, expression, generator);
        if (expression2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/StackValue", "expression"));
        }
        return expression2;
    }

    private static void box(Type type2, Type toType, InstructionAdapter v) {
        if (type2 == Type.BYTE_TYPE || toType.getInternalName().equals("java/lang/Byte") && type2 == Type.INT_TYPE) {
            v.cast(type2, Type.BYTE_TYPE);
            v.invokestatic("java/lang/Byte", "valueOf", "(B)Ljava/lang/Byte;", false);
        } else if (type2 == Type.SHORT_TYPE || toType.getInternalName().equals("java/lang/Short") && type2 == Type.INT_TYPE) {
            v.cast(type2, Type.SHORT_TYPE);
            v.invokestatic("java/lang/Short", "valueOf", "(S)Ljava/lang/Short;", false);
        } else if (type2 == Type.LONG_TYPE || toType.getInternalName().equals("java/lang/Long") && type2 == Type.INT_TYPE) {
            v.cast(type2, Type.LONG_TYPE);
            v.invokestatic("java/lang/Long", "valueOf", "(J)Ljava/lang/Long;", false);
        } else if (type2 == Type.INT_TYPE) {
            v.invokestatic("java/lang/Integer", "valueOf", "(I)Ljava/lang/Integer;", false);
        } else if (type2 == Type.BOOLEAN_TYPE) {
            v.invokestatic("java/lang/Boolean", "valueOf", "(Z)Ljava/lang/Boolean;", false);
        } else if (type2 == Type.CHAR_TYPE) {
            v.invokestatic("java/lang/Character", "valueOf", "(C)Ljava/lang/Character;", false);
        } else if (type2 == Type.FLOAT_TYPE) {
            v.invokestatic("java/lang/Float", "valueOf", "(F)Ljava/lang/Float;", false);
        } else if (type2 == Type.DOUBLE_TYPE) {
            v.invokestatic("java/lang/Double", "valueOf", "(D)Ljava/lang/Double;", false);
        }
    }

    private static void unbox(Type type2, InstructionAdapter v) {
        if (type2 == Type.INT_TYPE) {
            v.invokevirtual("java/lang/Number", "intValue", "()I", false);
        } else if (type2 == Type.BOOLEAN_TYPE) {
            v.invokevirtual("java/lang/Boolean", "booleanValue", "()Z", false);
        } else if (type2 == Type.CHAR_TYPE) {
            v.invokevirtual("java/lang/Character", "charValue", "()C", false);
        } else if (type2 == Type.SHORT_TYPE) {
            v.invokevirtual("java/lang/Number", "shortValue", "()S", false);
        } else if (type2 == Type.LONG_TYPE) {
            v.invokevirtual("java/lang/Number", "longValue", "()J", false);
        } else if (type2 == Type.BYTE_TYPE) {
            v.invokevirtual("java/lang/Number", "byteValue", "()B", false);
        } else if (type2 == Type.FLOAT_TYPE) {
            v.invokevirtual("java/lang/Number", "floatValue", "()F", false);
        } else if (type2 == Type.DOUBLE_TYPE) {
            v.invokevirtual("java/lang/Number", "doubleValue", "()D", false);
        }
    }

    protected void coerceTo(@NotNull Type toType, @NotNull InstructionAdapter v) {
        if (toType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toType", "org/jetbrains/kotlin/codegen/StackValue", "coerceTo"));
        }
        if (v == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "v", "org/jetbrains/kotlin/codegen/StackValue", "coerceTo"));
        }
        StackValue.coerce(this.type, toType, v);
    }

    protected void coerceFrom(@NotNull Type topOfStackType, @NotNull InstructionAdapter v) {
        if (topOfStackType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "topOfStackType", "org/jetbrains/kotlin/codegen/StackValue", "coerceFrom"));
        }
        if (v == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "v", "org/jetbrains/kotlin/codegen/StackValue", "coerceFrom"));
        }
        StackValue.coerce(topOfStackType, this.type, v);
    }

    public static void coerce(@NotNull Type fromType, @NotNull Type toType, @NotNull InstructionAdapter v) {
        if (fromType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fromType", "org/jetbrains/kotlin/codegen/StackValue", "coerce"));
        }
        if (toType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toType", "org/jetbrains/kotlin/codegen/StackValue", "coerce"));
        }
        if (v == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "v", "org/jetbrains/kotlin/codegen/StackValue", "coerce"));
        }
        if (toType.equals(fromType)) {
            return;
        }
        if (toType.getSort() == 0) {
            AsmUtil.pop(v, fromType);
        } else if (fromType.getSort() == 0) {
            if (toType.equals(AsmTypes.UNIT_TYPE) || toType.equals(AsmTypes.OBJECT_TYPE)) {
                StackValue.putUnitInstance(v);
            } else if (toType.getSort() == 10 || toType.getSort() == 9) {
                v.aconst(null);
            } else {
                AsmUtil.pushDefaultPrimitiveValueOnStack(toType, v);
            }
        } else if (toType.equals(AsmTypes.UNIT_TYPE)) {
            if (fromType.equals(AsmTypes.getType(Object.class))) {
                v.checkcast(AsmTypes.UNIT_TYPE);
            } else if (!fromType.equals(AsmTypes.getType(Void.class))) {
                AsmUtil.pop(v, fromType);
                StackValue.putUnitInstance(v);
            }
        } else if (toType.getSort() == 9) {
            v.checkcast(toType);
        } else if (toType.getSort() == 10) {
            if (fromType.getSort() == 10 || fromType.getSort() == 9) {
                if (!toType.equals(AsmTypes.OBJECT_TYPE)) {
                    v.checkcast(toType);
                }
            } else {
                StackValue.box(fromType, toType, v);
            }
        } else if (fromType.getSort() == 10) {
            if (fromType.equals(AsmTypes.getType(Boolean.class)) || fromType.equals(AsmTypes.getType(Character.class))) {
                StackValue.unbox(AsmUtil.unboxType(fromType), v);
                StackValue.coerce(AsmUtil.unboxType(fromType), toType, v);
            } else {
                if (toType.getSort() == 1 || toType.getSort() == 2) {
                    StackValue.coerce(fromType, AsmUtil.boxType(toType), v);
                } else {
                    StackValue.coerce(fromType, AsmTypes.getType(Number.class), v);
                }
                StackValue.unbox(toType, v);
            }
        } else {
            v.cast(fromType, toType);
        }
    }

    public static void putUnitInstance(@NotNull InstructionAdapter v) {
        if (v == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "v", "org/jetbrains/kotlin/codegen/StackValue", "putUnitInstance"));
        }
        StackValue.unit().put(AsmTypes.UNIT_TYPE, v);
    }

    public static StackValue unit() {
        return UNIT;
    }

    public void putAsBoolean(InstructionAdapter v) {
        Label ifTrue = new Label();
        Label end = new Label();
        this.condJump(ifTrue, false, v);
        v.iconst(0);
        v.goTo(end);
        v.mark(ifTrue);
        v.iconst(1);
        v.mark(end);
    }

    public static StackValue none() {
        return None.INSTANCE;
    }

    public static FieldForSharedVar fieldForSharedVar(@NotNull Type localType, @NotNull Type classType, @NotNull String fieldName, @NotNull StackValue receiver) {
        if (localType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localType", "org/jetbrains/kotlin/codegen/StackValue", "fieldForSharedVar"));
        }
        if (classType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classType", "org/jetbrains/kotlin/codegen/StackValue", "fieldForSharedVar"));
        }
        if (fieldName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fieldName", "org/jetbrains/kotlin/codegen/StackValue", "fieldForSharedVar"));
        }
        if (receiver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiver", "org/jetbrains/kotlin/codegen/StackValue", "fieldForSharedVar"));
        }
        Field receiverWithRefWrapper = StackValue.field(StackValue.sharedTypeForType(localType), classType, fieldName, false, receiver);
        return new FieldForSharedVar(localType, classType, fieldName, receiverWithRefWrapper);
    }

    @NotNull
    public static FieldForSharedVar fieldForSharedVar(@NotNull FieldForSharedVar field, @NotNull StackValue newReceiver) {
        if (field == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "org/jetbrains/kotlin/codegen/StackValue", "fieldForSharedVar"));
        }
        if (newReceiver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newReceiver", "org/jetbrains/kotlin/codegen/StackValue", "fieldForSharedVar"));
        }
        Field oldReceiver = (Field)field.receiver;
        Field newSharedVarReceiver = StackValue.field(oldReceiver, newReceiver);
        FieldForSharedVar fieldForSharedVar = new FieldForSharedVar(field.type, field.owner, field.name, newSharedVarReceiver);
        if (fieldForSharedVar == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/StackValue", "fieldForSharedVar"));
        }
        return fieldForSharedVar;
    }

    public static StackValue coercion(@NotNull StackValue value, @NotNull Type castType) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/kotlin/codegen/StackValue", "coercion"));
        }
        if (castType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "castType", "org/jetbrains/kotlin/codegen/StackValue", "coercion"));
        }
        if (value.type.equals(castType)) {
            return value;
        }
        return new CoercionValue(value, castType);
    }

    public static StackValue thisOrOuter(@NotNull ExpressionCodegen codegen, @NotNull ClassDescriptor descriptor, boolean isSuper, boolean isExplicit) {
        if (codegen == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "codegen", "org/jetbrains/kotlin/codegen/StackValue", "thisOrOuter"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/StackValue", "thisOrOuter"));
        }
        boolean coerceType = descriptor.getKind() == ClassKind.TRAIT || isExplicit && !isSuper;
        return new ThisOuter(codegen, descriptor, isSuper, coerceType);
    }

    public static StackValue postIncrement(int index2, int increment) {
        return new PostIncrement(index2, increment);
    }

    public static StackValue preIncrementForLocalVar(int index2, int increment) {
        return new PreIncrementForLocalVar(index2, increment);
    }

    public static StackValue preIncrement(@NotNull Type type2, @NotNull StackValue stackValue, int delta, @NotNull Callable method, ResolvedCall resolvedCall, @NotNull ExpressionCodegen codegen) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/codegen/StackValue", "preIncrement"));
        }
        if (stackValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stackValue", "org/jetbrains/kotlin/codegen/StackValue", "preIncrement"));
        }
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "org/jetbrains/kotlin/codegen/StackValue", "preIncrement"));
        }
        if (codegen == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "codegen", "org/jetbrains/kotlin/codegen/StackValue", "preIncrement"));
        }
        return new PrefixIncrement(type2, stackValue, delta, method, resolvedCall, codegen);
    }

    public static StackValue receiver(ResolvedCall<?> resolvedCall, StackValue receiver, ExpressionCodegen codegen, @Nullable CallableMethod callableMethod) {
        if (resolvedCall.getDispatchReceiver().exists() || resolvedCall.getExtensionReceiver().exists() || StackValue.isLocalFunCall(callableMethod)) {
            boolean hasExtensionReceiver = resolvedCall.getExtensionReceiver().exists();
            StackValue dispatchReceiver = StackValue.platformStaticCallIfPresent(StackValue.genReceiver(hasExtensionReceiver ? StackValue.none() : receiver, codegen, resolvedCall, callableMethod, false), resolvedCall.getResultingDescriptor());
            StackValue extensionReceiver2 = StackValue.genReceiver(receiver, codegen, resolvedCall, callableMethod, true);
            return new CallReceiver(dispatchReceiver, extensionReceiver2, CallReceiver.calcType(resolvedCall, codegen.typeMapper, callableMethod));
        }
        return receiver;
    }

    private static StackValue genReceiver(@NotNull StackValue receiver, @NotNull ExpressionCodegen codegen, @NotNull ResolvedCall resolvedCall, @Nullable CallableMethod callableMethod, boolean isExtension) {
        ReceiverValue receiverValue;
        if (receiver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiver", "org/jetbrains/kotlin/codegen/StackValue", "genReceiver"));
        }
        if (codegen == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "codegen", "org/jetbrains/kotlin/codegen/StackValue", "genReceiver"));
        }
        if (resolvedCall == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolvedCall", "org/jetbrains/kotlin/codegen/StackValue", "genReceiver"));
        }
        ReceiverValue receiverValue2 = receiverValue = isExtension ? resolvedCall.getExtensionReceiver() : resolvedCall.getDispatchReceiver();
        if (receiver == StackValue.none()) {
            if (receiverValue.exists()) {
                return codegen.generateReceiverValue(receiverValue);
            }
            if (StackValue.isLocalFunCall(callableMethod) && !isExtension) {
                Object descriptor = resolvedCall.getResultingDescriptor();
                StackValue value = codegen.findLocalOrCapturedValue(descriptor.getOriginal());
                assert (value != null) : "Local fun should be found in locals or in captured params: " + resolvedCall;
                return value;
            }
        } else if (receiverValue.exists()) {
            return receiver;
        }
        return StackValue.none();
    }

    private static StackValue platformStaticCallIfPresent(@NotNull StackValue resultReceiver, @NotNull CallableDescriptor descriptor) {
        if (resultReceiver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resultReceiver", "org/jetbrains/kotlin/codegen/StackValue", "platformStaticCallIfPresent"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/StackValue", "platformStaticCallIfPresent"));
        }
        if (AnnotationsPackage.isPlatformStaticInObjectOrClass(descriptor)) {
            if (resultReceiver.canHaveSideEffects()) {
                return StackValue.coercion(resultReceiver, Type.VOID_TYPE);
            }
            return StackValue.none();
        }
        return resultReceiver;
    }

    @Contract(value="null -> false")
    private static boolean isLocalFunCall(@Nullable CallableMethod callableMethod) {
        return callableMethod != null && callableMethod.getGenerateCalleeType() != null;
    }

    public static StackValue receiverWithoutReceiverArgument(StackValue receiverWithParameter) {
        if (receiverWithParameter instanceof CallReceiver) {
            CallReceiver callReceiver = (CallReceiver)receiverWithParameter;
            return new CallReceiver(callReceiver.dispatchReceiver, StackValue.none(), callReceiver.type);
        }
        return receiverWithParameter;
    }

    public static Field singleton(ClassDescriptor classDescriptor, JetTypeMapper typeMapper) {
        FieldInfo info = FieldInfo.createForSingleton(classDescriptor, typeMapper);
        return StackValue.field(info.getFieldType(), Type.getObjectType(info.getOwnerInternalName()), info.getFieldName(), true, StackValue.none());
    }

    public static StackValue operation(Type type2, Function1<InstructionAdapter, Unit> lambda2) {
        return new OperationStackValue(type2, lambda2);
    }

    public static StackValue functionCall(Type type2, Function1<InstructionAdapter, Unit> lambda2) {
        return new FunctionCallStackValue(type2, lambda2);
    }

    public static boolean couldSkipReceiverOnStaticCall(StackValue value) {
        return value instanceof Local || value instanceof Constant;
    }

    @NotNull
    public static Type sharedTypeForType(@NotNull Type type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/codegen/StackValue", "sharedTypeForType"));
        }
        switch (type2.getSort()) {
            case 9: 
            case 10: {
                Type type3 = AsmTypes.OBJECT_REF_TYPE;
                if (type3 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/StackValue", "sharedTypeForType"));
                }
                return type3;
            }
        }
        PrimitiveType primitiveType = AsmUtil.asmPrimitiveTypeToLangPrimitiveType(type2);
        if (primitiveType == null) {
            throw new UnsupportedOperationException();
        }
        String typeName = primitiveType.getTypeName().getIdentifier();
        Type type4 = Type.getObjectType("kotlin/jvm/internal/Ref$" + typeName + "Ref");
        if (type4 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/StackValue", "sharedTypeForType"));
        }
        return type4;
    }

    public static Type refType(Type type2) {
        if (type2.getSort() == 10 || type2.getSort() == 9) {
            return AsmTypes.OBJECT_TYPE;
        }
        return type2;
    }

    public static StackValue complexWriteReadReceiver(StackValue stackValue) {
        return StackValue.complexReceiver(stackValue, false, true);
    }

    private static StackValue complexReceiver(StackValue stackValue, boolean ... isReadOperations) {
        if (stackValue instanceof StackValueWithSimpleReceiver) {
            return new DelegatedForComplexReceiver(stackValue.type, (StackValueWithSimpleReceiver)stackValue, new ComplexReceiver((StackValueWithSimpleReceiver)stackValue, isReadOperations));
        }
        return stackValue;
    }

    static class SafeFallback
    extends StackValueWithSimpleReceiver {
        @Nullable
        private final Label ifNull;

        public SafeFallback(@NotNull Type type2, @Nullable Label ifNull, StackValue receiver) {
            if (type2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/codegen/StackValue$SafeFallback", "<init>"));
            }
            super(type2, false, false, receiver, true);
            this.ifNull = ifNull;
        }

        @Override
        public void putSelector(@NotNull Type type2, @NotNull InstructionAdapter v) {
            if (type2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/codegen/StackValue$SafeFallback", "putSelector"));
            }
            if (v == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "v", "org/jetbrains/kotlin/codegen/StackValue$SafeFallback", "putSelector"));
            }
            Label end = new Label();
            v.goTo(end);
            v.mark(this.ifNull);
            v.pop();
            if (!this.type.equals(Type.VOID_TYPE)) {
                v.aconst(null);
            }
            v.mark(end);
            this.coerceTo(type2, v);
        }

        @Override
        public void store(@NotNull StackValue rightSide, @NotNull InstructionAdapter v, boolean skipReceiver) {
            if (rightSide == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rightSide", "org/jetbrains/kotlin/codegen/StackValue$SafeFallback", "store"));
            }
            if (v == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "v", "org/jetbrains/kotlin/codegen/StackValue$SafeFallback", "store"));
            }
            this.receiver.store(rightSide, v, skipReceiver);
            Label end = new Label();
            v.goTo(end);
            v.mark(this.ifNull);
            v.pop();
            v.mark(end);
        }
    }

    static class SafeCall
    extends StackValue {
        @NotNull
        private final Type type;
        private final StackValue receiver;
        @Nullable
        private final Label ifNull;

        public SafeCall(@NotNull Type type2, @NotNull StackValue value, @Nullable Label ifNull) {
            if (type2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/codegen/StackValue$SafeCall", "<init>"));
            }
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/kotlin/codegen/StackValue$SafeCall", "<init>"));
            }
            super(type2);
            this.type = type2;
            this.receiver = value;
            this.ifNull = ifNull;
        }

        @Override
        public void putSelector(@NotNull Type type2, @NotNull InstructionAdapter v) {
            if (type2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/codegen/StackValue$SafeCall", "putSelector"));
            }
            if (v == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "v", "org/jetbrains/kotlin/codegen/StackValue$SafeCall", "putSelector"));
            }
            this.receiver.put(this.type, v);
            if (this.ifNull != null) {
                v.dup();
                v.ifnull(this.ifNull);
            }
            this.coerceTo(type2, v);
        }
    }

    public static class DelegatedForComplexReceiver
    extends StackValueWithSimpleReceiver {
        public final StackValueWithSimpleReceiver originalValue;

        public DelegatedForComplexReceiver(@NotNull Type type2, @NotNull StackValueWithSimpleReceiver originalValue, @NotNull ComplexReceiver receiver) {
            if (type2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/codegen/StackValue$DelegatedForComplexReceiver", "<init>"));
            }
            if (originalValue == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originalValue", "org/jetbrains/kotlin/codegen/StackValue$DelegatedForComplexReceiver", "<init>"));
            }
            if (receiver == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiver", "org/jetbrains/kotlin/codegen/StackValue$DelegatedForComplexReceiver", "<init>"));
            }
            super(type2, DelegatedForComplexReceiver.bothReceiverStatic(originalValue), DelegatedForComplexReceiver.bothReceiverStatic(originalValue), receiver, originalValue.canHaveSideEffects());
            this.originalValue = originalValue;
        }

        private static boolean bothReceiverStatic(StackValueWithSimpleReceiver originalValue) {
            return !originalValue.isNonStaticAccess(true) && !originalValue.isNonStaticAccess(false);
        }

        @Override
        public void putSelector(@NotNull Type type2, @NotNull InstructionAdapter v) {
            if (type2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/codegen/StackValue$DelegatedForComplexReceiver", "putSelector"));
            }
            if (v == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "v", "org/jetbrains/kotlin/codegen/StackValue$DelegatedForComplexReceiver", "putSelector"));
            }
            this.originalValue.putSelector(type2, v);
        }

        @Override
        public void storeSelector(@NotNull Type topOfStackType, @NotNull InstructionAdapter v) {
            if (topOfStackType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "topOfStackType", "org/jetbrains/kotlin/codegen/StackValue$DelegatedForComplexReceiver", "storeSelector"));
            }
            if (v == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "v", "org/jetbrains/kotlin/codegen/StackValue$DelegatedForComplexReceiver", "storeSelector"));
            }
            this.originalValue.storeSelector(topOfStackType, v);
        }

        @Override
        public void dup(@NotNull InstructionAdapter v, boolean withWriteReceiver) {
            if (v == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "v", "org/jetbrains/kotlin/codegen/StackValue$DelegatedForComplexReceiver", "dup"));
            }
            this.originalValue.dup(v, withWriteReceiver);
        }
    }

    public static class Receiver
    extends StackValue {
        private final StackValue[] instructions;

        protected Receiver(@NotNull Type type2, StackValue ... receiverInstructions) {
            if (type2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/codegen/StackValue$Receiver", "<init>"));
            }
            super(type2);
            this.instructions = receiverInstructions;
        }

        @Override
        public void putSelector(@NotNull Type type2, @NotNull InstructionAdapter v) {
            if (type2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/codegen/StackValue$Receiver", "putSelector"));
            }
            if (v == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "v", "org/jetbrains/kotlin/codegen/StackValue$Receiver", "putSelector"));
            }
            for (StackValue instruction : this.instructions) {
                instruction.put(instruction.type, v);
            }
        }
    }

    private static class ComplexReceiver
    extends StackValue {
        private final StackValueWithSimpleReceiver originalValueWithReceiver;
        private final boolean[] isReadOperations;

        public ComplexReceiver(StackValueWithSimpleReceiver value, boolean[] isReadOperations) {
            super(value.type, value.receiver.canHaveSideEffects());
            this.originalValueWithReceiver = value;
            this.isReadOperations = isReadOperations;
        }

        @Override
        public void putSelector(@NotNull Type type2, @NotNull InstructionAdapter v) {
            if (type2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/codegen/StackValue$ComplexReceiver", "putSelector"));
            }
            if (v == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "v", "org/jetbrains/kotlin/codegen/StackValue$ComplexReceiver", "putSelector"));
            }
            boolean wasPut = false;
            StackValue receiver = this.originalValueWithReceiver.receiver;
            for (boolean operation : this.isReadOperations) {
                if (!this.originalValueWithReceiver.isNonStaticAccess(operation)) continue;
                if (!wasPut) {
                    receiver.put(receiver.type, v);
                    wasPut = true;
                    continue;
                }
                receiver.dup(v, false);
            }
            if (!wasPut && receiver.canHaveSideEffects()) {
                receiver.put(Type.VOID_TYPE, v);
            }
        }
    }

    public static abstract class StackValueWithSimpleReceiver
    extends StackValue {
        public final boolean isStaticPut;
        public final boolean isStaticStore;
        @NotNull
        public final StackValue receiver;

        public StackValueWithSimpleReceiver(@NotNull Type type2, boolean isStaticPut, boolean isStaticStore, @NotNull StackValue receiver, boolean canHaveSideEffects) {
            if (type2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/codegen/StackValue$StackValueWithSimpleReceiver", "<init>"));
            }
            if (receiver == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiver", "org/jetbrains/kotlin/codegen/StackValue$StackValueWithSimpleReceiver", "<init>"));
            }
            super(type2, canHaveSideEffects);
            this.receiver = receiver;
            this.isStaticPut = isStaticPut;
            this.isStaticStore = isStaticStore;
        }

        @Override
        public void putReceiver(@NotNull InstructionAdapter v, boolean isRead) {
            if (v == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "v", "org/jetbrains/kotlin/codegen/StackValue$StackValueWithSimpleReceiver", "putReceiver"));
            }
            boolean hasReceiver = this.isNonStaticAccess(isRead);
            if (hasReceiver || this.receiver.canHaveSideEffects()) {
                this.receiver.put(hasReceiver ? this.receiver.type : Type.VOID_TYPE, v);
            }
        }

        @Override
        public boolean isNonStaticAccess(boolean isRead) {
            return isRead ? !this.isStaticPut : !this.isStaticStore;
        }

        public int receiverSize() {
            return this.receiver.type.getSize();
        }

        @Override
        public void dup(@NotNull InstructionAdapter v, boolean withWriteReceiver) {
            if (v == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "v", "org/jetbrains/kotlin/codegen/StackValue$StackValueWithSimpleReceiver", "dup"));
            }
            if (!withWriteReceiver) {
                super.dup(v, false);
            } else {
                int receiverSize = this.isNonStaticAccess(false) ? this.receiverSize() : 0;
                switch (receiverSize) {
                    case 0: {
                        AsmUtil.dup(v, this.type);
                        break;
                    }
                    case 1: {
                        if (this.type.getSize() == 2) {
                            v.dup2X1();
                            break;
                        }
                        v.dupX1();
                        break;
                    }
                    case 2: {
                        if (this.type.getSize() == 2) {
                            v.dup2X2();
                            break;
                        }
                        v.dupX2();
                        break;
                    }
                    case -1: {
                        throw new UnsupportedOperationException();
                    }
                }
            }
        }

        @Override
        public void store(@NotNull StackValue rightSide, @NotNull InstructionAdapter v, boolean skipReceiver) {
            if (rightSide == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rightSide", "org/jetbrains/kotlin/codegen/StackValue$StackValueWithSimpleReceiver", "store"));
            }
            if (v == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "v", "org/jetbrains/kotlin/codegen/StackValue$StackValueWithSimpleReceiver", "store"));
            }
            if (!skipReceiver) {
                this.putReceiver(v, false);
            }
            rightSide.put(rightSide.type, v);
            this.storeSelector(rightSide.type, v);
        }
    }

    public static class CallReceiver
    extends StackValue {
        private final StackValue dispatchReceiver;
        private final StackValue extensionReceiver;

        public CallReceiver(@NotNull StackValue dispatchReceiver, @NotNull StackValue extensionReceiver2, @NotNull Type type2) {
            if (dispatchReceiver == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dispatchReceiver", "org/jetbrains/kotlin/codegen/StackValue$CallReceiver", "<init>"));
            }
            if (extensionReceiver2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extensionReceiver", "org/jetbrains/kotlin/codegen/StackValue$CallReceiver", "<init>"));
            }
            if (type2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/codegen/StackValue$CallReceiver", "<init>"));
            }
            super(type2, dispatchReceiver.canHaveSideEffects() || extensionReceiver2.canHaveSideEffects());
            this.dispatchReceiver = dispatchReceiver;
            this.extensionReceiver = extensionReceiver2;
        }

        public static Type calcType(@NotNull ResolvedCall<?> resolvedCall, @NotNull JetTypeMapper typeMapper, @Nullable CallableMethod callableMethod) {
            if (resolvedCall == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolvedCall", "org/jetbrains/kotlin/codegen/StackValue$CallReceiver", "calcType"));
            }
            if (typeMapper == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeMapper", "org/jetbrains/kotlin/codegen/StackValue$CallReceiver", "calcType"));
            }
            Object descriptor = resolvedCall.getResultingDescriptor();
            ReceiverParameterDescriptor dispatchReceiver = descriptor.getDispatchReceiverParameter();
            ReceiverParameterDescriptor extensionReceiver2 = descriptor.getExtensionReceiverParameter();
            if (extensionReceiver2 != null) {
                return callableMethod != null ? callableMethod.getReceiverClass() : typeMapper.mapType(extensionReceiver2.getType());
            }
            if (dispatchReceiver != null) {
                if (AnnotationsPackage.isPlatformStaticInObjectOrClass(descriptor)) {
                    return Type.VOID_TYPE;
                }
                return callableMethod != null ? callableMethod.getThisType() : typeMapper.mapType(dispatchReceiver.getType());
            }
            if (StackValue.isLocalFunCall(callableMethod)) {
                return callableMethod.getGenerateCalleeType();
            }
            return Type.VOID_TYPE;
        }

        @Override
        public void putSelector(@NotNull Type type2, @NotNull InstructionAdapter v) {
            boolean hasExtensionReceiver;
            if (type2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/codegen/StackValue$CallReceiver", "putSelector"));
            }
            if (v == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "v", "org/jetbrains/kotlin/codegen/StackValue$CallReceiver", "putSelector"));
            }
            StackValue currentExtensionReceiver = this.extensionReceiver;
            boolean bl = hasExtensionReceiver = this.extensionReceiver != CallReceiver.none();
            if (this.extensionReceiver instanceof SafeCall) {
                currentExtensionReceiver.put(currentExtensionReceiver.type, v);
                currentExtensionReceiver = StackValue.onStack(currentExtensionReceiver.type);
            }
            this.dispatchReceiver.put(hasExtensionReceiver ? this.dispatchReceiver.type : type2, v);
            currentExtensionReceiver.moveToTopOfStack(hasExtensionReceiver ? type2 : currentExtensionReceiver.type, v, this.dispatchReceiver.type.getSize());
        }
    }

    private static class PrefixIncrement
    extends StackValue {
        private final int delta;
        private final Callable callable;
        private final ResolvedCall resolvedCall;
        private final ExpressionCodegen codegen;
        private StackValue value;

        public PrefixIncrement(@NotNull Type type2, @NotNull StackValue value, int delta, @NotNull Callable callable2, ResolvedCall resolvedCall, @NotNull ExpressionCodegen codegen) {
            if (type2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/codegen/StackValue$PrefixIncrement", "<init>"));
            }
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/kotlin/codegen/StackValue$PrefixIncrement", "<init>"));
            }
            if (callable2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callable", "org/jetbrains/kotlin/codegen/StackValue$PrefixIncrement", "<init>"));
            }
            if (codegen == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "codegen", "org/jetbrains/kotlin/codegen/StackValue$PrefixIncrement", "<init>"));
            }
            super(type2);
            this.value = value;
            this.delta = delta;
            this.callable = callable2;
            this.resolvedCall = resolvedCall;
            this.codegen = codegen;
        }

        @Override
        public void putSelector(@NotNull Type type2, @NotNull InstructionAdapter v) {
            if (type2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/codegen/StackValue$PrefixIncrement", "putSelector"));
            }
            if (v == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "v", "org/jetbrains/kotlin/codegen/StackValue$PrefixIncrement", "putSelector"));
            }
            this.value = StackValue.complexReceiver(this.value, new boolean[]{true, false, true});
            this.value.put(this.type, v);
            if (this.callable instanceof CallableMethod) {
                this.value.store(this.codegen.invokeFunction(this.resolvedCall, StackValue.onStack(this.type)), v, true);
            } else {
                AsmUtil.genIncrement(this.type, this.delta, v);
                this.value.store(StackValue.onStack(this.type), v, true);
            }
            this.value.put(this.type, v, true);
            this.coerceTo(type2, v);
        }
    }

    private static class PreIncrementForLocalVar
    extends StackValue {
        private final int index;
        private final int increment;

        public PreIncrementForLocalVar(int index2, int increment) {
            super(Type.INT_TYPE);
            this.index = index2;
            this.increment = increment;
        }

        @Override
        public void putSelector(@NotNull Type type2, @NotNull InstructionAdapter v) {
            if (type2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/codegen/StackValue$PreIncrementForLocalVar", "putSelector"));
            }
            if (v == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "v", "org/jetbrains/kotlin/codegen/StackValue$PreIncrementForLocalVar", "putSelector"));
            }
            v.iinc(this.index, this.increment);
            if (!type2.equals(Type.VOID_TYPE)) {
                v.load(this.index, Type.INT_TYPE);
                this.coerceTo(type2, v);
            }
        }
    }

    private static class PostIncrement
    extends StackValue {
        private final int index;
        private final int increment;

        public PostIncrement(int index2, int increment) {
            super(Type.INT_TYPE);
            this.index = index2;
            this.increment = increment;
        }

        @Override
        public void putSelector(@NotNull Type type2, @NotNull InstructionAdapter v) {
            if (type2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/codegen/StackValue$PostIncrement", "putSelector"));
            }
            if (v == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "v", "org/jetbrains/kotlin/codegen/StackValue$PostIncrement", "putSelector"));
            }
            if (!type2.equals(Type.VOID_TYPE)) {
                v.load(this.index, Type.INT_TYPE);
                this.coerceTo(type2, v);
            }
            v.iinc(this.index, this.increment);
        }
    }

    private static class ThisOuter
    extends StackValue {
        private final ExpressionCodegen codegen;
        private final ClassDescriptor descriptor;
        private final boolean isSuper;
        private final boolean coerceType;

        public ThisOuter(ExpressionCodegen codegen, ClassDescriptor descriptor, boolean isSuper, boolean coerceType) {
            super(AsmTypes.OBJECT_TYPE, false);
            this.codegen = codegen;
            this.descriptor = descriptor;
            this.isSuper = isSuper;
            this.coerceType = coerceType;
        }

        @Override
        public void putSelector(@NotNull Type type2, @NotNull InstructionAdapter v) {
            if (type2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/codegen/StackValue$ThisOuter", "putSelector"));
            }
            if (v == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "v", "org/jetbrains/kotlin/codegen/StackValue$ThisOuter", "putSelector"));
            }
            StackValue stackValue = this.codegen.generateThisOrOuter(this.descriptor, this.isSuper);
            stackValue.put(this.coerceType ? type2 : stackValue.type, v);
        }
    }

    public static class FieldForSharedVar
    extends StackValueWithSimpleReceiver {
        final Type owner;
        final String name;

        public FieldForSharedVar(Type type2, Type owner, String name, Field receiver) {
            super(type2, false, false, receiver, receiver.canHaveSideEffects());
            this.owner = owner;
            this.name = name;
        }

        @Override
        public void putSelector(@NotNull Type type2, @NotNull InstructionAdapter v) {
            if (type2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/codegen/StackValue$FieldForSharedVar", "putSelector"));
            }
            if (v == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "v", "org/jetbrains/kotlin/codegen/StackValue$FieldForSharedVar", "putSelector"));
            }
            Type sharedType = FieldForSharedVar.sharedTypeForType(this.type);
            Type refType = FieldForSharedVar.refType(this.type);
            v.visitFieldInsn(180, sharedType.getInternalName(), "element", refType.getDescriptor());
            this.coerceFrom(refType, v);
            this.coerceTo(type2, v);
        }

        @Override
        public void storeSelector(@NotNull Type topOfStackType, @NotNull InstructionAdapter v) {
            if (topOfStackType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "topOfStackType", "org/jetbrains/kotlin/codegen/StackValue$FieldForSharedVar", "storeSelector"));
            }
            if (v == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "v", "org/jetbrains/kotlin/codegen/StackValue$FieldForSharedVar", "storeSelector"));
            }
            this.coerceFrom(topOfStackType, v);
            v.visitFieldInsn(181, FieldForSharedVar.sharedTypeForType(this.type).getInternalName(), "element", FieldForSharedVar.refType(this.type).getDescriptor());
        }
    }

    public static class Shared
    extends StackValueWithSimpleReceiver {
        private final int index;

        public Shared(int index2, Type type2) {
            super(type2, false, false, Shared.local(index2, AsmTypes.OBJECT_TYPE), false);
            this.index = index2;
        }

        public int getIndex() {
            return this.index;
        }

        @Override
        public void putSelector(@NotNull Type type2, @NotNull InstructionAdapter v) {
            if (type2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/codegen/StackValue$Shared", "putSelector"));
            }
            if (v == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "v", "org/jetbrains/kotlin/codegen/StackValue$Shared", "putSelector"));
            }
            Type refType = Shared.refType(this.type);
            Type sharedType = Shared.sharedTypeForType(this.type);
            v.visitFieldInsn(180, sharedType.getInternalName(), "element", refType.getDescriptor());
            this.coerceFrom(refType, v);
            this.coerceTo(type2, v);
        }

        @Override
        public void storeSelector(@NotNull Type topOfStackType, @NotNull InstructionAdapter v) {
            if (topOfStackType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "topOfStackType", "org/jetbrains/kotlin/codegen/StackValue$Shared", "storeSelector"));
            }
            if (v == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "v", "org/jetbrains/kotlin/codegen/StackValue$Shared", "storeSelector"));
            }
            this.coerceFrom(topOfStackType, v);
            Type refType = Shared.refType(this.type);
            Type sharedType = Shared.sharedTypeForType(this.type);
            v.visitFieldInsn(181, sharedType.getInternalName(), "element", refType.getDescriptor());
        }
    }

    private static class Expression
    extends StackValue {
        private final JetExpression expression;
        private final ExpressionCodegen generator;

        public Expression(Type type2, JetExpression expression, ExpressionCodegen generator) {
            super(type2);
            this.expression = expression;
            this.generator = generator;
        }

        @Override
        public void putSelector(@NotNull Type type2, @NotNull InstructionAdapter v) {
            if (type2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/codegen/StackValue$Expression", "putSelector"));
            }
            if (v == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "v", "org/jetbrains/kotlin/codegen/StackValue$Expression", "putSelector"));
            }
            this.generator.gen(this.expression, type2);
        }
    }

    static class Property
    extends StackValueWithSimpleReceiver {
        private final CallableMethod getter;
        private final CallableMethod setter;
        private final Type backingFieldOwner;
        private final PropertyDescriptor descriptor;
        private final GenerationState state;
        private final String fieldName;

        public Property(@NotNull PropertyDescriptor descriptor, @NotNull Type backingFieldOwner, @Nullable CallableMethod getter, @Nullable CallableMethod setter, boolean isStaticBackingField, @Nullable String fieldName, @NotNull Type type2, @NotNull GenerationState state, @NotNull StackValue receiver) {
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/StackValue$Property", "<init>"));
            }
            if (backingFieldOwner == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "backingFieldOwner", "org/jetbrains/kotlin/codegen/StackValue$Property", "<init>"));
            }
            if (type2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/codegen/StackValue$Property", "<init>"));
            }
            if (state == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/kotlin/codegen/StackValue$Property", "<init>"));
            }
            if (receiver == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiver", "org/jetbrains/kotlin/codegen/StackValue$Property", "<init>"));
            }
            super(type2, Property.isStatic(isStaticBackingField, getter), Property.isStatic(isStaticBackingField, setter), receiver, true);
            this.backingFieldOwner = backingFieldOwner;
            this.getter = getter;
            this.setter = setter;
            this.descriptor = descriptor;
            this.state = state;
            this.fieldName = fieldName;
        }

        @Override
        public void putSelector(@NotNull Type type2, @NotNull InstructionAdapter v) {
            if (type2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/codegen/StackValue$Property", "putSelector"));
            }
            if (v == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "v", "org/jetbrains/kotlin/codegen/StackValue$Property", "putSelector"));
            }
            if (this.getter == null) {
                assert (this.fieldName != null) : "Property should have either a getter or a field name: " + this.descriptor;
                v.visitFieldInsn(this.isStaticPut ? 178 : 180, this.backingFieldOwner.getInternalName(), this.fieldName, this.type.getDescriptor());
                AsmUtil.genNotNullAssertionForField(v, this.state, this.descriptor);
                this.coerceTo(type2, v);
            } else {
                this.getter.invokeWithoutAssertions(v);
                Property.coerce(this.getter.getAsmMethod().getReturnType(), type2, v);
            }
        }

        @Override
        public void storeSelector(@NotNull Type topOfStackType, @NotNull InstructionAdapter v) {
            if (topOfStackType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "topOfStackType", "org/jetbrains/kotlin/codegen/StackValue$Property", "storeSelector"));
            }
            if (v == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "v", "org/jetbrains/kotlin/codegen/StackValue$Property", "storeSelector"));
            }
            this.coerceFrom(topOfStackType, v);
            if (this.setter == null) {
                assert (this.fieldName != null) : "Property should have either a setter or a field name: " + this.descriptor;
                v.visitFieldInsn(this.isStaticStore ? 179 : 181, this.backingFieldOwner.getInternalName(), this.fieldName, this.type.getDescriptor());
            } else {
                this.setter.invokeWithoutAssertions(v);
            }
        }

        private static boolean isStatic(boolean isStaticBackingField, @Nullable CallableMethod callable2) {
            if (isStaticBackingField && callable2 == null) {
                return true;
            }
            if (callable2 != null && callable2.isStaticCall()) {
                JvmMethodParameterSignature parameter;
                JvmMethodParameterKind kind;
                List<JvmMethodParameterSignature> parameters2 = callable2.getValueParameters();
                Iterator<JvmMethodParameterSignature> i$ = parameters2.iterator();
                while (i$.hasNext() && (kind = (parameter = i$.next()).getKind()) != JvmMethodParameterKind.VALUE) {
                    if (kind != JvmMethodParameterKind.RECEIVER && kind != JvmMethodParameterKind.THIS) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
    }

    public static class Field
    extends StackValueWithSimpleReceiver {
        public final Type owner;
        public final String name;

        public Field(Type type2, Type owner, String name, boolean isStatic, StackValue receiver) {
            super(type2, isStatic, isStatic, receiver, receiver.canHaveSideEffects());
            this.owner = owner;
            this.name = name;
        }

        @Override
        public void putSelector(@NotNull Type type2, @NotNull InstructionAdapter v) {
            if (type2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/codegen/StackValue$Field", "putSelector"));
            }
            if (v == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "v", "org/jetbrains/kotlin/codegen/StackValue$Field", "putSelector"));
            }
            v.visitFieldInsn(this.isStaticPut ? 178 : 180, this.owner.getInternalName(), this.name, this.type.getDescriptor());
            this.coerceTo(type2, v);
        }

        @Override
        public void storeSelector(@NotNull Type topOfStackType, @NotNull InstructionAdapter v) {
            if (topOfStackType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "topOfStackType", "org/jetbrains/kotlin/codegen/StackValue$Field", "storeSelector"));
            }
            if (v == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "v", "org/jetbrains/kotlin/codegen/StackValue$Field", "storeSelector"));
            }
            this.coerceFrom(topOfStackType, v);
            v.visitFieldInsn(this.isStaticStore ? 179 : 181, this.owner.getInternalName(), this.name, this.type.getDescriptor());
        }
    }

    public static class CollectionElement
    extends StackValueWithSimpleReceiver {
        private final Callable getter;
        private final Callable setter;
        private final ExpressionCodegen codegen;
        private final GenerationState state;
        private final ResolvedCall<FunctionDescriptor> resolvedGetCall;
        private final ResolvedCall<FunctionDescriptor> resolvedSetCall;
        private final FunctionDescriptor setterDescriptor;
        private final FunctionDescriptor getterDescriptor;

        public CollectionElement(StackValue collectionElementReceiver, Type type2, ResolvedCall<FunctionDescriptor> resolvedGetCall, ResolvedCall<FunctionDescriptor> resolvedSetCall, ExpressionCodegen codegen, GenerationState state) {
            super(type2, false, false, collectionElementReceiver, true);
            this.resolvedGetCall = resolvedGetCall;
            this.resolvedSetCall = resolvedSetCall;
            this.state = state;
            this.setterDescriptor = resolvedSetCall == null ? null : resolvedSetCall.getResultingDescriptor();
            this.getterDescriptor = resolvedGetCall == null ? null : resolvedGetCall.getResultingDescriptor();
            this.setter = resolvedSetCall == null ? null : codegen.resolveToCallable(this.setterDescriptor, false);
            this.getter = resolvedGetCall == null ? null : codegen.resolveToCallable(this.getterDescriptor, false);
            this.codegen = codegen;
        }

        @Override
        public void putSelector(@NotNull Type type2, @NotNull InstructionAdapter v) {
            if (type2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/codegen/StackValue$CollectionElement", "putSelector"));
            }
            if (v == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "v", "org/jetbrains/kotlin/codegen/StackValue$CollectionElement", "putSelector"));
            }
            if (this.getter == null) {
                throw new UnsupportedOperationException("no getter specified");
            }
            if (this.getter instanceof CallableMethod) {
                ((CallableMethod)this.getter).invokeWithNotNullAssertion(v, this.state, this.resolvedGetCall);
            } else {
                StackValue result2 = ((IntrinsicMethod)this.getter).generate(this.codegen, this.type, null, Collections.<JetExpression>emptyList(), StackValue.none());
                result2.put(result2.type, v);
            }
            this.coerceTo(type2, v);
        }

        @Override
        public int receiverSize() {
            if (this.isStandardStack(this.resolvedGetCall, 1) && this.isStandardStack(this.resolvedSetCall, 2)) {
                return 2;
            }
            return -1;
        }

        private boolean isStandardStack(ResolvedCall<?> call, int valueParamsSize) {
            if (call == null) {
                return true;
            }
            List<ValueParameterDescriptor> valueParameters = call.getResultingDescriptor().getValueParameters();
            if (valueParameters.size() != valueParamsSize) {
                return false;
            }
            for (ValueParameterDescriptor valueParameter : valueParameters) {
                if (this.codegen.typeMapper.mapType(valueParameter.getType()).getSize() == 1) continue;
                return false;
            }
            return !(call.getDispatchReceiver().exists() ? call.getExtensionReceiver().exists() : this.codegen.typeMapper.mapType(call.getResultingDescriptor().getExtensionReceiverParameter().getType()).getSize() != 1);
        }

        @Override
        public void storeSelector(@NotNull Type topOfStackType, @NotNull InstructionAdapter v) {
            if (topOfStackType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "topOfStackType", "org/jetbrains/kotlin/codegen/StackValue$CollectionElement", "storeSelector"));
            }
            if (v == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "v", "org/jetbrains/kotlin/codegen/StackValue$CollectionElement", "storeSelector"));
            }
            if (this.setter == null) {
                throw new UnsupportedOperationException("no setter specified");
            }
            if (this.setter instanceof CallableMethod) {
                CallableMethod method = (CallableMethod)this.setter;
                Method asmMethod = method.getAsmMethod();
                Type[] argumentTypes = asmMethod.getArgumentTypes();
                CollectionElement.coerce(topOfStackType, argumentTypes[argumentTypes.length - 1], v);
                method.invokeWithNotNullAssertion(v, this.state, this.resolvedSetCall);
                Type returnType = asmMethod.getReturnType();
                if (returnType != Type.VOID_TYPE) {
                    AsmUtil.pop(v, returnType);
                }
            } else {
                StackValue result2 = ((IntrinsicMethod)this.setter).generate(this.codegen, null, null, Collections.<JetExpression>emptyList(), StackValue.none());
                result2.put(result2.type, v);
            }
        }
    }

    public static class CollectionElementReceiver
    extends StackValue {
        private final Callable callable;
        private final boolean isGetter;
        private final ExpressionCodegen codegen;
        private final JetExpression array;
        private final Type arrayType;
        private final JetArrayAccessExpression expression;
        private final Type[] argumentTypes;
        private final ArgumentGenerator argumentGenerator;
        private final List<ResolvedValueArgument> valueArguments;
        private final FrameMap frame;
        private final StackValue receiver;
        private final ResolvedCall<FunctionDescriptor> resolvedGetCall;
        private final ResolvedCall<FunctionDescriptor> resolvedSetCall;

        public CollectionElementReceiver(Callable callable2, StackValue receiver, ResolvedCall<FunctionDescriptor> resolvedGetCall, ResolvedCall<FunctionDescriptor> resolvedSetCall, boolean isGetter, ExpressionCodegen codegen, ArgumentGenerator argumentGenerator, List<ResolvedValueArgument> valueArguments2, JetExpression array, Type arrayType, JetArrayAccessExpression expression, Type[] argumentTypes) {
            super(AsmTypes.OBJECT_TYPE);
            this.callable = callable2;
            this.isGetter = isGetter;
            this.receiver = receiver;
            this.resolvedGetCall = resolvedGetCall;
            this.resolvedSetCall = resolvedSetCall;
            this.argumentGenerator = argumentGenerator;
            this.valueArguments = valueArguments2;
            this.codegen = codegen;
            this.array = array;
            this.arrayType = arrayType;
            this.expression = expression;
            this.argumentTypes = argumentTypes;
            this.frame = codegen.myFrameMap;
        }

        @Override
        public void putSelector(@NotNull Type type2, @NotNull InstructionAdapter v) {
            ResolvedCall<FunctionDescriptor> call;
            if (type2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/codegen/StackValue$CollectionElementReceiver", "putSelector"));
            }
            if (v == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "v", "org/jetbrains/kotlin/codegen/StackValue$CollectionElementReceiver", "putSelector"));
            }
            ResolvedCall<FunctionDescriptor> resolvedCall = call = this.isGetter ? this.resolvedGetCall : this.resolvedSetCall;
            if (this.callable instanceof CallableMethod) {
                StackValue newReceiver = StackValue.receiver(call, this.receiver, this.codegen, (CallableMethod)this.callable);
                newReceiver.put(newReceiver.type, v);
                this.argumentGenerator.generate(this.valueArguments);
            } else {
                this.codegen.gen(this.array, this.arrayType);
                int index2 = call.getExtensionReceiver().exists() ? 1 : 0;
                for (JetExpression jetExpression : this.expression.getIndexExpressions()) {
                    this.codegen.gen(jetExpression, this.argumentTypes[index2]);
                    ++index2;
                }
            }
        }

        @Override
        public void dup(@NotNull InstructionAdapter v, boolean withReceiver) {
            if (v == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "v", "org/jetbrains/kotlin/codegen/StackValue$CollectionElementReceiver", "dup"));
            }
            this.dupReceiver(v);
        }

        public void dupReceiver(@NotNull InstructionAdapter v) {
            Type type2;
            int realReceiverIndex;
            Type realReceiverType;
            if (v == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "v", "org/jetbrains/kotlin/codegen/StackValue$CollectionElementReceiver", "dupReceiver"));
            }
            if (this.isStandardStack(this.resolvedGetCall, 1) && this.isStandardStack(this.resolvedSetCall, 2)) {
                v.dup2();
                return;
            }
            FrameMap.Mark mark = this.frame.mark();
            List<ValueParameterDescriptor> valueParameters = this.resolvedGetCall.getResultingDescriptor().getValueParameters();
            int firstParamIndex = -1;
            for (int i = valueParameters.size() - 1; i >= 0; --i) {
                Type type3 = this.codegen.typeMapper.mapType(valueParameters.get(i).getType());
                firstParamIndex = this.frame.enterTemp(type3);
                v.store(firstParamIndex, type3);
            }
            ReceiverValue receiverParameter = this.resolvedGetCall.getExtensionReceiver();
            int receiverIndex = -1;
            if (receiverParameter.exists()) {
                Type type4 = this.codegen.typeMapper.mapType(receiverParameter.getType());
                receiverIndex = this.frame.enterTemp(type4);
                v.store(receiverIndex, type4);
            }
            ReceiverValue dispatchReceiver = this.resolvedGetCall.getDispatchReceiver();
            int thisIndex = -1;
            if (dispatchReceiver.exists()) {
                thisIndex = this.frame.enterTemp(AsmTypes.OBJECT_TYPE);
                v.store(thisIndex, AsmTypes.OBJECT_TYPE);
            }
            if (receiverIndex != -1) {
                realReceiverType = this.codegen.typeMapper.mapType(receiverParameter.getType());
                realReceiverIndex = receiverIndex;
            } else if (thisIndex != -1) {
                realReceiverType = AsmTypes.OBJECT_TYPE;
                realReceiverIndex = thisIndex;
            } else {
                throw new UnsupportedOperationException();
            }
            if (this.resolvedSetCall.getDispatchReceiver().exists()) {
                if (this.resolvedSetCall.getExtensionReceiver().exists()) {
                    this.codegen.generateReceiverValue(this.resolvedSetCall.getDispatchReceiver()).put(AsmTypes.OBJECT_TYPE, v);
                }
                v.load(realReceiverIndex, realReceiverType);
            } else if (this.resolvedSetCall.getExtensionReceiver().exists()) {
                v.load(realReceiverIndex, realReceiverType);
            } else {
                throw new UnsupportedOperationException();
            }
            int index2 = firstParamIndex;
            for (ValueParameterDescriptor valueParameter : valueParameters) {
                type2 = this.codegen.typeMapper.mapType(valueParameter.getType());
                v.load(index2, type2);
                index2 -= type2.getSize();
            }
            if (thisIndex != -1) {
                v.load(thisIndex, AsmTypes.OBJECT_TYPE);
            }
            if (receiverIndex != -1) {
                v.load(receiverIndex, realReceiverType);
            }
            index2 = firstParamIndex;
            for (ValueParameterDescriptor valueParameter : valueParameters) {
                type2 = this.codegen.typeMapper.mapType(valueParameter.getType());
                v.load(index2, type2);
                index2 -= type2.getSize();
            }
            mark.dropTo();
        }

        private boolean isStandardStack(ResolvedCall<?> call, int valueParamsSize) {
            if (call == null) {
                return true;
            }
            List<ValueParameterDescriptor> valueParameters = call.getResultingDescriptor().getValueParameters();
            if (valueParameters.size() != valueParamsSize) {
                return false;
            }
            for (ValueParameterDescriptor valueParameter : valueParameters) {
                if (this.codegen.typeMapper.mapType(valueParameter.getType()).getSize() == 1) continue;
                return false;
            }
            return !(call.getDispatchReceiver().exists() ? call.getExtensionReceiver().exists() : this.codegen.typeMapper.mapType(call.getResultingDescriptor().getExtensionReceiverParameter().getType()).getSize() != 1);
        }
    }

    private static class ArrayElement
    extends StackValueWithSimpleReceiver {
        private final Type type;

        public ArrayElement(Type type2, StackValue array, StackValue index2) {
            super(type2, false, false, new Receiver(Type.LONG_TYPE, array, index2), true);
            this.type = type2;
        }

        @Override
        public void storeSelector(@NotNull Type topOfStackType, @NotNull InstructionAdapter v) {
            if (topOfStackType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "topOfStackType", "org/jetbrains/kotlin/codegen/StackValue$ArrayElement", "storeSelector"));
            }
            if (v == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "v", "org/jetbrains/kotlin/codegen/StackValue$ArrayElement", "storeSelector"));
            }
            this.coerceFrom(topOfStackType, v);
            v.astore(this.type);
        }

        @Override
        public int receiverSize() {
            return 2;
        }

        @Override
        public void putSelector(@NotNull Type type2, @NotNull InstructionAdapter v) {
            if (type2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/codegen/StackValue$ArrayElement", "putSelector"));
            }
            if (v == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "v", "org/jetbrains/kotlin/codegen/StackValue$ArrayElement", "putSelector"));
            }
            v.aload(this.type);
            this.coerceTo(type2, v);
        }
    }

    private static class Invert
    extends StackValue {
        private final StackValue myOperand;

        private Invert(StackValue operand) {
            super(Type.BOOLEAN_TYPE);
            this.myOperand = operand;
            if (this.myOperand.type != Type.BOOLEAN_TYPE) {
                throw new UnsupportedOperationException("operand of ! must be boolean");
            }
        }

        @Override
        public void putSelector(@NotNull Type type2, @NotNull InstructionAdapter v) {
            if (type2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/codegen/StackValue$Invert", "putSelector"));
            }
            if (v == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "v", "org/jetbrains/kotlin/codegen/StackValue$Invert", "putSelector"));
            }
            this.putAsBoolean(v);
            this.coerceTo(type2, v);
        }

        @Override
        public void condJump(@NotNull Label label, boolean jumpIfFalse, @NotNull InstructionAdapter v) {
            if (label == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "label", "org/jetbrains/kotlin/codegen/StackValue$Invert", "condJump"));
            }
            if (v == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "v", "org/jetbrains/kotlin/codegen/StackValue$Invert", "condJump"));
            }
            this.myOperand.condJump(label, !jumpIfFalse, v);
        }
    }

    private static class ObjectCompare
    extends NumberCompare {
        public ObjectCompare(IElementType opToken, Type operandType, StackValue left, StackValue right) {
            super(opToken, operandType, left, right);
        }

        @Override
        public void condJump(@NotNull Label label, boolean jumpIfFalse, @NotNull InstructionAdapter v) {
            int opcode;
            if (label == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "label", "org/jetbrains/kotlin/codegen/StackValue$ObjectCompare", "condJump"));
            }
            if (v == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "v", "org/jetbrains/kotlin/codegen/StackValue$ObjectCompare", "condJump"));
            }
            this.left.put(this.operandType, v);
            this.right.put(this.operandType, v);
            if (this.opToken == JetTokens.EQEQEQ) {
                opcode = jumpIfFalse ? 166 : 165;
            } else if (this.opToken == JetTokens.EXCLEQEQEQ) {
                opcode = jumpIfFalse ? 165 : 166;
            } else {
                throw new UnsupportedOperationException("don't know how to generate this condjump");
            }
            v.visitJumpInsn(opcode, label);
        }
    }

    private static class NumberCompare
    extends StackValue {
        protected final IElementType opToken;
        protected final Type operandType;
        protected final StackValue left;
        protected final StackValue right;

        public NumberCompare(IElementType opToken, Type operandType, StackValue left, StackValue right) {
            super(Type.BOOLEAN_TYPE);
            this.opToken = opToken;
            this.operandType = operandType;
            this.left = left;
            this.right = right;
        }

        @Override
        public void putSelector(@NotNull Type type2, @NotNull InstructionAdapter v) {
            if (type2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/codegen/StackValue$NumberCompare", "putSelector"));
            }
            if (v == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "v", "org/jetbrains/kotlin/codegen/StackValue$NumberCompare", "putSelector"));
            }
            this.putAsBoolean(v);
            this.coerceTo(type2, v);
        }

        @Override
        public void condJump(@NotNull Label label, boolean jumpIfFalse, @NotNull InstructionAdapter v) {
            int opcode;
            if (label == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "label", "org/jetbrains/kotlin/codegen/StackValue$NumberCompare", "condJump"));
            }
            if (v == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "v", "org/jetbrains/kotlin/codegen/StackValue$NumberCompare", "condJump"));
            }
            this.left.put(this.operandType, v);
            this.right.put(this.operandType, v);
            if (this.opToken == JetTokens.EQEQ || this.opToken == JetTokens.EQEQEQ) {
                opcode = jumpIfFalse ? 154 : 153;
            } else if (this.opToken == JetTokens.EXCLEQ || this.opToken == JetTokens.EXCLEQEQEQ) {
                opcode = jumpIfFalse ? 153 : 154;
            } else if (this.opToken == JetTokens.GT) {
                opcode = jumpIfFalse ? 158 : 157;
            } else if (this.opToken == JetTokens.GTEQ) {
                opcode = jumpIfFalse ? 155 : 156;
            } else if (this.opToken == JetTokens.LT) {
                opcode = jumpIfFalse ? 156 : 155;
            } else if (this.opToken == JetTokens.LTEQ) {
                opcode = jumpIfFalse ? 157 : 158;
            } else {
                throw new UnsupportedOperationException("Don't know how to generate this condJump: " + this.opToken);
            }
            if (this.operandType == Type.FLOAT_TYPE || this.operandType == Type.DOUBLE_TYPE) {
                if (this.opToken == JetTokens.GT || this.opToken == JetTokens.GTEQ) {
                    v.cmpl(this.operandType);
                } else {
                    v.cmpg(this.operandType);
                }
            } else if (this.operandType == Type.LONG_TYPE) {
                v.lcmp();
            } else {
                opcode += 6;
            }
            v.visitJumpInsn(opcode, label);
        }
    }

    public static class Constant
    extends StackValue {
        @Nullable
        private final Object value;

        public Constant(@Nullable Object value, Type type2) {
            super(type2, false);
            this.value = value;
        }

        @Override
        public void putSelector(@NotNull Type type2, @NotNull InstructionAdapter v) {
            if (type2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/codegen/StackValue$Constant", "putSelector"));
            }
            if (v == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "v", "org/jetbrains/kotlin/codegen/StackValue$Constant", "putSelector"));
            }
            if (this.value instanceof Integer) {
                v.iconst((Integer)this.value);
            } else if (this.value instanceof Long) {
                v.lconst((Long)this.value);
            } else if (this.value instanceof Float) {
                v.fconst(((Float)this.value).floatValue());
            } else if (this.value instanceof Double) {
                v.dconst((Double)this.value);
            } else {
                v.aconst(this.value);
            }
            this.coerceTo(type2, v);
        }

        @Override
        public void condJump(@NotNull Label label, boolean jumpIfFalse, @NotNull InstructionAdapter v) {
            if (label == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "label", "org/jetbrains/kotlin/codegen/StackValue$Constant", "condJump"));
            }
            if (v == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "v", "org/jetbrains/kotlin/codegen/StackValue$Constant", "condJump"));
            }
            if (this.value instanceof Boolean) {
                boolean boolValue = (Boolean)this.value;
                if (boolValue ^ jumpIfFalse) {
                    v.goTo(label);
                }
            } else {
                throw new UnsupportedOperationException("don't know how to generate this condjump");
            }
        }
    }

    public static class OnStack
    extends StackValue {
        public OnStack(Type type2) {
            super(type2);
        }

        @Override
        public void putSelector(@NotNull Type type2, @NotNull InstructionAdapter v) {
            if (type2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/codegen/StackValue$OnStack", "putSelector"));
            }
            if (v == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "v", "org/jetbrains/kotlin/codegen/StackValue$OnStack", "putSelector"));
            }
            this.coerceTo(type2, v);
        }

        @Override
        public void moveToTopOfStack(@NotNull Type type2, @NotNull InstructionAdapter v, int depth) {
            if (type2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/codegen/StackValue$OnStack", "moveToTopOfStack"));
            }
            if (v == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "v", "org/jetbrains/kotlin/codegen/StackValue$OnStack", "moveToTopOfStack"));
            }
            if (depth == 0) {
                this.put(type2, v);
            } else if (depth == 1) {
                int size = this.type.getSize();
                if (size == 1) {
                    v.swap();
                } else if (size == 2) {
                    v.dupX2();
                    v.pop();
                } else {
                    throw new UnsupportedOperationException("don't know how to move type " + type2 + " to top of stack");
                }
                this.coerceTo(type2, v);
            } else {
                throw new UnsupportedOperationException("unsupported move-to-top depth " + depth);
            }
        }
    }

    public static class Local
    extends StackValue {
        public final int index;

        private Local(int index2, Type type2) {
            super(type2, false);
            this.index = index2;
            if (index2 < 0) {
                throw new IllegalStateException("local variable index must be non-negative");
            }
        }

        @Override
        public void putSelector(@NotNull Type type2, @NotNull InstructionAdapter v) {
            if (type2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/codegen/StackValue$Local", "putSelector"));
            }
            if (v == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "v", "org/jetbrains/kotlin/codegen/StackValue$Local", "putSelector"));
            }
            v.load(this.index, this.type);
            this.coerceTo(type2, v);
        }

        @Override
        public void storeSelector(@NotNull Type topOfStackType, @NotNull InstructionAdapter v) {
            if (topOfStackType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "topOfStackType", "org/jetbrains/kotlin/codegen/StackValue$Local", "storeSelector"));
            }
            if (v == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "v", "org/jetbrains/kotlin/codegen/StackValue$Local", "storeSelector"));
            }
            this.coerceFrom(topOfStackType, v);
            v.store(this.index, this.type);
        }
    }

    private static class None
    extends StackValue {
        public static final None INSTANCE = new None();

        private None() {
            super(Type.VOID_TYPE, false);
        }

        @Override
        public void putSelector(@NotNull Type type2, @NotNull InstructionAdapter v) {
            if (type2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/codegen/StackValue$None", "putSelector"));
            }
            if (v == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "v", "org/jetbrains/kotlin/codegen/StackValue$None", "putSelector"));
            }
            this.coerceTo(type2, v);
        }
    }
}

