/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.facade;

import com.google.common.base.Predicates;
import com.google.dart.compiler.backend.js.ast.JsNode;
import com.google.dart.compiler.backend.js.ast.JsProgram;
import com.google.dart.compiler.util.TextOutputImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analyzer.AnalysisResult;
import org.jetbrains.kotlin.backend.common.output.OutputFileCollection;
import org.jetbrains.kotlin.backend.common.output.SimpleOutputFile;
import org.jetbrains.kotlin.backend.common.output.SimpleOutputFileCollection;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.diagnostics.DiagnosticUtils;
import org.jetbrains.kotlin.js.analyze.TopDownAnalyzerFacadeForJS;
import org.jetbrains.kotlin.js.config.Config;
import org.jetbrains.kotlin.js.facade.FacadeUtils;
import org.jetbrains.kotlin.js.facade.MainCallParameters;
import org.jetbrains.kotlin.js.facade.SourceMapBuilderConsumer;
import org.jetbrains.kotlin.js.facade.Status;
import org.jetbrains.kotlin.js.facade.exceptions.TranslationException;
import org.jetbrains.kotlin.js.inline.JsInliner;
import org.jetbrains.kotlin.js.sourceMap.JsSourceGenerationVisitor;
import org.jetbrains.kotlin.js.sourceMap.SourceMap3Builder;
import org.jetbrains.kotlin.js.sourceMap.SourceMapBuilder;
import org.jetbrains.kotlin.js.translate.general.Translation;
import org.jetbrains.kotlin.psi.JetFile;
import org.jetbrains.kotlin.psi.PsiPackage;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.diagnostics.Diagnostics;
import org.jetbrains.kotlin.utils.fileUtils.FileUtilsPackage;

public final class K2JSTranslator {
    public static final String FLUSH_SYSTEM_OUT = "Kotlin.out.flush();\n";
    public static final String GET_SYSTEM_OUT = "Kotlin.out.buffer;\n";
    @NotNull
    private final Config config;

    public static Status<OutputFileCollection> translateWithMainCallParameters(@NotNull MainCallParameters mainCall, @NotNull List<JetFile> files, @NotNull File outputFile, @Nullable File outputPrefixFile, @Nullable File outputPostfixFile, @NotNull Config config, @NotNull Consumer<JsNode> astConsumer) throws TranslationException, IOException {
        if (mainCall == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mainCall", "org/jetbrains/kotlin/js/facade/K2JSTranslator", "translateWithMainCallParameters"));
        }
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "org/jetbrains/kotlin/js/facade/K2JSTranslator", "translateWithMainCallParameters"));
        }
        if (outputFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outputFile", "org/jetbrains/kotlin/js/facade/K2JSTranslator", "translateWithMainCallParameters"));
        }
        if (config == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "config", "org/jetbrains/kotlin/js/facade/K2JSTranslator", "translateWithMainCallParameters"));
        }
        if (astConsumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "astConsumer", "org/jetbrains/kotlin/js/facade/K2JSTranslator", "translateWithMainCallParameters"));
        }
        K2JSTranslator translator = new K2JSTranslator(config);
        TextOutputImpl output = new TextOutputImpl();
        SourceMap3Builder sourceMapBuilder = config.isSourcemap() ? new SourceMap3Builder(outputFile, output, new SourceMapBuilderConsumer()) : null;
        Status<String> codeStatus = translator.generateProgramCode(files, mainCall, output, sourceMapBuilder, astConsumer);
        if (codeStatus.isFail()) {
            return Status.fail();
        }
        String programCode = codeStatus.getResult();
        String prefix = FileUtilsPackage.readTextOrEmpty(outputPrefixFile);
        String postfix = FileUtilsPackage.readTextOrEmpty(outputPostfixFile);
        List<File> sourceFiles = ContainerUtil.map(files, new Function<JetFile, File>(){

            @Override
            public File fun(JetFile file) {
                VirtualFile virtualFile = file.getOriginalFile().getVirtualFile();
                if (virtualFile == null) {
                    return new File(file.getName());
                }
                return VfsUtilCore.virtualToIoFile(virtualFile);
            }
        });
        SimpleOutputFile jsFile = new SimpleOutputFile(sourceFiles, outputFile.getName(), prefix + programCode + postfix);
        SmartList<SimpleOutputFile> outputFiles = new SmartList<SimpleOutputFile>(jsFile);
        if (sourceMapBuilder != null) {
            sourceMapBuilder.skipLinesAtBeginning(StringUtil.getLineBreakCount(prefix));
            SimpleOutputFile sourceMapFile = new SimpleOutputFile(sourceFiles, sourceMapBuilder.getOutFile().getName(), sourceMapBuilder.build());
            outputFiles.add(sourceMapFile);
        }
        SimpleOutputFileCollection outputFileCollection = new SimpleOutputFileCollection(outputFiles);
        return Status.success(outputFileCollection);
    }

    public K2JSTranslator(@NotNull Config config) {
        if (config == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "config", "org/jetbrains/kotlin/js/facade/K2JSTranslator", "<init>"));
        }
        this.config = config;
    }

    @NotNull
    public Status<String> translateStringWithCallToMain(@NotNull String programText, @NotNull String argumentsString) throws TranslationException {
        if (programText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "programText", "org/jetbrains/kotlin/js/facade/K2JSTranslator", "translateStringWithCallToMain"));
        }
        if (argumentsString == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argumentsString", "org/jetbrains/kotlin/js/facade/K2JSTranslator", "translateStringWithCallToMain"));
        }
        JetFile file = PsiPackage.JetPsiFactory(this.getProject()).createFile("test", programText);
        Status<String> status = this.generateProgramCode(file, MainCallParameters.mainWithArguments(FacadeUtils.parseString(argumentsString)));
        if (status.isFail()) {
            Status<String> status2 = status;
            if (status2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/facade/K2JSTranslator", "translateStringWithCallToMain"));
            }
            return status2;
        }
        String code = FLUSH_SYSTEM_OUT + status.getResult() + "\n" + GET_SYSTEM_OUT;
        Status<String> status3 = Status.success(code);
        if (status3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/facade/K2JSTranslator", "translateStringWithCallToMain"));
        }
        return status3;
    }

    @NotNull
    public Status<String> generateProgramCode(@NotNull JetFile file, @NotNull MainCallParameters mainCallParameters) throws TranslationException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/js/facade/K2JSTranslator", "generateProgramCode"));
        }
        if (mainCallParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mainCallParameters", "org/jetbrains/kotlin/js/facade/K2JSTranslator", "generateProgramCode"));
        }
        Status<String> status = this.generateProgramCode(Collections.singletonList(file), mainCallParameters);
        if (status == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/facade/K2JSTranslator", "generateProgramCode"));
        }
        return status;
    }

    @NotNull
    public Status<String> generateProgramCode(@NotNull List<JetFile> files, @NotNull MainCallParameters mainCallParameters) throws TranslationException {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "org/jetbrains/kotlin/js/facade/K2JSTranslator", "generateProgramCode"));
        }
        if (mainCallParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mainCallParameters", "org/jetbrains/kotlin/js/facade/K2JSTranslator", "generateProgramCode"));
        }
        Status<String> status = this.generateProgramCode(files, mainCallParameters, new TextOutputImpl(), null, Consumer.EMPTY_CONSUMER);
        if (status == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/facade/K2JSTranslator", "generateProgramCode"));
        }
        return status;
    }

    @NotNull
    public Status<String> generateProgramCode(@NotNull List<JetFile> files, @NotNull MainCallParameters mainCallParameters, @NotNull TextOutputImpl output, @Nullable SourceMapBuilder sourceMapBuilder, @NotNull Consumer<JsNode> astConsumer) throws TranslationException {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "org/jetbrains/kotlin/js/facade/K2JSTranslator", "generateProgramCode"));
        }
        if (mainCallParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mainCallParameters", "org/jetbrains/kotlin/js/facade/K2JSTranslator", "generateProgramCode"));
        }
        if (output == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "output", "org/jetbrains/kotlin/js/facade/K2JSTranslator", "generateProgramCode"));
        }
        if (astConsumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "astConsumer", "org/jetbrains/kotlin/js/facade/K2JSTranslator", "generateProgramCode"));
        }
        JsProgram program = this.generateProgram(files, mainCallParameters);
        Diagnostics diagnostics = this.config.getTrace().getBindingContext().getDiagnostics();
        if (DiagnosticUtils.hasError(diagnostics)) {
            Status<String> status = Status.fail();
            if (status == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/facade/K2JSTranslator", "generateProgramCode"));
            }
            return status;
        }
        program = JsInliner.process(program);
        program.accept(new JsSourceGenerationVisitor(output, sourceMapBuilder));
        astConsumer.consume(program);
        Status<String> status = Status.success(output.toString());
        if (status == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/facade/K2JSTranslator", "generateProgramCode"));
        }
        return status;
    }

    @NotNull
    public JsProgram generateProgram(@NotNull List<JetFile> filesToTranslate, @NotNull MainCallParameters mainCallParameters) throws TranslationException {
        if (filesToTranslate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filesToTranslate", "org/jetbrains/kotlin/js/facade/K2JSTranslator", "generateProgram"));
        }
        if (mainCallParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mainCallParameters", "org/jetbrains/kotlin/js/facade/K2JSTranslator", "generateProgram"));
        }
        AnalysisResult analysisResult = TopDownAnalyzerFacadeForJS.analyzeFiles(filesToTranslate, Predicates.<PsiFile>alwaysTrue(), this.config);
        BindingContext bindingContext = analysisResult.getBindingContext();
        TopDownAnalyzerFacadeForJS.checkForErrors(Config.withJsLibAdded(filesToTranslate, this.config), bindingContext);
        ModuleDescriptor moduleDescriptor = analysisResult.getModuleDescriptor();
        JsProgram jsProgram = Translation.generateAst(bindingContext, filesToTranslate, mainCallParameters, moduleDescriptor, this.config);
        if (jsProgram == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/facade/K2JSTranslator", "generateProgram"));
        }
        return jsProgram;
    }

    @NotNull
    private Project getProject() {
        Project project = this.config.getProject();
        if (project == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/facade/K2JSTranslator", "getProject"));
        }
        return project;
    }
}

