/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.reference;

import com.google.dart.compiler.backend.js.ast.JsExpression;
import com.google.dart.compiler.backend.js.ast.JsExpressionImpl;
import com.google.dart.compiler.backend.js.ast.JsInvocation;
import com.google.dart.compiler.backend.js.ast.JsLiteral;
import com.google.dart.compiler.backend.js.ast.JsName;
import com.google.dart.compiler.backend.js.ast.JsNameRef;
import com.google.dart.compiler.backend.js.ast.JsStringLiteral;
import java.util.ArrayList;
import java.util.List;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.KotlinPackage;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KObject;
import kotlin.jvm.internal.KotlinClass;
import kotlin.reflect.jvm.internal.InternalPackage;
import kotlin.reflect.jvm.internal.KClassImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.reference.ReferenceTranslator;
import org.jetbrains.kotlin.js.translate.utils.AnnotationsUtils;
import org.jetbrains.kotlin.js.translate.utils.BindingUtils;
import org.jetbrains.kotlin.js.translate.utils.JsDescriptorUtils;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.JetCallableReferenceExpression;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.types.JetType;

@KotlinClass(abiVersion=19, data={"6\f)Y2)\u00197mC\ndWMU3gKJ,gnY3Ue\u0006t7\u000f\\1u_JT1a\u001c:h\u0015%QW\r\u001e2sC&t7O\u0003\u0004l_Rd\u0017N\u001c\u0006\u0003UNT\u0011\u0002\u001e:b]Nd\u0017\r^3\u000b\u0013I,g-\u001a:f]\u000e,'bA!os*i\u0011n]\"p]N$(/^2u_JT!\u0002Z3tGJL\u0007\u000f^8s\u0015I\u0019\u0015\r\u001c7bE2,G)Z:de&\u0004Ho\u001c:\u000b\u0017\u0011,7o\u0019:jaR|'o\u001d\u0006\b\u0005>|G.Z1o\u0015-I7/\u0012=uK:\u001c\u0018n\u001c8\u000b\u0011%\u001cX*Z7cKJTQ![:WCJT!\u0003\u0015:pa\u0016\u0014H/\u001f#fg\u000e\u0014\u0018\u000e\u001d;pe*a!j]#yaJ,7o]5p]*\u00191m\\7\u000b\r\u001d|wn\u001a7f\u0015\u0011!\u0017M\u001d;\u000b\u0011\r|W\u000e]5mKJTqAY1dW\u0016tGMC\u0002bgRT!\"\u001a=qe\u0016\u001c8/[8o\u0015yQU\r^\"bY2\f'\r\\3SK\u001a,'/\u001a8dK\u0016C\bO]3tg&|gNC\u0002qg&TqaY8oi\u0016DHO\u0003\nUe\u0006t7\u000f\\1uS>t7i\u001c8uKb$(B\t;sC:\u001cH.\u0019;f\u0003NlU-\u001c2fe\u001a+hn\u0019;j_:\u0014VMZ3sK:\u001cWMC\bdY\u0006\u001c8\u000fR3tGJL\u0007\u000f^8s\u0015=\u0019E.Y:t\t\u0016\u001c8M]5qi>\u0014(b\u0006;sC:\u001cH.\u0019;f\r>\u00148i\u001c8tiJ,8\r^8s\u0015I1UO\\2uS>tG)Z:de&\u0004Ho\u001c:\u000b;Q\u0014\u0018M\\:mCR,gi\u001c:FqR,gn]5p]\u001a+hn\u0019;j_:TQ\u0004\u001e:b]Nd\u0017\r^3G_J,\u0005\u0010^3og&|g\u000e\u0015:pa\u0016\u0014H/\u001f\u0006\u0015iJ\fgn\u001d7bi\u00164uN\u001d$v]\u000e$\u0018n\u001c8\u000b5Q\u0014\u0018M\\:mCR,gi\u001c:NK6\u0014WM\u001d$v]\u000e$\u0018n\u001c8\u000b5Q\u0014\u0018M\\:mCR,gi\u001c:NK6\u0014WM\u001d)s_B,'\u000f^=\u000b)Q\u0014\u0018M\\:mCR,gi\u001c:Qe>\u0004XM\u001d;z\u0015q!(/\u00198tY\u0006$XMR8s)>\u0004H*\u001a<fYB\u0013x\u000e]3sifTa\u0006P2mCN\u001cXf\u001c2kK\u000e$XFZ8s[\r\u000bG\u000e\\1cY\u0016\u0014VMZ3sK:\u001cW\r\u0016:b]Nd\u0017\r^8s}\t\u0010!B\u0001\t\u0002\u0015\u0011A\u0001\u0001\u0005\u0002\u000b\t!\t\u0001c\u0001\u0006\u0005\u0011\t\u0001BA\u0003\u0003\t\u0007A)!\u0002\u0002\u0005\u0005!\u0019Qa\u0001C\u0003\u0011\u0001a\u0001!B\u0001\t\u0004\u0015\u0019Aq\u0001E\u0004\u0019\u0001)!\u0001B\u0001\t\f\u0015\u0019A\u0011\u0002\u0005\u0006\u0019\u0001)1\u0001b\u0002\t\r1\u0001QA\u0001C\u0005\u0011\u0015)1\u0001\"\u0003\t\u00111\u0001Q!\u0001\u0005\n\u000b\t!q\u0001c\u0005\u0006\u0005\u0011=\u0001BC\u0003\u0003\t!A)\"\u0002\u0002\u0005\u0012!YQA\u0001\u0003\n\u0011\t)!\u0001b\u0005\t\u0018\u0015\u0019AA\u0003E\t\u0019\u0001)!\u0001\u0002\u0006\t\u0012\u0015\u0011A\u0011\u0002\u0005\t\u000b\t!\u0011\u0001C\u0007\u0006\u0007\u0011a\u0001\u0012\u0004\u0007\u0001\u000b\t!!\u0001c\u0007\u0006\u0007\u0011i\u0001B\u0004\u0007\u0001\u000b\t!A\u0002#\u0007\u0006\u0005\u0011i\u0001BD\u0003\u0004\t\u0013Ay\u0002\u0004\u0001\u0006\u0005\u0011%\u0001rD\u0003\u0004\t\u0013A\t\u0003\u0004\u0001\u0006\u0005\u0011%\u0001\u0012E\u0003\u0004\t\rAI\u0003\u0004\u0001\u0005A\u0006a1!e\u0004\u0006\u000e\u0011\u0019\u001d\u0001D\t\u001a\u0005\u0015\t\u0001bA\u001b\u00013\t)\u0011\u0001\u0003\u0003.'\u0011\t\u0001\u0004BO\u0007\t\u0001AI!\u0004\u0002\u0006\u0003!)\u0001k\u0001\u0001\"\u0005\u0015\t\u00012B)\u0004\u000b\u0011!\u0011\"\u0001C\u0001\u001b\u0005Aa!L\n\u0005\u0003a5QT\u0002\u0003\u0001\u0011\u0013i!!B\u0001\t\u000bA\u001b\u0001!\t\u0002\u0006\u0003!-\u0011kA\u0003\u0005\u000e%\tA\u0011A\u0007\u0002\u0011\u0019i3\u0003B\u0001\u0019\u000fu5A\u0001\u0001E\u0005\u001b\t)\u0011\u0001C\u0003Q\u0007\u0001\t#!B\u0001\t\fE\u001bQ\u0001B\u0004\n\u0003\u0011\u0005Q\"\u0001\u0005\u0007[M!\u0011\u0001g\u0004\u001e\u000e\u0011\u0001\u0001\u0012B\u0007\u0003\u000b\u0005Ai\u0001U\u0002\u0001C\t)\u0011\u0001#\u0006R\u0007\u0015!y!C\u0001\t\u00175\t\u0001rCW\u001d\t\u0001A*!(\u0004\u0005\u0001!aQBA\u0003\u0002\u00113\u00016\u0001AO\u0007\t\u0001AY\"\u0004\u0002\u0006\u0003!m\u0001k!\u0001\"\u0005\u0015\t\u0001RC)\u0004\u000f\u0011\u0015\u0011\"\u0001\u0005\f\u001b\u0005Aa\"D\u0001\t\u001e52C!\u0001M\u000f;\u001b!\u0001\u0001#\u0003\u000e\u0005\u0015\t\u0001\"\u0002)\u0004\u0001u5A\u0001\u0001\u0005\u0010\u001b\t)\u0011\u0001C\bQ\u0007\u0003ij\u0001\u0002\u0001\t\u001c5\u0011Q!\u0001E\u000e!\u000e\t\u0011EA\u0003\u0002\u0011+\t6!\u0003C\u000f\u0013\u0005A1\"D\u0001\t\r5\t\u0001rD\u0007\u0002\u0011;iK\u0004B\u0001\u0019!u5A\u0001\u0001E\u0005\u001b\t)\u0011\u0001\u0003\tQ\u0007\u0001ij\u0001\u0002\u0001\t\u001c5\u0011Q!\u0001E\u000e!\u000e\u0005\u0011EA\u0003\u0002\u0011+\t6a\u0002\u0003\u0011\u0013\u0005A1\"D\u0001\t\"5\t\u0001RDW\u001d\t\u0005A\u0012#(\u0004\u0005\u0001!%QBA\u0003\u0002\u0011A\u00016\u0001AO\u0007\t\u0001AY\"\u0004\u0002\u0006\u0003!m\u0001k!\u0001\"\u0005\u0015\t\u0001RC)\u0004\u000f\u0011\t\u0012\"\u0001\u0005\f\u001b\u0005A\t#D\u0001\t\u001e5fB!\u0001M\u0012;\u001b!\u0001\u0001#\u0003\u000e\u0005\u0015\t\u0001R\u0002)\u0004\u0001u5A\u0001\u0001E\u000e\u001b\t)\u0011\u0001c\u0007Q\u0007\u0003\t#!B\u0001\t\u0016E\u001bq\u0001b\t\n\u0003!YQ\"\u0001E\f\u001b\u0005Ai\",\u000f\u0005\u0003a\u0011RT\u0002\u0003\u0001\u0011\u0013i!!B\u0001\t!A\u001b\u0001!(\u0004\u0005\u0001!mQBA\u0003\u0002\u00117\u00016\u0011A\u0011\u0003\u000b\u0005A)\"U\u0002\b\tII\u0011\u0001C\u0006\u000e\u0003!\u0005R\"\u0001E\u000f[s!\u0011\u0001'\n\u001e\u000e\u0011\u0001\u0001\u0012B\u0007\u0003\u000b\u0005A\u0001\u0003U\u0002\u0001;\u001b!\u0001\u0001c\u0007\u000e\u0005\u0015\t\u00012\u0004)\u0004\u0002\u0005\u0012Q!\u0001E\u000b#\u000e9AQE\u0005\u0002\u0011-i\u0011\u0001#\t\u000e\u0003!uQ\u0016\b\u0003\u00021Mij\u0001\u0002\u0001\t\n5\u0011Q!\u0001E\u0007!\u000e\u0001QT\u0002\u0003\u0001\u00117i!!B\u0001\t\u001cA\u001b\t!\t\u0002\u0006\u0003!U\u0011kA\u0004\u0005'%\t\u0001bC\u0007\u0002\u0011/i\u0011\u0001#\b.:\u0011\t\u0001tEO\u0007\t\u0001AI!\u0004\u0002\u0006\u0003!5\u0001k\u0001\u0001\u001e\u000e\u0011\u0001\u00012D\u0007\u0003\u000b\u0005AY\u0002UB\u0001C\t)\u0011\u0001#\u0006R\u0007\u001d!9#C\u0001\t\u00175\t\u0001rC\u0007\u0002\u0011;iK\u0004B\u0001\u0019)u5A\u0001\u0001E\u0005\u001b\t)\u0011\u0001#\u0004Q\u0007\u0001ij\u0001\u0002\u0001\t\u001c5\u0011Q!\u0001E\u000e!\u000e\u0005\u0011EA\u0003\u0002\u0011+\t6a\u0002\u0003\u0015\u0013\u0005A1\"D\u0001\t\u00185\t\u0001RD\u001b\u0001"})
public final class CallableReferenceTranslator
implements KObject {
    public static final /* synthetic */ KClassImpl $kotlinClass;
    public static final CallableReferenceTranslator INSTANCE$;

    static {
        $kotlinClass = InternalPackage.kClassFromKotlin(CallableReferenceTranslator.class);
        new CallableReferenceTranslator();
    }

    @NotNull
    public final JsExpression translate(@JetValueParameter(name="expression") @NotNull JetCallableReferenceExpression expression, @JetValueParameter(name="context") @NotNull TranslationContext context2) {
        JsExpression jsExpression;
        DeclarationDescriptor descriptor;
        Intrinsics.checkParameterIsNotNull(expression, "expression");
        Intrinsics.checkParameterIsNotNull(context2, "context");
        DeclarationDescriptor declarationDescriptor = descriptor = BindingUtils.getDescriptorForReferenceExpression(context2.bindingContext(), expression.getCallableReference());
        if (declarationDescriptor instanceof PropertyDescriptor) {
            jsExpression = this.translateForProperty((PropertyDescriptor)descriptor, context2);
        } else if (declarationDescriptor instanceof FunctionDescriptor) {
            jsExpression = this.translateForFunction((FunctionDescriptor)descriptor, context2);
        } else {
            throw (Throwable)new IllegalArgumentException("Expected property or function: " + descriptor + ", expression=" + expression.getText());
        }
        return jsExpression;
    }

    private final JsExpression translateForFunction(@JetValueParameter(name="descriptor") FunctionDescriptor descriptor, @JetValueParameter(name="context") TranslationContext context2) {
        JsExpression jsExpression;
        if (JsDescriptorUtils.isBuiltin(descriptor)) {
            throw (Throwable)new UnsupportedOperationException("callable references for builtin functions are not supported yet");
        }
        if (this.isConstructor(descriptor)) {
            jsExpression = this.translateForConstructor(descriptor, context2);
        } else if (this.isExtension(descriptor)) {
            jsExpression = this.translateForExtensionFunction(descriptor, context2);
        } else if (this.isMember(descriptor)) {
            jsExpression = this.translateForMemberFunction(descriptor, context2);
        } else {
            JsExpression jsExpression2 = ReferenceTranslator.translateAsFQReference(descriptor, context2);
            jsExpression = jsExpression2;
            Intrinsics.checkExpressionValueIsNotNull(jsExpression2, "ReferenceTranslator.tran\u2026ence(descriptor, context)");
        }
        return jsExpression;
    }

    private final JsExpression translateForProperty(@JetValueParameter(name="descriptor") PropertyDescriptor descriptor, @JetValueParameter(name="context") TranslationContext context2) {
        if (JsDescriptorUtils.isBuiltin(descriptor)) {
            throw (Throwable)new UnsupportedOperationException("callable references for builtin properties are not supported yet");
        }
        return this.isExtension(descriptor) ? this.translateForExtensionProperty(descriptor, context2) : (this.isMember(descriptor) ? this.translateForMemberProperty(descriptor, context2) : this.translateForTopLevelProperty(descriptor, context2));
    }

    private final boolean isConstructor(@JetValueParameter(name="descriptor") CallableDescriptor descriptor) {
        return descriptor instanceof ConstructorDescriptor;
    }

    private final boolean isExtension(@JetValueParameter(name="descriptor") CallableDescriptor descriptor) {
        return DescriptorUtils.isExtension(descriptor);
    }

    private final boolean isMember(@JetValueParameter(name="descriptor") CallableDescriptor descriptor) {
        return JsDescriptorUtils.getContainingDeclaration(descriptor) instanceof ClassDescriptor;
    }

    private final JsExpression isVar(@JetValueParameter(name="descriptor") PropertyDescriptor descriptor) {
        return descriptor.isVar() ? JsLiteral.TRUE : JsLiteral.FALSE;
    }

    private final JsExpression translateForTopLevelProperty(@JetValueParameter(name="descriptor") PropertyDescriptor descriptor, @JetValueParameter(name="context") TranslationContext context2) {
        DeclarationDescriptor packageDescriptor = JsDescriptorUtils.getContainingDeclaration(descriptor);
        KotlinPackage.assert(packageDescriptor instanceof PackageFragmentDescriptor, "Expected PackageFragmentDescriptor: " + packageDescriptor);
        JsNameRef jsPackageNameRef = context2.getQualifiedReference(packageDescriptor);
        JsName jsPropertyName = context2.getNameForDescriptor(descriptor);
        JsStringLiteral jsPropertyNameAsString = context2.program().getStringLiteral(jsPropertyName.toString());
        return new JsInvocation(context2.namer().callableRefForTopLevelPropertyReference(), jsPackageNameRef, jsPropertyNameAsString, this.isVar(descriptor));
    }

    private final JsExpression translateForMemberProperty(@JetValueParameter(name="descriptor") PropertyDescriptor descriptor, @JetValueParameter(name="context") TranslationContext context2) {
        JsName jsPropertyName = context2.getNameForDescriptor(descriptor);
        JsStringLiteral jsPropertyNameAsString = context2.program().getStringLiteral(jsPropertyName.toString());
        return new JsInvocation(context2.namer().callableRefForMemberPropertyReference(), jsPropertyNameAsString, this.isVar(descriptor));
    }

    private final JsExpression translateForExtensionProperty(@JetValueParameter(name="descriptor") PropertyDescriptor descriptor, @JetValueParameter(name="context") TranslationContext context2) {
        PropertyGetterDescriptor propertyGetterDescriptor = descriptor.getGetter();
        if (propertyGetterDescriptor == null) {
            Intrinsics.throwNpe();
        }
        JsNameRef jsGetterNameRef = context2.getQualifiedReference(propertyGetterDescriptor);
        Name propertyName = descriptor.getName();
        JsStringLiteral jsPropertyNameAsString = context2.program().getStringLiteral(propertyName.asString());
        ArrayList<JsExpressionImpl> argumentList = new ArrayList<JsExpressionImpl>(3);
        argumentList.add(jsPropertyNameAsString);
        argumentList.add(jsGetterNameRef);
        if (descriptor.isVar()) {
            PropertySetterDescriptor propertySetterDescriptor = descriptor.getSetter();
            if (propertySetterDescriptor == null) {
                Intrinsics.throwNpe();
            }
            JsNameRef jsSetterNameRef = context2.getQualifiedReference(propertySetterDescriptor);
            argumentList.add(jsSetterNameRef);
        }
        if (AnnotationsUtils.isNativeObject(descriptor)) {
            return this.translateForMemberProperty(descriptor, context2);
        }
        return new JsInvocation(context2.namer().callableRefForExtensionPropertyReference(), (List<JsExpression>)argumentList);
    }

    private final JsExpression translateForConstructor(@JetValueParameter(name="descriptor") FunctionDescriptor descriptor, @JetValueParameter(name="context") TranslationContext context2) {
        JsExpression jsFunctionRef = ReferenceTranslator.translateAsFQReference(descriptor, context2);
        return new JsInvocation(context2.namer().callableRefForConstructorReference(), jsFunctionRef);
    }

    private final JsExpression translateForExtensionFunction(@JetValueParameter(name="descriptor") FunctionDescriptor descriptor, @JetValueParameter(name="context") TranslationContext context2) {
        ReceiverParameterDescriptor receiverParameterDescriptor = descriptor.getExtensionReceiverParameter();
        KotlinPackage.assert(receiverParameterDescriptor != null, "receiverParameter for extension should not be null");
        JsExpression jsFunctionRef = ReferenceTranslator.translateAsFQReference(descriptor, context2);
        if (Intrinsics.areEqual(descriptor.getVisibility(), Visibilities.LOCAL)) {
            JsExpression jsExpression = jsFunctionRef;
            Intrinsics.checkExpressionValueIsNotNull(jsExpression, "jsFunctionRef");
            return jsExpression;
        }
        if (AnnotationsUtils.isNativeObject(descriptor)) {
            ReceiverParameterDescriptor receiverParameterDescriptor2 = receiverParameterDescriptor;
            if (receiverParameterDescriptor2 == null) {
                Intrinsics.throwNpe();
            }
            JetType jetType = receiverParameterDescriptor2.getType();
            ClassDescriptor receiverClassDescriptor = DescriptorUtils.getClassDescriptorForType(jetType);
            CallableDescriptor callableDescriptor = descriptor;
            ClassDescriptor classDescriptor = receiverClassDescriptor;
            Intrinsics.checkExpressionValueIsNotNull(classDescriptor, "receiverClassDescriptor");
            return this.translateAsMemberFunctionReference(callableDescriptor, classDescriptor, context2);
        }
        return new JsInvocation(context2.namer().callableRefForExtensionFunctionReference(), jsFunctionRef);
    }

    private final JsExpression translateForMemberFunction(@JetValueParameter(name="descriptor") FunctionDescriptor descriptor, @JetValueParameter(name="context") TranslationContext context2) {
        DeclarationDescriptor declarationDescriptor = JsDescriptorUtils.getContainingDeclaration(descriptor);
        if (!(declarationDescriptor instanceof ClassDescriptor)) {
            declarationDescriptor = null;
        }
        ClassDescriptor classDescriptor = (ClassDescriptor)declarationDescriptor;
        if (classDescriptor == null) {
            throw (Throwable)new IllegalArgumentException("Expected ClassDescriptor: " + descriptor);
        }
        ClassDescriptor classDescriptor2 = classDescriptor;
        return this.translateAsMemberFunctionReference(descriptor, classDescriptor2, context2);
    }

    private final JsExpression translateAsMemberFunctionReference(@JetValueParameter(name="descriptor") CallableDescriptor descriptor, @JetValueParameter(name="classDescriptor") ClassDescriptor classDescriptor, @JetValueParameter(name="context") TranslationContext context2) {
        JsNameRef jsClassNameRef = context2.getQualifiedReference(classDescriptor);
        JsName funName = context2.getNameForDescriptor(descriptor);
        JsStringLiteral funNameAsString = context2.program().getStringLiteral(funName.toString());
        return new JsInvocation(context2.namer().callableRefForMemberFunctionReference(), jsClassNameRef, funNameAsString);
    }

    CallableReferenceTranslator() {
        INSTANCE$ = this;
    }
}

