/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.kdoc.parser;

import com.intellij.lang.ASTNode;
import com.intellij.psi.tree.IElementType;
import java.lang.reflect.Constructor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.JetLanguage;
import org.jetbrains.kotlin.kdoc.psi.impl.KDocElementImpl;

public class KDocElementType
extends IElementType {
    private final Constructor<? extends KDocElementImpl> psiFactory;

    public KDocElementType(String debugName, @NotNull Class<? extends KDocElementImpl> psiClass) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "org/jetbrains/kotlin/kdoc/parser/KDocElementType", "<init>"));
        }
        super(debugName, JetLanguage.INSTANCE);
        try {
            this.psiFactory = psiClass != null ? psiClass.getConstructor(ASTNode.class) : null;
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Must have a constructor with ASTNode");
        }
    }

    public KDocElementImpl createPsi(ASTNode node) {
        assert (node.getElementType() == this);
        try {
            return this.psiFactory.newInstance(node);
        }
        catch (Exception e) {
            throw new RuntimeException("Error creating psi element for node", e);
        }
    }
}

