/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.name;

import jet.runtime.typeinfo.JetValueParameter;
import kotlin.CharIterator;
import kotlin.Function1;
import kotlin.KotlinPackage;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinSyntheticClass;
import kotlin.tailRecursive;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.NamePackage$FqNamesUtil$0b4833e7$WhenMappings;
import org.jetbrains.kotlin.name.State;
import org.jetbrains.kotlin.resolve.ImportPath;

@KotlinSyntheticClass(abiVersion=19, kind=KotlinSyntheticClass.Kind.PACKAGE_PART)
public final class NamePackage$FqNamesUtil$0b4833e7 {
    public static final boolean isSubpackageOf(@JetValueParameter(name="$receiver") FqName $receiver, @JetValueParameter(name="packageName") @NotNull FqName packageName) {
        int n;
        Intrinsics.checkParameterIsNotNull(packageName, "packageName");
        if (Intrinsics.areEqual($receiver, packageName)) {
            n = 1;
        } else if (packageName.isRoot()) {
            n = 1;
        } else {
            String string = $receiver.asString();
            Intrinsics.checkExpressionValueIsNotNull(string, "this.asString()");
            String string2 = packageName.asString();
            Intrinsics.checkExpressionValueIsNotNull(string2, "packageName.asString()");
            n = NamePackage$FqNamesUtil$0b4833e7.isSubpackageOf(string, string2) ? 1 : 0;
        }
        return n != 0;
    }

    public static final boolean isParent(@JetValueParameter(name="$receiver") FqName $receiver, @JetValueParameter(name="child") @NotNull FqName child) {
        Intrinsics.checkParameterIsNotNull(child, "child");
        return NamePackage$FqNamesUtil$0b4833e7.isSubpackageOf(child, $receiver);
    }

    public static final boolean isOneSegmentFQN(@JetValueParameter(name="$receiver") FqName $receiver) {
        return !$receiver.isRoot() ? $receiver.parent().isRoot() : false;
    }

    @NotNull
    public static final FqName withoutFirstSegment(@JetValueParameter(name="$receiver") FqName $receiver) {
        if (!$receiver.isRoot() ? $receiver.parent().isRoot() : true) {
            FqName fqName2 = FqName.ROOT;
            Intrinsics.checkExpressionValueIsNotNull(fqName2, "FqName.ROOT");
            return fqName2;
        }
        String fqNameStr = $receiver.asString();
        return new FqName(KotlinPackage.substring(fqNameStr, KotlinPackage.indexOf(fqNameStr, '.') + 1, fqNameStr.length()));
    }

    public static final int numberOfSegments(@JetValueParameter(name="$receiver") FqName $receiver) {
        return $receiver.isRoot() ? 0 : 1 + NamePackage$FqNamesUtil$0b4833e7.numberOfSegments($receiver.parent());
    }

    @NotNull
    public static final FqName tail(@JetValueParameter(name="$receiver") FqName $receiver, @JetValueParameter(name="headFQN") @NotNull FqName headFQN) {
        FqName fqName2;
        Intrinsics.checkParameterIsNotNull(headFQN, "headFQN");
        if (!(!NamePackage$FqNamesUtil$0b4833e7.isSubpackageOf($receiver, headFQN)) ? headFQN.isRoot() : true) {
            fqName2 = $receiver;
        } else if (Intrinsics.areEqual($receiver, headFQN)) {
            FqName fqName3 = FqName.ROOT;
            fqName2 = fqName3;
            Intrinsics.checkExpressionValueIsNotNull(fqName3, "FqName.ROOT");
        } else {
            fqName2 = new FqName(KotlinPackage.substring($receiver.asString(), KotlinPackage.getLength(headFQN.asString()) + 1));
        }
        return fqName2;
    }

    public static final boolean isImported(@JetValueParameter(name="$receiver") FqName $receiver, @JetValueParameter(name="importPath") @NotNull ImportPath importPath, @JetValueParameter(name="skipAliasedImports") boolean skipAliasedImports) {
        Intrinsics.checkParameterIsNotNull(importPath, "importPath");
        return (skipAliasedImports ? importPath.hasAlias() : false) ? false : ((importPath.isAllUnder() ? !$receiver.isRoot() : false) ? Intrinsics.areEqual(importPath.fqnPart(), $receiver.parent()) : Intrinsics.areEqual(importPath.fqnPart(), $receiver));
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isImported$default(FqName fqName2, ImportPath importPath, boolean bl, int n) {
        int n2;
        void var3_4;
        if ((var3_4 & 2) != 0) {
            n2 = 1;
        }
        return NamePackage$FqNamesUtil$0b4833e7.isImported(fqName2, importPath, n2 != 0);
    }

    public static final boolean isImported(@JetValueParameter(name="$receiver") ImportPath $receiver, @JetValueParameter(name="alreadyImported") @NotNull ImportPath alreadyImported) {
        Intrinsics.checkParameterIsNotNull(alreadyImported, "alreadyImported");
        return (!$receiver.isAllUnder() ? $receiver.hasAlias() : true) ? Intrinsics.areEqual($receiver, alreadyImported) : NamePackage$FqNamesUtil$0b4833e7.isImported$default($receiver.fqnPart(), alreadyImported, false, 2);
    }

    public static final boolean isImported(@JetValueParameter(name="$receiver") ImportPath $receiver, @JetValueParameter(name="imports") @NotNull Iterable<? extends ImportPath> imports) {
        boolean bl;
        block1: {
            Intrinsics.checkParameterIsNotNull(imports, "imports");
            Iterable<? extends ImportPath> iterable = imports;
            for (ImportPath importPath : iterable) {
                ImportPath it = importPath;
                if (!NamePackage$FqNamesUtil$0b4833e7.isImported($receiver, it)) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    public static final boolean isValidJavaFqName(@JetValueParameter(name="qualifiedName", type="?") @Nullable String qualifiedName) {
        if (qualifiedName == null) {
            return false;
        }
        State state = State.BEGINNING;
        CharIterator charIterator = KotlinPackage.iterator(qualifiedName);
        while (charIterator.hasNext()) {
            char c = charIterator.nextChar();
            switch (NamePackage$FqNamesUtil$0b4833e7$WhenMappings.$EnumSwitchMapping$0[state.ordinal()]) {
                case 1: 
                case 2: {
                    if (!Character.isJavaIdentifierPart(c)) {
                        return false;
                    }
                    state = State.MIDDLE;
                    break;
                }
                case 3: {
                    if (c == '.') {
                        state = State.AFTER_DOT;
                        break;
                    }
                    if (Character.isJavaIdentifierPart(c)) break;
                    return false;
                }
            }
        }
        return Intrinsics.areEqual(state, State.AFTER_DOT) ^ true;
    }

    @NotNull
    public static final Name getFirstSegment(@JetValueParameter(name="$receiver") FqName $receiver) {
        Name name = KotlinPackage.first($receiver.pathSegments());
        Intrinsics.checkExpressionValueIsNotNull(name, "this.pathSegments().first()");
        return name;
    }

    @tailRecursive
    public static final void each(@JetValueParameter(name="$receiver") FqName $receiver, @JetValueParameter(name="operation") @NotNull Function1<? super FqName, ? extends Boolean> operation) {
        while (true) {
            Intrinsics.checkParameterIsNotNull(operation, "operation");
            boolean bl = operation.invoke($receiver).booleanValue() ? !$receiver.isRoot() : false;
            if (!bl) break;
            $receiver = $receiver.parent();
        }
    }

    public static final boolean isSubpackageOf(@JetValueParameter(name="subpackageNameStr") @NotNull String subpackageNameStr, @JetValueParameter(name="packageNameStr") @NotNull String packageNameStr) {
        Intrinsics.checkParameterIsNotNull(subpackageNameStr, "subpackageNameStr");
        Intrinsics.checkParameterIsNotNull(packageNameStr, "packageNameStr");
        return !Intrinsics.areEqual(subpackageNameStr, packageNameStr) ? (KotlinPackage.startsWith(subpackageNameStr, packageNameStr) ? subpackageNameStr.charAt(packageNameStr.length()) == '.' : false) : true;
    }

    @NotNull
    public static final String getFirstSegment(@JetValueParameter(name="fqn") @NotNull String fqn) {
        Intrinsics.checkParameterIsNotNull(fqn, "fqn");
        int dotIndex = KotlinPackage.indexOf(fqn, '.');
        return dotIndex != -1 ? KotlinPackage.substring(fqn, 0, dotIndex) : fqn;
    }
}

