/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.checkers;

import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.InlineUtil;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorWithVisibility;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.lexer.JetToken;
import org.jetbrains.kotlin.lexer.JetTokens;
import org.jetbrains.kotlin.psi.JetBinaryExpression;
import org.jetbrains.kotlin.psi.JetDeclaration;
import org.jetbrains.kotlin.psi.JetElement;
import org.jetbrains.kotlin.psi.JetExpression;
import org.jetbrains.kotlin.psi.JetMultiDeclaration;
import org.jetbrains.kotlin.psi.JetOperationExpression;
import org.jetbrains.kotlin.psi.JetProperty;
import org.jetbrains.kotlin.psi.JetPsiUtil;
import org.jetbrains.kotlin.psi.JetSimpleNameExpression;
import org.jetbrains.kotlin.psi.JetThisExpression;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.InlineDescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilPackage;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.context.BasicCallResolutionContext;
import org.jetbrains.kotlin.resolve.calls.model.DefaultValueArgument;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedValueArgument;
import org.jetbrains.kotlin.resolve.calls.model.VariableAsFunctionResolvedCall;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExtensionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.types.JetType;

class InlineChecker
implements CallChecker {
    private final SimpleFunctionDescriptor descriptor;
    private final Set<CallableDescriptor> inlinableParameters;
    private final boolean isEffectivelyPublicApiFunction;

    public InlineChecker(@NotNull SimpleFunctionDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/resolve/calls/checkers/InlineChecker", "<init>"));
        }
        this.inlinableParameters = new HashSet<CallableDescriptor>();
        assert (descriptor.getInlineStrategy().isInline()) : "This extension should be created only for inline functions but not " + descriptor;
        this.descriptor = descriptor;
        this.isEffectivelyPublicApiFunction = this.isEffectivelyPublicApi(descriptor);
        for (ValueParameterDescriptor param : descriptor.getValueParameters()) {
            if (!InlineChecker.isInlinableParameter(param)) continue;
            this.inlinableParameters.add(param);
        }
        ReceiverParameterDescriptor receiverParameter = descriptor.getExtensionReceiverParameter();
        if (receiverParameter != null && InlineChecker.isInlinableParameter(receiverParameter)) {
            this.inlinableParameters.add(receiverParameter);
        }
    }

    @Override
    public <F extends CallableDescriptor> void check(@NotNull ResolvedCall<F> resolvedCall, @NotNull BasicCallResolutionContext context2) {
        if (resolvedCall == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolvedCall", "org/jetbrains/kotlin/resolve/calls/checkers/InlineChecker", "check"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/resolve/calls/checkers/InlineChecker", "check"));
        }
        JetExpression expression = context2.call.getCalleeExpression();
        if (expression == null) {
            return;
        }
        F targetDescriptor = resolvedCall.getResultingDescriptor();
        this.checkCallWithReceiver(context2, (CallableDescriptor)targetDescriptor, resolvedCall.getDispatchReceiver(), expression);
        this.checkCallWithReceiver(context2, (CallableDescriptor)targetDescriptor, resolvedCall.getExtensionReceiver(), expression);
        if (this.inlinableParameters.contains(targetDescriptor) && !InlineChecker.isInsideCall(expression)) {
            context2.trace.report(Errors.USAGE_IS_NOT_INLINABLE.on(expression, expression, this.descriptor));
        }
        for (Map.Entry<ValueParameterDescriptor, ResolvedValueArgument> entry : resolvedCall.getValueArguments().entrySet()) {
            ResolvedValueArgument value = entry.getValue();
            ValueParameterDescriptor valueDescriptor = entry.getKey();
            if (value instanceof DefaultValueArgument) continue;
            for (ValueArgument argument : value.getArguments()) {
                this.checkValueParameter(context2, (CallableDescriptor)targetDescriptor, argument, valueDescriptor);
            }
        }
        this.checkVisibility((CallableDescriptor)targetDescriptor, expression, context2);
        this.checkRecursion(context2, (CallableDescriptor)targetDescriptor, expression);
    }

    private static boolean isInsideCall(JetExpression expression) {
        JetToken token;
        JetExpression parent = JetPsiUtil.getParentCallIfPresent(expression);
        if (parent instanceof JetBinaryExpression && ((token = JetPsiUtil.getOperationToken((JetOperationExpression)parent)) == JetTokens.EQ || token == JetTokens.ANDAND || token == JetTokens.OROR)) {
            return false;
        }
        return parent != null;
    }

    private void checkValueParameter(@NotNull BasicCallResolutionContext context2, @NotNull CallableDescriptor targetDescriptor, @NotNull ValueArgument targetArgument, @NotNull ValueParameterDescriptor targetParameterDescriptor) {
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/resolve/calls/checkers/InlineChecker", "checkValueParameter"));
        }
        if (targetDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetDescriptor", "org/jetbrains/kotlin/resolve/calls/checkers/InlineChecker", "checkValueParameter"));
        }
        if (targetArgument == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetArgument", "org/jetbrains/kotlin/resolve/calls/checkers/InlineChecker", "checkValueParameter"));
        }
        if (targetParameterDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetParameterDescriptor", "org/jetbrains/kotlin/resolve/calls/checkers/InlineChecker", "checkValueParameter"));
        }
        JetExpression argumentExpression = targetArgument.getArgumentExpression();
        if (argumentExpression == null) {
            return;
        }
        CallableDescriptor argumentCallee = InlineChecker.getCalleeDescriptor(context2, argumentExpression, false);
        if (argumentCallee != null && this.inlinableParameters.contains(argumentCallee)) {
            boolean isTargetInlineFunction;
            boolean bl = isTargetInlineFunction = targetDescriptor instanceof SimpleFunctionDescriptor && ((SimpleFunctionDescriptor)targetDescriptor).getInlineStrategy().isInline();
            if (!isTargetInlineFunction || !InlineChecker.isInlinableParameter(targetParameterDescriptor)) {
                context2.trace.report(Errors.USAGE_IS_NOT_INLINABLE.on(argumentExpression, argumentExpression, this.descriptor));
            } else if (InlineDescriptorUtils.allowsNonLocalReturns(argumentCallee) && !InlineDescriptorUtils.allowsNonLocalReturns(targetParameterDescriptor)) {
                context2.trace.report(Errors.NON_LOCAL_RETURN_NOT_ALLOWED.on(argumentExpression, argumentExpression, argumentCallee, this.descriptor));
            } else {
                this.checkNonLocalReturn(context2, argumentCallee, argumentExpression);
            }
        }
    }

    private void checkCallWithReceiver(@NotNull BasicCallResolutionContext context2, @NotNull CallableDescriptor targetDescriptor, @NotNull ReceiverValue receiver, @Nullable JetExpression expression) {
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/resolve/calls/checkers/InlineChecker", "checkCallWithReceiver"));
        }
        if (targetDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetDescriptor", "org/jetbrains/kotlin/resolve/calls/checkers/InlineChecker", "checkCallWithReceiver"));
        }
        if (receiver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiver", "org/jetbrains/kotlin/resolve/calls/checkers/InlineChecker", "checkCallWithReceiver"));
        }
        if (!receiver.exists()) {
            return;
        }
        CallableDescriptor varDescriptor = null;
        JetExpression receiverExpression = null;
        if (receiver instanceof ExpressionReceiver) {
            receiverExpression = ((ExpressionReceiver)receiver).getExpression();
            varDescriptor = InlineChecker.getCalleeDescriptor(context2, receiverExpression, true);
        } else if (receiver instanceof ExtensionReceiver) {
            ExtensionReceiver extensionReceiver2 = (ExtensionReceiver)receiver;
            CallableDescriptor extension = extensionReceiver2.getDeclarationDescriptor();
            varDescriptor = extension.getExtensionReceiverParameter();
            assert (varDescriptor != null) : "Extension should have receiverParameterDescriptor: " + extension;
            receiverExpression = expression;
        }
        if (this.inlinableParameters.contains(varDescriptor)) {
            this.checkLambdaInvokeOrExtensionCall(context2, varDescriptor, targetDescriptor, receiverExpression);
        }
    }

    @Nullable
    private static CallableDescriptor getCalleeDescriptor(@NotNull BasicCallResolutionContext context2, @NotNull JetExpression expression, boolean unwrapVariableAsFunction) {
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/resolve/calls/checkers/InlineChecker", "getCalleeDescriptor"));
        }
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/resolve/calls/checkers/InlineChecker", "getCalleeDescriptor"));
        }
        if (!(expression instanceof JetSimpleNameExpression) && !(expression instanceof JetThisExpression)) {
            return null;
        }
        ResolvedCall<? extends CallableDescriptor> thisCall = CallUtilPackage.getResolvedCall(expression, context2.trace.getBindingContext());
        if (unwrapVariableAsFunction && thisCall instanceof VariableAsFunctionResolvedCall) {
            return ((VariableAsFunctionResolvedCall)((Object)thisCall)).getVariableCall().getResultingDescriptor();
        }
        return thisCall != null ? thisCall.getResultingDescriptor() : null;
    }

    private void checkLambdaInvokeOrExtensionCall(@NotNull BasicCallResolutionContext context2, @NotNull CallableDescriptor lambdaDescriptor, @NotNull CallableDescriptor callDescriptor, @NotNull JetExpression receiverExpresssion) {
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/resolve/calls/checkers/InlineChecker", "checkLambdaInvokeOrExtensionCall"));
        }
        if (lambdaDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lambdaDescriptor", "org/jetbrains/kotlin/resolve/calls/checkers/InlineChecker", "checkLambdaInvokeOrExtensionCall"));
        }
        if (callDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callDescriptor", "org/jetbrains/kotlin/resolve/calls/checkers/InlineChecker", "checkLambdaInvokeOrExtensionCall"));
        }
        if (receiverExpresssion == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiverExpresssion", "org/jetbrains/kotlin/resolve/calls/checkers/InlineChecker", "checkLambdaInvokeOrExtensionCall"));
        }
        boolean inlinableCall = InlineChecker.isInvokeOrInlineExtension(callDescriptor);
        if (!inlinableCall) {
            context2.trace.report(Errors.USAGE_IS_NOT_INLINABLE.on(receiverExpresssion, receiverExpresssion, this.descriptor));
        } else {
            this.checkNonLocalReturn(context2, lambdaDescriptor, receiverExpresssion);
        }
    }

    public void checkRecursion(@NotNull BasicCallResolutionContext context2, @NotNull CallableDescriptor targetDescriptor, @NotNull JetElement expression) {
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/resolve/calls/checkers/InlineChecker", "checkRecursion"));
        }
        if (targetDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetDescriptor", "org/jetbrains/kotlin/resolve/calls/checkers/InlineChecker", "checkRecursion"));
        }
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/resolve/calls/checkers/InlineChecker", "checkRecursion"));
        }
        if (targetDescriptor.getOriginal() == this.descriptor) {
            context2.trace.report(Errors.RECURSION_IN_INLINE.on(expression, expression, this.descriptor));
        }
    }

    private static boolean isInlinableParameter(@NotNull CallableDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/resolve/calls/checkers/InlineChecker", "isInlinableParameter"));
        }
        JetType type2 = descriptor.getReturnType();
        return type2 != null && KotlinBuiltIns.isExactFunctionOrExtensionFunctionType(type2) && !type2.isMarkedNullable() && !InlineUtil.hasNoinlineAnnotation(descriptor);
    }

    private static boolean isInvokeOrInlineExtension(@NotNull CallableDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/resolve/calls/checkers/InlineChecker", "isInvokeOrInlineExtension"));
        }
        if (!(descriptor instanceof SimpleFunctionDescriptor)) {
            return false;
        }
        DeclarationDescriptor containingDeclaration = descriptor.getContainingDeclaration();
        boolean isInvoke = descriptor.getName().asString().equals("invoke") && containingDeclaration instanceof ClassDescriptor && KotlinBuiltIns.isExactFunctionOrExtensionFunctionType(((ClassDescriptor)containingDeclaration).getDefaultType());
        return isInvoke || ((SimpleFunctionDescriptor)descriptor).getInlineStrategy().isInline();
    }

    private void checkVisibility(@NotNull CallableDescriptor declarationDescriptor, @NotNull JetElement expression, @NotNull BasicCallResolutionContext context2) {
        if (declarationDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declarationDescriptor", "org/jetbrains/kotlin/resolve/calls/checkers/InlineChecker", "checkVisibility"));
        }
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/resolve/calls/checkers/InlineChecker", "checkVisibility"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/resolve/calls/checkers/InlineChecker", "checkVisibility"));
        }
        if (this.isEffectivelyPublicApiFunction && !this.isEffectivelyPublicApi(declarationDescriptor) && declarationDescriptor.getVisibility() != Visibilities.LOCAL) {
            context2.trace.report(Errors.INVISIBLE_MEMBER_FROM_INLINE.on(expression, declarationDescriptor, this.descriptor));
        }
    }

    private boolean isEffectivelyPublicApi(@NotNull DeclarationDescriptorWithVisibility startDescriptor) {
        if (startDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startDescriptor", "org/jetbrains/kotlin/resolve/calls/checkers/InlineChecker", "isEffectivelyPublicApi"));
        }
        DeclarationDescriptorWithVisibility parent = startDescriptor;
        while (parent != null) {
            if (!parent.getVisibility().isPublicAPI()) {
                return parent.getContainingDeclaration() == this.descriptor;
            }
            parent = DescriptorUtils.getParentOfType(parent, DeclarationDescriptorWithVisibility.class);
        }
        return true;
    }

    private void checkNonLocalReturn(@NotNull BasicCallResolutionContext context2, @NotNull CallableDescriptor inlinableParameterDescriptor, @NotNull JetExpression parameterUsage) {
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/resolve/calls/checkers/InlineChecker", "checkNonLocalReturn"));
        }
        if (inlinableParameterDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inlinableParameterDescriptor", "org/jetbrains/kotlin/resolve/calls/checkers/InlineChecker", "checkNonLocalReturn"));
        }
        if (parameterUsage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameterUsage", "org/jetbrains/kotlin/resolve/calls/checkers/InlineChecker", "checkNonLocalReturn"));
        }
        if (!InlineDescriptorUtils.allowsNonLocalReturns(inlinableParameterDescriptor)) {
            return;
        }
        if (!InlineDescriptorUtils.checkNonLocalReturnUsage(this.descriptor, parameterUsage, context2.trace)) {
            context2.trace.report(Errors.NON_LOCAL_RETURN_NOT_ALLOWED.on(parameterUsage, parameterUsage, inlinableParameterDescriptor, this.descriptor));
        }
    }

    @Nullable
    public static PsiElement getDeclaration(JetExpression expression) {
        while ((expression = (JetExpression)PsiTreeUtil.getParentOfType((PsiElement)expression, JetDeclaration.class)) instanceof JetMultiDeclaration || expression instanceof JetProperty) {
        }
        return expression;
    }
}

