/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm;

import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.PrimitiveType;
import org.jetbrains.kotlin.name.FqName;

public enum JvmPrimitiveType {
    BOOLEAN(PrimitiveType.BOOLEAN, "boolean", "java.lang.Boolean"),
    CHAR(PrimitiveType.CHAR, "char", "java.lang.Character"),
    BYTE(PrimitiveType.BYTE, "byte", "java.lang.Byte"),
    SHORT(PrimitiveType.SHORT, "short", "java.lang.Short"),
    INT(PrimitiveType.INT, "int", "java.lang.Integer"),
    FLOAT(PrimitiveType.FLOAT, "float", "java.lang.Float"),
    LONG(PrimitiveType.LONG, "long", "java.lang.Long"),
    DOUBLE(PrimitiveType.DOUBLE, "double", "java.lang.Double");

    private static final Set<FqName> WRAPPERS_CLASS_NAMES;
    private final PrimitiveType primitiveType;
    private final String name;
    private final FqName wrapperFqName;

    public static boolean isWrapperClassName(@NotNull FqName className) {
        if (className == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "className", "org/jetbrains/kotlin/resolve/jvm/JvmPrimitiveType", "isWrapperClassName"));
        }
        return WRAPPERS_CLASS_NAMES.contains(className);
    }

    private JvmPrimitiveType(@NotNull PrimitiveType primitiveType, @NotNull String name, @NotNull String wrapperClassName) {
        if (primitiveType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "primitiveType", "org/jetbrains/kotlin/resolve/jvm/JvmPrimitiveType", "<init>"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/resolve/jvm/JvmPrimitiveType", "<init>"));
        }
        if (wrapperClassName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "wrapperClassName", "org/jetbrains/kotlin/resolve/jvm/JvmPrimitiveType", "<init>"));
        }
        this.primitiveType = primitiveType;
        this.name = name;
        this.wrapperFqName = new FqName(wrapperClassName);
    }

    @NotNull
    public PrimitiveType getPrimitiveType() {
        PrimitiveType primitiveType = this.primitiveType;
        if (primitiveType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/jvm/JvmPrimitiveType", "getPrimitiveType"));
        }
        return primitiveType;
    }

    @NotNull
    public String getName() {
        String string = this.name;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/jvm/JvmPrimitiveType", "getName"));
        }
        return string;
    }

    @NotNull
    public FqName getWrapperFqName() {
        FqName fqName2 = this.wrapperFqName;
        if (fqName2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/jvm/JvmPrimitiveType", "getWrapperFqName"));
        }
        return fqName2;
    }

    static {
        WRAPPERS_CLASS_NAMES = new HashSet<FqName>();
        for (JvmPrimitiveType primitiveType : JvmPrimitiveType.values()) {
            WRAPPERS_CLASS_NAMES.add(primitiveType.getWrapperFqName());
        }
    }
}

