/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.lazy.descriptors;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNameIdentifierOwner;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Function0;
import kotlin.Function1;
import kotlin.KotlinPackage;
import kotlin.Unit;
import kotlin.jvm.internal.KObject;
import org.jetbrains.annotations.Mutable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.ReadOnly;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptorWithResolutionScopes;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.descriptors.impl.ClassDescriptorBase;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.SpecialNames;
import org.jetbrains.kotlin.psi.JetAnnotationEntry;
import org.jetbrains.kotlin.psi.JetClassObject;
import org.jetbrains.kotlin.psi.JetClassOrObject;
import org.jetbrains.kotlin.psi.JetDelegationSpecifier;
import org.jetbrains.kotlin.psi.JetModifierList;
import org.jetbrains.kotlin.psi.JetParameter;
import org.jetbrains.kotlin.psi.JetPsiUtil;
import org.jetbrains.kotlin.psi.JetTypeParameter;
import org.jetbrains.kotlin.psi.JetTypeParameterList;
import org.jetbrains.kotlin.psi.JetTypeReference;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.ModifiersChecker;
import org.jetbrains.kotlin.resolve.lazy.ForceResolveUtil;
import org.jetbrains.kotlin.resolve.lazy.LazyClassContext;
import org.jetbrains.kotlin.resolve.lazy.LazyEntity;
import org.jetbrains.kotlin.resolve.lazy.data.JetClassInfoUtil;
import org.jetbrains.kotlin.resolve.lazy.data.JetClassLikeInfo;
import org.jetbrains.kotlin.resolve.lazy.data.SyntheticClassObjectInfo;
import org.jetbrains.kotlin.resolve.lazy.declarations.ClassMemberDeclarationProvider;
import org.jetbrains.kotlin.resolve.lazy.descriptors.LazyAnnotations;
import org.jetbrains.kotlin.resolve.lazy.descriptors.LazyAnnotationsContext;
import org.jetbrains.kotlin.resolve.lazy.descriptors.LazyClassMemberScope;
import org.jetbrains.kotlin.resolve.lazy.descriptors.LazyTypeParameterDescriptor;
import org.jetbrains.kotlin.resolve.scopes.ChainedScope;
import org.jetbrains.kotlin.resolve.scopes.ClassObjectMixinScope;
import org.jetbrains.kotlin.resolve.scopes.JetScope;
import org.jetbrains.kotlin.resolve.scopes.RedeclarationHandler;
import org.jetbrains.kotlin.resolve.scopes.StaticScopeForKotlinClass;
import org.jetbrains.kotlin.resolve.scopes.WritableScope;
import org.jetbrains.kotlin.resolve.scopes.WritableScopeImpl;
import org.jetbrains.kotlin.resolve.source.SourcePackage;
import org.jetbrains.kotlin.storage.MemoizedFunctionToNotNull;
import org.jetbrains.kotlin.storage.NotNullLazyValue;
import org.jetbrains.kotlin.storage.NullableLazyValue;
import org.jetbrains.kotlin.storage.StorageManager;
import org.jetbrains.kotlin.types.AbstractClassTypeConstructor;
import org.jetbrains.kotlin.types.JetType;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeUtils;

public class LazyClassDescriptor
extends ClassDescriptorBase
implements ClassDescriptorWithResolutionScopes,
LazyEntity {
    private static final Predicate<JetType> VALID_SUPERTYPE = new Predicate<JetType>(){

        @Override
        public boolean apply(JetType type2) {
            assert (!type2.isError()) : "Error types must be filtered out in DescriptorResolver";
            return TypeUtils.getClassDescriptor(type2) != null;
        }
    };
    private final LazyClassContext c;
    private final JetClassLikeInfo originalClassInfo;
    private final ClassMemberDeclarationProvider declarationProvider;
    private final LazyClassTypeConstructor typeConstructor;
    private final Modality modality;
    private final Visibility visibility;
    private final ClassKind kind;
    private final boolean isInner;
    private final Annotations annotations;
    private final Annotations danglingAnnotations;
    private final NullableLazyValue<LazyClassDescriptor> classObjectDescriptor;
    private final MemoizedFunctionToNotNull<JetClassObject, ClassDescriptor> extraClassObjectDescriptors;
    private final LazyClassMemberScope unsubstitutedMemberScope;
    private final JetScope staticScope;
    private final NotNullLazyValue<JetScope> scopeForClassHeaderResolution;
    private final NotNullLazyValue<JetScope> scopeForMemberDeclarationResolution;
    private final NotNullLazyValue<JetScope> scopeForPropertyInitializerResolution;
    private final NullableLazyValue<Void> forceResolveAllContents;

    public LazyClassDescriptor(@NotNull LazyClassContext c, @NotNull DeclarationDescriptor containingDeclaration, @NotNull Name name, @NotNull JetClassLikeInfo classLikeInfo) {
        boolean isLocal;
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "org/jetbrains/kotlin/resolve/lazy/descriptors/LazyClassDescriptor", "<init>"));
        }
        if (containingDeclaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingDeclaration", "org/jetbrains/kotlin/resolve/lazy/descriptors/LazyClassDescriptor", "<init>"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/resolve/lazy/descriptors/LazyClassDescriptor", "<init>"));
        }
        if (classLikeInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classLikeInfo", "org/jetbrains/kotlin/resolve/lazy/descriptors/LazyClassDescriptor", "<init>"));
        }
        super(c.getStorageManager(), containingDeclaration, name, SourcePackage.toSourceElement(classLikeInfo.getCorrespondingClassOrObject()));
        this.staticScope = new StaticScopeForKotlinClass(this);
        this.c = c;
        JetClassOrObject classOrObject = classLikeInfo.getCorrespondingClassOrObject();
        if (classOrObject != null) {
            this.c.getTrace().record(BindingContext.CLASS, classOrObject, this);
        }
        this.c.getTrace().record(BindingContext.FQNAME_TO_CLASS_DESCRIPTOR, DescriptorUtils.getFqName(this), this);
        this.originalClassInfo = classLikeInfo;
        this.declarationProvider = c.getDeclarationProviderFactory().getClassMemberDeclarationProvider(classLikeInfo);
        this.unsubstitutedMemberScope = this.createMemberScope(c, this.declarationProvider);
        this.typeConstructor = new LazyClassTypeConstructor();
        this.kind = classLikeInfo.getClassKind();
        JetModifierList modifierList = classLikeInfo.getModifierList();
        if (this.kind.isSingleton()) {
            this.modality = Modality.FINAL;
        } else {
            Modality defaultModality = this.kind == ClassKind.TRAIT ? Modality.ABSTRACT : Modality.FINAL;
            this.modality = ModifiersChecker.resolveModalityFromModifiers(modifierList, defaultModality);
        }
        boolean bl = isLocal = classOrObject != null && JetPsiUtil.isLocal(classOrObject);
        this.visibility = DescriptorUtils.isSyntheticClassObject(this) ? DescriptorUtils.getSyntheticClassObjectVisibility() : (isLocal ? Visibilities.LOCAL : ModifiersChecker.resolveVisibilityFromModifiers(modifierList, ModifiersChecker.getDefaultClassVisibility(this)));
        this.isInner = ModifiersChecker.isInnerClass(modifierList) && !ModifiersChecker.isIllegalInner(this);
        StorageManager storageManager = c.getStorageManager();
        this.annotations = modifierList != null ? new LazyAnnotations(new LazyAnnotationsContext(c.getAnnotationResolver(), storageManager, c.getTrace()){

            @Override
            @NotNull
            public JetScope getScope() {
                JetScope jetScope = LazyClassDescriptor.this.getOuterScope();
                if (jetScope == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/descriptors/LazyClassDescriptor$2", "getScope"));
                }
                return jetScope;
            }
        }, modifierList.getAnnotationEntries()) : Annotations.EMPTY;
        List<JetAnnotationEntry> jetDanglingAnnotations = classLikeInfo.getDanglingAnnotations();
        this.danglingAnnotations = jetDanglingAnnotations.isEmpty() ? Annotations.EMPTY : new LazyAnnotations(new LazyAnnotationsContext(c.getAnnotationResolver(), storageManager, c.getTrace()){

            @Override
            @NotNull
            public JetScope getScope() {
                JetScope jetScope = LazyClassDescriptor.this.getScopeForMemberDeclarationResolution();
                if (jetScope == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/descriptors/LazyClassDescriptor$3", "getScope"));
                }
                return jetScope;
            }
        }, jetDanglingAnnotations);
        this.classObjectDescriptor = storageManager.createNullableLazyValue(new Function0<LazyClassDescriptor>(){

            @Override
            public LazyClassDescriptor invoke() {
                return LazyClassDescriptor.this.computeClassObjectDescriptor(LazyClassDescriptor.this.getClassObjectIfAllowed());
            }
        });
        this.extraClassObjectDescriptors = storageManager.createMemoizedFunction(new Function1<JetClassObject, ClassDescriptor>(){

            @Override
            public ClassDescriptor invoke(JetClassObject classObject) {
                return LazyClassDescriptor.this.computeClassObjectDescriptor(classObject);
            }
        });
        this.scopeForClassHeaderResolution = storageManager.createLazyValue(new Function0<JetScope>(){

            @Override
            public JetScope invoke() {
                return LazyClassDescriptor.this.computeScopeForClassHeaderResolution();
            }
        });
        this.scopeForMemberDeclarationResolution = storageManager.createLazyValue(new Function0<JetScope>(){

            @Override
            public JetScope invoke() {
                return LazyClassDescriptor.this.computeScopeForMemberDeclarationResolution();
            }
        });
        this.scopeForPropertyInitializerResolution = storageManager.createLazyValue(new Function0<JetScope>(){

            @Override
            public JetScope invoke() {
                return LazyClassDescriptor.this.computeScopeForPropertyInitializerResolution();
            }
        });
        this.forceResolveAllContents = storageManager.createRecursionTolerantNullableLazyValue(new Function0<Void>(){

            @Override
            public Void invoke() {
                LazyClassDescriptor.this.doForceResolveAllContents();
                return null;
            }
        }, null);
    }

    @NotNull
    protected LazyClassMemberScope createMemberScope(@NotNull LazyClassContext c, @NotNull ClassMemberDeclarationProvider declarationProvider) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "org/jetbrains/kotlin/resolve/lazy/descriptors/LazyClassDescriptor", "createMemberScope"));
        }
        if (declarationProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declarationProvider", "org/jetbrains/kotlin/resolve/lazy/descriptors/LazyClassDescriptor", "createMemberScope"));
        }
        LazyClassMemberScope lazyClassMemberScope = new LazyClassMemberScope(c, declarationProvider, this, c.getTrace());
        if (lazyClassMemberScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/descriptors/LazyClassDescriptor", "createMemberScope"));
        }
        return lazyClassMemberScope;
    }

    @Override
    @NotNull
    public JetScope getScopeForMemberLookup() {
        LazyClassMemberScope lazyClassMemberScope = this.unsubstitutedMemberScope;
        if (lazyClassMemberScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/descriptors/LazyClassDescriptor", "getScopeForMemberLookup"));
        }
        return lazyClassMemberScope;
    }

    @Override
    @NotNull
    public JetScope getScopeForClassHeaderResolution() {
        JetScope jetScope = (JetScope)this.scopeForClassHeaderResolution.invoke();
        if (jetScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/descriptors/LazyClassDescriptor", "getScopeForClassHeaderResolution"));
        }
        return jetScope;
    }

    @NotNull
    private JetScope computeScopeForClassHeaderResolution() {
        WritableScopeImpl scope2 = new WritableScopeImpl(JetScope.Empty.INSTANCE$, this, RedeclarationHandler.DO_NOTHING, "Scope with type parameters for " + this.getName());
        for (TypeParameterDescriptor typeParameterDescriptor : this.getTypeConstructor().getParameters()) {
            scope2.addClassifierDescriptor(typeParameterDescriptor);
        }
        scope2.changeLockLevel(WritableScope.LockLevel.READING);
        ChainedScope chainedScope = new ChainedScope(this, "ScopeForClassHeaderResolution: " + this.getName(), scope2, this.getOuterScope());
        if (chainedScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/descriptors/LazyClassDescriptor", "computeScopeForClassHeaderResolution"));
        }
        return chainedScope;
    }

    @NotNull
    protected JetScope getOuterScope() {
        JetScope jetScope = this.c.getScopeProvider().getResolutionScopeForDeclaration(this.declarationProvider.getOwnerInfo().getScopeAnchor());
        if (jetScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/descriptors/LazyClassDescriptor", "getOuterScope"));
        }
        return jetScope;
    }

    @Override
    @NotNull
    public JetScope getScopeForMemberDeclarationResolution() {
        JetScope jetScope = (JetScope)this.scopeForMemberDeclarationResolution.invoke();
        if (jetScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/descriptors/LazyClassDescriptor", "getScopeForMemberDeclarationResolution"));
        }
        return jetScope;
    }

    @NotNull
    private JetScope computeScopeForMemberDeclarationResolution() {
        WritableScopeImpl thisScope = new WritableScopeImpl(JetScope.Empty.INSTANCE$, this, RedeclarationHandler.DO_NOTHING, "Scope with 'this' for " + this.getName());
        thisScope.addLabeledDeclaration(this);
        thisScope.setImplicitReceiver(this.getThisAsReceiverParameter());
        thisScope.changeLockLevel(WritableScope.LockLevel.READING);
        LazyClassDescriptor classObject = this.getClassObjectDescriptor();
        KObject classObjectAdapterScope = classObject != null ? new ClassObjectMixinScope(classObject) : JetScope.Empty.INSTANCE$;
        ChainedScope chainedScope = new ChainedScope(this, "ScopeForMemberDeclarationResolution: " + this.getName(), new JetScope[]{thisScope, this.getScopeForMemberLookup(), this.getScopeForClassHeaderResolution(), classObjectAdapterScope, this.getStaticScope()});
        if (chainedScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/descriptors/LazyClassDescriptor", "computeScopeForMemberDeclarationResolution"));
        }
        return chainedScope;
    }

    @Override
    @NotNull
    public JetScope getScopeForInitializerResolution() {
        JetScope jetScope = (JetScope)this.scopeForPropertyInitializerResolution.invoke();
        if (jetScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/descriptors/LazyClassDescriptor", "getScopeForInitializerResolution"));
        }
        return jetScope;
    }

    @Override
    @NotNull
    public Collection<CallableMemberDescriptor> getDeclaredCallableMembers() {
        List<DeclarationDescriptor> list = KotlinPackage.filter(this.unsubstitutedMemberScope.getAllDescriptors(), new Function1<DeclarationDescriptor, Boolean>(){

            @Override
            public Boolean invoke(DeclarationDescriptor descriptor) {
                return descriptor instanceof CallableMemberDescriptor && ((CallableMemberDescriptor)descriptor).getKind() != CallableMemberDescriptor.Kind.FAKE_OVERRIDE;
            }
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/descriptors/LazyClassDescriptor", "getDeclaredCallableMembers"));
        }
        return list;
    }

    @NotNull
    private JetScope computeScopeForPropertyInitializerResolution() {
        ConstructorDescriptor primaryConstructor2 = this.getUnsubstitutedPrimaryConstructor();
        if (primaryConstructor2 == null) {
            JetScope jetScope = this.getScopeForMemberDeclarationResolution();
            if (jetScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/descriptors/LazyClassDescriptor", "computeScopeForPropertyInitializerResolution"));
            }
            return jetScope;
        }
        WritableScopeImpl scope2 = new WritableScopeImpl(JetScope.Empty.INSTANCE$, primaryConstructor2, RedeclarationHandler.DO_NOTHING, "Scope with constructor parameters in " + this.getName());
        for (int i = 0; i < this.originalClassInfo.getPrimaryConstructorParameters().size(); ++i) {
            JetParameter jetParameter = this.originalClassInfo.getPrimaryConstructorParameters().get(i);
            if (jetParameter.hasValOrVarNode()) continue;
            scope2.addVariableDescriptor(primaryConstructor2.getValueParameters().get(i));
        }
        scope2.changeLockLevel(WritableScope.LockLevel.READING);
        ChainedScope chainedScope = new ChainedScope(primaryConstructor2, "ScopeForPropertyInitializerResolution: " + this.getName(), scope2, this.getScopeForMemberDeclarationResolution());
        if (chainedScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/descriptors/LazyClassDescriptor", "computeScopeForPropertyInitializerResolution"));
        }
        return chainedScope;
    }

    @Override
    @NotNull
    public JetScope getStaticScope() {
        JetScope jetScope = this.staticScope;
        if (jetScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/descriptors/LazyClassDescriptor", "getStaticScope"));
        }
        return jetScope;
    }

    @Override
    @NotNull
    public Collection<ConstructorDescriptor> getConstructors() {
        Set<ConstructorDescriptor> set = this.unsubstitutedMemberScope.getConstructors();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/descriptors/LazyClassDescriptor", "getConstructors"));
        }
        return set;
    }

    @Override
    public ConstructorDescriptor getUnsubstitutedPrimaryConstructor() {
        return this.unsubstitutedMemberScope.getPrimaryConstructor();
    }

    @Override
    @NotNull
    public TypeConstructor getTypeConstructor() {
        LazyClassTypeConstructor lazyClassTypeConstructor = this.typeConstructor;
        if (lazyClassTypeConstructor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/descriptors/LazyClassDescriptor", "getTypeConstructor"));
        }
        return lazyClassTypeConstructor;
    }

    @Override
    public LazyClassDescriptor getClassObjectDescriptor() {
        return (LazyClassDescriptor)this.classObjectDescriptor.invoke();
    }

    @NotNull
    @ReadOnly
    public List<ClassDescriptor> getDescriptorsForExtraClassObjects() {
        final JetClassObject allowedClassObject = this.getClassObjectIfAllowed();
        List<ClassDescriptor> list = KotlinPackage.map(KotlinPackage.filter(this.declarationProvider.getOwnerInfo().getClassObjects(), new Function1<JetClassObject, Boolean>(){

            @Override
            public Boolean invoke(JetClassObject classObject) {
                return classObject != allowedClassObject;
            }
        }), new Function1<JetClassObject, ClassDescriptor>(){

            @Override
            public ClassDescriptor invoke(JetClassObject classObject) {
                return (ClassDescriptor)LazyClassDescriptor.this.extraClassObjectDescriptors.invoke(classObject);
            }
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/descriptors/LazyClassDescriptor", "getDescriptorsForExtraClassObjects"));
        }
        return list;
    }

    @Nullable
    private LazyClassDescriptor computeClassObjectDescriptor(@Nullable JetClassObject classObject) {
        JetClassLikeInfo classObjectInfo = this.getClassObjectInfo(classObject);
        if (classObjectInfo != null) {
            return new LazyClassDescriptor(this.c, (DeclarationDescriptor)this, SpecialNames.getClassObjectName(this.getName()), classObjectInfo);
        }
        return null;
    }

    @Nullable
    private JetClassLikeInfo getClassObjectInfo(@Nullable JetClassObject classObject) {
        if (classObject != null) {
            if (!this.isClassObjectAllowed()) {
                this.c.getTrace().report(Errors.CLASS_OBJECT_NOT_ALLOWED.on(classObject));
            }
            return JetClassInfoUtil.createClassLikeInfo(classObject.getObjectDeclaration());
        }
        if (this.getKind() == ClassKind.OBJECT || this.getKind() == ClassKind.ENUM_ENTRY) {
            return new SyntheticClassObjectInfo(this.originalClassInfo, this);
        }
        return null;
    }

    @Nullable
    private JetClassObject getClassObjectIfAllowed() {
        JetClassObject classObject = this.declarationProvider.getOwnerInfo().getClassObject();
        return classObject != null && this.isClassObjectAllowed() ? classObject : null;
    }

    private boolean isClassObjectAllowed() {
        return !this.getKind().isSingleton() && !this.isInner() && !DescriptorUtils.isLocal(this);
    }

    @Override
    @NotNull
    public ClassKind getKind() {
        ClassKind classKind = this.kind;
        if (classKind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/descriptors/LazyClassDescriptor", "getKind"));
        }
        return classKind;
    }

    @Override
    @NotNull
    public Modality getModality() {
        Modality modality = this.modality;
        if (modality == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/descriptors/LazyClassDescriptor", "getModality"));
        }
        return modality;
    }

    @Override
    @NotNull
    public Visibility getVisibility() {
        Visibility visibility = this.visibility;
        if (visibility == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/descriptors/LazyClassDescriptor", "getVisibility"));
        }
        return visibility;
    }

    @Override
    public boolean isInner() {
        return this.isInner;
    }

    @Override
    @NotNull
    public Annotations getAnnotations() {
        Annotations annotations2 = this.annotations;
        if (annotations2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/descriptors/LazyClassDescriptor", "getAnnotations"));
        }
        return annotations2;
    }

    @NotNull
    public Annotations getDanglingAnnotations() {
        Annotations annotations2 = this.danglingAnnotations;
        if (annotations2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/descriptors/LazyClassDescriptor", "getDanglingAnnotations"));
        }
        return annotations2;
    }

    public String toString() {
        return "lazy class " + this.getName().toString();
    }

    @Override
    public void forceResolveAllContents() {
        this.forceResolveAllContents.invoke();
    }

    private void doForceResolveAllContents() {
        this.resolveMemberHeaders();
        LazyClassDescriptor classObjectDescriptor2 = this.getClassObjectDescriptor();
        if (classObjectDescriptor2 != null) {
            ForceResolveUtil.forceResolveAllContents(classObjectDescriptor2);
        }
        ForceResolveUtil.forceResolveAllContents(this.getConstructors());
        ForceResolveUtil.forceResolveAllContents(this.getDescriptorsForExtraClassObjects());
        ForceResolveUtil.forceResolveAllContents(this.getScopeForMemberLookup());
        ForceResolveUtil.forceResolveAllContents(this.getTypeConstructor());
    }

    public void resolveMemberHeaders() {
        ForceResolveUtil.forceResolveAllContents(this.getAnnotations());
        ForceResolveUtil.forceResolveAllContents(this.getDanglingAnnotations());
        this.getClassObjectDescriptor();
        this.getDescriptorsForExtraClassObjects();
        this.getClassObjectType();
        this.getConstructors();
        this.getContainingDeclaration();
        this.getThisAsReceiverParameter();
        this.getKind();
        this.getModality();
        this.getName();
        this.getOriginal();
        this.getScopeForClassHeaderResolution();
        this.getScopeForMemberDeclarationResolution();
        this.getScopeForMemberLookup().getAllDescriptors();
        this.getScopeForInitializerResolution();
        this.getUnsubstitutedInnerClassesScope();
        this.getTypeConstructor().getSupertypes();
        for (TypeParameterDescriptor typeParameterDescriptor : this.getTypeConstructor().getParameters()) {
            typeParameterDescriptor.getUpperBounds();
            typeParameterDescriptor.getLowerBounds();
        }
        this.getUnsubstitutedPrimaryConstructor();
        this.getVisibility();
    }

    private class LazyClassTypeConstructor
    extends AbstractClassTypeConstructor
    implements LazyEntity {
        private final NotNullLazyValue<Supertypes> supertypes;
        private final NotNullLazyValue<List<TypeParameterDescriptor>> parameters;
        private final NullableLazyValue<Void> forceResolveAllContents;

        private LazyClassTypeConstructor() {
            this.supertypes = LazyClassDescriptor.this.c.getStorageManager().createLazyValueWithPostCompute(new Function0<Supertypes>(){

                @Override
                public Supertypes invoke() {
                    LazyClassDescriptor descriptor;
                    if (KotlinBuiltIns.isSpecialClassWithNoSupertypes(LazyClassDescriptor.this)) {
                        return new Supertypes((Collection)Collections.emptyList());
                    }
                    JetClassLikeInfo info = LazyClassDescriptor.this.declarationProvider.getOwnerInfo();
                    if (info instanceof SyntheticClassObjectInfo && (descriptor = ((SyntheticClassObjectInfo)info).getClassDescriptor()).getKind().isSingleton()) {
                        return new Supertypes(Collections.singleton(descriptor.getDefaultType()));
                    }
                    JetClassOrObject classOrObject = info.getCorrespondingClassOrObject();
                    if (classOrObject == null) {
                        return new Supertypes(Collections.singleton(LazyClassDescriptor.this.c.getModuleDescriptor().getBuiltIns().getAnyType()));
                    }
                    List<JetType> allSupertypes = LazyClassDescriptor.this.c.getDescriptorResolver().resolveSupertypes(LazyClassDescriptor.this.getScopeForClassHeaderResolution(), LazyClassDescriptor.this, classOrObject, LazyClassDescriptor.this.c.getTrace());
                    return new Supertypes(Lists.newArrayList(Collections2.filter(allSupertypes, VALID_SUPERTYPE)));
                }
            }, new Function1<Boolean, Supertypes>(){

                @Override
                public Supertypes invoke(Boolean firstTime) {
                    return new Supertypes((Collection)Collections.emptyList());
                }
            }, new Function1<Supertypes, Unit>(){

                @Override
                public Unit invoke(@NotNull Supertypes supertypes2) {
                    if (supertypes2 == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "supertypes", "org/jetbrains/kotlin/resolve/lazy/descriptors/LazyClassDescriptor$LazyClassTypeConstructor$3", "invoke"));
                    }
                    LazyClassTypeConstructor.this.findAndDisconnectLoopsInTypeHierarchy(supertypes2);
                    return Unit.INSTANCE$;
                }
            });
            this.parameters = LazyClassDescriptor.this.c.getStorageManager().createLazyValue(new Function0<List<TypeParameterDescriptor>>(){

                @Override
                public List<TypeParameterDescriptor> invoke() {
                    JetClassLikeInfo classInfo = LazyClassDescriptor.this.declarationProvider.getOwnerInfo();
                    JetTypeParameterList typeParameterList = classInfo.getTypeParameterList();
                    if (typeParameterList == null) {
                        return Collections.emptyList();
                    }
                    if (classInfo.getClassKind() == ClassKind.ENUM_CLASS) {
                        LazyClassDescriptor.this.c.getTrace().report(Errors.TYPE_PARAMETERS_IN_ENUM.on(typeParameterList));
                    }
                    List<JetTypeParameter> typeParameters = typeParameterList.getParameters();
                    ArrayList<TypeParameterDescriptor> parameters2 = new ArrayList<TypeParameterDescriptor>(typeParameters.size());
                    for (int i = 0; i < typeParameters.size(); ++i) {
                        parameters2.add(new LazyTypeParameterDescriptor(LazyClassDescriptor.this.c, LazyClassDescriptor.this, typeParameters.get(i), i));
                    }
                    return parameters2;
                }
            });
            this.forceResolveAllContents = LazyClassDescriptor.this.c.getStorageManager().createRecursionTolerantNullableLazyValue(new Function0<Void>(){

                @Override
                public Void invoke() {
                    LazyClassTypeConstructor.this.doForceResolveAllContents();
                    return null;
                }
            }, null);
        }

        @Override
        @NotNull
        public List<TypeParameterDescriptor> getParameters() {
            List list = (List)this.parameters.invoke();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/descriptors/LazyClassDescriptor$LazyClassTypeConstructor", "getParameters"));
            }
            return list;
        }

        @Override
        @NotNull
        public Collection<JetType> getSupertypes() {
            Collection<JetType> collection = ((Supertypes)this.supertypes.invoke()).trueSupertypes;
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/descriptors/LazyClassDescriptor$LazyClassTypeConstructor", "getSupertypes"));
            }
            return collection;
        }

        private void findAndDisconnectLoopsInTypeHierarchy(Supertypes supertypes2) {
            Iterator<JetType> iterator2 = supertypes2.trueSupertypes.iterator();
            while (iterator2.hasNext()) {
                JetType supertype = iterator2.next();
                if (!this.isReachable(supertype.getConstructor(), this, new HashSet<TypeConstructor>())) continue;
                iterator2.remove();
                supertypes2.cyclicSupertypes.add(supertype);
                ClassifierDescriptor supertypeDescriptor = supertype.getConstructor().getDeclarationDescriptor();
                if (!(supertypeDescriptor instanceof ClassDescriptor)) continue;
                ClassDescriptor superclass = (ClassDescriptor)supertypeDescriptor;
                this.reportCyclicInheritanceHierarchyError(LazyClassDescriptor.this.c.getTrace(), LazyClassDescriptor.this, superclass);
            }
        }

        private void reportCyclicInheritanceHierarchyError(@NotNull BindingTrace trace, @NotNull ClassDescriptor classDescriptor, @NotNull ClassDescriptor superclass) {
            PsiNameIdentifierOwner namedElement;
            PsiElement nameIdentifier;
            if (trace == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/lazy/descriptors/LazyClassDescriptor$LazyClassTypeConstructor", "reportCyclicInheritanceHierarchyError"));
            }
            if (classDescriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classDescriptor", "org/jetbrains/kotlin/resolve/lazy/descriptors/LazyClassDescriptor$LazyClassTypeConstructor", "reportCyclicInheritanceHierarchyError"));
            }
            if (superclass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "superclass", "org/jetbrains/kotlin/resolve/lazy/descriptors/LazyClassDescriptor$LazyClassTypeConstructor", "reportCyclicInheritanceHierarchyError"));
            }
            PsiElement psiElement = DescriptorToSourceUtils.classDescriptorToDeclaration(classDescriptor);
            PsiElement elementToMark = null;
            if (psiElement instanceof JetClassOrObject) {
                JetClassOrObject classOrObject = (JetClassOrObject)psiElement;
                for (JetDelegationSpecifier delegationSpecifier : classOrObject.getDelegationSpecifiers()) {
                    JetType supertype;
                    JetTypeReference typeReference = delegationSpecifier.getTypeReference();
                    if (typeReference == null || (supertype = trace.get(BindingContext.TYPE, typeReference)) == null || supertype.getConstructor() != superclass.getTypeConstructor()) continue;
                    elementToMark = typeReference;
                }
            }
            if (elementToMark == null && psiElement instanceof PsiNameIdentifierOwner && (nameIdentifier = (namedElement = (PsiNameIdentifierOwner)psiElement).getNameIdentifier()) != null) {
                elementToMark = nameIdentifier;
            }
            if (elementToMark != null) {
                trace.report(Errors.CYCLIC_INHERITANCE_HIERARCHY.on(elementToMark));
            }
        }

        private boolean isReachable(TypeConstructor from, TypeConstructor to, Set<TypeConstructor> visited) {
            if (!visited.add(from)) {
                return false;
            }
            for (JetType supertype : this.getNeighbors(from)) {
                TypeConstructor supertypeConstructor = supertype.getConstructor();
                if (supertypeConstructor == to) {
                    return true;
                }
                if (!this.isReachable(supertypeConstructor, to, visited)) continue;
                return true;
            }
            return false;
        }

        private Collection<JetType> getNeighbors(TypeConstructor from) {
            DeclarationDescriptor container;
            ArrayList<JetType> neighbours = new ArrayList<JetType>(from instanceof LazyClassTypeConstructor ? ((Supertypes)((LazyClassTypeConstructor)from).supertypes.invoke()).getAllSupertypes() : from.getSupertypes());
            ClassifierDescriptor fromDescriptor = from.getDeclarationDescriptor();
            if (fromDescriptor != null && (container = fromDescriptor.getContainingDeclaration()) instanceof ClassDescriptor) {
                neighbours.add(((ClassDescriptor)container).getDefaultType());
            }
            return neighbours;
        }

        @Override
        public boolean isFinal() {
            return !LazyClassDescriptor.this.getModality().isOverridable();
        }

        @Override
        public boolean isDenotable() {
            return true;
        }

        @Override
        public ClassifierDescriptor getDeclarationDescriptor() {
            return LazyClassDescriptor.this;
        }

        @Override
        @NotNull
        public Annotations getAnnotations() {
            Annotations annotations2 = Annotations.EMPTY;
            if (annotations2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/descriptors/LazyClassDescriptor$LazyClassTypeConstructor", "getAnnotations"));
            }
            return annotations2;
        }

        public String toString() {
            return LazyClassDescriptor.this.getName().toString();
        }

        @Override
        public void forceResolveAllContents() {
            this.forceResolveAllContents.invoke();
        }

        private void doForceResolveAllContents() {
            ForceResolveUtil.forceResolveAllContents(this.getAnnotations());
            ForceResolveUtil.forceResolveAllContents(this.getSupertypes());
            ForceResolveUtil.forceResolveAllContents(this.getParameters());
        }
    }

    private static class Supertypes {
        @Mutable
        public final Collection<JetType> trueSupertypes;
        @Mutable
        public final Collection<JetType> cyclicSupertypes;

        private Supertypes(@Mutable @NotNull Collection<JetType> trueSupertypes) {
            if (trueSupertypes == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trueSupertypes", "org/jetbrains/kotlin/resolve/lazy/descriptors/LazyClassDescriptor$Supertypes", "<init>"));
            }
            this(trueSupertypes, new ArrayList<JetType>(0));
        }

        private Supertypes(@Mutable @NotNull Collection<JetType> trueSupertypes, @Mutable @NotNull Collection<JetType> cyclicSupertypes) {
            if (trueSupertypes == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trueSupertypes", "org/jetbrains/kotlin/resolve/lazy/descriptors/LazyClassDescriptor$Supertypes", "<init>"));
            }
            if (cyclicSupertypes == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cyclicSupertypes", "org/jetbrains/kotlin/resolve/lazy/descriptors/LazyClassDescriptor$Supertypes", "<init>"));
            }
            this.trueSupertypes = trueSupertypes;
            this.cyclicSupertypes = cyclicSupertypes;
        }

        @NotNull
        public Collection<JetType> getAllSupertypes() {
            List<JetType> list = KotlinPackage.plus(this.trueSupertypes, this.cyclicSupertypes);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/descriptors/LazyClassDescriptor$Supertypes", "getAllSupertypes"));
            }
            return list;
        }
    }
}

