/*
 * Copyright 2010-2015 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.jetbrains.kotlin.psi.stubs.impl

import com.intellij.psi.stubs.StubElement
import com.intellij.util.io.StringRef
import org.jetbrains.kotlin.psi.JetNamedFunction
import org.jetbrains.kotlin.psi.stubs.KotlinFunctionStub
import org.jetbrains.kotlin.psi.stubs.elements.JetStubElementTypes
import org.jetbrains.kotlin.name.FqName
import com.intellij.psi.PsiElement

public class KotlinFunctionStubImpl(
        parent: StubElement<out PsiElement>?,
        private val nameRef: StringRef?,
        private val isTopLevel: Boolean,
        private val fqName: FqName?,
        private val isExtension: Boolean,
        private val hasBlockBody: Boolean,
        private val hasBody: Boolean,
        private val hasTypeParameterListBeforeFunctionName: Boolean,
        private val isProbablyNothingType: Boolean
) : KotlinStubBaseImpl<JetNamedFunction>(parent, JetStubElementTypes.FUNCTION), KotlinFunctionStub {
    {
        if (isTopLevel && fqName == null) {
            throw IllegalArgumentException("fqName shouldn't be null for top level functions")
        }
    }
    override fun getFqName() = fqName

    override fun getName() = StringRef.toString(nameRef)
    override fun isTopLevel() = isTopLevel
    override fun isExtension() = isExtension
    override fun hasBlockBody() = hasBlockBody
    override fun hasBody() = hasBody
    override fun hasTypeParameterListBeforeFunctionName() = hasTypeParameterListBeforeFunctionName
    override fun isProbablyNothingType() = isProbablyNothingType
}
