/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.compiler.backend.js.ast;

import com.google.dart.compiler.backend.js.ast.JsContext;
import com.google.dart.compiler.backend.js.ast.JsExpression;
import com.google.dart.compiler.backend.js.ast.JsName;
import com.google.dart.compiler.backend.js.ast.JsStatement;
import com.google.dart.compiler.backend.js.ast.JsVisitor;
import com.google.dart.compiler.backend.js.ast.JsVisitorWithContext;
import com.google.dart.compiler.backend.js.ast.SourceInfoAwareJsNode;
import com.google.dart.compiler.util.AstUtil;
import org.jetbrains.annotations.NotNull;

public class JsForIn
extends SourceInfoAwareJsNode
implements JsStatement {
    private JsStatement body;
    private JsExpression iterExpression;
    private JsExpression objectExpression;
    private final JsName iterVarName;

    public JsForIn() {
        this(null);
    }

    public JsForIn(JsName iterVarName) {
        this.iterVarName = iterVarName;
    }

    public JsForIn(JsName iterVarName, JsExpression iterExpression, JsExpression objectExpression, JsStatement body) {
        this.iterVarName = iterVarName;
        this.iterExpression = iterExpression;
        this.objectExpression = objectExpression;
        this.body = body;
    }

    public JsStatement getBody() {
        return this.body;
    }

    public JsExpression getIterExpression() {
        return this.iterExpression;
    }

    public JsName getIterVarName() {
        return this.iterVarName;
    }

    public JsExpression getObjectExpression() {
        return this.objectExpression;
    }

    public void setBody(JsStatement body) {
        this.body = body;
    }

    public void setIterExpression(JsExpression iterExpression) {
        this.iterExpression = iterExpression;
    }

    public void setObjectExpression(JsExpression objectExpression) {
        this.objectExpression = objectExpression;
    }

    @Override
    public void accept(JsVisitor v) {
        v.visitForIn(this);
    }

    @Override
    public void acceptChildren(JsVisitor visitor) {
        if (this.iterExpression != null) {
            visitor.acceptLvalue(this.iterExpression);
        }
        visitor.accept(this.objectExpression);
        visitor.accept(this.body);
    }

    @Override
    public void traverse(JsVisitorWithContext v, JsContext ctx) {
        if (v.visit(this, ctx)) {
            if (this.iterExpression != null) {
                this.iterExpression = v.acceptLvalue(this.iterExpression);
            }
            this.objectExpression = v.accept(this.objectExpression);
            this.body = v.acceptStatement(this.body);
        }
        v.endVisit(this, ctx);
    }

    @Override
    @NotNull
    public JsForIn deepCopy() {
        JsStatement bodyCopy = AstUtil.deepCopy(this.body);
        JsExpression iterCopy = AstUtil.deepCopy(this.iterExpression);
        JsExpression objectCopy = AstUtil.deepCopy(this.objectExpression);
        JsForIn jsForIn = new JsForIn(this.iterVarName, iterCopy, objectCopy, bodyCopy).withMetadataFrom(this);
        if (jsForIn == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/google/dart/compiler/backend/js/ast/JsForIn", "deepCopy"));
        }
        return jsForIn;
    }
}

