/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.core;

import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class CoreProgressManager
extends ProgressManager {
    private static final ThreadLocal<ProgressIndicator> myIndicator = new ThreadLocal();

    CoreProgressManager() {
    }

    @Override
    public void executeNonCancelableSection(@NotNull Runnable runnable2) {
        if (runnable2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/core/CoreProgressManager", "executeNonCancelableSection"));
        }
        this.executeProcessUnderProgress(runnable2, new EmptyProgressIndicator());
    }

    @Override
    public ProgressIndicator getProgressIndicator() {
        return myIndicator.get();
    }

    @Override
    protected void doCheckCanceled() throws ProcessCanceledException {
        ProgressIndicator indicator = this.getProgressIndicator();
        if (indicator != null) {
            indicator.checkCanceled();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeProcessUnderProgress(@NotNull Runnable process, @Nullable(value="null means reuse current progress") ProgressIndicator progress) throws ProcessCanceledException {
        if (process == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "process", "com/intellij/core/CoreProgressManager", "executeProcessUnderProgress"));
        }
        ProgressIndicator old = null;
        if (progress != null) {
            old = this.getProgressIndicator();
            myIndicator.set(progress);
        }
        try {
            process.run();
        }
        finally {
            if (progress != null) {
                myIndicator.set(old);
            }
        }
    }
}

