/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.graphInference.constraints;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiMethodReferenceUtil;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.impl.source.resolve.graphInference.FunctionalInterfaceParameterizationUtil;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceSession;
import com.intellij.psi.impl.source.resolve.graphInference.PsiPolyExpressionUtil;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.ConstraintFormula;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.StrictSubtypingConstraint;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.TypeCompatibilityConstraint;
import com.intellij.psi.infos.MethodCandidateInfo;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.Map;

public class PsiMethodReferenceCompatibilityConstraint
implements ConstraintFormula {
    private static final Logger LOG = Logger.getInstance("#" + PsiMethodReferenceCompatibilityConstraint.class.getName());
    private final PsiMethodReferenceExpression myExpression;
    private PsiType myT;

    public PsiMethodReferenceCompatibilityConstraint(PsiMethodReferenceExpression expression, PsiType t) {
        this.myExpression = expression;
        this.myT = t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean reduce(InferenceSession session, List<ConstraintFormula> constraints) {
        JavaResolveResult resolve2;
        if (!LambdaUtil.isFunctionalType(this.myT)) {
            return false;
        }
        PsiType groundTargetType = FunctionalInterfaceParameterizationUtil.getGroundTargetType(this.myT);
        PsiClassType.ClassResolveResult classResolveResult = PsiUtil.resolveGenericsClassInType(groundTargetType);
        PsiMethod interfaceMethod = LambdaUtil.getFunctionalInterfaceMethod(classResolveResult);
        if (interfaceMethod == null) {
            return false;
        }
        PsiSubstitutor substitutor = LambdaUtil.getSubstitutor(interfaceMethod, classResolveResult);
        PsiParameter[] targetParameters = interfaceMethod.getParameterList().getParameters();
        PsiType interfaceMethodReturnType = interfaceMethod.getReturnType();
        PsiType returnType = substitutor.substitute(interfaceMethodReturnType);
        PsiType[] typeParameters = this.myExpression.getTypeParameters();
        PsiMethodReferenceUtil.QualifierResolveResult qualifierResolveResult = PsiMethodReferenceUtil.getQualifierResolveResult(this.myExpression);
        if (!this.myExpression.isExact()) {
            for (PsiParameter parameter : targetParameters) {
                if (session.isProperType(substitutor.substitute(parameter.getType()))) continue;
                return false;
            }
        } else {
            int i;
            PsiParameter[] parameters2;
            PsiMember applicableMember = this.myExpression.getPotentiallyApplicableMember();
            LOG.assertTrue(applicableMember != null);
            PsiClass applicableMemberContainingClass = applicableMember.getContainingClass();
            PsiClass containingClass = qualifierResolveResult.getContainingClass();
            PsiSubstitutor psiSubstitutor = qualifierResolveResult.getSubstitutor();
            psiSubstitutor = applicableMemberContainingClass == null || containingClass == null || this.myExpression.isConstructor() ? psiSubstitutor : TypeConversionUtil.getSuperClassSubstitutor(applicableMemberContainingClass, containingClass, psiSubstitutor);
            PsiType applicableMethodReturnType = applicableMember instanceof PsiMethod ? ((PsiMethod)applicableMember).getReturnType() : null;
            int idx = 0;
            for (PsiTypeParameter param : ((PsiTypeParameterListOwner)applicableMember).getTypeParameters()) {
                if (idx >= typeParameters.length) continue;
                psiSubstitutor = psiSubstitutor.put(param, typeParameters[idx++]);
            }
            PsiParameter[] psiParameterArray = parameters2 = applicableMember instanceof PsiMethod ? ((PsiMethod)applicableMember).getParameterList().getParameters() : PsiParameter.EMPTY_ARRAY;
            if (targetParameters.length == parameters2.length + 1) {
                this.specialCase(session, constraints, substitutor, targetParameters, true);
                for (i = 1; i < targetParameters.length; ++i) {
                    constraints.add(new TypeCompatibilityConstraint(session.substituteWithInferenceVariables(psiSubstitutor.substitute(parameters2[i - 1].getType())), substitutor.substitute(targetParameters[i].getType())));
                }
            } else if (targetParameters.length == parameters2.length) {
                for (i = 0; i < targetParameters.length; ++i) {
                    constraints.add(new TypeCompatibilityConstraint(session.substituteWithInferenceVariables(psiSubstitutor.substitute(parameters2[i].getType())), substitutor.substitute(targetParameters[i].getType())));
                }
            } else {
                return false;
            }
            if (returnType != PsiType.VOID && returnType != null) {
                if (applicableMethodReturnType == PsiType.VOID) {
                    return false;
                }
                if (applicableMethodReturnType != null) {
                    constraints.add(new TypeCompatibilityConstraint(returnType, session.substituteWithInferenceVariables(psiSubstitutor.substitute(applicableMethodReturnType))));
                } else if (applicableMember instanceof PsiClass || applicableMember instanceof PsiMethod && ((PsiMethod)applicableMember).isConstructor()) {
                    PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory(applicableMember.getProject());
                    if (containingClass != null) {
                        PsiType classType = session.substituteWithInferenceVariables(elementFactory.createType(containingClass, psiSubstitutor));
                        constraints.add(new TypeCompatibilityConstraint(returnType, classType));
                    }
                }
            }
            return true;
        }
        Map<PsiElement, PsiType> map = LambdaUtil.getFunctionalTypeMap();
        PsiType added = map.put(this.myExpression, session.startWithFreshVars(groundTargetType));
        try {
            resolve2 = this.myExpression.advancedResolve(true);
        }
        finally {
            if (added == null) {
                map.remove(this.myExpression);
            }
        }
        PsiElement element = resolve2.getElement();
        if (element == null) {
            return false;
        }
        if (PsiType.VOID.equals(returnType) || returnType == null) {
            return true;
        }
        if (element instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)element;
            PsiClass containingClass = method.getContainingClass();
            LOG.assertTrue(containingClass != null, method);
            PsiClass qContainingClass = qualifierResolveResult.getContainingClass();
            PsiSubstitutor psiSubstitutor = qualifierResolveResult.getSubstitutor();
            if (qContainingClass != null) {
                if (PsiUtil.isRawSubstitutor(qContainingClass, psiSubstitutor)) {
                    psiSubstitutor = PsiSubstitutor.EMPTY;
                }
                if (qContainingClass.isInheritor(containingClass, true)) {
                    psiSubstitutor = TypeConversionUtil.getClassSubstitutor(containingClass, qContainingClass, PsiSubstitutor.EMPTY);
                    LOG.assertTrue(psiSubstitutor != null);
                }
            }
            PsiType referencedMethodReturnType = method.isConstructor() ? JavaPsiFacade.getElementFactory(method.getProject()).createType(containingClass, PsiSubstitutor.EMPTY) : method.getReturnType();
            LOG.assertTrue(referencedMethodReturnType != null, method);
            if (!PsiTreeUtil.isContextAncestor(containingClass, this.myExpression, false) || PsiUtil.getEnclosingStaticElement(this.myExpression, containingClass) != null) {
                session.initBounds(this.myExpression, containingClass.getTypeParameters());
            }
            session.initBounds(this.myExpression, method.getTypeParameters());
            if (typeParameters.length == 0 && method.getTypeParameters().length > 0) {
                PsiClass interfaceClass = classResolveResult.getElement();
                LOG.assertTrue(interfaceClass != null);
                if (PsiPolyExpressionUtil.mentionsTypeParameters(referencedMethodReturnType, ContainerUtil.newHashSet(method.getTypeParameters())).booleanValue()) {
                    session.collectApplicabilityConstraints(this.myExpression, (MethodCandidateInfo)resolve2, groundTargetType);
                    session.registerReturnTypeConstraints(referencedMethodReturnType, returnType);
                    return true;
                }
            }
            if (PsiType.VOID.equals(referencedMethodReturnType)) {
                return false;
            }
            int idx = 0;
            for (PsiTypeParameter param : method.getTypeParameters()) {
                if (idx >= typeParameters.length) continue;
                psiSubstitutor = psiSubstitutor.put(param, typeParameters[idx++]);
            }
            PsiParameter[] parameters3 = method.getParameterList().getParameters();
            if (targetParameters.length == parameters3.length + 1 && !method.isVarArgs() && PsiPolyExpressionUtil.mentionsTypeParameters(referencedMethodReturnType, ContainerUtil.newHashSet(containingClass.getTypeParameters())).booleanValue()) {
                this.specialCase(session, constraints, substitutor, targetParameters, false);
            }
            constraints.add(new TypeCompatibilityConstraint(returnType, session.substituteWithInferenceVariables(psiSubstitutor.substitute(referencedMethodReturnType))));
        }
        return true;
    }

    private void specialCase(InferenceSession session, List<ConstraintFormula> constraints, PsiSubstitutor substitutor, PsiParameter[] targetParameters, boolean ignoreRaw) {
        JavaResolveResult resolveResult;
        PsiElement res;
        PsiClass qualifierClass;
        PsiElement qualifier = this.myExpression.getQualifier();
        PsiType qualifierType = null;
        if (qualifier instanceof PsiTypeElement) {
            qualifierType = ((PsiTypeElement)qualifier).getType();
            qualifierClass = PsiUtil.resolveClassInType(qualifierType);
            if (qualifierClass != null) {
                qualifierType = JavaPsiFacade.getElementFactory(this.myExpression.getProject()).createType(qualifierClass, PsiSubstitutor.EMPTY);
            }
        } else if (qualifier instanceof PsiExpression && (qualifierType = ((PsiExpression)qualifier).getType()) == null && qualifier instanceof PsiReferenceExpression && (res = (resolveResult = ((PsiReferenceExpression)qualifier).advancedResolve(false)).getElement()) instanceof PsiClass) {
            PsiClass containingClass = (PsiClass)res;
            boolean isRawSubst = !ignoreRaw && !this.myExpression.isConstructor() && PsiUtil.isRawSubstitutor(containingClass, resolveResult.getSubstitutor());
            qualifierType = JavaPsiFacade.getElementFactory(res.getProject()).createType(containingClass, isRawSubst ? PsiSubstitutor.EMPTY : resolveResult.getSubstitutor());
        }
        qualifierClass = PsiUtil.resolveClassInType(qualifierType);
        if (qualifierClass != null) {
            session.initBounds(this.myExpression, qualifierClass.getTypeParameters());
            constraints.add(new StrictSubtypingConstraint(session.substituteWithInferenceVariables(qualifierType), session.substituteWithInferenceVariables(substitutor.substitute(targetParameters[0].getType()))));
        }
    }

    @Override
    public void apply(PsiSubstitutor substitutor, boolean cache2) {
        this.myT = substitutor.substitute(this.myT);
    }

    public String toString() {
        return this.myExpression.getText() + " -> " + this.myT.getPresentableText();
    }
}

