/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna;

import com.sun.jna.Function;
import com.sun.jna.Memory;
import com.sun.jna.NativeString;
import com.sun.jna.Pointer;
import com.sun.jna.WString;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class StringArray
extends Memory
implements Function.PostCallRead {
    private boolean wide;
    private List natives = new ArrayList();
    private Object[] original;

    public StringArray(String[] strings2) {
        this(strings2, false);
    }

    public StringArray(String[] strings2, boolean wide) {
        this((Object[])strings2, wide);
    }

    public StringArray(WString[] strings2) {
        this(strings2, true);
    }

    private StringArray(Object[] strings2, boolean wide) {
        super((strings2.length + 1) * Pointer.SIZE);
        this.original = strings2;
        this.wide = wide;
        for (int i = 0; i < strings2.length; ++i) {
            Pointer p = null;
            if (strings2[i] != null) {
                NativeString ns = new NativeString(strings2[i].toString(), wide);
                this.natives.add(ns);
                p = ns.getPointer();
            }
            this.setPointer(Pointer.SIZE * i, p);
        }
        this.setPointer(Pointer.SIZE * strings2.length, null);
    }

    @Override
    public void read() {
        boolean returnWide = this.original instanceof WString[];
        for (int si = 0; si < this.original.length; ++si) {
            Pointer p = this.getPointer(si * Pointer.SIZE);
            CharSequence s = null;
            if (p != null) {
                s = p.getString(0L, this.wide);
                if (returnWide) {
                    s = new WString((String)s);
                }
            }
            this.original[si] = s;
        }
    }

    @Override
    public String toString() {
        String s = this.wide ? "const wchar_t*[]" : "const char*[]";
        s = new StringBuffer().append(s).append(Arrays.asList(this.original)).toString();
        return s;
    }
}

