/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna;

import com.sun.jna.FromNativeContext;
import com.sun.jna.FromNativeConverter;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.NativeMappedConverter;
import com.sun.jna.NativeString;
import com.sun.jna.Platform;
import com.sun.jna.Pointer;
import com.sun.jna.StructureReadContext;
import com.sun.jna.StructureWriteContext;
import com.sun.jna.ToNativeContext;
import com.sun.jna.ToNativeConverter;
import com.sun.jna.TypeMapper;
import com.sun.jna.Union;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.zip.Adler32;

public abstract class Structure {
    private static final boolean REVERSE_FIELDS;
    private static final boolean REQUIRES_FIELD_ORDER;
    static final boolean isPPC;
    static final boolean isSPARC;
    static final boolean isARM;
    static final int MAX_GNUC_ALIGNMENT;
    static final Map layoutInfo;
    private Pointer memory;
    private int size = -1;
    private int alignType;
    private int structAlignment;
    private Map structFields;
    private final Map nativeStrings = new HashMap();
    private TypeMapper typeMapper;
    private long typeInfo;
    private List fieldOrder;
    private boolean autoRead = true;
    private boolean autoWrite = true;
    private Structure[] array;
    private static final ThreadLocal reads;
    private static final ThreadLocal busy;
    static /* synthetic */ Class class$com$sun$jna$Structure$MemberOrder;
    static /* synthetic */ Class class$com$sun$jna$Structure;
    static /* synthetic */ Class class$com$sun$jna$Callback;
    static /* synthetic */ Class class$java$nio$Buffer;
    static /* synthetic */ Class class$com$sun$jna$Pointer;
    static /* synthetic */ Class class$com$sun$jna$NativeMapped;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$com$sun$jna$WString;
    static /* synthetic */ Class class$com$sun$jna$Structure$ByReference;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Void;

    protected Structure() {
        this(null);
    }

    protected Structure(Pointer p) {
        this(p, 0);
    }

    protected Structure(Pointer p, int alignType) {
        this(p, alignType, null);
    }

    protected Structure(Pointer p, int alignType, TypeMapper mapper) {
        this.setAlignType(alignType);
        this.setTypeMapper(mapper);
        if (p != null) {
            this.useMemory(p);
        } else {
            this.allocateMemory(-1);
        }
    }

    Map fields() {
        return this.structFields;
    }

    protected void setTypeMapper(TypeMapper mapper) {
        Class<?> declaring;
        if (mapper == null && (declaring = this.getClass().getDeclaringClass()) != null) {
            mapper = Native.getTypeMapper(declaring);
        }
        this.typeMapper = mapper;
        this.size = -1;
        if (this.memory instanceof AutoAllocated) {
            this.memory = null;
        }
    }

    protected void setAlignType(int alignType) {
        if (alignType == 0) {
            Class<?> declaring = this.getClass().getDeclaringClass();
            if (declaring != null) {
                alignType = Native.getStructureAlignment(declaring);
            }
            if (alignType == 0) {
                alignType = Platform.isWindows() ? 3 : 2;
            }
        }
        this.alignType = alignType;
        this.size = -1;
        if (this.memory instanceof AutoAllocated) {
            this.memory = null;
        }
    }

    protected Memory autoAllocate(int size) {
        return new AutoAllocated(size);
    }

    protected void useMemory(Pointer m) {
        this.useMemory(m, 0);
    }

    protected void useMemory(Pointer m, int offset) {
        try {
            this.memory = m.share(offset);
            if (this.size == -1) {
                this.size = this.calculateSize(false);
            }
            if (this.size != -1) {
                this.memory = m.share(offset, this.size);
            }
            this.array = null;
        }
        catch (IndexOutOfBoundsException e) {
            throw new IllegalArgumentException("Structure exceeds provided memory bounds");
        }
    }

    protected void ensureAllocated() {
        this.ensureAllocated(false);
    }

    private void ensureAllocated(boolean avoidFFIType) {
        if (this.memory == null) {
            this.allocateMemory(avoidFFIType);
        } else if (this.size == -1) {
            this.size = this.calculateSize(true, avoidFFIType);
        }
    }

    protected void allocateMemory() {
        this.allocateMemory(false);
    }

    private void allocateMemory(boolean avoidFFIType) {
        this.allocateMemory(this.calculateSize(true, avoidFFIType));
    }

    protected void allocateMemory(int size) {
        if (size == -1) {
            size = this.calculateSize(false);
        } else if (size <= 0) {
            throw new IllegalArgumentException(new StringBuffer().append("Structure size must be greater than zero: ").append(size).toString());
        }
        if (size != -1) {
            if (this.memory == null || this.memory instanceof AutoAllocated) {
                this.memory = this.autoAllocate(size);
            }
            this.size = size;
        }
    }

    public int size() {
        this.ensureAllocated();
        if (this.size == -1) {
            this.size = this.calculateSize(true);
        }
        return this.size;
    }

    public void clear() {
        this.memory.clear(this.size());
    }

    public Pointer getPointer() {
        this.ensureAllocated();
        return this.memory;
    }

    static Set busy() {
        return (Set)busy.get();
    }

    static Map reading() {
        return (Map)reads.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read() {
        this.ensureAllocated();
        if (Structure.busy().contains(this)) {
            return;
        }
        Structure.busy().add(this);
        if (this instanceof ByReference) {
            Structure.reading().put(this.getPointer(), this);
        }
        try {
            Iterator i = this.fields().values().iterator();
            while (i.hasNext()) {
                this.readField((StructField)i.next());
            }
        }
        finally {
            Structure.busy().remove(this);
            if (Structure.reading().get(this.getPointer()) == this) {
                Structure.reading().remove(this.getPointer());
            }
        }
    }

    Object getField(StructField structField) {
        try {
            return structField.field.get(this);
        }
        catch (Exception e) {
            throw new Error(new StringBuffer().append("Exception reading field '").append(structField.name).append("' in ").append(this.getClass()).append(": ").append(e).toString());
        }
    }

    void setField(StructField structField, Object value) {
        this.setField(structField, value, false);
    }

    void setField(StructField structField, Object value, boolean overrideFinal) {
        try {
            structField.field.set(this, value);
        }
        catch (IllegalAccessException e) {
            int modifiers = structField.field.getModifiers();
            if (Modifier.isFinal(modifiers)) {
                if (overrideFinal) {
                    throw new UnsupportedOperationException(new StringBuffer().append("This VM does not support Structures with final fields (field '").append(structField.name).append("' within ").append(this.getClass()).append(")").toString());
                }
                throw new UnsupportedOperationException(new StringBuffer().append("Attempt to write to read-only field '").append(structField.name).append("' within ").append(this.getClass()).toString());
            }
            throw new Error(new StringBuffer().append("Unexpectedly unable to write to field '").append(structField.name).append("' within ").append(this.getClass()).append(": ").append(e).toString());
        }
    }

    static Structure updateStructureByReference(Class type2, Structure s, Pointer address) {
        if (address == null) {
            s = null;
        } else {
            if (s == null || !address.equals(s.getPointer())) {
                Structure s1 = (Structure)Structure.reading().get(address);
                if (s1 != null && type2.equals(s1.getClass())) {
                    s = s1;
                } else {
                    s = Structure.newInstance(type2);
                    s.useMemory(address);
                }
            }
            s.autoRead();
        }
        return s;
    }

    Object readField(StructField structField) {
        int offset = structField.offset;
        Class fieldType = structField.type;
        FromNativeConverter readConverter = structField.readConverter;
        if (readConverter != null) {
            fieldType = readConverter.nativeType();
        }
        Object currentValue = (class$com$sun$jna$Structure == null ? (class$com$sun$jna$Structure = Structure.class$("com.sun.jna.Structure")) : class$com$sun$jna$Structure).isAssignableFrom(fieldType) || (class$com$sun$jna$Callback == null ? (class$com$sun$jna$Callback = Structure.class$("com.sun.jna.Callback")) : class$com$sun$jna$Callback).isAssignableFrom(fieldType) || Platform.HAS_BUFFERS && (class$java$nio$Buffer == null ? (class$java$nio$Buffer = Structure.class$("java.nio.Buffer")) : class$java$nio$Buffer).isAssignableFrom(fieldType) || (class$com$sun$jna$Pointer == null ? (class$com$sun$jna$Pointer = Structure.class$("com.sun.jna.Pointer")) : class$com$sun$jna$Pointer).isAssignableFrom(fieldType) || (class$com$sun$jna$NativeMapped == null ? (class$com$sun$jna$NativeMapped = Structure.class$("com.sun.jna.NativeMapped")) : class$com$sun$jna$NativeMapped).isAssignableFrom(fieldType) || fieldType.isArray() ? this.getField(structField) : null;
        Object result2 = this.memory.getValue(offset, fieldType, currentValue);
        if (readConverter != null) {
            result2 = readConverter.fromNative(result2, structField.context);
        }
        this.setField(structField, result2, true);
        return result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write() {
        this.ensureAllocated();
        if (this instanceof ByValue) {
            this.getTypeInfo();
        }
        if (Structure.busy().contains(this)) {
            return;
        }
        Structure.busy().add(this);
        try {
            for (StructField sf : this.fields().values()) {
                if (sf.isVolatile) continue;
                this.writeField(sf);
            }
        }
        finally {
            Structure.busy().remove(this);
        }
    }

    void writeField(StructField structField) {
        if (structField.isReadOnly) {
            return;
        }
        int offset = structField.offset;
        Object value = this.getField(structField);
        Class fieldType = structField.type;
        ToNativeConverter converter = structField.writeConverter;
        if (converter != null) {
            value = converter.toNative(value, new StructureWriteContext(this, structField.field));
            fieldType = converter.nativeType();
        }
        if ((class$java$lang$String == null ? (class$java$lang$String = Structure.class$("java.lang.String")) : class$java$lang$String) == fieldType || (class$com$sun$jna$WString == null ? (class$com$sun$jna$WString = Structure.class$("com.sun.jna.WString")) : class$com$sun$jna$WString) == fieldType) {
            boolean wide;
            boolean bl = wide = fieldType == (class$com$sun$jna$WString == null ? (class$com$sun$jna$WString = Structure.class$("com.sun.jna.WString")) : class$com$sun$jna$WString);
            if (value != null) {
                NativeString nativeString = new NativeString(value.toString(), wide);
                this.nativeStrings.put(structField.name, nativeString);
                value = nativeString.getPointer();
            } else {
                value = null;
                this.nativeStrings.remove(structField.name);
            }
        }
        try {
            this.memory.setValue(offset, value, fieldType);
        }
        catch (IllegalArgumentException e) {
            String msg = new StringBuffer().append("Structure field \"").append(structField.name).append("\" was declared as ").append(structField.type).append(structField.type == fieldType ? "" : new StringBuffer().append(" (native type ").append(fieldType).append(")").toString()).append(", which is not supported within a Structure").toString();
            throw new IllegalArgumentException(msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasFieldOrder() {
        Structure structure = this;
        synchronized (structure) {
            return this.fieldOrder != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List getFieldOrder() {
        Structure structure = this;
        synchronized (structure) {
            if (this.fieldOrder == null) {
                this.fieldOrder = new ArrayList();
            }
            return this.fieldOrder;
        }
    }

    protected void sortFields(List fields2, List names2) {
        block0: for (int i = 0; i < names2.size(); ++i) {
            String name = (String)names2.get(i);
            for (int f = 0; f < fields2.size(); ++f) {
                Field field = (Field)fields2.get(f);
                if (!name.equals(field.getName())) continue;
                Collections.swap(fields2, i, f);
                continue block0;
            }
        }
    }

    protected List getFields(boolean force) {
        ArrayList flist = new ArrayList();
        Class<?> cls = this.getClass();
        while (!cls.equals(class$com$sun$jna$Structure == null ? Structure.class$("com.sun.jna.Structure") : class$com$sun$jna$Structure)) {
            ArrayList<Field> classFields = new ArrayList<Field>();
            Field[] fields2 = cls.getDeclaredFields();
            for (int i = 0; i < fields2.length; ++i) {
                int modifiers = fields2[i].getModifiers();
                if (Modifier.isStatic(modifiers) || !Modifier.isPublic(modifiers)) continue;
                classFields.add(fields2[i]);
            }
            if (REVERSE_FIELDS) {
                Collections.reverse(classFields);
            }
            flist.addAll(0, classFields);
            cls = cls.getSuperclass();
        }
        if (REQUIRES_FIELD_ORDER || this.hasFieldOrder()) {
            List fieldOrder = this.getFieldOrder();
            if (fieldOrder.size() < flist.size()) {
                if (force) {
                    throw new Error(new StringBuffer().append("This VM does not store fields in a predictable order; you must use Structure.setFieldOrder to explicitly indicate the field order: ").append(System.getProperty("java.vendor")).append(", ").append(System.getProperty("java.version")).toString());
                }
                return null;
            }
            this.sortFields(flist, fieldOrder);
        }
        return flist;
    }

    private synchronized boolean fieldOrderMatch(List fieldOrder) {
        return this.fieldOrder == fieldOrder || this.fieldOrder != null && ((Object)this.fieldOrder).equals(fieldOrder);
    }

    private int calculateSize(boolean force) {
        return this.calculateSize(force, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int calculateSize(boolean force, boolean avoidFFIType) {
        LayoutInfo info;
        boolean needsInit = true;
        Map map = layoutInfo;
        synchronized (map) {
            info = (LayoutInfo)layoutInfo.get(this.getClass());
        }
        if (info == null || this.alignType != info.alignType || this.typeMapper != info.typeMapper || !this.fieldOrderMatch(info.fieldOrder)) {
            info = this.deriveLayout(force, avoidFFIType);
            needsInit = false;
        }
        if (info != null) {
            this.structAlignment = info.alignment;
            this.structFields = info.fields;
            info.alignType = this.alignType;
            info.typeMapper = this.typeMapper;
            info.fieldOrder = this.fieldOrder;
            if (!info.variable) {
                map = layoutInfo;
                synchronized (map) {
                    layoutInfo.put(this.getClass(), info);
                }
            }
            if (needsInit) {
                this.initializeFields();
            }
            return info.size;
        }
        return -1;
    }

    private LayoutInfo deriveLayout(boolean force, boolean avoidFFIType) {
        LayoutInfo info = new LayoutInfo();
        int calculatedSize = 0;
        List fields2 = this.getFields(force);
        if (fields2 == null) {
            return null;
        }
        boolean firstField = true;
        for (Field field : fields2) {
            int modifiers = field.getModifiers();
            Class type2 = field.getType();
            if (type2.isArray()) {
                info.variable = true;
            }
            StructField structField = new StructField();
            structField.isVolatile = Modifier.isVolatile(modifiers);
            structField.isReadOnly = Modifier.isFinal(modifiers);
            if (structField.isReadOnly) {
                if (!Platform.RO_FIELDS) {
                    throw new IllegalArgumentException(new StringBuffer().append("This VM does not support read-only fields (field '").append(field.getName()).append("' within ").append(this.getClass()).append(")").toString());
                }
                field.setAccessible(true);
            }
            structField.field = field;
            structField.name = field.getName();
            structField.type = type2;
            if ((class$com$sun$jna$Callback == null ? Structure.class$("com.sun.jna.Callback") : class$com$sun$jna$Callback).isAssignableFrom(type2) && !type2.isInterface()) {
                throw new IllegalArgumentException(new StringBuffer().append("Structure Callback field '").append(field.getName()).append("' must be an interface").toString());
            }
            if (type2.isArray() && (class$com$sun$jna$Structure == null ? Structure.class$("com.sun.jna.Structure") : class$com$sun$jna$Structure).equals(type2.getComponentType())) {
                String msg = "Nested Structure arrays must use a derived Structure type so that the size of the elements can be determined";
                throw new IllegalArgumentException(msg);
            }
            int fieldAlignment = 1;
            if (Modifier.isPublic(field.getModifiers())) {
                Object value = this.getField(structField);
                if (value == null && type2.isArray()) {
                    if (force) {
                        throw new IllegalStateException("Array fields must be initialized");
                    }
                    return null;
                }
                Class nativeType = type2;
                if ((class$com$sun$jna$NativeMapped == null ? Structure.class$("com.sun.jna.NativeMapped") : class$com$sun$jna$NativeMapped).isAssignableFrom(type2)) {
                    NativeMappedConverter tc = NativeMappedConverter.getInstance(type2);
                    nativeType = tc.nativeType();
                    structField.writeConverter = tc;
                    structField.readConverter = tc;
                    structField.context = new StructureReadContext(this, field);
                } else if (this.typeMapper != null) {
                    ToNativeConverter writeConverter = this.typeMapper.getToNativeConverter(type2);
                    FromNativeConverter readConverter = this.typeMapper.getFromNativeConverter(type2);
                    if (writeConverter != null && readConverter != null) {
                        nativeType = (value = writeConverter.toNative(value, new StructureWriteContext(this, structField.field))) != null ? value.getClass() : (class$com$sun$jna$Pointer == null ? Structure.class$("com.sun.jna.Pointer") : class$com$sun$jna$Pointer);
                        structField.writeConverter = writeConverter;
                        structField.readConverter = readConverter;
                        structField.context = new StructureReadContext(this, field);
                    } else if (writeConverter != null || readConverter != null) {
                        String msg = new StringBuffer().append("Structures require bidirectional type conversion for ").append(type2).toString();
                        throw new IllegalArgumentException(msg);
                    }
                }
                if (value == null) {
                    value = this.initializeField(structField, type2);
                }
                try {
                    structField.size = this.getNativeSize(nativeType, value);
                    fieldAlignment = this.getNativeAlignment(nativeType, value, firstField);
                }
                catch (IllegalArgumentException e) {
                    if (!force && this.typeMapper == null) {
                        return null;
                    }
                    String msg = new StringBuffer().append("Invalid Structure field in ").append(this.getClass()).append(", field name '").append(structField.name).append("', ").append(structField.type).append(": ").append(e.getMessage()).toString();
                    throw new IllegalArgumentException(msg);
                }
                info.alignment = Math.max(info.alignment, fieldAlignment);
                if (calculatedSize % fieldAlignment != 0) {
                    calculatedSize += fieldAlignment - calculatedSize % fieldAlignment;
                }
                structField.offset = calculatedSize;
                calculatedSize += structField.size;
                info.fields.put(structField.name, structField);
            }
            firstField = false;
        }
        if (calculatedSize > 0) {
            int size = this.calculateAlignedSize(calculatedSize, info.alignment);
            if (this instanceof ByValue && !avoidFFIType) {
                this.getTypeInfo();
            }
            if (this.memory != null && !(this.memory instanceof AutoAllocated)) {
                this.memory = this.memory.share(0L, size);
            }
            info.size = size;
            return info;
        }
        throw new IllegalArgumentException(new StringBuffer().append("Structure ").append(this.getClass()).append(" has unknown size (ensure ").append("all fields are public)").toString());
    }

    private void initializeFields() {
        for (StructField f : this.fields().values()) {
            this.initializeField(f, f.type);
        }
    }

    private Object initializeField(StructField structField, Class type2) {
        Object value = null;
        if ((class$com$sun$jna$Structure == null ? (class$com$sun$jna$Structure = Structure.class$("com.sun.jna.Structure")) : class$com$sun$jna$Structure).isAssignableFrom(type2) && !(class$com$sun$jna$Structure$ByReference == null ? (class$com$sun$jna$Structure$ByReference = Structure.class$("com.sun.jna.Structure$ByReference")) : class$com$sun$jna$Structure$ByReference).isAssignableFrom(type2)) {
            try {
                value = Structure.newInstance(type2);
                this.setField(structField, value);
            }
            catch (IllegalArgumentException e) {
                String msg = new StringBuffer().append("Can't determine size of nested structure: ").append(e.getMessage()).toString();
                throw new IllegalArgumentException(msg);
            }
        } else if ((class$com$sun$jna$NativeMapped == null ? (class$com$sun$jna$NativeMapped = Structure.class$("com.sun.jna.NativeMapped")) : class$com$sun$jna$NativeMapped).isAssignableFrom(type2)) {
            NativeMappedConverter tc = NativeMappedConverter.getInstance(type2);
            value = tc.defaultValue();
            this.setField(structField, value);
        }
        return value;
    }

    int calculateAlignedSize(int calculatedSize) {
        return this.calculateAlignedSize(calculatedSize, this.structAlignment);
    }

    private int calculateAlignedSize(int calculatedSize, int alignment) {
        if (this.alignType != 1 && calculatedSize % alignment != 0) {
            calculatedSize += alignment - calculatedSize % alignment;
        }
        return calculatedSize;
    }

    protected int getStructAlignment() {
        if (this.size == -1) {
            this.calculateSize(true);
        }
        return this.structAlignment;
    }

    protected int getNativeAlignment(Class type2, Object value, boolean isFirstElement) {
        int alignment = 1;
        if ((class$com$sun$jna$NativeMapped == null ? (class$com$sun$jna$NativeMapped = Structure.class$("com.sun.jna.NativeMapped")) : class$com$sun$jna$NativeMapped).isAssignableFrom(type2)) {
            NativeMappedConverter tc = NativeMappedConverter.getInstance(type2);
            type2 = tc.nativeType();
            value = tc.toNative(value, new ToNativeContext());
        }
        int size = Native.getNativeSize(type2, value);
        if (type2.isPrimitive() || (class$java$lang$Long == null ? (class$java$lang$Long = Structure.class$("java.lang.Long")) : class$java$lang$Long) == type2 || (class$java$lang$Integer == null ? (class$java$lang$Integer = Structure.class$("java.lang.Integer")) : class$java$lang$Integer) == type2 || (class$java$lang$Short == null ? (class$java$lang$Short = Structure.class$("java.lang.Short")) : class$java$lang$Short) == type2 || (class$java$lang$Character == null ? (class$java$lang$Character = Structure.class$("java.lang.Character")) : class$java$lang$Character) == type2 || (class$java$lang$Byte == null ? (class$java$lang$Byte = Structure.class$("java.lang.Byte")) : class$java$lang$Byte) == type2 || (class$java$lang$Boolean == null ? (class$java$lang$Boolean = Structure.class$("java.lang.Boolean")) : class$java$lang$Boolean) == type2 || (class$java$lang$Float == null ? (class$java$lang$Float = Structure.class$("java.lang.Float")) : class$java$lang$Float) == type2 || (class$java$lang$Double == null ? (class$java$lang$Double = Structure.class$("java.lang.Double")) : class$java$lang$Double) == type2) {
            alignment = size;
        } else if ((class$com$sun$jna$Pointer == null ? (class$com$sun$jna$Pointer = Structure.class$("com.sun.jna.Pointer")) : class$com$sun$jna$Pointer) == type2 || Platform.HAS_BUFFERS && (class$java$nio$Buffer == null ? (class$java$nio$Buffer = Structure.class$("java.nio.Buffer")) : class$java$nio$Buffer).isAssignableFrom(type2) || (class$com$sun$jna$Callback == null ? (class$com$sun$jna$Callback = Structure.class$("com.sun.jna.Callback")) : class$com$sun$jna$Callback).isAssignableFrom(type2) || (class$com$sun$jna$WString == null ? (class$com$sun$jna$WString = Structure.class$("com.sun.jna.WString")) : class$com$sun$jna$WString) == type2 || (class$java$lang$String == null ? (class$java$lang$String = Structure.class$("java.lang.String")) : class$java$lang$String) == type2) {
            alignment = Pointer.SIZE;
        } else if ((class$com$sun$jna$Structure == null ? (class$com$sun$jna$Structure = Structure.class$("com.sun.jna.Structure")) : class$com$sun$jna$Structure).isAssignableFrom(type2)) {
            if ((class$com$sun$jna$Structure$ByReference == null ? (class$com$sun$jna$Structure$ByReference = Structure.class$("com.sun.jna.Structure$ByReference")) : class$com$sun$jna$Structure$ByReference).isAssignableFrom(type2)) {
                alignment = Pointer.SIZE;
            } else {
                if (value == null) {
                    value = Structure.newInstance(type2);
                }
                alignment = ((Structure)value).getStructAlignment();
            }
        } else if (type2.isArray()) {
            alignment = this.getNativeAlignment(type2.getComponentType(), null, isFirstElement);
        } else {
            throw new IllegalArgumentException(new StringBuffer().append("Type ").append(type2).append(" has unknown ").append("native alignment").toString());
        }
        if (this.alignType == 1) {
            alignment = 1;
        } else if (this.alignType == 3) {
            alignment = Math.min(8, alignment);
        } else if (!(this.alignType != 2 || isFirstElement && Platform.isMac() && isPPC)) {
            alignment = Math.min(MAX_GNUC_ALIGNMENT, alignment);
        }
        return alignment;
    }

    public String toString() {
        return this.toString(Boolean.getBoolean("jna.dump_memory"));
    }

    public String toString(boolean debug) {
        return this.toString(0, true, true);
    }

    private String format(Class type2) {
        String s = type2.getName();
        int dot = s.lastIndexOf(".");
        return s.substring(dot + 1);
    }

    private String toString(int indent, boolean showContents, boolean dumpMemory) {
        this.ensureAllocated();
        String LS = System.getProperty("line.separator");
        String name = new StringBuffer().append(this.format(this.getClass())).append("(").append(this.getPointer()).append(")").toString();
        if (!(this.getPointer() instanceof Memory)) {
            name = new StringBuffer().append(name).append(" (").append(this.size()).append(" bytes)").toString();
        }
        String prefix = "";
        for (int idx = 0; idx < indent; ++idx) {
            prefix = new StringBuffer().append(prefix).append("  ").toString();
        }
        String contents = LS;
        if (!showContents) {
            contents = "...}";
        } else {
            Iterator i = this.fields().values().iterator();
            while (i.hasNext()) {
                StructField sf = (StructField)i.next();
                Object value = this.getField(sf);
                String type2 = this.format(sf.type);
                String index2 = "";
                contents = new StringBuffer().append(contents).append(prefix).toString();
                if (sf.type.isArray() && value != null) {
                    type2 = this.format(sf.type.getComponentType());
                    index2 = new StringBuffer().append("[").append(Array.getLength(value)).append("]").toString();
                }
                contents = new StringBuffer().append(contents).append("  ").append(type2).append(" ").append(sf.name).append(index2).append("@").append(Integer.toHexString(sf.offset)).toString();
                if (value instanceof Structure) {
                    value = ((Structure)value).toString(indent + 1, !(value instanceof ByReference), dumpMemory);
                }
                contents = new StringBuffer().append(contents).append("=").toString();
                contents = value instanceof Long ? new StringBuffer().append(contents).append(Long.toHexString((Long)value)).toString() : (value instanceof Integer ? new StringBuffer().append(contents).append(Integer.toHexString((Integer)value)).toString() : (value instanceof Short ? new StringBuffer().append(contents).append(Integer.toHexString(((Short)value).shortValue())).toString() : (value instanceof Byte ? new StringBuffer().append(contents).append(Integer.toHexString(((Byte)value).byteValue())).toString() : new StringBuffer().append(contents).append(String.valueOf(value).trim()).toString())));
                contents = new StringBuffer().append(contents).append(LS).toString();
                if (i.hasNext()) continue;
                contents = new StringBuffer().append(contents).append(prefix).append("}").toString();
            }
        }
        if (indent == 0 && dumpMemory) {
            int BYTES_PER_ROW = 4;
            contents = new StringBuffer().append(contents).append(LS).append("memory dump").append(LS).toString();
            byte[] buf = this.getPointer().getByteArray(0L, this.size());
            for (int i = 0; i < buf.length; ++i) {
                if (i % 4 == 0) {
                    contents = new StringBuffer().append(contents).append("[").toString();
                }
                if (buf[i] >= 0 && buf[i] < 16) {
                    contents = new StringBuffer().append(contents).append("0").toString();
                }
                contents = new StringBuffer().append(contents).append(Integer.toHexString(buf[i] & 0xFF)).toString();
                if (i % 4 != 3 || i >= buf.length - 1) continue;
                contents = new StringBuffer().append(contents).append("]").append(LS).toString();
            }
            contents = new StringBuffer().append(contents).append("]").toString();
        }
        return new StringBuffer().append(name).append(" {").append(contents).toString();
    }

    public Structure[] toArray(Structure[] array) {
        this.ensureAllocated();
        if (this.memory instanceof AutoAllocated) {
            Memory m = (Memory)this.memory;
            int requiredSize = array.length * this.size();
            if (m.size() < (long)requiredSize) {
                this.useMemory(this.autoAllocate(requiredSize));
            }
        }
        array[0] = this;
        int size = this.size();
        for (int i = 1; i < array.length; ++i) {
            array[i] = Structure.newInstance(this.getClass());
            array[i].useMemory(this.memory.share(i * size, size));
            array[i].read();
        }
        if (!(this instanceof ByValue)) {
            this.array = array;
        }
        return array;
    }

    private Class baseClass() {
        if ((this instanceof ByReference || this instanceof ByValue) && (class$com$sun$jna$Structure == null ? (class$com$sun$jna$Structure = Structure.class$("com.sun.jna.Structure")) : class$com$sun$jna$Structure).isAssignableFrom(this.getClass().getSuperclass())) {
            return this.getClass().getSuperclass();
        }
        return this.getClass();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Structure)) {
            return false;
        }
        if (o.getClass() != this.getClass() && ((Structure)o).baseClass() != this.baseClass()) {
            return false;
        }
        Structure s = (Structure)o;
        if (s.getPointer().equals(this.getPointer())) {
            return true;
        }
        if (s.size() == this.size()) {
            this.clear();
            this.write();
            byte[] buf = this.getPointer().getByteArray(0L, this.size());
            s.clear();
            s.write();
            byte[] sbuf = s.getPointer().getByteArray(0L, s.size());
            return Arrays.equals(buf, sbuf);
        }
        return false;
    }

    public int hashCode() {
        this.clear();
        this.write();
        Adler32 code = new Adler32();
        code.update(this.getPointer().getByteArray(0L, this.size()));
        return (int)code.getValue();
    }

    protected void cacheTypeInfo(Pointer p) {
        this.typeInfo = p.peer;
    }

    protected Pointer getFieldTypeInfo(StructField f) {
        ToNativeConverter nc;
        Class type2 = f.type;
        Object value = this.getField(f);
        if (this.typeMapper != null && (nc = this.typeMapper.getToNativeConverter(type2)) != null) {
            type2 = nc.nativeType();
            value = nc.toNative(value, new ToNativeContext());
        }
        return FFIType.get(value, type2);
    }

    Pointer getTypeInfo() {
        Pointer p = Structure.getTypeInfo(this);
        this.cacheTypeInfo(p);
        return p;
    }

    public boolean getAutoRead() {
        return this.autoRead;
    }

    public boolean getAutoWrite() {
        return this.autoWrite;
    }

    static Pointer getTypeInfo(Object obj) {
        return FFIType.get(obj);
    }

    public static Structure newInstance(Class type2) throws IllegalArgumentException {
        try {
            Structure s = (Structure)type2.newInstance();
            if (s instanceof ByValue) {
                s.allocateMemory();
            }
            return s;
        }
        catch (InstantiationException e) {
            String msg = new StringBuffer().append("Can't instantiate ").append(type2).append(" (").append(e).append(")").toString();
            throw new IllegalArgumentException(msg);
        }
        catch (IllegalAccessException e) {
            String msg = new StringBuffer().append("Instantiation of ").append(type2).append(" not allowed, is it public? (").append(e).append(")").toString();
            throw new IllegalArgumentException(msg);
        }
    }

    private static void structureArrayCheck(Structure[] ss) {
        Pointer base = ss[0].getPointer();
        int size = ss[0].size();
        for (int si = 1; si < ss.length; ++si) {
            if (ss[si].getPointer().peer == base.peer + (long)(size * si)) continue;
            String msg = new StringBuffer().append("Structure array elements must use contiguous memory (bad backing address at Structure array index ").append(si).append(")").toString();
            throw new IllegalArgumentException(msg);
        }
    }

    public static void autoRead(Structure[] ss) {
        Structure.structureArrayCheck(ss);
        if (ss[0].array == ss) {
            ss[0].autoRead();
        } else {
            for (int si = 0; si < ss.length; ++si) {
                ss[si].autoRead();
            }
        }
    }

    public void autoRead() {
        if (this.getAutoRead()) {
            this.read();
            if (this.array != null) {
                for (int i = 1; i < this.array.length; ++i) {
                    this.array[i].autoRead();
                }
            }
        }
    }

    public static void autoWrite(Structure[] ss) {
        Structure.structureArrayCheck(ss);
        if (ss[0].array == ss) {
            ss[0].autoWrite();
        } else {
            for (int si = 0; si < ss.length; ++si) {
                ss[si].autoWrite();
            }
        }
    }

    public void autoWrite() {
        if (this.getAutoWrite()) {
            this.write();
            if (this.array != null) {
                for (int i = 1; i < this.array.length; ++i) {
                    this.array[i].autoWrite();
                }
            }
        }
    }

    protected int getNativeSize(Class nativeType, Object value) {
        return Native.getNativeSize(nativeType, value);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError().initCause(x1);
        }
    }

    static {
        Field[] fields2 = (class$com$sun$jna$Structure$MemberOrder == null ? (class$com$sun$jna$Structure$MemberOrder = Structure.class$("com.sun.jna.Structure$MemberOrder")) : class$com$sun$jna$Structure$MemberOrder).getFields();
        ArrayList<String> names2 = new ArrayList<String>();
        for (int i = 0; i < fields2.length; ++i) {
            names2.add(fields2[i].getName());
        }
        List<String> expected = Arrays.asList(MemberOrder.FIELDS);
        ArrayList<String> reversed = new ArrayList<String>(expected);
        Collections.reverse(reversed);
        REVERSE_FIELDS = ((Object)names2).equals(reversed);
        REQUIRES_FIELD_ORDER = !((Object)names2).equals(expected) && !REVERSE_FIELDS;
        String arch = System.getProperty("os.arch").toLowerCase();
        isPPC = "ppc".equals(arch) || "powerpc".equals(arch);
        isSPARC = "sparc".equals(arch);
        isARM = "arm".equals(arch);
        MAX_GNUC_ALIGNMENT = isSPARC || (isPPC || isARM) && Platform.isLinux() ? 8 : Native.LONG_SIZE;
        layoutInfo = new WeakHashMap();
        reads = new ThreadLocal(){

            protected synchronized Object initialValue() {
                return new HashMap();
            }
        };
        busy = new ThreadLocal(){

            protected synchronized Object initialValue() {
                return new StructureSet();
            }

            class StructureSet
            extends AbstractCollection
            implements Set {
                private Structure[] elements;
                private int count;

                StructureSet() {
                }

                private void ensureCapacity(int size) {
                    if (this.elements == null) {
                        this.elements = new Structure[size * 3 / 2];
                    } else if (this.elements.length < size) {
                        Structure[] e = new Structure[size * 3 / 2];
                        System.arraycopy(this.elements, 0, e, 0, this.elements.length);
                        this.elements = e;
                    }
                }

                @Override
                public int size() {
                    return this.count;
                }

                @Override
                public boolean contains(Object o) {
                    return this.indexOf(o) != -1;
                }

                @Override
                public boolean add(Object o) {
                    if (!this.contains(o)) {
                        this.ensureCapacity(this.count + 1);
                        this.elements[this.count++] = (Structure)o;
                    }
                    return true;
                }

                private int indexOf(Object o) {
                    Structure s1 = (Structure)o;
                    for (int i = 0; i < this.count; ++i) {
                        Structure s2 = this.elements[i];
                        if (s1 != s2 && (s1.getClass() != s2.getClass() || s1.size() != s2.size() || !s1.getPointer().equals(s2.getPointer()))) continue;
                        return i;
                    }
                    return -1;
                }

                @Override
                public boolean remove(Object o) {
                    int idx = this.indexOf(o);
                    if (idx != -1) {
                        if (--this.count > 0) {
                            this.elements[idx] = this.elements[this.count];
                            this.elements[this.count] = null;
                        }
                        return true;
                    }
                    return false;
                }

                @Override
                public Iterator iterator() {
                    Structure[] e = new Structure[this.count];
                    if (this.count > 0) {
                        System.arraycopy(this.elements, 0, e, 0, this.count);
                    }
                    return Arrays.asList(e).iterator();
                }
            }
        };
    }

    private class AutoAllocated
    extends Memory {
        public AutoAllocated(int size) {
            super(size);
            super.clear();
        }
    }

    static class FFIType
    extends Structure {
        private static Map typeInfoMap = new WeakHashMap();
        public short type = (short)13;
        public Pointer elements;

        private FFIType(Structure ref) {
            Pointer[] els;
            ref.ensureAllocated(true);
            if (ref instanceof Union) {
                StructField sf = ((Union)ref).biggestField;
                els = new Pointer[]{FFIType.get(ref.getField(sf), sf.type), null};
            } else {
                els = new Pointer[ref.fields().size() + 1];
                int idx = 0;
                for (StructField sf : ref.fields().values()) {
                    els[idx++] = ref.getFieldTypeInfo(sf);
                }
            }
            this.init(els);
        }

        private FFIType(Object array, Class type2) {
            int length = Array.getLength(array);
            Pointer[] els = new Pointer[length + 1];
            Pointer p = FFIType.get(null, type2.getComponentType());
            for (int i = 0; i < length; ++i) {
                els[i] = p;
            }
            this.init(els);
        }

        private void init(Pointer[] els) {
            this.elements = new Memory(Pointer.SIZE * els.length);
            this.elements.write(0L, els, 0, els.length);
            this.write();
        }

        static Pointer get(Object obj) {
            if (obj == null) {
                return FFITypes.ffi_type_pointer;
            }
            if (obj instanceof Class) {
                return FFIType.get(null, (Class)obj);
            }
            return FFIType.get(obj, obj.getClass());
        }

        private static Pointer get(Object obj, Class cls) {
            ToNativeConverter nc;
            TypeMapper mapper = Native.getTypeMapper(cls);
            if (mapper != null && (nc = mapper.getToNativeConverter(cls)) != null) {
                cls = nc.nativeType();
            }
            Map map = typeInfoMap;
            synchronized (map) {
                Object o = typeInfoMap.get(cls);
                if (o instanceof Pointer) {
                    return (Pointer)o;
                }
                if (o instanceof FFIType) {
                    return ((FFIType)o).getPointer();
                }
                if (Platform.HAS_BUFFERS && (class$java$nio$Buffer == null ? (class$java$nio$Buffer = Structure.class$("java.nio.Buffer")) : class$java$nio$Buffer).isAssignableFrom(cls) || (class$com$sun$jna$Callback == null ? (class$com$sun$jna$Callback = Structure.class$("com.sun.jna.Callback")) : class$com$sun$jna$Callback).isAssignableFrom(cls)) {
                    typeInfoMap.put(cls, FFITypes.ffi_type_pointer);
                    return FFITypes.ffi_type_pointer;
                }
                if ((class$com$sun$jna$Structure == null ? (class$com$sun$jna$Structure = Structure.class$("com.sun.jna.Structure")) : class$com$sun$jna$Structure).isAssignableFrom(cls)) {
                    if (obj == null) {
                        obj = FFIType.newInstance(cls);
                    }
                    if ((class$com$sun$jna$Structure$ByReference == null ? (class$com$sun$jna$Structure$ByReference = Structure.class$("com.sun.jna.Structure$ByReference")) : class$com$sun$jna$Structure$ByReference).isAssignableFrom(cls)) {
                        typeInfoMap.put(cls, FFITypes.ffi_type_pointer);
                        return FFITypes.ffi_type_pointer;
                    }
                    FFIType type2 = new FFIType((Structure)obj);
                    typeInfoMap.put(cls, type2);
                    return type2.getPointer();
                }
                if ((class$com$sun$jna$NativeMapped == null ? (class$com$sun$jna$NativeMapped = Structure.class$("com.sun.jna.NativeMapped")) : class$com$sun$jna$NativeMapped).isAssignableFrom(cls)) {
                    NativeMappedConverter c = NativeMappedConverter.getInstance(cls);
                    return FFIType.get(c.toNative(obj, new ToNativeContext()), c.nativeType());
                }
                if (cls.isArray()) {
                    FFIType type3 = new FFIType(obj, cls);
                    typeInfoMap.put(obj, type3);
                    return type3.getPointer();
                }
                throw new IllegalArgumentException(new StringBuffer().append("Unsupported Structure field type ").append(cls).toString());
            }
        }

        static {
            if (Native.POINTER_SIZE == 0) {
                throw new Error("Native library not initialized");
            }
            if (FFITypes.ffi_type_void == null) {
                throw new Error("FFI types not initialized");
            }
            typeInfoMap.put(Void.TYPE, FFITypes.ffi_type_void);
            typeInfoMap.put(class$java$lang$Void == null ? (class$java$lang$Void = Structure.class$("java.lang.Void")) : class$java$lang$Void, FFITypes.ffi_type_void);
            typeInfoMap.put(Float.TYPE, FFITypes.ffi_type_float);
            typeInfoMap.put(class$java$lang$Float == null ? (class$java$lang$Float = Structure.class$("java.lang.Float")) : class$java$lang$Float, FFITypes.ffi_type_float);
            typeInfoMap.put(Double.TYPE, FFITypes.ffi_type_double);
            typeInfoMap.put(class$java$lang$Double == null ? (class$java$lang$Double = Structure.class$("java.lang.Double")) : class$java$lang$Double, FFITypes.ffi_type_double);
            typeInfoMap.put(Long.TYPE, FFITypes.ffi_type_sint64);
            typeInfoMap.put(class$java$lang$Long == null ? (class$java$lang$Long = Structure.class$("java.lang.Long")) : class$java$lang$Long, FFITypes.ffi_type_sint64);
            typeInfoMap.put(Integer.TYPE, FFITypes.ffi_type_sint32);
            typeInfoMap.put(class$java$lang$Integer == null ? (class$java$lang$Integer = Structure.class$("java.lang.Integer")) : class$java$lang$Integer, FFITypes.ffi_type_sint32);
            typeInfoMap.put(Short.TYPE, FFITypes.ffi_type_sint16);
            typeInfoMap.put(class$java$lang$Short == null ? (class$java$lang$Short = Structure.class$("java.lang.Short")) : class$java$lang$Short, FFITypes.ffi_type_sint16);
            Pointer ctype = Native.WCHAR_SIZE == 2 ? FFITypes.ffi_type_uint16 : FFITypes.ffi_type_uint32;
            typeInfoMap.put(Character.TYPE, ctype);
            typeInfoMap.put(class$java$lang$Character == null ? (class$java$lang$Character = Structure.class$("java.lang.Character")) : class$java$lang$Character, ctype);
            typeInfoMap.put(Byte.TYPE, FFITypes.ffi_type_sint8);
            typeInfoMap.put(class$java$lang$Byte == null ? (class$java$lang$Byte = Structure.class$("java.lang.Byte")) : class$java$lang$Byte, FFITypes.ffi_type_sint8);
            typeInfoMap.put(class$com$sun$jna$Pointer == null ? (class$com$sun$jna$Pointer = Structure.class$("com.sun.jna.Pointer")) : class$com$sun$jna$Pointer, FFITypes.ffi_type_pointer);
            typeInfoMap.put(class$java$lang$String == null ? (class$java$lang$String = Structure.class$("java.lang.String")) : class$java$lang$String, FFITypes.ffi_type_pointer);
            typeInfoMap.put(class$com$sun$jna$WString == null ? (class$com$sun$jna$WString = Structure.class$("com.sun.jna.WString")) : class$com$sun$jna$WString, FFITypes.ffi_type_pointer);
            typeInfoMap.put(Boolean.TYPE, FFITypes.ffi_type_uint32);
            typeInfoMap.put(class$java$lang$Boolean == null ? (class$java$lang$Boolean = Structure.class$("java.lang.Boolean")) : class$java$lang$Boolean, FFITypes.ffi_type_uint32);
        }

        private static class FFITypes {
            private static Pointer ffi_type_void;
            private static Pointer ffi_type_float;
            private static Pointer ffi_type_double;
            private static Pointer ffi_type_sint8;
            private static Pointer ffi_type_uint16;
            private static Pointer ffi_type_sint16;
            private static Pointer ffi_type_uint32;
            private static Pointer ffi_type_sint32;
            private static Pointer ffi_type_sint64;
            private static Pointer ffi_type_pointer;
        }
    }

    class StructField {
        public String name;
        public Class type;
        public Field field;
        public int size = -1;
        public int offset = -1;
        public boolean isVolatile;
        public boolean isReadOnly;
        public FromNativeConverter readConverter;
        public ToNativeConverter writeConverter;
        public FromNativeContext context;

        StructField() {
        }

        public String toString() {
            return new StringBuffer().append(this.name).append("@").append(this.offset).append("[").append(this.size).append("] (").append(this.type).append(")").toString();
        }
    }

    private class LayoutInfo {
        int size = -1;
        int alignment = 1;
        Map fields = Collections.synchronizedMap(new LinkedHashMap());
        int alignType = 0;
        TypeMapper typeMapper;
        List fieldOrder;
        boolean variable;

        private LayoutInfo() {
        }
    }

    private static class MemberOrder {
        private static final String[] FIELDS = new String[]{"first", "second", "middle", "penultimate", "last"};

        private MemberOrder() {
        }
    }

    public static interface ByReference {
    }

    public static interface ByValue {
    }
}

