/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.context;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.codegen.OwnerKind;
import org.jetbrains.kotlin.codegen.binding.MutableClosure;
import org.jetbrains.kotlin.codegen.context.CodegenContext;
import org.jetbrains.kotlin.codegen.context.FieldOwnerContext;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ScriptDescriptor;

public class ScriptContext
extends FieldOwnerContext<ClassDescriptor> {
    private final ScriptDescriptor scriptDescriptor;
    private final List<ScriptDescriptor> earlierScripts;

    public ScriptContext(@NotNull ScriptDescriptor scriptDescriptor, @NotNull List<ScriptDescriptor> earlierScripts, @NotNull ClassDescriptor contextDescriptor, @NotNull OwnerKind contextKind, @Nullable CodegenContext parentContext, @Nullable MutableClosure closure) {
        if (scriptDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scriptDescriptor", "org/jetbrains/kotlin/codegen/context/ScriptContext", "<init>"));
        }
        if (earlierScripts == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "earlierScripts", "org/jetbrains/kotlin/codegen/context/ScriptContext", "<init>"));
        }
        if (contextDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contextDescriptor", "org/jetbrains/kotlin/codegen/context/ScriptContext", "<init>"));
        }
        if (contextKind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contextKind", "org/jetbrains/kotlin/codegen/context/ScriptContext", "<init>"));
        }
        super(contextDescriptor, contextKind, parentContext, closure, contextDescriptor, null);
        this.scriptDescriptor = scriptDescriptor;
        this.earlierScripts = earlierScripts;
    }

    @NotNull
    public ScriptDescriptor getScriptDescriptor() {
        ScriptDescriptor scriptDescriptor = this.scriptDescriptor;
        if (scriptDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/context/ScriptContext", "getScriptDescriptor"));
        }
        return scriptDescriptor;
    }

    @NotNull
    public List<ScriptDescriptor> getEarlierScripts() {
        List<ScriptDescriptor> list = this.earlierScripts;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/context/ScriptContext", "getEarlierScripts"));
        }
        return list;
    }

    @NotNull
    public String getScriptFieldName(@NotNull ScriptDescriptor scriptDescriptor) {
        if (scriptDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scriptDescriptor", "org/jetbrains/kotlin/codegen/context/ScriptContext", "getScriptFieldName"));
        }
        int index2 = this.earlierScripts.indexOf(scriptDescriptor);
        if (index2 < 0) {
            throw new IllegalStateException("Unregistered script: " + scriptDescriptor);
        }
        String string = "script$" + (index2 + 1);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/context/ScriptContext", "getScriptFieldName"));
        }
        return string;
    }

    @Override
    public boolean isStatic() {
        return true;
    }
}

