/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.descriptors.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.descriptors.impl.AbstractTypeParameterDescriptor;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.storage.StorageManager;
import org.jetbrains.kotlin.types.JetType;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.Variance;

public abstract class AbstractLazyTypeParameterDescriptor
extends AbstractTypeParameterDescriptor {
    public AbstractLazyTypeParameterDescriptor(@NotNull StorageManager storageManager, @NotNull DeclarationDescriptor containingDeclaration, @NotNull Name name, @NotNull Variance variance, boolean isReified, int index2, @NotNull SourceElement source) {
        if (storageManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "storageManager", "org/jetbrains/kotlin/descriptors/impl/AbstractLazyTypeParameterDescriptor", "<init>"));
        }
        if (containingDeclaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingDeclaration", "org/jetbrains/kotlin/descriptors/impl/AbstractLazyTypeParameterDescriptor", "<init>"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/descriptors/impl/AbstractLazyTypeParameterDescriptor", "<init>"));
        }
        if (variance == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variance", "org/jetbrains/kotlin/descriptors/impl/AbstractLazyTypeParameterDescriptor", "<init>"));
        }
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "org/jetbrains/kotlin/descriptors/impl/AbstractLazyTypeParameterDescriptor", "<init>"));
        }
        super(storageManager, containingDeclaration, Annotations.EMPTY, name, variance, isReified, index2, source);
    }

    @Override
    @NotNull
    protected TypeConstructor createTypeConstructor() {
        TypeConstructor typeConstructor2 = new TypeConstructor(){

            @Override
            @NotNull
            public Collection<JetType> getSupertypes() {
                Set<JetType> set = AbstractLazyTypeParameterDescriptor.this.getUpperBounds();
                if (set == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/descriptors/impl/AbstractLazyTypeParameterDescriptor$1", "getSupertypes"));
                }
                return set;
            }

            @Override
            @NotNull
            public List<TypeParameterDescriptor> getParameters() {
                List<TypeParameterDescriptor> list = Collections.emptyList();
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/descriptors/impl/AbstractLazyTypeParameterDescriptor$1", "getParameters"));
                }
                return list;
            }

            @Override
            public boolean isFinal() {
                return false;
            }

            @Override
            public boolean isDenotable() {
                return true;
            }

            @Override
            public ClassifierDescriptor getDeclarationDescriptor() {
                return AbstractLazyTypeParameterDescriptor.this;
            }

            @Override
            @NotNull
            public Annotations getAnnotations() {
                Annotations annotations2 = AbstractLazyTypeParameterDescriptor.this.getAnnotations();
                if (annotations2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/descriptors/impl/AbstractLazyTypeParameterDescriptor$1", "getAnnotations"));
                }
                return annotations2;
            }

            public String toString() {
                return AbstractLazyTypeParameterDescriptor.this.getName().toString();
            }
        };
        if (typeConstructor2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/descriptors/impl/AbstractLazyTypeParameterDescriptor", "createTypeConstructor"));
        }
        return typeConstructor2;
    }

    @Override
    public String toString() {
        return String.format("%s%s%s", this.isReified() ? "reified " : "", this.getVariance() == Variance.INVARIANT ? "" : this.getVariance() + " ", this.getName());
    }
}

