/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.diagnostics.rendering;

import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.Function;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.Function1;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KObject;
import kotlin.jvm.internal.KotlinClass;
import kotlin.platform.platformStatic;
import kotlin.reflect.jvm.internal.InternalPackage;
import kotlin.reflect.jvm.internal.KClassImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.Named;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.diagnostics.rendering.Renderers;
import org.jetbrains.kotlin.diagnostics.rendering.RenderingPackage$sam$Function$8585622c;
import org.jetbrains.kotlin.diagnostics.rendering.TabledDescriptorRenderer;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.JetClassOrObject;
import org.jetbrains.kotlin.psi.JetNamedDeclaration;
import org.jetbrains.kotlin.renderer.Renderer;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.inference.CannotCapture;
import org.jetbrains.kotlin.resolve.calls.inference.CapturedTypeConstructor;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintError;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystem;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemImpl;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemStatus;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintsUtil;
import org.jetbrains.kotlin.resolve.calls.inference.InferenceErrorData;
import org.jetbrains.kotlin.resolve.calls.inference.InferencePackage$CapturedTypeConstructor$e856b5bd;
import org.jetbrains.kotlin.resolve.calls.inference.TypeBounds;
import org.jetbrains.kotlin.resolve.calls.inference.TypeBoundsImpl;
import org.jetbrains.kotlin.resolve.calls.inference.TypeConstructorMismatch;
import org.jetbrains.kotlin.resolve.calls.inference.constraintPosition.ConstraintPosition;
import org.jetbrains.kotlin.resolve.calls.inference.constraintPosition.ConstraintPositionKind;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.types.JetType;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeSubstitutor;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.checker.JetTypeChecker;

@KotlinClass(abiVersion=19, data={"\u0015 )I!+\u001a8eKJ,'o\u001d\u0006\u0004_J<'\"\u00036fi\n\u0014\u0018-\u001b8t\u0015\u0019Yw\u000e\u001e7j]*YA-[1h]>\u001cH/[2t\u0015%\u0011XM\u001c3fe&twMC\u0002B]fTq\"Q'C\u0013\u001e+v*V*`\u0007\u0006cEj\u0015\u0006\t%\u0016tG-\u001a:fe*A!/\u001a8eKJ,'O\u0003\u0006D_2dWm\u0019;j_:TABU3t_24X\rZ\"bY2TqA]3t_24XMC\u0003dC2d7OC\u0003n_\u0012,GN\u0003\nDC2d\u0017M\u00197f\t\u0016\u001c8M]5qi>\u0014(b\u00033fg\u000e\u0014\u0018\u000e\u001d;peNTqc[8uY&tgF\u001b<n]Ac\u0017\r\u001e4pe6$\u0016\u0010]3\u000b%\u001d,G/Q'C\u0013\u001e+v*V*`\u0007\u0006cEj\u0015\u0006\u0015\u00072\u000b5kU#T?>\u0013vlU#Q\u0003J\u000bE+\u0012#\u000b\u001f\rc\u0017m]:EKN\u001c'/\u001b9u_JTqcZ3u\u00072\u000b5kU#T?>\u0013vlU#Q\u0003J\u000bE+\u0012#\u000b!\u0011+5\tT!S\u0003RKuJT0O\u00036+%b\u0005&fi:\u000bW.\u001a3EK\u000ed\u0017M]1uS>t'b\u00019tS*\u0019r-\u001a;E\u000b\u000ec\u0015IU!U\u0013>suLT!N\u000b*aQ\tT#N\u000b:#v\fV#Y)*Q\u0001k]5FY\u0016lWM\u001c;\u000b\u0007\r|WN\u0003\u0005j]R,G\u000e\\5k\u0015=9W\r^#M\u000b6+e\nV0U\u000bb#&b\u0001'P\u000f*1Aj\\4hKJTqa\u001c9f]\u0006\u0004\u0018N\u0003\u0006eS\u0006<gn\\:uS\u000eTAAT!N\u000b*)a*Y7fI*9q-\u001a;O\u00036+%B\u0006*F\u001d\u0012+%kX\"M\u0003N\u001bvl\u0014*`\u001f\nSUi\u0011+\u000b!)+Go\u00117bgN|%o\u00142kK\u000e$(\"G4fiJ+e\nR#S?\u000ec\u0015iU*`\u001fJ{vJ\u0011&F\u0007RS1DU#O\t\u0016\u0013vl\u0011'B'N{vJU0P\u0005*+5\tV0O\u00036+%BH4fiJ+e\nR#S?\u000ec\u0015iU*`\u001fJ{vJ\u0011&F\u0007R{f*Q'F\u0015i\u0011VI\u0014#F%~\u001bu\n\u0014'F\u0007RKuJT0P\r~#\u0016\fU#T\u0015\u001dQU\r\u001e+za\u0016TQ\u0001^=qKNTQdZ3u%\u0016sE)\u0012*`\u0007>cE*R\"U\u0013>sul\u0014$`)f\u0003Vi\u0015\u0006\u0019%\u0016sE)\u0012*`\u0007>s5\u000b\u0016*B\u0013:#vlU-T)\u0016k%\u0002E\"p]N$(/Y5oiNK8\u000f^3n\u0015%IgNZ3sK:\u001cWMC\u000ehKR\u0014VI\u0014#F%~\u001buJT*U%\u0006Ke\nV0T3N#V)\u0014\u0006\u0019%\u0016sE)\u0012*`!>\u001b\u0016\nV%P\u001d~3\u0016IU%B\u001d\u000e+%\u0002\u0003,be&\fgnY3\u000b7\u001d,GOU#O\t\u0016\u0013v\fU(T\u0013RKuJT0W\u0003JK\u0015IT\"F\u0015-\u0011VI\u0014#F%~#\u0016\fU#\u000b\u001d\u001d,GOU#O\t\u0016\u0013v\fV-Q\u000b*\u0011\"+\u0012(E\u000bJ{F+\u0017)F?\n{UK\u0014#T\u0015)!\u0016\u0010]3C_VtGm\u001d\u0006\u0016O\u0016$(+\u0012(E\u000bJ{F+\u0017)F?\n{UK\u0014#T\u0015\u0019\u0019FKU%O\u000f*11\u000b\u001e:j]\u001eT\u0011bZ3u'R\u0013\u0016JT$\u000b\u0013Q{ul\u0015+S\u0013:;%\u0002D4fiR{ul\u0015+S\u0013:;%\u0002\f+Z!\u0016{\u0016J\u0014$F%\u0016s5)R0D\u0003:su\nV0D\u0003B#VKU#`)f\u0003ViU0S\u000b:#UIU#S\u0015IIeNZ3sK:\u001cW-\u0012:s_J$\u0015\r^1\u000b_\u001d,G\u000fV-Q\u000b~KeJR#S\u000b:\u001bUiX\"B\u001d:{EkX\"B!R+&+R0U3B+5k\u0018*F\u001d\u0012+%+\u0012*\u000bcQK\u0006+R0J\u001d\u001a+%+\u0012(D\u000b~\u001buJ\u0014$M\u0013\u000e#\u0016JT$`'V\u00135\u000bV%U+RKuJT*`%\u0016sE)\u0012*F%*!t-\u001a;U3B+u,\u0013(G\u000bJ+ejQ#`\u0007>se\tT%D)&suiX*V\u0005N#\u0016\nV+U\u0013>s5k\u0018*F\u001d\u0012+%+\u0012*\u000biQK\u0006+R0J\u001d\u001a+%+\u0012(D\u000b~sujX%O\r>\u0013V*\u0011+J\u001f:{fi\u0014*`!\u0006\u0013\u0016)T#U\u000bJ{&+\u0012(E\u000bJ+%KC\u001chKR$\u0016\fU#`\u0013:3UIU#O\u0007\u0016{fjT0J\u001d\u001a{%+T!U\u0013>suLR(S?B\u000b%+Q'F)\u0016\u0013vLU#O\t\u0016\u0013VI\u0015\u00062)f\u0003ViX%O\r\u0016\u0013VIT\"F?RK\u0006+R0D\u001f:\u001bFKU+D)>\u0013v,T%T\u001b\u0006#6\tS0S\u000b:#UIU#S\u0015Q:W\r\u001e+Z!\u0016{\u0016J\u0014$F%\u0016s5)R0U3B+ulQ(O'R\u0013Vk\u0011+P%~k\u0015jU'B)\u000eCuLU#O\t\u0016\u0013VI\u0015\u0006-)f\u0003ViX%O\r\u0016\u0013VIT\"F?V\u0003\u0006+\u0012*`\u0005>+f\nR0W\u0013>c\u0015\tV#E?J+e\nR#S\u000bJSqfZ3u)f\u0003ViX%O\r\u0016\u0013VIT\"F?V\u0003\u0006+\u0012*`\u0005>+f\nR0W\u0013>c\u0015\tV#E?J+e\nR#S\u000bJS\u0011\u0001\u0016\u0006\u000fG>lW.Y*fa\u0006\u0014\u0018\r^3e\u00151IG/Z7SK:$WM]3s\u0015\u0015\u0012XM\u001c3fe\u000e\u000bgN\\8u\u0007\u0006\u0004H/\u001e:f)f\u0004X\rU1sC6,G/\u001a:FeJ|'O\u0003\nj]\u001a,'/\u001a8dK\u0016\u0013(o\u001c:ECR\f'B\u0002:fgVdGO\u0003\rUC\ndW\r\u001a#fg\u000e\u0014\u0018\u000e\u001d;peJ+g\u000eZ3sKJTAF]3oI\u0016\u00148i\u001c8gY&\u001cG/\u001b8h'V\u00147\u000f^5ukRLwN\\:J]\u001a,'/\u001a8dK\u0016\u0013(o\u001c:\u000b-I,g\u000eZ3s\u0007>t7\u000f\u001e:bS:$8+_:uK6T\u0001cY8ogR\u0014\u0018-\u001b8u'f\u001cH/Z7\u000b\t)\fg/\u0019\u0006\u0005Y\u0006twM\u0003\nsK:$WM\u001d#fEV<W*Z:tC\u001e,'bB7fgN\fw-\u001a\u0006%e\u0016tG-\u001a:O_&sgm\u001c:nCRLwN\u001c$peB\u000b'/Y7fi\u0016\u0014XI\u001d:pe*\u0001\"/\u001a8eKJ$\u0016\u0010]3C_VtGm\u001d\u0006\u000bif\u0004XMQ8v]\u0012\u001c(B\t:f]\u0012,'\u000fV=qK\u000e{gn\u001d;sk\u000e$xN]'jg6\fGo\u00195FeJ|'OC\u0006sK:$WM\u001d+za\u0016\u001c(\u0002B;uS2TaE]3oI\u0016\u0014X\u000b\u001d9fe\n{WO\u001c3WS>d\u0017\r^3e\u0013:4WM]3oG\u0016,%O]8s\u0015qa4\r\\1tg6z'M[3di62wN]\u0017SK:$WM]3sgzb-A\u0003\u0002\u0011\u0003)!\u0001\u0002\u0001\t\u0003\u0015\u0011A\u0011\u0001E\u0002\u000b\t!\u0011\u0001\u0003\u0002\u0006\u0005\u0011\r\u0001RA\u0003\u0004\t\tA\u0001\u0001\u0004\u0001\u0006\u0003!\rQa\u0001\u0003\u0004\u0011\ra\u0001!\u0002\u0002\u0005\u0003!%Qa\u0001\u0003\u0005\u0011\u0011a\u0001!B\u0002\u0005\u0007!)A\u0002A\u0003\u0003\t\u0005Aa!\u0002\u0002\u0005\f!5QA\u0001\u0003\u0007\u0011\u001d)1\u0001\"\u0004\t\f1\u0001QA\u0001\u0003\u0002\u0011!)1\u0001b\u0004\t\u00101\u0001QA\u0001\u0003\u0005\u0011\u0011)1\u0001b\u0004\t\u00151\u0001QA\u0001\u0003\u0002\u00111)1\u0001b\u0005\t\u00181\u0001Q!\u0001\u0005\u000f\u000b\t!)\u0002#\b\u0006\u0005\u0011Y\u0001\u0002D\u0003\u0004\t/AY\u0002\u0004\u0001\u0006\u0005\u0011Y\u0001\u0012E\u0003\u0003\t3A\u0011#B\u0002\u0005\u001b!\u0001B\u0002A\u0003\u0003\t5A\u0001#B\u0002\u0005\u0010!\u0011B\u0002A\u0003\u0004\t'A9\u0003\u0004\u0001\u0006\u0005\u0011\t\u0001RF\u0003\u0004\t?Aa\u0003\u0004\u0001\u0006\u0005\u00111\u0001\u0012G\u0003\u0004\tCA\u0001\u0004\u0004\u0001\u0006\u0007\u0011}\u0001B\u0007\u0007\u0001\u000b\r!\t\u0003#\u000f\r\u0001\u0015\u0019Aa\u0001\u0005\u001f\u0019\u0001)1\u0001\"\t\tB1\u0001Qa\u0001\u0003\u0003\u0011#b\u0001!\u0002\u0002\u0005\u0005!ESA\u0001C\u0011\u0011\u0003*\u0011\u0001#\u0016\u0006\u0005\u0011)\u0002bK\u0003\u0003\tWAa$\u0002\u0002\u0005\"!ARA\u0001C\u0011\u0011s)!\u0001B\u000b\t_\u0015\u0011Aq\u0006\u0005\u0006\u000b\r!)\u0001\u0003\u0019\r\u0001\u0011\u0019\u0017\u0001$\u0002\u0012\u0010\u00155Aaq\u0001\r2e\u0011Q!\u0001E\u0003k\u0001I\"!B\u0001\t\b5\nCa\u0019\u0003\u0019\b\u0005\"R!\u0001E\u0005\u0013EI\u0001#B\u0001\t\u000b%i\u0011\u0002D\u0003\u0002\u0011\u001dI\u0011\u0002b\u0001\n\u000f\u0015\t\u0001\u0002\u0003I\t+\r)\u0011\u0001\u0003\u0005\r\u0002U\u001b\u0001\"B\u0002\u0005\b%\t\u0001\u0012C\u0007\u0004\t%I\u0011\u0001#\u0005./\u0011\u0019G\u0001g\u0005\"\u0015\u0015\t\u0001\u0012B\u0005\b\u0013\u0019)\u0011\u0001C\u0003\n\u0007%\u0011Q!\u0001\u0005\n+\u000eAQa\u0001C\n\u0013\u0005A\t\"D\u0002\u0005\u0016%\t\u0001\u0012C\u0017\u0014\t\r$\u0001dC\u0011\u0007\u000b\u0005AI!C\u0002\n\u0005\u0015\t\u0001BC+\u0004\u0011\u0015\u0019AaC\u0005\u0002\u0011#i1\u0001\"\u0007\n\u0003!EQf\u0005\u0003d\tai\u0011EB\u0003\u0002\u0011\u0013I1!\u0003\u0002\u0006\u0003!aQk\u0001\u0005\u0006\u0007\u0011i\u0011\"\u0001E\t\u001b\r!q\"C\u0001\t\u00125\u0002B!\u0019\u0003\u0019 \u0005:Q!\u0001E\u000e!#)2!B\u0001\t\u001c1\u0005Qk\u0001\u0003\u0006\u0007\u0011}\u0011\"\u0001\u0005\u000f[M!1\r\u0002M\u0012C\u0019)\u0011\u0001#\u0003\n\u0007%\u0011Q!\u0001E\u000f+\u000eAQa\u0001C\u0012\u0013\u0005A\t\"D\u0002\u0005&%\t\u0001\u0012C\u0017\u0014\t\r$\u0001dE\u0011\u0007\u000b\u0005AI!C\u0002\n\u0005\u0015\t\u0001bD+\u0004\u0011\u0015\u0019AaE\u0005\u0002\u0011#i1\u0001\u0002\u000b\n\u0003!EQf\u0005\u0003d\ta%\u0012EB\u0003\u0002\u0011\u0013I1!\u0003\u0002\u0006\u0003!IQk\u0001\u0005\u0006\u0007\u0011%\u0012\"\u0001E\t\u001b\r!Q#C\u0001\t\u00125:Ba\u0019\u0003\u0019,\u0005RQ!\u0001E\u0005\u0013\u001dIa!B\u0001\t\u000b%\u0019\u0011BA\u0003\u0002\u0011A)6\u0001C\u0003\u0004\tWI\u0011\u0001#\u0005\u000e\u0007\u00119\u0012\"\u0001E\t[M!1\r\u0002M\u0018C\u0019)\u0011\u0001#\u0003\n\u0007%\u0011Q!\u0001\u0005\u0012+\u000eAQa\u0001C\u0018\u0013\u0005A\t\"D\u0002\u00053%\t\u0001\u0012C\u0017\u0014\t\r$\u00014G\u0011\u0007\u000b\u0005AI!C\u0002\n\u0005\u0015\t\u00012E+\u0004\u0011\u0015\u0019A1G\u0005\u0002\u0011#i1\u0001\"\u000e\n\u0003!EQf\u0005\u0003d\taY\u0012EB\u0003\u0002\u0011\u0013I1!\u0003\u0002\u0006\u0003!\u0001Rk\u0001\u0005\u0006\u0007\u0011Y\u0012\"\u0001E\t\u001b\r!9$C\u0001\t\u00125\u001aBa\u0019\u0003\u00199\u00052Q!\u0001E\u0005\u0013\rI!!B\u0001\t%U\u001b\u0001\"B\u0002\u00059%\t\u0001\u0012C\u0007\u0004\tuI\u0011\u0001#\u0005.'\u0011\u0019G\u0001g\u000f\"\r\u0015\t\u0001\u0012B\u0005\u0004\u0013\t)\u0011\u0001#\nV\u0007!)1\u0001b\u000f\n\u0003!EQb\u0001C\u001f\u0013\u0005A\t\"L\n\u0005G\u0012Ar$\t\u0004\u0006\u0003!%\u0011bA\u0005\u0003\u000b\u0005A9!V\u0002\t\u000b\r!q$C\u0001\t\u00125\u0019AqH\u0005\u0002\u0011#i3\u0003B2\u00051\u0001\nc!B\u0001\t\n%\u0019\u0011BA\u0003\u0002\u0011M)6\u0001C\u0003\u0004\t\u0001J\u0011\u0001#\u0005\u000e\u0007\u0011\t\u0013\"\u0001E\t[M!1\r\u0002M\"C\u0019)\u0011\u0001#\u0003\n\u0007%\u0011Q!\u0001\u0005\u0014+\u000eAQa\u0001C\"\u0013\u0005A\t\"D\u0002\u0005E%\t\u0001\u0012C\u0017\u0014\t\r$\u0001TI\u0011\u0007\u000b\u0005AI!C\u0002\n\u0005\u0015\t\u0001bE+\u0004\u0011\u0015\u0019AQI\u0005\u0002\u0011#i1\u0001B\u0012\n\u0003!EQf\u0005\u0003d\ta\u001d\u0013EB\u0003\u0002\u0011\u0013I1!\u0003\u0002\u0006\u0003!\u0019Rk\u0001\u0005\u0006\u0007\u0011\u001d\u0013\"\u0001E\t\u001b\r!A%C\u0001\t\u00125\u001aBa\u0019\u0003\u0019J\u00052Q!\u0001E\u0005\u0013\rI!!B\u0001\t'U\u001b\u0001\"B\u0002\u0005J%\t\u0001\u0012C\u0007\u0004\t\u0015J\u0011\u0001#\u0005.Q\u0011\u001d\u0011C\u0002\u0003\u0001\u0011\u0017*2!B\u0001\t\b1\u0005\u0001DJO\f\t\u0001Ai%D\u0004\u0006\u0003!%\u0011\u0002B\u0005\u0004\u000b\t!\t\u0001\u0003\u0001Q\u0007\u0001\t3\"B\u0001\t\n%A\u0011bB\u0003\u0002\u0011\u0015IA!C\u0002\u0006\u0005\u0011\u0005\u0001\u0002A)\u0004\u000b\u00111\u0013\"\u0001E\t\u001b\u0005A\t\",\u000f\u0005\ba9ST\u0002\u0003\u0001\u0011\u001fj!!B\u0001\t'A\u001b\u0001!(\u0004\u0005\u0001!ASBA\u0003\u0002\u0011O\u00016\u0011A\u0011\u0003\u000b\u0005A9#U\u0002\b\t\u001dJ\u0011\u0001\u0003\u000b\u000e\u0003!%R\"\u0001\u0005\u0015[s!9\u0001G\u0015\u001e\u000e\u0011\u0001\u0001rJ\u0007\u0003\u000b\u0005A1\u0003U\u0002\u0001;\u001b!\u0001\u0001\u0003\u0015\u000e\u0005\u0015\t\u0001r\u0005)\u0004\u0002\u0005\u0012Q!\u0001E\u0014#\u000e9A!K\u0005\u0002\u0011Qi\u0011\u0001#\u000b\u000e\u0003!!Rf\u0005\u0003\u00021'jj\u0001\u0002\u0001\tU5\u0011Q!\u0001\u0005\u0012!\u000e\u0001\u0011EA\u0003\u0002\u0011K\t6!\u0002C*\u0013\u0005Aa#D\u0001\t.5\u000eC!\u0001M,;\u001b!\u0001\u0001\u0003\u0017\u000e\u0005\u0015\t\u0001R\u0005)\u0004\u0001u5A\u0001\u0001E(\u001b\t)\u0011\u0001C\nQ\u0007\u0003\ts!B\u0001\t&AEQcA\u0003\u0002\u0011Ka\t!U\u0002\b\t/J\u0011\u0001\u0003\f\u000e\u0003!1R\"\u0001E\u0015[s!9\u0001'\u0017\u001e\u000e\u0011\u0001\u0001rJ\u0007\u0003\u000b\u0005A1\u0003U\u0002\u0001;\u001b!\u0001\u0001\u0003\u0015\u000e\u0005\u0015\t\u0001r\u0005)\u0004\u0002\u0005\u0012Q!\u0001E\u0014#\u000e9A\u0011L\u0005\u0002\u0011Qi\u0011\u0001#\u000b\u000e\u0003!!Rf\u0005\u0003\u000215jj\u0001\u0002\u0001\t\\5\u0011Q!\u0001\u0005\u0013!\u000e\u0001\u0011EA\u0003\u0002\u0011K\t6!\u0002\u0003.\u0013\u0005Aa#D\u0001\t/5fBq\u0001\r/;\u001b!\u0001\u0001c\u0014\u000e\u0005\u0015\t\u0001b\u0005)\u0004\u0001u5A\u0001\u0001E\u0005\u001b\t)\u0011\u0001c\nQ\u0007\u0003\t#!B\u0001\t(E\u001bq\u0001\u0002\u0018\n\u0003!!R\"\u0001E\u0015\u001b\u0005AA#\f\u000f\u0005\u0003auST\u0003\u0003\u0001\u0011[ia!B\u0001\t\u000b%\u0019\u0011BA\u0003\u0002\u0011A\u00016\u0001A\u0011\b\u000b\u0005A)\u0003%\u0005\u0016\u0007\u0015\t\u0001R\u0005G\u0001#\u000e)AQL\u0005\u0002\u0011Yi\u0011\u0001\u0003\r.:\u0011\u001d\u0001tLO\u0007\t\u0001Ay%\u0004\u0002\u0006\u0003!\u0019\u0002k\u0001\u0001\u001e\u000e\u0011\u0001\u0001\u0002K\u0007\u0003\u000b\u0005A9\u0003UB\u0001C\t)\u0011\u0001c\nR\u0007\u001d!y&C\u0001\t)5\t\u0001\u0012F\u0007\u0002\u0011Q)\u0004\u0001"})
public final class Renderers
implements KObject {
    public static final /* synthetic */ KClassImpl $kotlinClass;
    private static final Logger LOG;
    @NotNull
    public static final Renderer<Object> TO_STRING;
    @NotNull
    public static final Renderer<String> STRING;
    @NotNull
    public static final Renderer<Named> NAME;
    @NotNull
    public static final Renderer<PsiElement> ELEMENT_TEXT;
    @NotNull
    public static final Renderer<JetNamedDeclaration> DECLARATION_NAME;
    @NotNull
    public static final Renderer<JetClassOrObject> RENDER_CLASS_OR_OBJECT;
    @NotNull
    public static final Renderer<ClassDescriptor> RENDER_CLASS_OR_OBJECT_NAME;
    @NotNull
    public static final Renderer<JetType> RENDER_TYPE;
    @NotNull
    public static final Renderer<Variance> RENDER_POSITION_VARIANCE;
    @NotNull
    public static final Renderer<Collection<? extends ResolvedCall<?>>> AMBIGUOUS_CALLS;
    @NotNull
    public static final Renderer<InferenceErrorData> TYPE_INFERENCE_CONFLICTING_SUBSTITUTIONS_RENDERER;
    @NotNull
    public static final Renderer<InferenceErrorData> TYPE_INFERENCE_TYPE_CONSTRUCTOR_MISMATCH_RENDERER;
    @NotNull
    public static final Renderer<InferenceErrorData> TYPE_INFERENCE_NO_INFORMATION_FOR_PARAMETER_RENDERER;
    @NotNull
    public static final Renderer<InferenceErrorData> TYPE_INFERENCE_UPPER_BOUND_VIOLATED_RENDERER;
    @NotNull
    public static final Renderer<InferenceErrorData> TYPE_INFERENCE_CANNOT_CAPTURE_TYPES_RENDERER;
    @NotNull
    public static final Renderer<Collection<? extends ClassDescriptor>> CLASSES_OR_SEPARATED;
    @NotNull
    public static final Renderer<Collection<? extends JetType>> RENDER_COLLECTION_OF_TYPES;
    @NotNull
    public static final Renderer<ConstraintSystem> RENDER_CONSTRAINT_SYSTEM;
    @NotNull
    public static final Renderer<TypeBounds> RENDER_TYPE_BOUNDS;
    public static final Renderers INSTANCE$;

    static {
        $kotlinClass = InternalPackage.kClassFromKotlin(Renderers.class);
        new Renderers();
    }

    @NotNull
    public final Renderer<Object> getTO_STRING() {
        return TO_STRING;
    }

    @NotNull
    public final Renderer<String> getSTRING() {
        return STRING;
    }

    @NotNull
    public final Renderer<Named> getNAME() {
        return NAME;
    }

    @NotNull
    public final Renderer<PsiElement> getELEMENT_TEXT() {
        return ELEMENT_TEXT;
    }

    @NotNull
    public final Renderer<JetNamedDeclaration> getDECLARATION_NAME() {
        return DECLARATION_NAME;
    }

    @NotNull
    public final Renderer<JetClassOrObject> getRENDER_CLASS_OR_OBJECT() {
        return RENDER_CLASS_OR_OBJECT;
    }

    @NotNull
    public final Renderer<ClassDescriptor> getRENDER_CLASS_OR_OBJECT_NAME() {
        return RENDER_CLASS_OR_OBJECT_NAME;
    }

    @NotNull
    public final Renderer<JetType> getRENDER_TYPE() {
        return RENDER_TYPE;
    }

    @NotNull
    public final Renderer<Variance> getRENDER_POSITION_VARIANCE() {
        return RENDER_POSITION_VARIANCE;
    }

    @NotNull
    public final Renderer<Collection<? extends ResolvedCall<?>>> getAMBIGUOUS_CALLS() {
        return AMBIGUOUS_CALLS;
    }

    @platformStatic
    @NotNull
    public static final <T> Renderer<Collection<? extends T>> commaSeparated(@JetValueParameter(name="itemRenderer") @NotNull Renderer<T> itemRenderer) {
        Intrinsics.checkParameterIsNotNull(itemRenderer, "itemRenderer");
        return new Renderer<Collection<? extends T>>(itemRenderer){
            final /* synthetic */ Renderer $itemRenderer;

            @NotNull
            public final String render(@JetValueParameter(name="collection") Collection<? extends T> collection) {
                StringBuilder stringBuilder;
                StringBuilder $receiver = stringBuilder = new StringBuilder();
                Iterator<T> iterator2 = collection.iterator();
                while (iterator2.hasNext()) {
                    T next = iterator2.next();
                    $receiver.append(this.$itemRenderer.render(next));
                    if (!iterator2.hasNext()) continue;
                    $receiver.append(", ");
                }
                return stringBuilder.toString();
            }
            {
                this.$itemRenderer = renderer;
            }
        };
    }

    @NotNull
    public final Renderer<InferenceErrorData> getTYPE_INFERENCE_CONFLICTING_SUBSTITUTIONS_RENDERER() {
        return TYPE_INFERENCE_CONFLICTING_SUBSTITUTIONS_RENDERER;
    }

    @NotNull
    public final Renderer<InferenceErrorData> getTYPE_INFERENCE_TYPE_CONSTRUCTOR_MISMATCH_RENDERER() {
        return TYPE_INFERENCE_TYPE_CONSTRUCTOR_MISMATCH_RENDERER;
    }

    @NotNull
    public final Renderer<InferenceErrorData> getTYPE_INFERENCE_NO_INFORMATION_FOR_PARAMETER_RENDERER() {
        return TYPE_INFERENCE_NO_INFORMATION_FOR_PARAMETER_RENDERER;
    }

    @NotNull
    public final Renderer<InferenceErrorData> getTYPE_INFERENCE_UPPER_BOUND_VIOLATED_RENDERER() {
        return TYPE_INFERENCE_UPPER_BOUND_VIOLATED_RENDERER;
    }

    @NotNull
    public final Renderer<InferenceErrorData> getTYPE_INFERENCE_CANNOT_CAPTURE_TYPES_RENDERER() {
        return TYPE_INFERENCE_CANNOT_CAPTURE_TYPES_RENDERER;
    }

    @platformStatic
    @NotNull
    public static final TabledDescriptorRenderer renderConflictingSubstitutionsInferenceError(@JetValueParameter(name="inferenceErrorData") @NotNull InferenceErrorData inferenceErrorData, @JetValueParameter(name="result") @NotNull TabledDescriptorRenderer result2) {
        Intrinsics.checkParameterIsNotNull(inferenceErrorData, "inferenceErrorData");
        Intrinsics.checkParameterIsNotNull(result2, "result");
        LOG.assertTrue(inferenceErrorData.constraintSystem.getStatus().hasConflictingConstraints(), INSTANCE$.renderDebugMessage("Conflicting substitutions inference error renderer is applied for incorrect status", inferenceErrorData));
        ArrayList<CallableDescriptor> substitutedDescriptors = Lists.newArrayList();
        Collection<TypeSubstitutor> substitutors = ConstraintsUtil.getSubstitutorsForConflictingParameters(inferenceErrorData.constraintSystem);
        for (TypeSubstitutor substitutor : substitutors) {
            CallableDescriptor substitutedDescriptor = inferenceErrorData.descriptor.substitute(substitutor);
            substitutedDescriptors.add(substitutedDescriptor);
        }
        TypeParameterDescriptor firstConflictingParameter = ConstraintsUtil.getFirstConflictingParameter(inferenceErrorData.constraintSystem);
        if (firstConflictingParameter == null) {
            LOG.error(INSTANCE$.renderDebugMessage("There is no conflicting parameter for 'conflicting constraints' error.", inferenceErrorData));
            return result2;
        }
        result2.text(TabledDescriptorRenderer.newText().normal("Cannot infer type parameter ").strong(firstConflictingParameter.getName()).normal(" in "));
        TabledDescriptorRenderer.TableRenderer table = TabledDescriptorRenderer.newTable();
        result2.table(table);
        table.descriptor(inferenceErrorData.descriptor).text("None of the following substitutions");
        for (CallableDescriptor substitutedDescriptor : substitutedDescriptors) {
            JetType receiverType = DescriptorUtils.getReceiverParameterType(substitutedDescriptor.getExtensionReceiverParameter());
            HashSet<ConstraintPosition> errorPositions = Sets.newHashSet();
            ArrayList<JetType> parameterTypes = Lists.newArrayList();
            for (ValueParameterDescriptor valueParameterDescriptor : substitutedDescriptor.getValueParameters()) {
                JetType actualType;
                parameterTypes.add(valueParameterDescriptor.getType());
                if (valueParameterDescriptor.getIndex() >= inferenceErrorData.valueArgumentsTypes.size() || JetTypeChecker.DEFAULT.isSubtypeOf(actualType = inferenceErrorData.valueArgumentsTypes.get(valueParameterDescriptor.getIndex()), valueParameterDescriptor.getType())) continue;
                errorPositions.add(ConstraintPositionKind.VALUE_PARAMETER_POSITION.position(valueParameterDescriptor.getIndex()));
            }
            boolean bl = (receiverType != null ? inferenceErrorData.receiverArgumentType != null : false) ? !JetTypeChecker.DEFAULT.isSubtypeOf(inferenceErrorData.receiverArgumentType, receiverType) : false;
            if (bl) {
                errorPositions.add(ConstraintPositionKind.RECEIVER_POSITION.position());
            }
            table.functionArgumentTypeList(receiverType, (List<JetType>)parameterTypes, new Predicate<ConstraintPosition>(errorPositions){
                final /* synthetic */ HashSet $errorPositions;

                public final boolean apply(@JetValueParameter(name="it") ConstraintPosition it) {
                    return this.$errorPositions.contains(it);
                }
                {
                    this.$errorPositions = hashSet;
                }
            });
        }
        table.text("can be applied to").functionArgumentTypeList(inferenceErrorData.receiverArgumentType, inferenceErrorData.valueArgumentsTypes);
        return result2;
    }

    @platformStatic
    @NotNull
    public static final TabledDescriptorRenderer renderTypeConstructorMismatchError(@JetValueParameter(name="inferenceErrorData") @NotNull InferenceErrorData inferenceErrorData, @JetValueParameter(name="renderer") @NotNull TabledDescriptorRenderer renderer) {
        ConstraintError it;
        Iterable iterable;
        Intrinsics.checkParameterIsNotNull(inferenceErrorData, "inferenceErrorData");
        Intrinsics.checkParameterIsNotNull(renderer, "renderer");
        ConstraintSystem constraintSystem = inferenceErrorData.constraintSystem;
        if (constraintSystem == null) {
            throw new TypeCastException("org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystem! cannot be cast to org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemImpl");
        }
        List<ConstraintError> constraintErrors = ((ConstraintSystemImpl)constraintSystem).getConstraintErrors();
        Iterable iterable2 = iterable = (Iterable)constraintErrors;
        Collection collection = new ArrayList();
        for (Object t : iterable2) {
            it = (ConstraintError)t;
            if (!(it instanceof TypeConstructorMismatch)) continue;
            collection.add(t);
        }
        iterable2 = iterable = (Iterable)((ArrayList)collection);
        collection = new ArrayList();
        for (Object t : iterable2) {
            it = (ConstraintError)t;
            Collection collection2 = collection;
            ConstraintPosition constraintPosition = it.getConstraintPosition();
            collection2.add(constraintPosition);
        }
        List errorPositions = (ArrayList)collection;
        TabledDescriptorRenderer tabledDescriptorRenderer = renderer.table(TabledDescriptorRenderer.newTable().descriptor(inferenceErrorData.descriptor).text("cannot be applied to").functionArgumentTypeList(inferenceErrorData.receiverArgumentType, inferenceErrorData.valueArgumentsTypes, new Predicate<ConstraintPosition>(errorPositions){
            final /* synthetic */ List $errorPositions;

            public final boolean apply(@JetValueParameter(name="it") ConstraintPosition it) {
                return this.$errorPositions.contains(it);
            }
            {
                this.$errorPositions = list;
            }
        }));
        Intrinsics.checkExpressionValueIsNotNull(tabledDescriptorRenderer, "renderer.table(\n        \u2026ositions.contains(it) }))");
        return tabledDescriptorRenderer;
    }

    @platformStatic
    @NotNull
    public static final TabledDescriptorRenderer renderNoInformationForParameterError(@JetValueParameter(name="inferenceErrorData") @NotNull InferenceErrorData inferenceErrorData, @JetValueParameter(name="result") @NotNull TabledDescriptorRenderer result2) {
        Intrinsics.checkParameterIsNotNull(inferenceErrorData, "inferenceErrorData");
        Intrinsics.checkParameterIsNotNull(result2, "result");
        TypeParameterDescriptor firstUnknownParameter = null;
        for (TypeParameterDescriptor typeParameter : inferenceErrorData.constraintSystem.getTypeVariables()) {
            if (!inferenceErrorData.constraintSystem.getTypeBounds(typeParameter).isEmpty()) continue;
            firstUnknownParameter = typeParameter;
            break;
        }
        if (firstUnknownParameter == null) {
            LOG.error(INSTANCE$.renderDebugMessage("There is no unknown parameter for 'no information for parameter error'.", inferenceErrorData));
            return result2;
        }
        TabledDescriptorRenderer.TextRenderer textRenderer = TabledDescriptorRenderer.newText().normal("Not enough information to infer parameter ");
        TypeParameterDescriptor typeParameterDescriptor = firstUnknownParameter;
        if (typeParameterDescriptor == null) {
            Intrinsics.throwNpe();
        }
        TabledDescriptorRenderer tabledDescriptorRenderer = result2.text(textRenderer.strong(typeParameterDescriptor.getName()).normal(" in ")).table(TabledDescriptorRenderer.newTable().descriptor(inferenceErrorData.descriptor).text("Please specify it explicitly."));
        Intrinsics.checkExpressionValueIsNotNull(tabledDescriptorRenderer, "result\n                .\u2026specify it explicitly.\"))");
        return tabledDescriptorRenderer;
    }

    @platformStatic
    @NotNull
    public static final TabledDescriptorRenderer renderUpperBoundViolatedInferenceError(@JetValueParameter(name="inferenceErrorData") @NotNull InferenceErrorData inferenceErrorData, @JetValueParameter(name="result") @NotNull TabledDescriptorRenderer result2) {
        Object v1;
        ConstraintSystem systemWithoutWeakConstraints;
        ConstraintSystemStatus status;
        block7: {
            Intrinsics.checkParameterIsNotNull(inferenceErrorData, "inferenceErrorData");
            Intrinsics.checkParameterIsNotNull(result2, "result");
            ConstraintSystem constraintSystem = inferenceErrorData.constraintSystem;
            if (constraintSystem == null) {
                throw new TypeCastException("org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystem! cannot be cast to org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemImpl");
            }
            ConstraintSystemImpl constraintSystem2 = (ConstraintSystemImpl)constraintSystem;
            status = constraintSystem2.getStatus();
            LOG.assertTrue(status.hasViolatedUpperBound(), INSTANCE$.renderDebugMessage("Upper bound violated renderer is applied for incorrect status", inferenceErrorData));
            systemWithoutWeakConstraints = constraintSystem2.getSystemWithoutWeakConstraints();
            Iterable iterable = inferenceErrorData.descriptor.getTypeParameters();
            for (Object t : iterable) {
                TypeParameterDescriptor it = (TypeParameterDescriptor)t;
                if (!(!ConstraintsUtil.checkUpperBoundIsSatisfied(systemWithoutWeakConstraints, it, true))) continue;
                v1 = t;
                break block7;
            }
            v1 = null;
        }
        TypeParameterDescriptor typeParameterDescriptor = v1;
        if (typeParameterDescriptor == null ? status.hasConflictingConstraints() : false) {
            return Renderers.renderConflictingSubstitutionsInferenceError(inferenceErrorData, result2);
        }
        if (typeParameterDescriptor == null) {
            LOG.error(INSTANCE$.renderDebugMessage("There is no type parameter with violated upper bound for 'upper bound violated' error", inferenceErrorData));
            return result2;
        }
        JetType inferredValueForTypeParameter = systemWithoutWeakConstraints.getTypeBounds(typeParameterDescriptor).getValue();
        if (inferredValueForTypeParameter == null) {
            LOG.error(INSTANCE$.renderDebugMessage("System without weak constraints is not successful, there is no value for type parameter " + typeParameterDescriptor.getName() + "\n: " + systemWithoutWeakConstraints, inferenceErrorData));
            return result2;
        }
        result2.text(TabledDescriptorRenderer.newText().normal("Type parameter bound for ").strong(typeParameterDescriptor.getName()).normal(" in ")).table(TabledDescriptorRenderer.newTable().descriptor(inferenceErrorData.descriptor));
        JetType violatedUpperBound = null;
        for (JetType upperBound : typeParameterDescriptor.getUpperBounds()) {
            JetType upperBoundWithSubstitutedInferredTypes = systemWithoutWeakConstraints.getResultingSubstitutor().substitute(upperBound, Variance.INVARIANT);
            boolean bl = upperBoundWithSubstitutedInferredTypes != null ? !JetTypeChecker.DEFAULT.isSubtypeOf(inferredValueForTypeParameter, upperBoundWithSubstitutedInferredTypes) : false;
            if (!bl) continue;
            violatedUpperBound = upperBoundWithSubstitutedInferredTypes;
            break;
        }
        if (violatedUpperBound == null) {
            LOG.error(INSTANCE$.renderDebugMessage("Type parameter (chosen as violating its upper bound)" + typeParameterDescriptor.getName() + " violates no bounds after substitution", inferenceErrorData));
            return result2;
        }
        Renderer<JetType> typeRenderer = result2.getTypeRenderer();
        result2.text(TabledDescriptorRenderer.newText().normal(" is not satisfied: inferred type ").error(typeRenderer.render(inferredValueForTypeParameter)).normal(" is not a subtype of ").strong(typeRenderer.render(violatedUpperBound)));
        return result2;
    }

    @platformStatic
    @NotNull
    public static final TabledDescriptorRenderer renderCannotCaptureTypeParameterError(@JetValueParameter(name="inferenceErrorData") @NotNull InferenceErrorData inferenceErrorData, @JetValueParameter(name="result") @NotNull TabledDescriptorRenderer result2) {
        CapturedTypeConstructor capturedTypeConstructor;
        TypeConstructor typeConstructor2;
        TypeBounds.Bound boundWithCapturedType;
        Object object2;
        Object v4;
        TypeParameterDescriptor typeParameterWithCapturedConstraint;
        block8: {
            ConstraintError constraintError;
            Object v1;
            Object object32;
            ConstraintSystemImpl constraintSystem;
            block7: {
                Intrinsics.checkParameterIsNotNull(inferenceErrorData, "inferenceErrorData");
                Intrinsics.checkParameterIsNotNull(result2, "result");
                ConstraintSystem constraintSystem2 = inferenceErrorData.constraintSystem;
                if (constraintSystem2 == null) {
                    throw new TypeCastException("org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystem! cannot be cast to org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemImpl");
                }
                constraintSystem = (ConstraintSystemImpl)constraintSystem2;
                List<ConstraintError> errors = constraintSystem.getConstraintErrors();
                Iterable iterable = errors;
                for (Object object32 : iterable) {
                    ConstraintError it = (ConstraintError)object32;
                    if (!(it instanceof CannotCapture)) continue;
                    v1 = object32;
                    break block7;
                }
                v1 = null;
            }
            if (!((constraintError = (ConstraintError)v1) instanceof CannotCapture)) {
                constraintError = null;
            }
            CannotCapture cannotCapture = (CannotCapture)constraintError;
            typeParameterWithCapturedConstraint = cannotCapture != null ? cannotCapture.getTypeVariable() : null;
            if (typeParameterWithCapturedConstraint == null) {
                LOG.error(INSTANCE$.renderDebugMessage("An error 'cannot capture type parameter' is not found in errors", inferenceErrorData));
                return result2;
            }
            TypeBoundsImpl typeBounds = constraintSystem.getTypeBounds(typeParameterWithCapturedConstraint);
            object32 = typeBounds.getBounds();
            for (Object e : object32) {
                TypeBounds.Bound it = (TypeBounds.Bound)e;
                if (!InferencePackage$CapturedTypeConstructor$e856b5bd.isCaptured(it.getConstrainingType())) continue;
                v4 = e;
                break block8;
            }
            v4 = null;
        }
        if (!(((object2 = (boundWithCapturedType = (TypeBounds.Bound)v4)) != null && (object2 = ((TypeBounds.Bound)object2).getConstrainingType()) != null ? object2.getConstructor() : (typeConstructor2 = null)) instanceof CapturedTypeConstructor)) {
            typeConstructor2 = null;
        }
        if ((capturedTypeConstructor = (CapturedTypeConstructor)typeConstructor2) == null) {
            LOG.error(INSTANCE$.renderDebugMessage("There is no captured type in bounds, but there is an error 'cannot capture type parameter'", inferenceErrorData));
            return result2;
        }
        JetType upperBound = typeParameterWithCapturedConstraint.getUpperBoundsAsType();
        String explanation = (!KotlinBuiltIns.isNullableAny(upperBound) ? Intrinsics.areEqual(capturedTypeConstructor.getTypeProjection().getProjectionKind(), Variance.IN_VARIANCE) : false) ? "Type parameter has an upper bound '" + result2.getTypeRenderer().render(upperBound) + "'" + " that cannot be satisfied capturing 'in' projection" : "Only top-level type projections can be captured";
        result2.text(TabledDescriptorRenderer.newText().normal("'" + typeParameterWithCapturedConstraint.getName() + "'" + " cannot capture " + "'" + capturedTypeConstructor.getTypeProjection() + "'. " + explanation));
        return result2;
    }

    @NotNull
    public final Renderer<Collection<? extends ClassDescriptor>> getCLASSES_OR_SEPARATED() {
        return CLASSES_OR_SEPARATED;
    }

    private final String renderTypes(@JetValueParameter(name="types") Collection<? extends JetType> types) {
        return StringUtil.join(types, (Function)renderTypes.1.INSTANCE$, ", ");
    }

    @NotNull
    public final Renderer<Collection<? extends JetType>> getRENDER_COLLECTION_OF_TYPES() {
        return RENDER_COLLECTION_OF_TYPES;
    }

    private final String renderConstraintSystem(@JetValueParameter(name="constraintSystem") ConstraintSystem constraintSystem) {
        Set<TypeParameterDescriptor> typeVariables = constraintSystem.getTypeVariables();
        LinkedHashSet<TypeBounds> typeBounds = Sets.newLinkedHashSet();
        for (TypeParameterDescriptor variable : typeVariables) {
            typeBounds.add(constraintSystem.getTypeBounds(variable));
        }
        return "type parameter bounds:\n" + StringUtil.join((Collection)typeBounds, (Function)renderConstraintSystem.1.INSTANCE$, "\n") + "\n" + "status:\n" + ConstraintsUtil.getDebugMessageForStatus(constraintSystem.getStatus());
    }

    @NotNull
    public final Renderer<ConstraintSystem> getRENDER_CONSTRAINT_SYSTEM() {
        return RENDER_CONSTRAINT_SYSTEM;
    }

    private final String renderTypeBounds(@JetValueParameter(name="typeBounds") TypeBounds typeBounds) {
        String string;
        Function1 renderBound2 = renderTypeBounds.renderBound.1.INSTANCE$;
        Name typeVariableName = typeBounds.getTypeVariable().getName();
        if (typeBounds.isEmpty()) {
            string = typeVariableName.asString();
        } else {
            Function1 function1 = renderBound2;
            string = typeVariableName + " " + StringUtil.join(typeBounds.getBounds(), (Function)(function1 == null ? null : new RenderingPackage$sam$Function$8585622c(function1)), ", ");
        }
        return string;
    }

    @NotNull
    public final Renderer<TypeBounds> getRENDER_TYPE_BOUNDS() {
        return RENDER_TYPE_BOUNDS;
    }

    private final String renderDebugMessage(@JetValueParameter(name="message") String message, @JetValueParameter(name="inferenceErrorData") InferenceErrorData inferenceErrorData) {
        StringBuilder stringBuilder;
        StringBuilder $receiver = stringBuilder = new StringBuilder();
        $receiver.append(message);
        $receiver.append("\nConstraint system: \n");
        $receiver.append(INSTANCE$.getRENDER_CONSTRAINT_SYSTEM().render(inferenceErrorData.constraintSystem));
        $receiver.append("\nDescriptor:\n");
        $receiver.append(inferenceErrorData.descriptor);
        $receiver.append("\nExpected type:\n");
        if (TypeUtils.noExpectedType(inferenceErrorData.expectedType)) {
            $receiver.append(inferenceErrorData.expectedType);
        } else {
            $receiver.append(INSTANCE$.getRENDER_TYPE().render(inferenceErrorData.expectedType));
        }
        $receiver.append("\nArgument types:\n");
        if (inferenceErrorData.receiverArgumentType != null) {
            $receiver.append(INSTANCE$.getRENDER_TYPE().render(inferenceErrorData.receiverArgumentType)).append(".");
        }
        StringBuilder stringBuilder2 = $receiver.append("(");
        Collection collection = inferenceErrorData.valueArgumentsTypes;
        Intrinsics.checkExpressionValueIsNotNull(collection, "inferenceErrorData.valueArgumentsTypes");
        stringBuilder2.append(Renderers.INSTANCE$.renderTypes(collection)).append(")");
        return stringBuilder.toString();
    }

    Renderers() {
        INSTANCE$ = this;
        LOG = Logger.getInstance(Renderers.class);
        TO_STRING = TO_STRING.1.INSTANCE$;
        STRING = STRING.1.INSTANCE$;
        NAME = NAME.1.INSTANCE$;
        ELEMENT_TEXT = ELEMENT_TEXT.1.INSTANCE$;
        DECLARATION_NAME = DECLARATION_NAME.1.INSTANCE$;
        RENDER_CLASS_OR_OBJECT = RENDER_CLASS_OR_OBJECT.1.INSTANCE$;
        RENDER_CLASS_OR_OBJECT_NAME = RENDER_CLASS_OR_OBJECT_NAME.1.INSTANCE$;
        RENDER_TYPE = RENDER_TYPE.1.INSTANCE$;
        RENDER_POSITION_VARIANCE = RENDER_POSITION_VARIANCE.1.INSTANCE$;
        AMBIGUOUS_CALLS = AMBIGUOUS_CALLS.1.INSTANCE$;
        TYPE_INFERENCE_CONFLICTING_SUBSTITUTIONS_RENDERER = TYPE_INFERENCE_CONFLICTING_SUBSTITUTIONS_RENDERER.1.INSTANCE$;
        TYPE_INFERENCE_TYPE_CONSTRUCTOR_MISMATCH_RENDERER = TYPE_INFERENCE_TYPE_CONSTRUCTOR_MISMATCH_RENDERER.1.INSTANCE$;
        TYPE_INFERENCE_NO_INFORMATION_FOR_PARAMETER_RENDERER = TYPE_INFERENCE_NO_INFORMATION_FOR_PARAMETER_RENDERER.1.INSTANCE$;
        TYPE_INFERENCE_UPPER_BOUND_VIOLATED_RENDERER = TYPE_INFERENCE_UPPER_BOUND_VIOLATED_RENDERER.1.INSTANCE$;
        TYPE_INFERENCE_CANNOT_CAPTURE_TYPES_RENDERER = TYPE_INFERENCE_CANNOT_CAPTURE_TYPES_RENDERER.1.INSTANCE$;
        CLASSES_OR_SEPARATED = CLASSES_OR_SEPARATED.1.INSTANCE$;
        RENDER_COLLECTION_OF_TYPES = RENDER_COLLECTION_OF_TYPES.1.INSTANCE$;
        RENDER_CONSTRAINT_SYSTEM = RENDER_CONSTRAINT_SYSTEM.1.INSTANCE$;
        RENDER_TYPE_BOUNDS = RENDER_TYPE_BOUNDS.1.INSTANCE$;
    }

    @NotNull
    public static final /* synthetic */ Logger getLOG$b$0(@JetValueParameter(name="$this", type="?") Renderers $this) {
        Renderers renderers = $this;
        return LOG;
    }

    @NotNull
    public static final /* synthetic */ String renderConstraintSystem$b$2(@JetValueParameter(name="$this", type="?") Renderers $this, @JetValueParameter(name="constraintSystem") @NotNull ConstraintSystem constraintSystem) {
        return $this.renderConstraintSystem(constraintSystem);
    }

    @NotNull
    public static final /* synthetic */ String renderTypeBounds$b$3(@JetValueParameter(name="$this", type="?") Renderers $this, @JetValueParameter(name="typeBounds") @NotNull TypeBounds typeBounds) {
        return $this.renderTypeBounds(typeBounds);
    }
}

