/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.load.java.components;

import com.intellij.openapi.diagnostic.Logger;
import javax.inject.Inject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.load.java.components.ErrorReporter;
import org.jetbrains.kotlin.load.kotlin.KotlinJvmBinaryClass;
import org.jetbrains.kotlin.load.kotlin.VirtualFileKotlinClass;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.OverrideResolver;
import org.jetbrains.kotlin.util.slicedMap.Slices;
import org.jetbrains.kotlin.util.slicedMap.WritableSlice;

public class TraceBasedErrorReporter
implements ErrorReporter {
    private static final Logger LOG = Logger.getInstance(TraceBasedErrorReporter.class);
    public static final WritableSlice<VirtualFileKotlinClass, Integer> ABI_VERSION_ERRORS = Slices.createCollectiveSlice();
    private BindingTrace trace;

    @Inject
    public void setTrace(BindingTrace trace) {
        this.trace = trace;
    }

    @Override
    public void reportIncompatibleAbiVersion(@NotNull KotlinJvmBinaryClass kotlinClass, int actualVersion) {
        if (kotlinClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kotlinClass", "org/jetbrains/kotlin/load/java/components/TraceBasedErrorReporter", "reportIncompatibleAbiVersion"));
        }
        this.trace.record(ABI_VERSION_ERRORS, (VirtualFileKotlinClass)kotlinClass, actualVersion);
    }

    @Override
    public void reportCannotInferVisibility(@NotNull CallableMemberDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/load/java/components/TraceBasedErrorReporter", "reportCannotInferVisibility"));
        }
        OverrideResolver.createCannotInferVisibilityReporter(this.trace).invoke(descriptor);
    }

    @Override
    public void reportLoadingError(@NotNull String message, @Nullable Exception exception) {
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "org/jetbrains/kotlin/load/java/components/TraceBasedErrorReporter", "reportLoadingError"));
        }
        LOG.error(message, exception);
    }
}

