/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.load.java.lazy;

import jet.runtime.typeinfo.JetValueParameter;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinSyntheticClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.load.java.lazy.GlobalJavaResolverContext;
import org.jetbrains.kotlin.load.java.lazy.JavaClassLookupResult;
import org.jetbrains.kotlin.load.java.lazy.LazyJavaResolverContext;
import org.jetbrains.kotlin.load.java.structure.JavaClass;
import org.jetbrains.kotlin.load.kotlin.KotlinJvmBinaryClass;
import org.jetbrains.kotlin.load.kotlin.header.KotlinClassHeader;
import org.jetbrains.kotlin.name.ClassId;

@KotlinSyntheticClass(abiVersion=19, kind=KotlinSyntheticClass.Kind.PACKAGE_PART)
public final class LazyPackage$resolvers$043543b4 {
    @Nullable
    public static final ClassDescriptor lookupBinaryClass(@JetValueParameter(name="$receiver") LazyJavaResolverContext $receiver, @JetValueParameter(name="javaClass") @NotNull JavaClass javaClass) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(javaClass, "javaClass");
        KotlinJvmBinaryClass kotlinJvmBinaryClass = ((GlobalJavaResolverContext)$receiver).getKotlinClassFinder().findKotlinClass(javaClass);
        JavaClassLookupResult javaClassLookupResult = LazyPackage$resolvers$043543b4.resolveBinaryClass($receiver, kotlinJvmBinaryClass);
        return javaClassLookupResult != null ? javaClassLookupResult.getkClass() : null;
    }

    @NotNull
    public static final JavaClassLookupResult findClassInJava(@JetValueParameter(name="$receiver") LazyJavaResolverContext $receiver, @JetValueParameter(name="classId") @NotNull ClassId classId) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(classId, "classId");
        KotlinJvmBinaryClass kotlinClass = ((GlobalJavaResolverContext)$receiver).getKotlinClassFinder().findKotlinClass(classId);
        JavaClassLookupResult binaryClassResult = LazyPackage$resolvers$043543b4.resolveBinaryClass($receiver, kotlinClass);
        if (binaryClassResult != null) {
            return binaryClassResult;
        }
        JavaClass javaClass = ((GlobalJavaResolverContext)$receiver).getFinder().findClass(classId);
        if (javaClass == null) {
            return new JavaClassLookupResult(null, null, 3);
        }
        if (Intrinsics.areEqual((Object)javaClass.getOriginKind(), (Object)JavaClass.OriginKind.KOTLIN_LIGHT_CLASS)) {
            return new JavaClassLookupResult(null, null, 3);
        }
        return new JavaClassLookupResult(javaClass, null, 2);
    }

    @Nullable
    public static final JavaClassLookupResult resolveBinaryClass(@JetValueParameter(name="$receiver") LazyJavaResolverContext $receiver, @JetValueParameter(name="kotlinClass", type="?") @Nullable KotlinJvmBinaryClass kotlinClass) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        if (kotlinClass == null) {
            return null;
        }
        KotlinClassHeader header = kotlinClass.getClassHeader();
        if (!header.getIsCompatibleAbiVersion()) {
            ((GlobalJavaResolverContext)$receiver).getErrorReporter().reportIncompatibleAbiVersion(kotlinClass, header.getVersion());
        } else if (Intrinsics.areEqual(header.getKind(), KotlinClassHeader.Kind.CLASS)) {
            ClassDescriptor descriptor = ((GlobalJavaResolverContext)$receiver).getDeserializedDescriptorResolver().resolveClass(kotlinClass);
            if (descriptor != null) {
                return new JavaClassLookupResult(null, descriptor, 1);
            }
        } else {
            return new JavaClassLookupResult(null, null, 3);
        }
        return null;
    }
}

