/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi;

import com.intellij.lang.ASTNode;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.JetNodeTypes;
import org.jetbrains.kotlin.lexer.JetTokens;
import org.jetbrains.kotlin.psi.JetBlockExpression;
import org.jetbrains.kotlin.psi.JetElement;
import org.jetbrains.kotlin.psi.JetExpressionImpl;
import org.jetbrains.kotlin.psi.JetFunctionLiteral;
import org.jetbrains.kotlin.psi.JetParameter;
import org.jetbrains.kotlin.psi.JetVisitor;

public class JetFunctionLiteralExpression
extends JetExpressionImpl {
    public JetFunctionLiteralExpression(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/kotlin/psi/JetFunctionLiteralExpression", "<init>"));
        }
        super(node);
    }

    @Override
    public <R, D> R accept(@NotNull JetVisitor<R, D> visitor, D data2) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/jetbrains/kotlin/psi/JetFunctionLiteralExpression", "accept"));
        }
        return visitor.visitFunctionLiteralExpression(this, data2);
    }

    @NotNull
    public JetFunctionLiteral getFunctionLiteral() {
        JetFunctionLiteral jetFunctionLiteral = (JetFunctionLiteral)this.findChildByType(JetNodeTypes.FUNCTION_LITERAL);
        if (jetFunctionLiteral == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/JetFunctionLiteralExpression", "getFunctionLiteral"));
        }
        return jetFunctionLiteral;
    }

    @NotNull
    public List<JetParameter> getValueParameters() {
        List<JetParameter> list = this.getFunctionLiteral().getValueParameters();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/JetFunctionLiteralExpression", "getValueParameters"));
        }
        return list;
    }

    public JetBlockExpression getBodyExpression() {
        return this.getFunctionLiteral().getBodyExpression();
    }

    public boolean hasBlockBody() {
        return this.getFunctionLiteral().hasBlockBody();
    }

    public boolean hasDeclaredReturnType() {
        return this.getFunctionLiteral().getTypeReference() != null;
    }

    @NotNull
    public JetElement asElement() {
        JetFunctionLiteralExpression jetFunctionLiteralExpression = this;
        if (jetFunctionLiteralExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/JetFunctionLiteralExpression", "asElement"));
        }
        return jetFunctionLiteralExpression;
    }

    @NotNull
    public ASTNode getLeftCurlyBrace() {
        ASTNode aSTNode = this.getFunctionLiteral().getNode().findChildByType(JetTokens.LBRACE);
        if (aSTNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/JetFunctionLiteralExpression", "getLeftCurlyBrace"));
        }
        return aSTNode;
    }

    @Nullable
    public ASTNode getRightCurlyBrace() {
        return this.getFunctionLiteral().getNode().findChildByType(JetTokens.RBRACE);
    }
}

