/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import kotlin.Function1;
import kotlin.KotlinPackage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptorWithResolutionScopes;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.JetElement;
import org.jetbrains.kotlin.psi.JetFile;
import org.jetbrains.kotlin.psi.JetNamedDeclaration;
import org.jetbrains.kotlin.psi.JetPackageDirective;
import org.jetbrains.kotlin.resolve.AnnotationResolver;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.TopDownAnalysisContext;
import org.jetbrains.kotlin.resolve.lazy.FileScopeProvider;
import org.jetbrains.kotlin.resolve.lazy.TopLevelDescriptorProvider;
import org.jetbrains.kotlin.resolve.lazy.descriptors.LazyPackageDescriptor;
import org.jetbrains.kotlin.resolve.scopes.JetScope;
import org.jetbrains.kotlin.utils.UtilsPackage;

public class DeclarationResolver {
    private AnnotationResolver annotationResolver;
    private BindingTrace trace;

    @Inject
    public void setAnnotationResolver(@NotNull AnnotationResolver annotationResolver) {
        if (annotationResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotationResolver", "org/jetbrains/kotlin/resolve/DeclarationResolver", "setAnnotationResolver"));
        }
        this.annotationResolver = annotationResolver;
    }

    @Inject
    public void setTrace(@NotNull BindingTrace trace) {
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/DeclarationResolver", "setTrace"));
        }
        this.trace = trace;
    }

    public void resolveAnnotationsOnFiles(@NotNull TopDownAnalysisContext c, final @NotNull FileScopeProvider scopeProvider) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "org/jetbrains/kotlin/resolve/DeclarationResolver", "resolveAnnotationsOnFiles"));
        }
        if (scopeProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scopeProvider", "org/jetbrains/kotlin/resolve/DeclarationResolver", "resolveAnnotationsOnFiles"));
        }
        Map<JetFile, JetScope> file2scope = UtilsPackage.keysToMap(c.getFiles(), new Function1<JetFile, JetScope>(){

            @Override
            public JetScope invoke(JetFile file) {
                return scopeProvider.getFileScope(file);
            }
        });
        this.resolveAnnotationsOnFiles(file2scope);
    }

    private void resolveAnnotationsOnFiles(@NotNull Map<JetFile, ? extends JetScope> file2scope) {
        if (file2scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file2scope", "org/jetbrains/kotlin/resolve/DeclarationResolver", "resolveAnnotationsOnFiles"));
        }
        for (Map.Entry<JetFile, ? extends JetScope> entry : file2scope.entrySet()) {
            JetFile file = entry.getKey();
            JetScope fileScope = entry.getValue();
            this.annotationResolver.resolveAnnotationsWithArguments(fileScope, file.getAnnotationEntries(), this.trace);
            this.annotationResolver.resolveAnnotationsWithArguments(fileScope, file.getDanglingAnnotations(), this.trace);
        }
    }

    @NotNull
    public static ConstructorDescriptor getConstructorOfDataClass(@NotNull ClassDescriptor classDescriptor) {
        if (classDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classDescriptor", "org/jetbrains/kotlin/resolve/DeclarationResolver", "getConstructorOfDataClass"));
        }
        Collection<ConstructorDescriptor> constructors2 = classDescriptor.getConstructors();
        assert (constructors2.size() == 1) : "Data class must have only one constructor: " + classDescriptor.getConstructors();
        ConstructorDescriptor constructorDescriptor = constructors2.iterator().next();
        if (constructorDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/DeclarationResolver", "getConstructorOfDataClass"));
        }
        return constructorDescriptor;
    }

    public void checkRedeclarationsInInnerClassNames(@NotNull TopDownAnalysisContext c) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "org/jetbrains/kotlin/resolve/DeclarationResolver", "checkRedeclarationsInInnerClassNames"));
        }
        for (ClassDescriptorWithResolutionScopes classDescriptor : c.getDeclaredClasses().values()) {
            Collection<DeclarationDescriptor> classObjDescriptors;
            if (classDescriptor.getKind() == ClassKind.CLASS_OBJECT) continue;
            Collection<DeclarationDescriptor> allDescriptors2 = classDescriptor.getScopeForMemberLookup().getOwnDeclaredDescriptors();
            ClassDescriptorWithResolutionScopes classObj = classDescriptor.getClassObjectDescriptor();
            if (classObj != null && !(classObjDescriptors = classObj.getScopeForMemberLookup().getOwnDeclaredDescriptors()).isEmpty()) {
                allDescriptors2 = Lists.newArrayList(allDescriptors2);
                allDescriptors2.addAll(classObjDescriptors);
            }
            HashMultimap<Name, DeclarationDescriptor> descriptorMap = HashMultimap.create();
            for (DeclarationDescriptor desc : allDescriptors2) {
                if (!(desc instanceof ClassDescriptor) && !(desc instanceof PropertyDescriptor)) continue;
                descriptorMap.put(desc.getName(), desc);
            }
            this.reportRedeclarations(descriptorMap);
        }
    }

    private void reportRedeclarations(@NotNull Multimap<Name, DeclarationDescriptor> descriptorMap) {
        if (descriptorMap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptorMap", "org/jetbrains/kotlin/resolve/DeclarationResolver", "reportRedeclarations"));
        }
        HashSet<Pair<PsiElement, Name>> redeclarations = Sets.newHashSet();
        for (Name name : descriptorMap.keySet()) {
            Collection<DeclarationDescriptor> descriptors = descriptorMap.get(name);
            if (descriptors.size() <= 1) continue;
            for (DeclarationDescriptor descriptor : descriptors) {
                if (!(descriptor instanceof ClassDescriptor)) continue;
                for (DeclarationDescriptor descriptor2 : descriptors) {
                    if (descriptor == descriptor2) continue;
                    redeclarations.add(Pair.create(DescriptorToSourceUtils.classDescriptorToDeclaration((ClassDescriptor)descriptor), descriptor.getName()));
                    if (!(descriptor2 instanceof PropertyDescriptor)) continue;
                    redeclarations.add(Pair.create(DescriptorToSourceUtils.descriptorToDeclaration(descriptor2), descriptor2.getName()));
                }
            }
        }
        for (Pair pair : redeclarations) {
            this.trace.report(Errors.REDECLARATION.on((PsiElement)pair.getFirst(), ((Name)pair.getSecond()).asString()));
        }
    }

    public void checkRedeclarationsInPackages(@NotNull TopLevelDescriptorProvider topLevelDescriptorProvider, @NotNull Multimap<FqName, JetElement> topLevelFqNames) {
        if (topLevelDescriptorProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "topLevelDescriptorProvider", "org/jetbrains/kotlin/resolve/DeclarationResolver", "checkRedeclarationsInPackages"));
        }
        if (topLevelFqNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "topLevelFqNames", "org/jetbrains/kotlin/resolve/DeclarationResolver", "checkRedeclarationsInPackages"));
        }
        for (Map.Entry<FqName, Collection<JetElement>> entry : topLevelFqNames.asMap().entrySet()) {
            Set<DeclarationDescriptor> descriptors;
            FqName fqName2 = entry.getKey();
            Collection<JetElement> declarationsOrPackageDirectives = entry.getValue();
            if (fqName2.isRoot() || (descriptors = DeclarationResolver.getTopLevelDescriptorsByFqName(topLevelDescriptorProvider, fqName2)).size() <= 1) continue;
            for (JetElement declarationOrPackageDirective : declarationsOrPackageDirectives) {
                JetElement reportAt = declarationOrPackageDirective instanceof JetNamedDeclaration ? declarationOrPackageDirective : ((JetPackageDirective)declarationOrPackageDirective).getNameIdentifier();
                this.trace.report(Errors.REDECLARATION.on(reportAt, fqName2.shortName().asString()));
            }
        }
    }

    @NotNull
    private static Set<DeclarationDescriptor> getTopLevelDescriptorsByFqName(@NotNull TopLevelDescriptorProvider topLevelDescriptorProvider, @NotNull FqName fqName2) {
        if (topLevelDescriptorProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "topLevelDescriptorProvider", "org/jetbrains/kotlin/resolve/DeclarationResolver", "getTopLevelDescriptorsByFqName"));
        }
        if (fqName2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqName", "org/jetbrains/kotlin/resolve/DeclarationResolver", "getTopLevelDescriptorsByFqName"));
        }
        FqName parentFqName = fqName2.parent();
        HashSet<DeclarationDescriptor> descriptors = new HashSet<DeclarationDescriptor>();
        LazyPackageDescriptor parentFragment = topLevelDescriptorProvider.getPackageFragment(parentFqName);
        if (parentFragment != null) {
            descriptors.addAll(KotlinPackage.filter(parentFragment.getMemberScope().getProperties(fqName2.shortName()), new Function1<VariableDescriptor, Boolean>(){

                @Override
                public Boolean invoke(VariableDescriptor descriptor) {
                    return descriptor.getExtensionReceiverParameter() == null;
                }
            }));
        }
        ContainerUtil.addIfNotNull(descriptors, topLevelDescriptorProvider.getPackageFragment(fqName2));
        descriptors.addAll(topLevelDescriptorProvider.getTopLevelClassDescriptors(fqName2));
        HashSet<DeclarationDescriptor> hashSet = descriptors;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/DeclarationResolver", "getTopLevelDescriptorsByFqName"));
        }
        return hashSet;
    }
}

