/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import com.google.common.collect.Lists;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorWithSource;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.psi.JetFile;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.source.SourcePackage;

public final class DescriptorToSourceUtils {
    @Nullable
    private static PsiElement doGetDescriptorToDeclaration(@NotNull DeclarationDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/resolve/DescriptorToSourceUtils", "doGetDescriptorToDeclaration"));
        }
        DeclarationDescriptor original = descriptor.getOriginal();
        if (!(original instanceof DeclarationDescriptorWithSource)) {
            return null;
        }
        return SourcePackage.getPsi(((DeclarationDescriptorWithSource)original).getSource());
    }

    @Nullable
    public static PsiElement descriptorToDeclaration(@NotNull DeclarationDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/resolve/DescriptorToSourceUtils", "descriptorToDeclaration"));
        }
        if (descriptor instanceof CallableMemberDescriptor) {
            return DescriptorToSourceUtils.callableDescriptorToDeclaration((CallableMemberDescriptor)descriptor);
        }
        if (descriptor instanceof ClassDescriptor) {
            return DescriptorToSourceUtils.classDescriptorToDeclaration((ClassDescriptor)descriptor);
        }
        return DescriptorToSourceUtils.doGetDescriptorToDeclaration(descriptor);
    }

    @NotNull
    public static List<PsiElement> descriptorToDeclarations(@NotNull DeclarationDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/resolve/DescriptorToSourceUtils", "descriptorToDeclarations"));
        }
        if (descriptor instanceof CallableMemberDescriptor) {
            List<PsiElement> list = DescriptorToSourceUtils.callableDescriptorToDeclarations((CallableMemberDescriptor)descriptor);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/DescriptorToSourceUtils", "descriptorToDeclarations"));
            }
            return list;
        }
        PsiElement psiElement = DescriptorToSourceUtils.descriptorToDeclaration(descriptor);
        if (psiElement != null) {
            ArrayList<PsiElement> arrayList = Lists.newArrayList(psiElement);
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/DescriptorToSourceUtils", "descriptorToDeclarations"));
            }
            return arrayList;
        }
        ArrayList<PsiElement> arrayList = Lists.newArrayList();
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/DescriptorToSourceUtils", "descriptorToDeclarations"));
        }
        return arrayList;
    }

    @Nullable
    public static PsiElement callableDescriptorToDeclaration(@NotNull CallableMemberDescriptor callable2) {
        if (callable2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callable", "org/jetbrains/kotlin/resolve/DescriptorToSourceUtils", "callableDescriptorToDeclaration"));
        }
        if (callable2.getKind() == CallableMemberDescriptor.Kind.DECLARATION || callable2.getKind() == CallableMemberDescriptor.Kind.SYNTHESIZED) {
            return DescriptorToSourceUtils.doGetDescriptorToDeclaration(callable2);
        }
        Set<? extends CallableMemberDescriptor> overriddenDescriptors = callable2.getOverriddenDescriptors();
        if (overriddenDescriptors.size() == 1) {
            return DescriptorToSourceUtils.callableDescriptorToDeclaration(overriddenDescriptors.iterator().next());
        }
        return null;
    }

    @NotNull
    public static List<PsiElement> callableDescriptorToDeclarations(@NotNull CallableMemberDescriptor callable2) {
        if (callable2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callable", "org/jetbrains/kotlin/resolve/DescriptorToSourceUtils", "callableDescriptorToDeclarations"));
        }
        if (callable2.getKind() == CallableMemberDescriptor.Kind.DECLARATION || callable2.getKind() == CallableMemberDescriptor.Kind.SYNTHESIZED) {
            PsiElement psiElement = DescriptorToSourceUtils.doGetDescriptorToDeclaration(callable2);
            ArrayList<PsiElement> arrayList = psiElement != null ? Lists.newArrayList(psiElement) : Lists.newArrayList();
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/DescriptorToSourceUtils", "callableDescriptorToDeclarations"));
            }
            return arrayList;
        }
        ArrayList<PsiElement> r = new ArrayList<PsiElement>();
        Set<? extends CallableMemberDescriptor> overriddenDescriptors = callable2.getOverriddenDescriptors();
        for (CallableMemberDescriptor callableMemberDescriptor : overriddenDescriptors) {
            r.addAll(DescriptorToSourceUtils.callableDescriptorToDeclarations(callableMemberDescriptor));
        }
        ArrayList<PsiElement> arrayList = r;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/DescriptorToSourceUtils", "callableDescriptorToDeclarations"));
        }
        return arrayList;
    }

    @Nullable
    public static PsiElement classDescriptorToDeclaration(@NotNull ClassDescriptor clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "org/jetbrains/kotlin/resolve/DescriptorToSourceUtils", "classDescriptorToDeclaration"));
        }
        return DescriptorToSourceUtils.doGetDescriptorToDeclaration(clazz);
    }

    private DescriptorToSourceUtils() {
    }

    @Nullable
    public static JetFile getContainingFile(@NotNull DeclarationDescriptor declarationDescriptor) {
        if (declarationDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declarationDescriptor", "org/jetbrains/kotlin/resolve/DescriptorToSourceUtils", "getContainingFile"));
        }
        DeclarationDescriptor descriptor = DescriptorToSourceUtils.findTopLevelParent(declarationDescriptor);
        if (descriptor == null) {
            return null;
        }
        PsiElement declaration = DescriptorToSourceUtils.descriptorToDeclaration(descriptor);
        if (declaration == null) {
            return null;
        }
        PsiFile containingFile = declaration.getContainingFile();
        if (!(containingFile instanceof JetFile)) {
            return null;
        }
        return (JetFile)containingFile;
    }

    @Nullable
    private static DeclarationDescriptor findTopLevelParent(@NotNull DeclarationDescriptor declarationDescriptor) {
        if (declarationDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declarationDescriptor", "org/jetbrains/kotlin/resolve/DescriptorToSourceUtils", "findTopLevelParent"));
        }
        DeclarationDescriptor descriptor = declarationDescriptor;
        if (declarationDescriptor instanceof PropertyAccessorDescriptor) {
            descriptor = ((PropertyAccessorDescriptor)descriptor).getCorrespondingProperty();
        }
        while (descriptor != null && !DescriptorUtils.isTopLevelDeclaration(descriptor)) {
            descriptor = descriptor.getContainingDeclaration();
        }
        return descriptor;
    }
}

