/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import com.intellij.openapi.util.Key;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ScriptDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.impl.MutablePackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.impl.ScriptDescriptorImpl;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.JetFile;
import org.jetbrains.kotlin.psi.JetScript;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.MutablePackageFragmentProvider;
import org.jetbrains.kotlin.resolve.ScriptNameUtil;
import org.jetbrains.kotlin.resolve.ScriptParameterResolver;
import org.jetbrains.kotlin.resolve.TopDownAnalysisContext;
import org.jetbrains.kotlin.resolve.scopes.RedeclarationHandler;
import org.jetbrains.kotlin.resolve.scopes.WritableScope;
import org.jetbrains.kotlin.resolve.scopes.WritableScopeImpl;
import org.jetbrains.kotlin.resolve.source.SourcePackage;

public class ScriptHeaderResolver {
    public static final Key<Integer> PRIORITY_KEY = Key.create(JetScript.class.getName() + ".priority");
    @NotNull
    private MutablePackageFragmentProvider packageFragmentProvider;
    @NotNull
    private BindingTrace trace;

    @Inject
    public void setPackageFragmentProvider(@NotNull MutablePackageFragmentProvider packageFragmentProvider) {
        if (packageFragmentProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageFragmentProvider", "org/jetbrains/kotlin/resolve/ScriptHeaderResolver", "setPackageFragmentProvider"));
        }
        this.packageFragmentProvider = packageFragmentProvider;
    }

    @Inject
    public void setTrace(@NotNull BindingTrace trace) {
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/ScriptHeaderResolver", "setTrace"));
        }
        this.trace = trace;
    }

    public void processScriptHierarchy(@NotNull TopDownAnalysisContext c, @NotNull JetScript script, @NotNull WritableScope outerScope) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "org/jetbrains/kotlin/resolve/ScriptHeaderResolver", "processScriptHierarchy"));
        }
        if (script == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "script", "org/jetbrains/kotlin/resolve/ScriptHeaderResolver", "processScriptHierarchy"));
        }
        if (outerScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outerScope", "org/jetbrains/kotlin/resolve/ScriptHeaderResolver", "processScriptHierarchy"));
        }
        JetFile file = script.getContainingJetFile();
        FqName fqName2 = file.getPackageFqName();
        MutablePackageFragmentDescriptor ns = this.packageFragmentProvider.getOrCreateFragment(fqName2);
        Integer priority = ScriptHeaderResolver.getScriptPriority(script);
        FqName nameForScript = ScriptNameUtil.classNameForScript(script);
        Name className = nameForScript.shortName();
        ScriptDescriptorImpl scriptDescriptor = new ScriptDescriptorImpl(ns, priority, outerScope, className, SourcePackage.toSourceElement(script));
        WritableScopeImpl scriptScope = new WritableScopeImpl(outerScope, scriptDescriptor, RedeclarationHandler.DO_NOTHING, "script");
        scriptScope.changeLockLevel(WritableScope.LockLevel.BOTH);
        scriptDescriptor.setScopeForBodyResolution(scriptScope);
        c.getScripts().put(script, scriptDescriptor);
        this.trace.record(BindingContext.SCRIPT, script, scriptDescriptor);
        outerScope.addClassifierDescriptor(scriptDescriptor.getClassDescriptor());
    }

    public static int getScriptPriority(@NotNull JetScript script) {
        if (script == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "script", "org/jetbrains/kotlin/resolve/ScriptHeaderResolver", "getScriptPriority"));
        }
        Integer priority = script.getUserData(PRIORITY_KEY);
        return priority == null ? 0 : priority;
    }

    public static void resolveScriptDeclarations(@NotNull TopDownAnalysisContext c) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "org/jetbrains/kotlin/resolve/ScriptHeaderResolver", "resolveScriptDeclarations"));
        }
        for (Map.Entry<JetScript, ScriptDescriptor> e : c.getScripts().entrySet()) {
            JetScript declaration = e.getKey();
            ScriptDescriptorImpl descriptor = (ScriptDescriptorImpl)e.getValue();
            List<ValueParameterDescriptor> valueParameters = ScriptParameterResolver.resolveScriptParameters(declaration, descriptor);
            descriptor.setValueParameters(valueParameters);
            WritableScope scope2 = descriptor.getScopeForBodyResolution();
            scope2.setImplicitReceiver(descriptor.getThisAsReceiverParameter());
            for (ValueParameterDescriptor valueParameterDescriptor : valueParameters) {
                scope2.addVariableDescriptor(valueParameterDescriptor);
            }
        }
    }
}

