/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.serialization.deserialization;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.FqNameUnsafe;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.serialization.ProtoBuf;

public class NameResolver {
    private final ProtoBuf.StringTable strings;
    private final ProtoBuf.QualifiedNameTable qualifiedNames;

    public NameResolver(@NotNull ProtoBuf.StringTable strings2, @NotNull ProtoBuf.QualifiedNameTable qualifiedNames) {
        if (strings2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "strings", "org/jetbrains/kotlin/serialization/deserialization/NameResolver", "<init>"));
        }
        if (qualifiedNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedNames", "org/jetbrains/kotlin/serialization/deserialization/NameResolver", "<init>"));
        }
        this.strings = strings2;
        this.qualifiedNames = qualifiedNames;
    }

    @NotNull
    public ProtoBuf.StringTable getStringTable() {
        ProtoBuf.StringTable stringTable = this.strings;
        if (stringTable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/serialization/deserialization/NameResolver", "getStringTable"));
        }
        return stringTable;
    }

    @NotNull
    public ProtoBuf.QualifiedNameTable getQualifiedNameTable() {
        ProtoBuf.QualifiedNameTable qualifiedNameTable = this.qualifiedNames;
        if (qualifiedNameTable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/serialization/deserialization/NameResolver", "getQualifiedNameTable"));
        }
        return qualifiedNameTable;
    }

    @NotNull
    public String getString(int index2) {
        String string = this.strings.getString(index2);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/serialization/deserialization/NameResolver", "getString"));
        }
        return string;
    }

    @NotNull
    public Name getName(int index2) {
        String name = this.strings.getString(index2);
        Name name2 = Name.guess(name);
        if (name2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/serialization/deserialization/NameResolver", "getName"));
        }
        return name2;
    }

    @NotNull
    public ClassId getClassId(int index2) {
        FqName packageFqName;
        ProtoBuf.QualifiedNameTable.QualifiedName fqNameProto = this.qualifiedNames.getQualifiedName(index2);
        assert (fqNameProto.getKind() == ProtoBuf.QualifiedNameTable.QualifiedName.Kind.CLASS) : "Not a class fqName: " + fqNameProto.getKind();
        StringBuilder relativeClassName = new StringBuilder();
        ProtoBuf.QualifiedNameTable.QualifiedName packageFqNameProto = this.renderFqName(relativeClassName, fqNameProto, ProtoBuf.QualifiedNameTable.QualifiedName.Kind.CLASS);
        if (packageFqNameProto != null) {
            StringBuilder sb = new StringBuilder();
            ProtoBuf.QualifiedNameTable.QualifiedName mustBeNull = this.renderFqName(sb, packageFqNameProto, ProtoBuf.QualifiedNameTable.QualifiedName.Kind.PACKAGE);
            assert (mustBeNull == null) : "Prefix of an fqName must be all of kind PACKAGE";
            packageFqName = new FqName(sb.toString());
        } else {
            packageFqName = FqName.ROOT;
        }
        ClassId classId = new ClassId(packageFqName, new FqNameUnsafe(relativeClassName.toString()));
        if (classId == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/serialization/deserialization/NameResolver", "getClassId"));
        }
        return classId;
    }

    @Nullable
    private ProtoBuf.QualifiedNameTable.QualifiedName renderFqName(StringBuilder sb, ProtoBuf.QualifiedNameTable.QualifiedName fqNameProto, ProtoBuf.QualifiedNameTable.QualifiedName.Kind kind) {
        ProtoBuf.QualifiedNameTable.QualifiedName result2 = null;
        if (fqNameProto.hasParentQualifiedName()) {
            ProtoBuf.QualifiedNameTable.QualifiedName parentProto = this.qualifiedNames.getQualifiedName(fqNameProto.getParentQualifiedName());
            if (kind == null || parentProto.getKind() == kind) {
                result2 = this.renderFqName(sb, parentProto, kind);
                sb.append(".");
            } else {
                result2 = parentProto;
            }
        }
        sb.append(this.strings.getString(fqNameProto.getShortName()));
        return result2;
    }

    @NotNull
    public FqName getFqName(int index2) {
        ProtoBuf.QualifiedNameTable.QualifiedName qualifiedName = this.qualifiedNames.getQualifiedName(index2);
        Name shortName = this.getName(qualifiedName.getShortName());
        if (!qualifiedName.hasParentQualifiedName()) {
            FqName fqName2 = FqName.topLevel(shortName);
            if (fqName2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/serialization/deserialization/NameResolver", "getFqName"));
            }
            return fqName2;
        }
        FqName fqName3 = this.getFqName(qualifiedName.getParentQualifiedName()).child(shortName);
        if (fqName3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/serialization/deserialization/NameResolver", "getFqName"));
        }
        return fqName3;
    }
}

