/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.utils;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import java.io.File;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.java.impl.JavaSdkUtil;
import org.jetbrains.kotlin.utils.KotlinPaths;
import org.jetbrains.kotlin.utils.KotlinPathsFromHomeDir;

public class PathUtil {
    public static final String JPS_KOTLIN_HOME_PROPERTY = "jps.kotlin.home";
    public static final String JS_LIB_JAR_NAME = "kotlin-jslib.jar";
    public static final String JS_LIB_SRC_JAR_NAME = "kotlin-jslib-sources.jar";
    public static final String JDK_ANNOTATIONS_JAR = "kotlin-jdk-annotations.jar";
    public static final String ANDROID_SDK_ANNOTATIONS_JAR = "kotlin-android-sdk-annotations.jar";
    public static final String KOTLIN_JAVA_RUNTIME_JAR = "kotlin-runtime.jar";
    public static final String KOTLIN_JAVA_RUNTIME_SRC_JAR = "kotlin-runtime-sources.jar";
    public static final String HOME_FOLDER_NAME = "kotlinc";
    private static final File NO_PATH = new File("<no_path>");

    private PathUtil() {
    }

    @NotNull
    public static KotlinPaths getKotlinPathsForIdeaPlugin() {
        KotlinPaths kotlinPaths = ApplicationManager.getApplication().isUnitTestMode() ? PathUtil.getKotlinPathsForDistDirectory() : new KotlinPathsFromHomeDir(PathUtil.getCompilerPathForIdeaPlugin());
        if (kotlinPaths == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/utils/PathUtil", "getKotlinPathsForIdeaPlugin"));
        }
        return kotlinPaths;
    }

    @NotNull
    public static KotlinPaths getKotlinPathsForJpsPlugin() {
        String jpsKotlinHome = System.getProperty(JPS_KOTLIN_HOME_PROPERTY);
        if (jpsKotlinHome != null) {
            KotlinPathsFromHomeDir kotlinPathsFromHomeDir = new KotlinPathsFromHomeDir(new File(jpsKotlinHome));
            if (kotlinPathsFromHomeDir == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/utils/PathUtil", "getKotlinPathsForJpsPlugin"));
            }
            return kotlinPathsFromHomeDir;
        }
        KotlinPathsFromHomeDir kotlinPathsFromHomeDir = new KotlinPathsFromHomeDir(PathUtil.getCompilerPathForJpsPlugin());
        if (kotlinPathsFromHomeDir == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/utils/PathUtil", "getKotlinPathsForJpsPlugin"));
        }
        return kotlinPathsFromHomeDir;
    }

    @NotNull
    public static KotlinPaths getKotlinPathsForJpsPluginOrJpsTests() {
        if ("true".equalsIgnoreCase(System.getProperty("kotlin.jps.tests"))) {
            KotlinPaths kotlinPaths = PathUtil.getKotlinPathsForDistDirectory();
            if (kotlinPaths == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/utils/PathUtil", "getKotlinPathsForJpsPluginOrJpsTests"));
            }
            return kotlinPaths;
        }
        KotlinPaths kotlinPaths = PathUtil.getKotlinPathsForJpsPlugin();
        if (kotlinPaths == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/utils/PathUtil", "getKotlinPathsForJpsPluginOrJpsTests"));
        }
        return kotlinPaths;
    }

    @NotNull
    public static KotlinPaths getKotlinPathsForCompiler() {
        if (!PathUtil.getPathUtilJar().isFile()) {
            KotlinPaths kotlinPaths = PathUtil.getKotlinPathsForDistDirectory();
            if (kotlinPaths == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/utils/PathUtil", "getKotlinPathsForCompiler"));
            }
            return kotlinPaths;
        }
        KotlinPathsFromHomeDir kotlinPathsFromHomeDir = new KotlinPathsFromHomeDir(PathUtil.getCompilerPathForCompilerJar());
        if (kotlinPathsFromHomeDir == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/utils/PathUtil", "getKotlinPathsForCompiler"));
        }
        return kotlinPathsFromHomeDir;
    }

    @NotNull
    public static KotlinPaths getKotlinPathsForDistDirectory() {
        KotlinPathsFromHomeDir kotlinPathsFromHomeDir = new KotlinPathsFromHomeDir(new File("dist", HOME_FOLDER_NAME));
        if (kotlinPathsFromHomeDir == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/utils/PathUtil", "getKotlinPathsForDistDirectory"));
        }
        return kotlinPathsFromHomeDir;
    }

    @NotNull
    private static File getCompilerPathForCompilerJar() {
        File jar = PathUtil.getPathUtilJar();
        if (!jar.exists()) {
            File file = NO_PATH;
            if (file == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/utils/PathUtil", "getCompilerPathForCompilerJar"));
            }
            return file;
        }
        if (jar.getName().equals("kotlin-compiler.jar")) {
            File lib = jar.getParentFile();
            File file = lib.getParentFile();
            if (file == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/utils/PathUtil", "getCompilerPathForCompilerJar"));
            }
            return file;
        }
        File file = NO_PATH;
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/utils/PathUtil", "getCompilerPathForCompilerJar"));
        }
        return file;
    }

    @NotNull
    private static File getCompilerPathForJpsPlugin() {
        File jar = PathUtil.getPathUtilJar();
        if (!jar.exists()) {
            File file = NO_PATH;
            if (file == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/utils/PathUtil", "getCompilerPathForJpsPlugin"));
            }
            return file;
        }
        if (jar.getName().equals("kotlin-jps-plugin.jar")) {
            File pluginHome = jar.getParentFile().getParentFile().getParentFile();
            File file = new File(pluginHome, HOME_FOLDER_NAME);
            if (file == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/utils/PathUtil", "getCompilerPathForJpsPlugin"));
            }
            return file;
        }
        File file = NO_PATH;
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/utils/PathUtil", "getCompilerPathForJpsPlugin"));
        }
        return file;
    }

    @NotNull
    private static File getCompilerPathForIdeaPlugin() {
        File jar = PathUtil.getPathUtilJar();
        if (!jar.exists()) {
            File file = NO_PATH;
            if (file == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/utils/PathUtil", "getCompilerPathForIdeaPlugin"));
            }
            return file;
        }
        if (jar.getName().equals("kotlin-plugin.jar")) {
            File lib = jar.getParentFile();
            File pluginHome = lib.getParentFile();
            File file = new File(pluginHome, HOME_FOLDER_NAME);
            if (file == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/utils/PathUtil", "getCompilerPathForIdeaPlugin"));
            }
            return file;
        }
        File file = NO_PATH;
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/utils/PathUtil", "getCompilerPathForIdeaPlugin"));
        }
        return file;
    }

    @NotNull
    public static File getPathUtilJar() {
        File file = PathUtil.getResourcePathForClass(PathUtil.class);
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/utils/PathUtil", "getPathUtilJar"));
        }
        return file;
    }

    @NotNull
    public static File getResourcePathForClass(@NotNull Class aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "org/jetbrains/kotlin/utils/PathUtil", "getResourcePathForClass"));
        }
        String resourceRoot = PathManager.getResourceRoot(aClass, "/" + aClass.getName().replace('.', '/') + ".class");
        File file = new File(resourceRoot).getAbsoluteFile();
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/utils/PathUtil", "getResourcePathForClass"));
        }
        return file;
    }

    @NotNull
    public static VirtualFile jarFileOrDirectoryToVirtualFile(@NotNull File file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/utils/PathUtil", "jarFileOrDirectoryToVirtualFile"));
        }
        if (file.exists()) {
            if (file.isDirectory()) {
                VirtualFile virtualFile = VirtualFileManager.getInstance().findFileByUrl("file://" + FileUtil.toSystemIndependentName(file.getAbsolutePath()));
                if (virtualFile == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/utils/PathUtil", "jarFileOrDirectoryToVirtualFile"));
                }
                return virtualFile;
            }
            VirtualFile virtualFile = VirtualFileManager.getInstance().findFileByUrl("jar://" + FileUtil.toSystemIndependentName(file.getAbsolutePath()) + "!/");
            if (virtualFile == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/utils/PathUtil", "jarFileOrDirectoryToVirtualFile"));
            }
            return virtualFile;
        }
        throw new IllegalStateException("Path " + file + " does not exist.");
    }

    @NotNull
    public static List<File> getJdkClassesRoots() {
        List<File> list = JavaSdkUtil.getJdkClassesRoots(new File(System.getProperty("java.home")), true);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/utils/PathUtil", "getJdkClassesRoots"));
        }
        return list;
    }
}

