/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.compiler.backend.js.ast;

import com.google.dart.compiler.backend.js.ast.JsBlock;
import com.google.dart.compiler.backend.js.ast.JsContext;
import com.google.dart.compiler.backend.js.ast.JsExpression;
import com.google.dart.compiler.backend.js.ast.JsNode;
import com.google.dart.compiler.backend.js.ast.JsStatement;
import com.google.dart.compiler.backend.js.ast.JsVisitorWithContext;
import com.intellij.util.SmartList;
import java.util.List;
import java.util.Stack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsVisitorWithContextImpl
extends JsVisitorWithContext {
    private final Stack<JsContext> statementContexts = new Stack();

    protected static void checkReplacement(JsNode origNode, JsNode newNode) {
        if (newNode == null) {
            throw new RuntimeException("Cannot replace with null");
        }
    }

    @Override
    protected <T extends JsNode> T doAccept(T node2) {
        return new NodeContext<T>().traverse(node2);
    }

    @Override
    protected JsExpression doAcceptLvalue(JsExpression expr) {
        return new LvalueContext().traverse(expr);
    }

    @Override
    protected <T extends JsStatement> JsStatement doAcceptStatement(T statement) {
        SmartList<JsStatement> statements = new SmartList<JsStatement>(statement);
        this.doAcceptStatementList(statements);
        if (statements.size() == 1) {
            return (JsStatement)statements.get(0);
        }
        return new JsBlock(statements);
    }

    @Override
    protected <T extends JsStatement> void doAcceptStatementList(List<T> statements) {
        ListContext<T> context2 = new ListContext<T>();
        this.statementContexts.push(context2);
        context2.traverse(statements);
        this.statementContexts.pop();
    }

    @Override
    protected <T extends JsNode> void doAcceptList(List<T> collection) {
        new ListContext<T>().traverse(collection);
    }

    @NotNull
    protected JsContext getLastStatementLevelContext() {
        JsContext jsContext = this.statementContexts.peek();
        if (jsContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/google/dart/compiler/backend/js/ast/JsVisitorWithContextImpl", "getLastStatementLevelContext"));
        }
        return jsContext;
    }

    @Override
    protected <T extends JsNode> void doTraverse(T node2, JsContext ctx) {
        node2.traverse(this, ctx);
    }

    private class NodeContext<T extends JsNode>
    implements JsContext {
        protected T node;

        private NodeContext() {
        }

        @Override
        public void insertAfter(JsNode node2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void insertBefore(JsNode node2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void removeMe() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void replaceMe(JsNode node2) {
            JsVisitorWithContextImpl.checkReplacement(this.node, node2);
            this.node = node2;
        }

        @Override
        @Nullable
        public JsNode getCurrentNode() {
            return this.node;
        }

        protected T traverse(T node2) {
            this.node = node2;
            JsVisitorWithContextImpl.this.doTraverse(node2, this);
            return this.node;
        }
    }

    private class LvalueContext
    extends NodeContext<JsExpression> {
        private LvalueContext() {
        }
    }

    public class ListContext<T extends JsNode>
    implements JsContext {
        private List<T> collection;
        private int index;

        @Override
        public void insertAfter(JsNode node2) {
            this.collection.add(this.index + 1, node2);
        }

        @Override
        public void insertBefore(JsNode node2) {
            this.collection.add(this.index++, node2);
        }

        @Override
        public void removeMe() {
            this.collection.remove(this.index--);
        }

        @Override
        public void replaceMe(JsNode node2) {
            JsVisitorWithContextImpl.checkReplacement((JsNode)this.collection.get(this.index), node2);
            this.collection.set(this.index, node2);
        }

        @Override
        @Nullable
        public JsNode getCurrentNode() {
            if (this.index < this.collection.size()) {
                return (JsNode)this.collection.get(this.index);
            }
            return null;
        }

        protected void traverse(List<T> collection) {
            this.collection = collection;
            this.index = 0;
            while (this.index < collection.size()) {
                JsNode node2 = (JsNode)collection.get(this.index);
                JsVisitorWithContextImpl.this.doTraverse(node2, this);
                ++this.index;
            }
        }
    }
}

