/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnnotationOwner;
import com.intellij.psi.PsiArrayInitializerMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiPackageStatement;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AnnotationTargetUtil {
    public static final Set<PsiAnnotation.TargetType> DEFAULT_TARGETS = Collections.unmodifiableSet(ContainerUtil.newHashSet(PsiAnnotation.TargetType.PACKAGE, PsiAnnotation.TargetType.TYPE, PsiAnnotation.TargetType.ANNOTATION_TYPE, PsiAnnotation.TargetType.FIELD, PsiAnnotation.TargetType.METHOD, PsiAnnotation.TargetType.CONSTRUCTOR, PsiAnnotation.TargetType.PARAMETER, PsiAnnotation.TargetType.LOCAL_VARIABLE));
    private static final Logger LOG = Logger.getInstance("#com.intellij.codeInsight.AnnotationUtil");
    private static final PsiAnnotation.TargetType[] PACKAGE_TARGETS = new PsiAnnotation.TargetType[]{PsiAnnotation.TargetType.PACKAGE};
    private static final PsiAnnotation.TargetType[] TYPE_USE_TARGETS = new PsiAnnotation.TargetType[]{PsiAnnotation.TargetType.TYPE_USE};
    private static final PsiAnnotation.TargetType[] ANNOTATION_TARGETS = new PsiAnnotation.TargetType[]{PsiAnnotation.TargetType.ANNOTATION_TYPE, PsiAnnotation.TargetType.TYPE, PsiAnnotation.TargetType.TYPE_USE};
    private static final PsiAnnotation.TargetType[] TYPE_TARGETS = new PsiAnnotation.TargetType[]{PsiAnnotation.TargetType.TYPE, PsiAnnotation.TargetType.TYPE_USE};
    private static final PsiAnnotation.TargetType[] TYPE_PARAMETER_TARGETS = new PsiAnnotation.TargetType[]{PsiAnnotation.TargetType.TYPE_PARAMETER, PsiAnnotation.TargetType.TYPE_USE};
    private static final PsiAnnotation.TargetType[] CONSTRUCTOR_TARGETS = new PsiAnnotation.TargetType[]{PsiAnnotation.TargetType.CONSTRUCTOR, PsiAnnotation.TargetType.TYPE_USE};
    private static final PsiAnnotation.TargetType[] METHOD_TARGETS = new PsiAnnotation.TargetType[]{PsiAnnotation.TargetType.METHOD, PsiAnnotation.TargetType.TYPE_USE};
    private static final PsiAnnotation.TargetType[] FIELD_TARGETS = new PsiAnnotation.TargetType[]{PsiAnnotation.TargetType.FIELD, PsiAnnotation.TargetType.TYPE_USE};
    private static final PsiAnnotation.TargetType[] PARAMETER_TARGETS = new PsiAnnotation.TargetType[]{PsiAnnotation.TargetType.PARAMETER, PsiAnnotation.TargetType.TYPE_USE};
    private static final PsiAnnotation.TargetType[] LOCAL_VARIABLE_TARGETS = new PsiAnnotation.TargetType[]{PsiAnnotation.TargetType.LOCAL_VARIABLE, PsiAnnotation.TargetType.TYPE_USE};

    @NotNull
    public static PsiAnnotation.TargetType[] getTargetsForLocation(@Nullable PsiAnnotationOwner owner) {
        if (owner == null) {
            if (PsiAnnotation.TargetType.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/AnnotationTargetUtil", "getTargetsForLocation"));
            }
            return PsiAnnotation.TargetType.EMPTY_ARRAY;
        }
        if (owner instanceof PsiType || owner instanceof PsiTypeElement) {
            if (TYPE_USE_TARGETS == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/AnnotationTargetUtil", "getTargetsForLocation"));
            }
            return TYPE_USE_TARGETS;
        }
        if (owner instanceof PsiTypeParameter) {
            if (TYPE_PARAMETER_TARGETS == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/AnnotationTargetUtil", "getTargetsForLocation"));
            }
            return TYPE_PARAMETER_TARGETS;
        }
        if (owner instanceof PsiModifierList) {
            PsiElement element = ((PsiModifierList)owner).getParent();
            if (element instanceof PsiPackageStatement) {
                if (PACKAGE_TARGETS == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/AnnotationTargetUtil", "getTargetsForLocation"));
                }
                return PACKAGE_TARGETS;
            }
            if (element instanceof PsiClass) {
                if (((PsiClass)element).isAnnotationType()) {
                    if (ANNOTATION_TARGETS == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/AnnotationTargetUtil", "getTargetsForLocation"));
                    }
                    return ANNOTATION_TARGETS;
                }
                if (TYPE_TARGETS == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/AnnotationTargetUtil", "getTargetsForLocation"));
                }
                return TYPE_TARGETS;
            }
            if (element instanceof PsiMethod) {
                if (((PsiMethod)element).isConstructor()) {
                    if (CONSTRUCTOR_TARGETS == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/AnnotationTargetUtil", "getTargetsForLocation"));
                    }
                    return CONSTRUCTOR_TARGETS;
                }
                if (METHOD_TARGETS == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/AnnotationTargetUtil", "getTargetsForLocation"));
                }
                return METHOD_TARGETS;
            }
            if (element instanceof PsiField) {
                if (FIELD_TARGETS == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/AnnotationTargetUtil", "getTargetsForLocation"));
                }
                return FIELD_TARGETS;
            }
            if (element instanceof PsiParameter) {
                if (PARAMETER_TARGETS == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/AnnotationTargetUtil", "getTargetsForLocation"));
                }
                return PARAMETER_TARGETS;
            }
            if (element instanceof PsiLocalVariable) {
                if (LOCAL_VARIABLE_TARGETS == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/AnnotationTargetUtil", "getTargetsForLocation"));
                }
                return LOCAL_VARIABLE_TARGETS;
            }
        }
        if (PsiAnnotation.TargetType.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/AnnotationTargetUtil", "getTargetsForLocation"));
        }
        return PsiAnnotation.TargetType.EMPTY_ARRAY;
    }

    @Nullable
    public static Set<PsiAnnotation.TargetType> extractRequiredAnnotationTargets(@Nullable PsiAnnotationMemberValue value) {
        if (value instanceof PsiReference) {
            PsiAnnotation.TargetType targetType = AnnotationTargetUtil.translateTargetRef((PsiReference)((Object)value));
            if (targetType != null) {
                return Collections.singleton(targetType);
            }
        } else if (value instanceof PsiArrayInitializerMemberValue) {
            HashSet<PsiAnnotation.TargetType> targets = ContainerUtil.newHashSet();
            for (PsiAnnotationMemberValue initializer : ((PsiArrayInitializerMemberValue)value).getInitializers()) {
                PsiAnnotation.TargetType targetType;
                if (!(initializer instanceof PsiReference) || (targetType = AnnotationTargetUtil.translateTargetRef((PsiReference)((Object)initializer))) == null) continue;
                targets.add(targetType);
            }
            return targets;
        }
        return null;
    }

    @Nullable
    private static PsiAnnotation.TargetType translateTargetRef(@NotNull PsiReference reference) {
        if (reference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "com/intellij/codeInsight/AnnotationTargetUtil", "translateTargetRef"));
        }
        PsiElement field = reference.resolve();
        if (field instanceof PsiEnumConstant) {
            String name = ((PsiEnumConstant)field).getName();
            try {
                return PsiAnnotation.TargetType.valueOf(name);
            }
            catch (IllegalArgumentException e) {
                LOG.warn("Unknown target: " + name);
            }
        }
        return null;
    }
}

