/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree;

import com.intellij.lang.LighterAST;
import com.intellij.lang.LighterASTNode;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.source.tree.JavaSourceUtil;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;

public class SourceUtil {
    private SourceUtil() {
    }

    @NotNull
    public static String getReferenceText(@NotNull PsiJavaCodeReferenceElement ref) {
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/intellij/psi/impl/source/tree/SourceUtil", "getReferenceText"));
        }
        String string = JavaSourceUtil.getReferenceText(ref);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/tree/SourceUtil", "getReferenceText"));
        }
        return string;
    }

    @NotNull
    public static String getReferenceText(@NotNull LighterAST tree, @NotNull LighterASTNode node2) {
        if (tree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/psi/impl/source/tree/SourceUtil", "getReferenceText"));
        }
        if (node2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/psi/impl/source/tree/SourceUtil", "getReferenceText"));
        }
        String string = JavaSourceUtil.getReferenceText(tree, node2);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/tree/SourceUtil", "getReferenceText"));
        }
        return string;
    }

    public static TreeElement addParenthToReplacedChild(@NotNull IElementType parenthType, @NotNull TreeElement newChild, @NotNull PsiManager manager) {
        if (parenthType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parenthType", "com/intellij/psi/impl/source/tree/SourceUtil", "addParenthToReplacedChild"));
        }
        if (newChild == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newChild", "com/intellij/psi/impl/source/tree/SourceUtil", "addParenthToReplacedChild"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/psi/impl/source/tree/SourceUtil", "addParenthToReplacedChild"));
        }
        return JavaSourceUtil.addParenthToReplacedChild(parenthType, newChild, manager);
    }
}

