/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util;

import com.intellij.psi.HierarchicalMethodSignature;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.util.containers.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class PsiSuperMethodUtil {
    private PsiSuperMethodUtil() {
    }

    public static PsiMethod findConstructorInSuper(PsiMethod constructor2) {
        return PsiSuperMethodUtil.findConstructorInSuper(constructor2, new HashSet<PsiMethod>());
    }

    public static PsiMethod findConstructorInSuper(PsiMethod constructor2, Set<PsiMethod> visited) {
        PsiClass superClass;
        PsiClass containingClass;
        PsiElement firstChild;
        PsiStatement[] statements;
        if (visited.contains(constructor2)) {
            return null;
        }
        visited.add(constructor2);
        PsiCodeBlock body = constructor2.getBody();
        if (body != null && (statements = body.getStatements()).length > 0 && (firstChild = statements[0].getFirstChild()) instanceof PsiMethodCallExpression) {
            PsiReferenceExpression methodExpr = ((PsiMethodCallExpression)firstChild).getMethodExpression();
            String text = methodExpr.getText();
            if (text.equals("super")) {
                PsiElement superConstructor = methodExpr.resolve();
                if (superConstructor instanceof PsiMethod) {
                    return (PsiMethod)superConstructor;
                }
            } else if (text.equals("this")) {
                PsiElement resolved = methodExpr.resolve();
                if (resolved instanceof PsiMethod) {
                    return PsiSuperMethodUtil.findConstructorInSuper((PsiMethod)resolved, visited);
                }
                return null;
            }
        }
        if ((containingClass = constructor2.getContainingClass()) != null && (superClass = containingClass.getSuperClass()) != null) {
            MethodSignature defConstructor = MethodSignatureUtil.createMethodSignature(superClass.getName(), PsiType.EMPTY_ARRAY, PsiTypeParameter.EMPTY_ARRAY, PsiSubstitutor.EMPTY, true);
            return MethodSignatureUtil.findMethodBySignature(superClass, defConstructor, false);
        }
        return null;
    }

    public static boolean isSuperMethod(@NotNull PsiMethod method, @NotNull PsiMethod superMethod) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/psi/util/PsiSuperMethodUtil", "isSuperMethod"));
        }
        if (superMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "superMethod", "com/intellij/psi/util/PsiSuperMethodUtil", "isSuperMethod"));
        }
        HierarchicalMethodSignature signature = method.getHierarchicalMethodSignature();
        List<HierarchicalMethodSignature> superSignatures = signature.getSuperSignatures();
        int superSignaturesSize = superSignatures.size();
        for (int i = 0; i < superSignaturesSize; ++i) {
            HierarchicalMethodSignature supsig = superSignatures.get(i);
            PsiMethod supsigme = supsig.getMethod();
            if (!superMethod.equals(supsigme) && !PsiSuperMethodUtil.isSuperMethod(supsigme, superMethod)) continue;
            return true;
        }
        return false;
    }
}

