/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.optimization;

import com.intellij.util.containers.Stack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.IntRange;
import kotlin.KotlinPackage;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinSyntheticClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.codegen.inline.InlineCodegenUtil;
import org.jetbrains.kotlin.codegen.optimization.StoredStackValuesDescriptor;
import org.jetbrains.org.objectweb.asm.Opcodes;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.tree.AbstractInsnNode;
import org.jetbrains.org.objectweb.asm.tree.InsnList;
import org.jetbrains.org.objectweb.asm.tree.MethodInsnNode;
import org.jetbrains.org.objectweb.asm.tree.MethodNode;
import org.jetbrains.org.objectweb.asm.tree.VarInsnNode;
import org.jetbrains.org.objectweb.asm.tree.analysis.BasicValue;
import org.jetbrains.org.objectweb.asm.tree.analysis.Frame;

@KotlinSyntheticClass(abiVersion=22, kind=KotlinSyntheticClass.Kind.PACKAGE_PART)
public final class OptimizationPackage$StoreStackBeforeInlineMethodTransformer$b0041f7d {
    public static final boolean needToProcess(@JetValueParameter(name="node") @NotNull MethodNode node2, @JetValueParameter(name="frames") @NotNull Frame<BasicValue>[] frames) {
        Intrinsics.checkParameterIsNotNull(node2, "node");
        Intrinsics.checkParameterIsNotNull(frames, "frames");
        AbstractInsnNode[] insns = node2.instructions.toArray();
        int balance = 0;
        int isThereAnyInlineMarker = 0;
        for (Pair<Object, Object> pair : KotlinPackage.zip((Object[])insns, (Object[])frames)) {
            AbstractInsnNode insn = (AbstractInsnNode)pair.component1();
            Frame frame = (Frame)pair.component2();
            AbstractInsnNode abstractInsnNode = insn;
            Intrinsics.checkExpressionValueIsNotNull(abstractInsnNode, "insn");
            if (OptimizationPackage$StoreStackBeforeInlineMethodTransformer$b0041f7d.isInlineMarker$default(abstractInsnNode, null, 2)) {
                isThereAnyInlineMarker = 1;
                if (frame == null) {
                    return false;
                }
            }
            AbstractInsnNode abstractInsnNode2 = insn;
            Intrinsics.checkExpressionValueIsNotNull(abstractInsnNode2, "insn");
            if (OptimizationPackage$StoreStackBeforeInlineMethodTransformer$b0041f7d.isBeforeInlineMarker(abstractInsnNode2)) {
                ++balance;
            } else {
                AbstractInsnNode abstractInsnNode3 = insn;
                Intrinsics.checkExpressionValueIsNotNull(abstractInsnNode3, "insn");
                if (OptimizationPackage$StoreStackBeforeInlineMethodTransformer$b0041f7d.isAfterInlineMarker(abstractInsnNode3)) {
                    --balance;
                }
            }
            if (balance >= 0) continue;
            return false;
        }
        return (balance == 0 ? isThereAnyInlineMarker : 0) != 0;
    }

    public static final boolean isBeforeInlineMarker(@JetValueParameter(name="insn") @NotNull AbstractInsnNode insn) {
        Intrinsics.checkParameterIsNotNull(insn, "insn");
        return OptimizationPackage$StoreStackBeforeInlineMethodTransformer$b0041f7d.isInlineMarker(insn, InlineCodegenUtil.INLINE_MARKER_BEFORE_METHOD_NAME);
    }

    public static final boolean isAfterInlineMarker(@JetValueParameter(name="insn") @NotNull AbstractInsnNode insn) {
        Intrinsics.checkParameterIsNotNull(insn, "insn");
        return OptimizationPackage$StoreStackBeforeInlineMethodTransformer$b0041f7d.isInlineMarker(insn, InlineCodegenUtil.INLINE_MARKER_AFTER_METHOD_NAME);
    }

    public static final boolean isInlineMarker(@JetValueParameter(name="insn") @NotNull AbstractInsnNode insn, @JetValueParameter(name="markerName", type="?") @Nullable String markerName) {
        Intrinsics.checkParameterIsNotNull(insn, "insn");
        return ((insn.getOpcode() == Opcodes.INVOKESTATIC ? insn instanceof MethodInsnNode : false) ? Intrinsics.areEqual(((MethodInsnNode)insn).owner, InlineCodegenUtil.INLINE_MARKER_CLASS_NAME) : false) ? (markerName != null ? Intrinsics.areEqual(markerName, ((MethodInsnNode)insn).name) : (!Intrinsics.areEqual(((MethodInsnNode)insn).name, InlineCodegenUtil.INLINE_MARKER_BEFORE_METHOD_NAME) ? Intrinsics.areEqual(((MethodInsnNode)insn).name, InlineCodegenUtil.INLINE_MARKER_AFTER_METHOD_NAME) : true)) : false;
    }

    public static boolean isInlineMarker$default(AbstractInsnNode abstractInsnNode, String string, int n) {
        if ((n & 2) != 0) {
            string = null;
        }
        return OptimizationPackage$StoreStackBeforeInlineMethodTransformer$b0041f7d.isInlineMarker(abstractInsnNode, string);
    }

    public static final void process(@JetValueParameter(name="methodNode") @NotNull MethodNode methodNode, @JetValueParameter(name="frames") @NotNull Frame<BasicValue>[] frames) {
        Intrinsics.checkParameterIsNotNull(methodNode, "methodNode");
        Intrinsics.checkParameterIsNotNull(frames, "frames");
        AbstractInsnNode[] insns = methodNode.instructions.toArray();
        Stack<StoredStackValuesDescriptor> storedValuesDescriptorsStack = new Stack<StoredStackValuesDescriptor>();
        int firstAvailableVarIndex = methodNode.maxLocals;
        int currentStoredValuesCount = 0;
        for (Pair<Object, Object> pair : KotlinPackage.zip((Object[])insns, (Object[])frames)) {
            StoredStackValuesDescriptor desc;
            AbstractInsnNode insn = (AbstractInsnNode)pair.component1();
            Frame frame = (Frame)pair.component2();
            AbstractInsnNode abstractInsnNode = insn;
            Intrinsics.checkExpressionValueIsNotNull(abstractInsnNode, "insn");
            if (OptimizationPackage$StoreStackBeforeInlineMethodTransformer$b0041f7d.isBeforeInlineMarker(abstractInsnNode)) {
                if (frame == null) {
                    throw (Throwable)((Object)new AssertionError((Object)"process method shouldn't be called if frame is null before inline marker"));
                }
                AbstractInsnNode abstractInsnNode2 = insn;
                Intrinsics.checkExpressionValueIsNotNull(abstractInsnNode2, "insn");
                desc = OptimizationPackage$StoreStackBeforeInlineMethodTransformer$b0041f7d.storeStackValues(methodNode, frame, abstractInsnNode2, firstAvailableVarIndex, currentStoredValuesCount);
                firstAvailableVarIndex += desc.getStoredStackSize();
                currentStoredValuesCount += desc.getStoredValuesCount();
                storedValuesDescriptorsStack.push(desc);
            } else {
                AbstractInsnNode abstractInsnNode3 = insn;
                Intrinsics.checkExpressionValueIsNotNull(abstractInsnNode3, "insn");
                if (OptimizationPackage$StoreStackBeforeInlineMethodTransformer$b0041f7d.isAfterInlineMarker(abstractInsnNode3)) {
                    if (frame == null) {
                        throw (Throwable)((Object)new AssertionError((Object)"process method shouldn't be called if frame is null before inline marker"));
                    }
                    if ((StoredStackValuesDescriptor)storedValuesDescriptorsStack.pop() == null) {
                        throw (Throwable)((Object)new AssertionError((Object)"should be non null becase markers are balanced"));
                    }
                    AbstractInsnNode abstractInsnNode4 = insn;
                    Intrinsics.checkExpressionValueIsNotNull(abstractInsnNode4, "insn");
                    OptimizationPackage$StoreStackBeforeInlineMethodTransformer$b0041f7d.loadStackValues(methodNode, frame, abstractInsnNode4, desc);
                    firstAvailableVarIndex -= desc.getStoredStackSize();
                    currentStoredValuesCount -= desc.getStoredValuesCount();
                }
            }
            AbstractInsnNode abstractInsnNode5 = insn;
            Intrinsics.checkExpressionValueIsNotNull(abstractInsnNode5, "insn");
            if (!OptimizationPackage$StoreStackBeforeInlineMethodTransformer$b0041f7d.isInlineMarker$default(abstractInsnNode5, null, 2)) continue;
            methodNode.instructions.remove(insn);
        }
    }

    public static final void removeInlineMarkers(@JetValueParameter(name="node") @NotNull MethodNode node2) {
        Intrinsics.checkParameterIsNotNull(node2, "node");
        AbstractInsnNode[] abstractInsnNodeArray = node2.instructions.toArray();
        for (int i = 0; i < abstractInsnNodeArray.length; ++i) {
            AbstractInsnNode insn;
            AbstractInsnNode abstractInsnNode = insn = abstractInsnNodeArray[i];
            Intrinsics.checkExpressionValueIsNotNull(abstractInsnNode, "insn");
            if (!OptimizationPackage$StoreStackBeforeInlineMethodTransformer$b0041f7d.isInlineMarker$default(abstractInsnNode, null, 2)) continue;
            node2.instructions.remove(insn);
        }
    }

    @NotNull
    public static final StoredStackValuesDescriptor storeStackValues(@JetValueParameter(name="node") @NotNull MethodNode node2, @JetValueParameter(name="frame") @NotNull Frame<BasicValue> frame, @JetValueParameter(name="beforeInlineMarker") @NotNull AbstractInsnNode beforeInlineMarker, @JetValueParameter(name="firstAvailableVarIndex") int firstAvailableVarIndex, @JetValueParameter(name="alreadyStoredValuesCount") int alreadyStoredValuesCount) {
        Intrinsics.checkParameterIsNotNull(node2, "node");
        Intrinsics.checkParameterIsNotNull(frame, "frame");
        Intrinsics.checkParameterIsNotNull(beforeInlineMarker, "beforeInlineMarker");
        int stackSize = 0;
        List<BasicValue> values = OptimizationPackage$StoreStackBeforeInlineMethodTransformer$b0041f7d.getStackValuesStartingFrom(frame, alreadyStoredValuesCount);
        for (BasicValue value : KotlinPackage.reverse((Iterable)values)) {
            InsnList insnList = node2.instructions;
            Type type2 = value.getType();
            if (type2 == null) {
                Intrinsics.throwNpe();
            }
            insnList.insertBefore(beforeInlineMarker, new VarInsnNode(type2.getOpcode(Opcodes.ISTORE), firstAvailableVarIndex + stackSize));
            stackSize += value.getSize();
        }
        OptimizationPackage$StoreStackBeforeInlineMethodTransformer$b0041f7d.updateMaxLocals(node2, firstAvailableVarIndex + stackSize);
        return new StoredStackValuesDescriptor(values, firstAvailableVarIndex, stackSize, alreadyStoredValuesCount);
    }

    public static final void loadStackValues(@JetValueParameter(name="node") @NotNull MethodNode node2, @JetValueParameter(name="frame") @NotNull Frame<BasicValue> frame, @JetValueParameter(name="afterInlineMarker") @NotNull AbstractInsnNode afterInlineMarker, @JetValueParameter(name="desc") @NotNull StoredStackValuesDescriptor desc) {
        Intrinsics.checkParameterIsNotNull(node2, "node");
        Intrinsics.checkParameterIsNotNull(frame, "frame");
        Intrinsics.checkParameterIsNotNull(afterInlineMarker, "afterInlineMarker");
        Intrinsics.checkParameterIsNotNull(desc, "desc");
        if (!desc.getIsStored()) {
            return;
        }
        InsnList insns = node2.instructions;
        int returnValueVarIndex = -1;
        Type returnType2 = null;
        if (frame.getStackSize() != desc.getTotalValuesCountOnStackBeforeInline()) {
            KotlinPackage.assert(frame.getStackSize() - desc.getTotalValuesCountOnStackBeforeInline() == 1, "Stack sizes should not differ by more than 1 (returned value)");
            returnValueVarIndex = desc.getNextFreeVarIndex();
            BasicValue basicValue = frame.getStack(frame.getStackSize() - 1);
            if (basicValue == null) {
                Intrinsics.throwNpe();
            }
            Type type2 = returnType2 = basicValue.getType();
            if (type2 == null) {
                Intrinsics.throwNpe();
            }
            OptimizationPackage$StoreStackBeforeInlineMethodTransformer$b0041f7d.updateMaxLocals(node2, returnValueVarIndex + type2.getSize());
            Type type3 = returnType2;
            if (type3 == null) {
                Intrinsics.throwNpe();
            }
            insns.insertBefore(afterInlineMarker, new VarInsnNode(type3.getOpcode(Opcodes.ISTORE), returnValueVarIndex));
        }
        int currentVarIndex = desc.getFirstVariableIndex() + desc.getStoredStackSize();
        for (BasicValue value : desc.getValues()) {
            currentVarIndex -= value.getSize();
            Type type4 = value.getType();
            if (type4 == null) {
                Intrinsics.throwNpe();
            }
            insns.insertBefore(afterInlineMarker, new VarInsnNode(type4.getOpcode(Opcodes.ILOAD), currentVarIndex));
        }
        if (returnValueVarIndex != -1) {
            Type type5 = returnType2;
            if (type5 == null) {
                Intrinsics.throwNpe();
            }
            insns.insertBefore(afterInlineMarker, new VarInsnNode(type5.getOpcode(Opcodes.ILOAD), returnValueVarIndex));
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final <V extends BasicValue> List<V> getStackValuesStartingFrom(@JetValueParameter(name="$receiver") Frame<V> $receiver, @JetValueParameter(name="from") int from) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Iterable iterable = new IntRange(from, $receiver.getStackSize() - 1);
        Iterable iterable2 = iterable;
        Collection collection = new ArrayList();
        for (Object t : iterable2) {
            void it;
            int n = ((Number)t).intValue();
            Collection collection2 = collection;
            BasicValue basicValue = (BasicValue)$receiver.getStack((int)it);
            collection2.add(basicValue);
        }
        return KotlinPackage.requireNoNulls((ArrayList)collection);
    }

    public static final void updateMaxLocals(@JetValueParameter(name="$receiver") MethodNode $receiver, @JetValueParameter(name="newMaxLocals") int newMaxLocals) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        $receiver.maxLocals = Math.max($receiver.maxLocals, newMaxLocals);
    }
}

