/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.when;

import java.util.ArrayList;
import java.util.List;
import kotlin.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.codegen.ExpressionCodegen;
import org.jetbrains.kotlin.codegen.binding.CodegenBinding;
import org.jetbrains.kotlin.codegen.when.EnumSwitchCodegen;
import org.jetbrains.kotlin.codegen.when.IntegralConstantsSwitchCodegen;
import org.jetbrains.kotlin.codegen.when.StringSwitchCodegen;
import org.jetbrains.kotlin.codegen.when.SwitchCodegen;
import org.jetbrains.kotlin.codegen.when.WhenByEnumsMapping;
import org.jetbrains.kotlin.psi.JetExpression;
import org.jetbrains.kotlin.psi.JetWhenCondition;
import org.jetbrains.kotlin.psi.JetWhenConditionWithExpression;
import org.jetbrains.kotlin.psi.JetWhenEntry;
import org.jetbrains.kotlin.psi.JetWhenExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstant;
import org.jetbrains.kotlin.resolve.constants.IntegerValueConstant;
import org.jetbrains.kotlin.resolve.constants.NullValue;
import org.jetbrains.kotlin.resolve.constants.StringValue;
import org.jetbrains.org.objectweb.asm.Type;

public class SwitchCodegenUtil {
    public static boolean checkAllItemsAreConstantsSatisfying(@NotNull JetWhenExpression expression, @NotNull BindingContext bindingContext, Function1<CompileTimeConstant, Boolean> predicate) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/codegen/when/SwitchCodegenUtil", "checkAllItemsAreConstantsSatisfying"));
        }
        if (bindingContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bindingContext", "org/jetbrains/kotlin/codegen/when/SwitchCodegenUtil", "checkAllItemsAreConstantsSatisfying"));
        }
        for (JetWhenEntry entry : expression.getEntries()) {
            for (JetWhenCondition condition : entry.getConditions()) {
                if (!(condition instanceof JetWhenConditionWithExpression)) {
                    return false;
                }
                JetExpression patternExpression = ((JetWhenConditionWithExpression)condition).getExpression();
                assert (patternExpression != null) : "expression in when should not be null";
                CompileTimeConstant constant = ExpressionCodegen.getCompileTimeConstant(patternExpression, bindingContext);
                if (constant != null && predicate.invoke(constant).booleanValue()) continue;
                return false;
            }
        }
        return true;
    }

    @NotNull
    public static Iterable<CompileTimeConstant> getAllConstants(@NotNull JetWhenExpression expression, @NotNull BindingContext bindingContext) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/codegen/when/SwitchCodegenUtil", "getAllConstants"));
        }
        if (bindingContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bindingContext", "org/jetbrains/kotlin/codegen/when/SwitchCodegenUtil", "getAllConstants"));
        }
        ArrayList<CompileTimeConstant> result2 = new ArrayList<CompileTimeConstant>();
        for (JetWhenEntry entry : expression.getEntries()) {
            SwitchCodegenUtil.addConstantsFromEntry(result2, entry, bindingContext);
        }
        ArrayList<CompileTimeConstant> arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/when/SwitchCodegenUtil", "getAllConstants"));
        }
        return arrayList;
    }

    private static void addConstantsFromEntry(@NotNull List<CompileTimeConstant> result2, @NotNull JetWhenEntry entry, @NotNull BindingContext bindingContext) {
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/kotlin/codegen/when/SwitchCodegenUtil", "addConstantsFromEntry"));
        }
        if (entry == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entry", "org/jetbrains/kotlin/codegen/when/SwitchCodegenUtil", "addConstantsFromEntry"));
        }
        if (bindingContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bindingContext", "org/jetbrains/kotlin/codegen/when/SwitchCodegenUtil", "addConstantsFromEntry"));
        }
        for (JetWhenCondition condition : entry.getConditions()) {
            if (!(condition instanceof JetWhenConditionWithExpression)) continue;
            JetExpression patternExpression = ((JetWhenConditionWithExpression)condition).getExpression();
            assert (patternExpression != null) : "expression in when should not be null";
            result2.add(ExpressionCodegen.getCompileTimeConstant(patternExpression, bindingContext));
        }
    }

    @NotNull
    public static Iterable<CompileTimeConstant> getConstantsFromEntry(@NotNull JetWhenEntry entry, @NotNull BindingContext bindingContext) {
        if (entry == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entry", "org/jetbrains/kotlin/codegen/when/SwitchCodegenUtil", "getConstantsFromEntry"));
        }
        if (bindingContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bindingContext", "org/jetbrains/kotlin/codegen/when/SwitchCodegenUtil", "getConstantsFromEntry"));
        }
        ArrayList<CompileTimeConstant> result2 = new ArrayList<CompileTimeConstant>();
        SwitchCodegenUtil.addConstantsFromEntry(result2, entry, bindingContext);
        ArrayList<CompileTimeConstant> arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/when/SwitchCodegenUtil", "getConstantsFromEntry"));
        }
        return arrayList;
    }

    @Nullable
    public static SwitchCodegen buildAppropriateSwitchCodegenIfPossible(@NotNull JetWhenExpression expression, boolean isStatement, @NotNull ExpressionCodegen codegen) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/codegen/when/SwitchCodegenUtil", "buildAppropriateSwitchCodegenIfPossible"));
        }
        if (codegen == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "codegen", "org/jetbrains/kotlin/codegen/when/SwitchCodegenUtil", "buildAppropriateSwitchCodegenIfPossible"));
        }
        BindingContext bindingContext = codegen.getBindingContext();
        if (!SwitchCodegenUtil.isThereConstantEntriesButNulls(expression, bindingContext)) {
            return null;
        }
        Type subjectType = codegen.expressionType(expression.getSubjectExpression());
        WhenByEnumsMapping mapping = codegen.getBindingContext().get(CodegenBinding.MAPPING_FOR_WHEN_BY_ENUM, expression);
        if (mapping != null) {
            return new EnumSwitchCodegen(expression, isStatement, codegen, mapping);
        }
        if (SwitchCodegenUtil.isIntegralConstantsSwitch(expression, subjectType, bindingContext)) {
            return new IntegralConstantsSwitchCodegen(expression, isStatement, codegen);
        }
        if (SwitchCodegenUtil.isStringConstantsSwitch(expression, subjectType, bindingContext)) {
            return new StringSwitchCodegen(expression, isStatement, codegen);
        }
        return null;
    }

    private static boolean isThereConstantEntriesButNulls(@NotNull JetWhenExpression expression, @NotNull BindingContext bindingContext) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/codegen/when/SwitchCodegenUtil", "isThereConstantEntriesButNulls"));
        }
        if (bindingContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bindingContext", "org/jetbrains/kotlin/codegen/when/SwitchCodegenUtil", "isThereConstantEntriesButNulls"));
        }
        for (CompileTimeConstant constant : SwitchCodegenUtil.getAllConstants(expression, bindingContext)) {
            if (constant == null || constant instanceof NullValue) continue;
            return true;
        }
        return false;
    }

    private static boolean isIntegralConstantsSwitch(@NotNull JetWhenExpression expression, @NotNull Type subjectType, @NotNull BindingContext bindingContext) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/codegen/when/SwitchCodegenUtil", "isIntegralConstantsSwitch"));
        }
        if (subjectType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subjectType", "org/jetbrains/kotlin/codegen/when/SwitchCodegenUtil", "isIntegralConstantsSwitch"));
        }
        if (bindingContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bindingContext", "org/jetbrains/kotlin/codegen/when/SwitchCodegenUtil", "isIntegralConstantsSwitch"));
        }
        int typeSort = subjectType.getSort();
        if (typeSort != 5 && typeSort != 2 && typeSort != 4 && typeSort != 3) {
            return false;
        }
        return SwitchCodegenUtil.checkAllItemsAreConstantsSatisfying(expression, bindingContext, new Function1<CompileTimeConstant, Boolean>(){

            @Override
            public Boolean invoke(@NotNull CompileTimeConstant constant) {
                if (constant == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constant", "org/jetbrains/kotlin/codegen/when/SwitchCodegenUtil$1", "invoke"));
                }
                return constant instanceof IntegerValueConstant;
            }
        });
    }

    private static boolean isStringConstantsSwitch(@NotNull JetWhenExpression expression, @NotNull Type subjectType, @NotNull BindingContext bindingContext) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/codegen/when/SwitchCodegenUtil", "isStringConstantsSwitch"));
        }
        if (subjectType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subjectType", "org/jetbrains/kotlin/codegen/when/SwitchCodegenUtil", "isStringConstantsSwitch"));
        }
        if (bindingContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bindingContext", "org/jetbrains/kotlin/codegen/when/SwitchCodegenUtil", "isStringConstantsSwitch"));
        }
        if (!subjectType.getClassName().equals(String.class.getName())) {
            return false;
        }
        return SwitchCodegenUtil.checkAllItemsAreConstantsSatisfying(expression, bindingContext, new Function1<CompileTimeConstant, Boolean>(){

            @Override
            public Boolean invoke(@NotNull CompileTimeConstant constant) {
                if (constant == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constant", "org/jetbrains/kotlin/codegen/when/SwitchCodegenUtil$2", "invoke"));
                }
                return constant instanceof StringValue || constant instanceof NullValue;
            }
        });
    }
}

