/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.operation;

import com.google.dart.compiler.backend.js.ast.JsBinaryOperation;
import com.google.dart.compiler.backend.js.ast.JsExpression;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.js.translate.callTranslator.CallTranslator;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.general.Translation;
import org.jetbrains.kotlin.js.translate.operation.IncrementTranslator;
import org.jetbrains.kotlin.js.translate.utils.BindingUtils;
import org.jetbrains.kotlin.js.translate.utils.ErrorReportingUtils;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.js.translate.utils.PsiUtils;
import org.jetbrains.kotlin.js.translate.utils.TranslationUtils;
import org.jetbrains.kotlin.lexer.JetTokens;
import org.jetbrains.kotlin.psi.JetConstantExpression;
import org.jetbrains.kotlin.psi.JetExpression;
import org.jetbrains.kotlin.psi.JetUnaryExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingContextUtils;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilPackage;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstant;
import org.jetbrains.kotlin.types.JetType;

public final class UnaryOperationTranslator {
    private UnaryOperationTranslator() {
    }

    @NotNull
    public static JsExpression translate(@NotNull JetUnaryExpression expression, @NotNull TranslationContext context2) {
        Object baseExpression;
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/operation/UnaryOperationTranslator", "translate"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/operation/UnaryOperationTranslator", "translate"));
        }
        IElementType operationToken = expression.getOperationReference().getReferencedNameElementType();
        if (operationToken == JetTokens.EXCLEXCL) {
            JetExpression baseExpression2 = PsiUtils.getBaseExpression(expression);
            JetType type2 = BindingContextUtils.getNotNull(context2.bindingContext(), BindingContext.EXPRESSION_TYPE, baseExpression2);
            JsExpression translatedExpression = Translation.translateAsExpression(baseExpression2, context2);
            JsExpression jsExpression = type2.isMarkedNullable() ? TranslationUtils.sure(translatedExpression, context2) : translatedExpression;
            if (jsExpression == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/operation/UnaryOperationTranslator", "translate"));
            }
            return jsExpression;
        }
        if (operationToken == JetTokens.MINUS && (baseExpression = PsiUtils.getBaseExpression(expression)) instanceof JetConstantExpression) {
            CompileTimeConstant<?> compileTimeValue = context2.bindingContext().get(BindingContext.COMPILE_TIME_VALUE, expression);
            assert (compileTimeValue != null) : ErrorReportingUtils.message(expression, "Expression is not compile time value: " + expression.getText() + " ");
            Object value = BindingUtils.getCompileTimeValue(context2.bindingContext(), expression, compileTimeValue);
            if (value instanceof Long) {
                JsExpression jsExpression = JsAstUtils.newLong((Long)value, context2);
                if (jsExpression == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/operation/UnaryOperationTranslator", "translate"));
                }
                return jsExpression;
            }
        }
        if (IncrementTranslator.isIncrement(operationToken)) {
            JsExpression jsExpression = IncrementTranslator.translate(expression, context2);
            if (jsExpression == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/operation/UnaryOperationTranslator", "translate"));
            }
            return jsExpression;
        }
        baseExpression = TranslationUtils.translateBaseExpression(context2, expression);
        if (UnaryOperationTranslator.isExclForBinaryEqualLikeExpr(expression, (JsExpression)baseExpression)) {
            JsExpression jsExpression = TranslationUtils.translateExclForBinaryEqualLikeExpr((JsBinaryOperation)baseExpression);
            if (jsExpression == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/operation/UnaryOperationTranslator", "translate"));
            }
            return jsExpression;
        }
        ResolvedCall<? extends FunctionDescriptor> resolvedCall = CallUtilPackage.getFunctionResolvedCallWithAssert(expression, context2.bindingContext());
        JsExpression jsExpression = CallTranslator.INSTANCE$.translate(context2, resolvedCall, (JsExpression)baseExpression);
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/operation/UnaryOperationTranslator", "translate"));
        }
        return jsExpression;
    }

    private static boolean isExclForBinaryEqualLikeExpr(@NotNull JetUnaryExpression expression, @NotNull JsExpression baseExpression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/operation/UnaryOperationTranslator", "isExclForBinaryEqualLikeExpr"));
        }
        if (baseExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseExpression", "org/jetbrains/kotlin/js/translate/operation/UnaryOperationTranslator", "isExclForBinaryEqualLikeExpr"));
        }
        if (PsiUtils.getOperationToken(expression).equals(JetTokens.EXCL) && baseExpression instanceof JsBinaryOperation) {
            return TranslationUtils.isEqualLikeOperator(((JsBinaryOperation)baseExpression).getOperator());
        }
        return false;
    }
}

