/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.utils.mutator;

import com.google.dart.compiler.backend.js.ast.JsBlock;
import com.google.dart.compiler.backend.js.ast.JsCatch;
import com.google.dart.compiler.backend.js.ast.JsExpressionStatement;
import com.google.dart.compiler.backend.js.ast.JsIf;
import com.google.dart.compiler.backend.js.ast.JsNode;
import com.google.dart.compiler.backend.js.ast.JsStatement;
import com.google.dart.compiler.backend.js.ast.JsTry;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.js.translate.utils.mutator.Mutator;

public final class LastExpressionMutator {
    @NotNull
    private final Mutator mutator;

    public static JsStatement mutateLastExpression(@NotNull JsNode node2, @NotNull Mutator mutator) {
        if (node2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/kotlin/js/translate/utils/mutator/LastExpressionMutator", "mutateLastExpression"));
        }
        if (mutator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mutator", "org/jetbrains/kotlin/js/translate/utils/mutator/LastExpressionMutator", "mutateLastExpression"));
        }
        return JsAstUtils.convertToStatement(new LastExpressionMutator(mutator).apply(node2));
    }

    private LastExpressionMutator(@NotNull Mutator mutator) {
        if (mutator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mutator", "org/jetbrains/kotlin/js/translate/utils/mutator/LastExpressionMutator", "<init>"));
        }
        this.mutator = mutator;
    }

    @NotNull
    private JsNode apply(@NotNull JsNode node2) {
        if (node2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/kotlin/js/translate/utils/mutator/LastExpressionMutator", "apply"));
        }
        if (node2 instanceof JsBlock) {
            JsNode jsNode = this.applyToBlock((JsBlock)node2);
            if (jsNode == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/utils/mutator/LastExpressionMutator", "apply"));
            }
            return jsNode;
        }
        if (node2 instanceof JsIf) {
            JsNode jsNode = this.applyToIf((JsIf)node2);
            if (jsNode == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/utils/mutator/LastExpressionMutator", "apply"));
            }
            return jsNode;
        }
        if (node2 instanceof JsTry) {
            JsNode jsNode = this.applyToTry((JsTry)node2);
            if (jsNode == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/utils/mutator/LastExpressionMutator", "apply"));
            }
            return jsNode;
        }
        if (node2 instanceof JsExpressionStatement) {
            JsNode jsNode = this.applyToStatement((JsExpressionStatement)node2);
            if (jsNode == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/utils/mutator/LastExpressionMutator", "apply"));
            }
            return jsNode;
        }
        JsNode jsNode = this.mutator.mutate(node2);
        if (jsNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/utils/mutator/LastExpressionMutator", "apply"));
        }
        return jsNode;
    }

    @NotNull
    private JsNode applyToStatement(@NotNull JsExpressionStatement node2) {
        if (node2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/kotlin/js/translate/utils/mutator/LastExpressionMutator", "applyToStatement"));
        }
        JsStatement jsStatement = JsAstUtils.convertToStatement(this.apply(node2.getExpression()));
        if (jsStatement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/utils/mutator/LastExpressionMutator", "applyToStatement"));
        }
        return jsStatement;
    }

    @NotNull
    private JsNode applyToIf(@NotNull JsIf node2) {
        if (node2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/kotlin/js/translate/utils/mutator/LastExpressionMutator", "applyToIf"));
        }
        node2.setThenStatement(JsAstUtils.convertToStatement(this.apply(node2.getThenStatement())));
        JsStatement elseStmt = node2.getElseStatement();
        if (elseStmt != null) {
            node2.setElseStatement(JsAstUtils.convertToStatement(this.apply(elseStmt)));
        }
        JsIf jsIf = node2;
        if (jsIf == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/utils/mutator/LastExpressionMutator", "applyToIf"));
        }
        return jsIf;
    }

    @NotNull
    private JsNode applyToTry(@NotNull JsTry node2) {
        if (node2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/kotlin/js/translate/utils/mutator/LastExpressionMutator", "applyToTry"));
        }
        this.applyToBlock(node2.getTryBlock());
        for (JsCatch jsCatch : node2.getCatches()) {
            this.applyToBlock(jsCatch.getBody());
        }
        JsTry jsTry = node2;
        if (jsTry == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/utils/mutator/LastExpressionMutator", "applyToTry"));
        }
        return jsTry;
    }

    @NotNull
    private JsNode applyToBlock(@NotNull JsBlock node2) {
        if (node2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/kotlin/js/translate/utils/mutator/LastExpressionMutator", "applyToBlock"));
        }
        List<JsStatement> statements = node2.getStatements();
        if (statements.isEmpty()) {
            JsBlock jsBlock = node2;
            if (jsBlock == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/utils/mutator/LastExpressionMutator", "applyToBlock"));
            }
            return jsBlock;
        }
        int size = statements.size();
        statements.set(size - 1, JsAstUtils.convertToStatement(this.apply(statements.get(size - 1))));
        JsBlock jsBlock = node2;
        if (jsBlock == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/utils/mutator/LastExpressionMutator", "applyToBlock"));
        }
        return jsBlock;
    }
}

