/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi;

import com.intellij.lang.ASTNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.JetNodeTypes;
import org.jetbrains.kotlin.psi.JetContainerNode;
import org.jetbrains.kotlin.psi.JetExpressionImpl;
import org.jetbrains.kotlin.psi.JetSimpleNameExpression;
import org.jetbrains.kotlin.psi.JetVisitor;

public class JetExpressionWithLabel
extends JetExpressionImpl {
    public JetExpressionWithLabel(@NotNull ASTNode node2) {
        if (node2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/kotlin/psi/JetExpressionWithLabel", "<init>"));
        }
        super(node2);
    }

    @Nullable
    public JetSimpleNameExpression getTargetLabel() {
        JetContainerNode qualifier = (JetContainerNode)this.findChildByType(JetNodeTypes.LABEL_QUALIFIER);
        if (qualifier == null) {
            return null;
        }
        return (JetSimpleNameExpression)qualifier.findChildByType(JetNodeTypes.LABEL);
    }

    @Nullable
    public String getLabelName() {
        JetSimpleNameExpression labelElement = this.getTargetLabel();
        assert (labelElement == null || labelElement.getText().startsWith("@"));
        return labelElement == null ? null : labelElement.getText().substring(1);
    }

    @Override
    public <R, D> R accept(@NotNull JetVisitor<R, D> visitor2, D data2) {
        if (visitor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/jetbrains/kotlin/psi/JetExpressionWithLabel", "accept"));
        }
        return visitor2.visitExpressionWithLabel(this, data2);
    }
}

