/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types.expressions;

import com.google.common.collect.Lists;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.JetNodeTypes;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.impl.VariableDescriptorImpl;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.lexer.JetTokens;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.JetBinaryExpression;
import org.jetbrains.kotlin.psi.JetBinaryExpressionWithTypeRHS;
import org.jetbrains.kotlin.psi.JetConstructorDelegationReferenceExpression;
import org.jetbrains.kotlin.psi.JetElement;
import org.jetbrains.kotlin.psi.JetExpression;
import org.jetbrains.kotlin.psi.JetMultiDeclaration;
import org.jetbrains.kotlin.psi.JetMultiDeclarationEntry;
import org.jetbrains.kotlin.psi.JetPsiUtil;
import org.jetbrains.kotlin.psi.JetReferenceExpression;
import org.jetbrains.kotlin.psi.JetSimpleNameExpression;
import org.jetbrains.kotlin.psi.JetThisExpression;
import org.jetbrains.kotlin.psi.JetTypeReference;
import org.jetbrains.kotlin.psi.JetUnaryExpression;
import org.jetbrains.kotlin.psi.PsiPackage;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.ObservableBindingTrace;
import org.jetbrains.kotlin.resolve.TemporaryBindingTrace;
import org.jetbrains.kotlin.resolve.TraceBasedRedeclarationHandler;
import org.jetbrains.kotlin.resolve.TraceEntryFilter;
import org.jetbrains.kotlin.resolve.calls.CallResolver;
import org.jetbrains.kotlin.resolve.calls.results.OverloadResolutionResults;
import org.jetbrains.kotlin.resolve.calls.util.CallMaker;
import org.jetbrains.kotlin.resolve.dataClassUtils.DataClassUtilsPackage;
import org.jetbrains.kotlin.resolve.scopes.WritableScope;
import org.jetbrains.kotlin.resolve.scopes.WritableScopeImpl;
import org.jetbrains.kotlin.resolve.scopes.receivers.ClassReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.JetType;
import org.jetbrains.kotlin.types.JetTypeInfo;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.checker.JetTypeChecker;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingContext;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingFacade;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingInternals;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingServices;
import org.jetbrains.kotlin.types.expressions.OperatorConventions;
import org.jetbrains.kotlin.util.slicedMap.WritableSlice;

public class ExpressionTypingUtils {
    private final ExpressionTypingServices expressionTypingServices;
    private final CallResolver callResolver;
    private final KotlinBuiltIns builtIns;

    public ExpressionTypingUtils(@NotNull ExpressionTypingServices expressionTypingServices, @NotNull CallResolver resolver2, @NotNull KotlinBuiltIns builtIns) {
        if (expressionTypingServices == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expressionTypingServices", "org/jetbrains/kotlin/types/expressions/ExpressionTypingUtils", "<init>"));
        }
        if (resolver2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolver", "org/jetbrains/kotlin/types/expressions/ExpressionTypingUtils", "<init>"));
        }
        if (builtIns == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builtIns", "org/jetbrains/kotlin/types/expressions/ExpressionTypingUtils", "<init>"));
        }
        this.expressionTypingServices = expressionTypingServices;
        this.callResolver = resolver2;
        this.builtIns = builtIns;
    }

    @NotNull
    public static ReceiverValue normalizeReceiverValueForVisibility(@NotNull ReceiverValue receiverValue, @NotNull BindingContext trace) {
        if (receiverValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiverValue", "org/jetbrains/kotlin/types/expressions/ExpressionTypingUtils", "normalizeReceiverValueForVisibility"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/types/expressions/ExpressionTypingUtils", "normalizeReceiverValueForVisibility"));
        }
        if (receiverValue instanceof ExpressionReceiver) {
            DeclarationDescriptor descriptor;
            JetExpression expression = ((ExpressionReceiver)receiverValue).getExpression();
            JetReferenceExpression referenceExpression = null;
            if (expression instanceof JetThisExpression) {
                referenceExpression = ((JetThisExpression)expression).getInstanceReference();
            } else if (expression instanceof JetConstructorDelegationReferenceExpression) {
                referenceExpression = (JetReferenceExpression)expression;
            }
            if (referenceExpression != null && (descriptor = trace.get(BindingContext.REFERENCE_TARGET, referenceExpression)) instanceof ClassDescriptor) {
                ClassReceiver classReceiver = new ClassReceiver((ClassDescriptor)descriptor.getOriginal());
                if (classReceiver == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/ExpressionTypingUtils", "normalizeReceiverValueForVisibility"));
                }
                return classReceiver;
            }
        }
        ReceiverValue receiverValue2 = receiverValue;
        if (receiverValue2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/ExpressionTypingUtils", "normalizeReceiverValueForVisibility"));
        }
        return receiverValue2;
    }

    @Nullable
    protected static ExpressionReceiver getExpressionReceiver(@NotNull JetExpression expression, @Nullable JetType type2) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/ExpressionTypingUtils", "getExpressionReceiver"));
        }
        if (type2 == null) {
            return null;
        }
        return new ExpressionReceiver(expression, type2);
    }

    @Nullable
    protected static ExpressionReceiver getExpressionReceiver(@NotNull ExpressionTypingFacade facade, @NotNull JetExpression expression, ExpressionTypingContext context2) {
        if (facade == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facade", "org/jetbrains/kotlin/types/expressions/ExpressionTypingUtils", "getExpressionReceiver"));
        }
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/ExpressionTypingUtils", "getExpressionReceiver"));
        }
        return ExpressionTypingUtils.getExpressionReceiver(expression, facade.getTypeInfo(expression, context2).getType());
    }

    @NotNull
    protected static ExpressionReceiver safeGetExpressionReceiver(@NotNull ExpressionTypingFacade facade, @NotNull JetExpression expression, ExpressionTypingContext context2) {
        if (facade == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facade", "org/jetbrains/kotlin/types/expressions/ExpressionTypingUtils", "safeGetExpressionReceiver"));
        }
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/ExpressionTypingUtils", "safeGetExpressionReceiver"));
        }
        JetType type2 = ExpressionTypingUtils.safeGetType(facade.safeGetTypeInfo(expression, context2));
        ExpressionReceiver expressionReceiver = new ExpressionReceiver(expression, type2);
        if (expressionReceiver == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/ExpressionTypingUtils", "safeGetExpressionReceiver"));
        }
        return expressionReceiver;
    }

    @NotNull
    public static JetType safeGetType(@NotNull JetTypeInfo typeInfo) {
        if (typeInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeInfo", "org/jetbrains/kotlin/types/expressions/ExpressionTypingUtils", "safeGetType"));
        }
        JetType type2 = typeInfo.getType();
        assert (type2 != null) : "safeGetType should be invoked on safe JetTypeInfo; safeGetTypeInfo should return @NotNull type";
        JetType jetType = type2;
        if (jetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/ExpressionTypingUtils", "safeGetType"));
        }
        return jetType;
    }

    @NotNull
    public static WritableScopeImpl newWritableScopeImpl(ExpressionTypingContext context2, @NotNull String scopeDebugName) {
        if (scopeDebugName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scopeDebugName", "org/jetbrains/kotlin/types/expressions/ExpressionTypingUtils", "newWritableScopeImpl"));
        }
        WritableScopeImpl scope2 = new WritableScopeImpl(context2.scope, context2.scope.getContainingDeclaration(), new TraceBasedRedeclarationHandler(context2.trace), scopeDebugName);
        scope2.changeLockLevel(WritableScope.LockLevel.BOTH);
        WritableScopeImpl writableScopeImpl = scope2;
        if (writableScopeImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/ExpressionTypingUtils", "newWritableScopeImpl"));
        }
        return writableScopeImpl;
    }

    public boolean ensureBooleanResult(JetExpression operationSign, Name name, JetType resultType, ExpressionTypingContext context2) {
        return this.ensureBooleanResultWithCustomSubject(operationSign, resultType, "'" + name + "'", context2);
    }

    private boolean ensureBooleanResultWithCustomSubject(JetExpression operationSign, JetType resultType, String subjectName, ExpressionTypingContext context2) {
        if (resultType != null && !this.builtIns.isBooleanOrSubtype(resultType)) {
            context2.trace.report(Errors.RESULT_TYPE_MISMATCH.on(operationSign, subjectName, this.builtIns.getBooleanType(), resultType));
            return false;
        }
        return true;
    }

    @NotNull
    public JetType getDefaultType(IElementType constantType) {
        if (constantType == JetNodeTypes.INTEGER_CONSTANT) {
            JetType jetType = this.builtIns.getIntType();
            if (jetType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/ExpressionTypingUtils", "getDefaultType"));
            }
            return jetType;
        }
        if (constantType == JetNodeTypes.FLOAT_CONSTANT) {
            JetType jetType = this.builtIns.getDoubleType();
            if (jetType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/ExpressionTypingUtils", "getDefaultType"));
            }
            return jetType;
        }
        if (constantType == JetNodeTypes.BOOLEAN_CONSTANT) {
            JetType jetType = this.builtIns.getBooleanType();
            if (jetType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/ExpressionTypingUtils", "getDefaultType"));
            }
            return jetType;
        }
        if (constantType == JetNodeTypes.CHARACTER_CONSTANT) {
            JetType jetType = this.builtIns.getCharType();
            if (jetType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/ExpressionTypingUtils", "getDefaultType"));
            }
            return jetType;
        }
        if (constantType == JetNodeTypes.NULL) {
            JetType jetType = this.builtIns.getNullableNothingType();
            if (jetType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/ExpressionTypingUtils", "getDefaultType"));
            }
            return jetType;
        }
        throw new IllegalArgumentException("Unsupported constant type: " + constantType);
    }

    @NotNull
    public OverloadResolutionResults<FunctionDescriptor> resolveFakeCall(@NotNull ExpressionTypingContext context2, @NotNull ReceiverValue receiver, @NotNull Name name, @Nullable JetExpression callElement, JetType ... argumentTypes) {
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/types/expressions/ExpressionTypingUtils", "resolveFakeCall"));
        }
        if (receiver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiver", "org/jetbrains/kotlin/types/expressions/ExpressionTypingUtils", "resolveFakeCall"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/types/expressions/ExpressionTypingUtils", "resolveFakeCall"));
        }
        if (argumentTypes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argumentTypes", "org/jetbrains/kotlin/types/expressions/ExpressionTypingUtils", "resolveFakeCall"));
        }
        TemporaryBindingTrace traceWithFakeArgumentInfo = TemporaryBindingTrace.create(context2.trace, "trace to store fake argument for", name);
        ArrayList<JetExpression> fakeArguments = Lists.newArrayList();
        for (JetType type2 : argumentTypes) {
            fakeArguments.add(ExpressionTypingUtils.createFakeExpressionOfType(this.expressionTypingServices.getProject(), traceWithFakeArgumentInfo, "fakeArgument" + fakeArguments.size(), type2));
        }
        OverloadResolutionResults<FunctionDescriptor> overloadResolutionResults = this.makeAndResolveFakeCall(receiver, (ExpressionTypingContext)context2.replaceBindingTrace(traceWithFakeArgumentInfo), fakeArguments, name, callElement).getSecond();
        if (overloadResolutionResults == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/ExpressionTypingUtils", "resolveFakeCall"));
        }
        return overloadResolutionResults;
    }

    public static JetExpression createFakeExpressionOfType(@NotNull Project project, @NotNull BindingTrace trace, @NotNull String argumentName, @NotNull JetType argumentType) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/types/expressions/ExpressionTypingUtils", "createFakeExpressionOfType"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/types/expressions/ExpressionTypingUtils", "createFakeExpressionOfType"));
        }
        if (argumentName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argumentName", "org/jetbrains/kotlin/types/expressions/ExpressionTypingUtils", "createFakeExpressionOfType"));
        }
        if (argumentType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argumentType", "org/jetbrains/kotlin/types/expressions/ExpressionTypingUtils", "createFakeExpressionOfType"));
        }
        JetExpression fakeExpression = PsiPackage.JetPsiFactory(project).createExpression(argumentName);
        trace.record(BindingContext.EXPRESSION_TYPE, fakeExpression, argumentType);
        trace.record(BindingContext.PROCESSED, fakeExpression);
        return fakeExpression;
    }

    @NotNull
    public OverloadResolutionResults<FunctionDescriptor> resolveFakeCall(@NotNull ExpressionTypingContext context2, @NotNull ReceiverValue receiver, @NotNull Name name, @NotNull JetExpression callElement) {
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/types/expressions/ExpressionTypingUtils", "resolveFakeCall"));
        }
        if (receiver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiver", "org/jetbrains/kotlin/types/expressions/ExpressionTypingUtils", "resolveFakeCall"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/types/expressions/ExpressionTypingUtils", "resolveFakeCall"));
        }
        if (callElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callElement", "org/jetbrains/kotlin/types/expressions/ExpressionTypingUtils", "resolveFakeCall"));
        }
        OverloadResolutionResults<FunctionDescriptor> overloadResolutionResults = this.resolveFakeCall(receiver, context2, Collections.<JetExpression>emptyList(), name, callElement);
        if (overloadResolutionResults == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/ExpressionTypingUtils", "resolveFakeCall"));
        }
        return overloadResolutionResults;
    }

    @NotNull
    public OverloadResolutionResults<FunctionDescriptor> resolveFakeCall(@NotNull ReceiverValue receiver, @NotNull ExpressionTypingContext context2, @NotNull List<JetExpression> valueArguments2, @NotNull Name name, @NotNull JetExpression callElement) {
        if (receiver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiver", "org/jetbrains/kotlin/types/expressions/ExpressionTypingUtils", "resolveFakeCall"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/types/expressions/ExpressionTypingUtils", "resolveFakeCall"));
        }
        if (valueArguments2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueArguments", "org/jetbrains/kotlin/types/expressions/ExpressionTypingUtils", "resolveFakeCall"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/types/expressions/ExpressionTypingUtils", "resolveFakeCall"));
        }
        if (callElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callElement", "org/jetbrains/kotlin/types/expressions/ExpressionTypingUtils", "resolveFakeCall"));
        }
        OverloadResolutionResults<FunctionDescriptor> overloadResolutionResults = this.makeAndResolveFakeCall(receiver, context2, valueArguments2, name, callElement).getSecond();
        if (overloadResolutionResults == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/ExpressionTypingUtils", "resolveFakeCall"));
        }
        return overloadResolutionResults;
    }

    @NotNull
    public Pair<Call, OverloadResolutionResults<FunctionDescriptor>> makeAndResolveFakeCall(@NotNull ReceiverValue receiver, @NotNull ExpressionTypingContext context2, @NotNull List<JetExpression> valueArguments2, @NotNull Name name, @Nullable JetExpression callElement) {
        if (receiver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiver", "org/jetbrains/kotlin/types/expressions/ExpressionTypingUtils", "makeAndResolveFakeCall"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/types/expressions/ExpressionTypingUtils", "makeAndResolveFakeCall"));
        }
        if (valueArguments2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueArguments", "org/jetbrains/kotlin/types/expressions/ExpressionTypingUtils", "makeAndResolveFakeCall"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/types/expressions/ExpressionTypingUtils", "makeAndResolveFakeCall"));
        }
        final JetSimpleNameExpression fake = PsiPackage.JetPsiFactory(this.expressionTypingServices.getProject()).createSimpleName("fake");
        TemporaryBindingTrace fakeTrace = TemporaryBindingTrace.create(context2.trace, "trace to resolve fake call for", name);
        Call call = CallMaker.makeCallWithExpressions(callElement != null ? callElement : fake, receiver, null, fake, valueArguments2);
        OverloadResolutionResults<FunctionDescriptor> results = this.callResolver.resolveCallWithGivenName((ExpressionTypingContext)context2.replaceBindingTrace(fakeTrace), call, fake, name);
        if (results.isSuccess()) {
            fakeTrace.commit(new TraceEntryFilter(){

                @Override
                public boolean accept(@Nullable WritableSlice<?, ?> slice, Object key) {
                    return key != fake;
                }
            }, true);
        }
        Pair<Call, OverloadResolutionResults<FunctionDescriptor>> pair = Pair.create(call, results);
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/ExpressionTypingUtils", "makeAndResolveFakeCall"));
        }
        return pair;
    }

    public void defineLocalVariablesFromMultiDeclaration(@NotNull WritableScope writableScope, @NotNull JetMultiDeclaration multiDeclaration, @NotNull ReceiverValue receiver, @NotNull JetExpression reportErrorsOn, @NotNull ExpressionTypingContext context2) {
        if (writableScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "writableScope", "org/jetbrains/kotlin/types/expressions/ExpressionTypingUtils", "defineLocalVariablesFromMultiDeclaration"));
        }
        if (multiDeclaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "multiDeclaration", "org/jetbrains/kotlin/types/expressions/ExpressionTypingUtils", "defineLocalVariablesFromMultiDeclaration"));
        }
        if (receiver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiver", "org/jetbrains/kotlin/types/expressions/ExpressionTypingUtils", "defineLocalVariablesFromMultiDeclaration"));
        }
        if (reportErrorsOn == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reportErrorsOn", "org/jetbrains/kotlin/types/expressions/ExpressionTypingUtils", "defineLocalVariablesFromMultiDeclaration"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/types/expressions/ExpressionTypingUtils", "defineLocalVariablesFromMultiDeclaration"));
        }
        int componentIndex = 1;
        for (JetMultiDeclarationEntry entry : multiDeclaration.getEntries()) {
            Name componentName = DataClassUtilsPackage.createComponentName(componentIndex);
            ++componentIndex;
            JetType expectedType = this.getExpectedTypeForComponent(context2, entry);
            OverloadResolutionResults<FunctionDescriptor> results = this.resolveFakeCall((ExpressionTypingContext)context2.replaceExpectedType(expectedType), receiver, componentName, entry);
            JetType componentType = null;
            if (results.isSuccess()) {
                context2.trace.record(BindingContext.COMPONENT_RESOLVED_CALL, entry, results.getResultingCall());
                componentType = results.getResultingDescriptor().getReturnType();
                if (componentType != null && !TypeUtils.noExpectedType(expectedType) && !JetTypeChecker.DEFAULT.isSubtypeOf(componentType, expectedType)) {
                    context2.trace.report(Errors.COMPONENT_FUNCTION_RETURN_TYPE_MISMATCH.on(reportErrorsOn, componentName, componentType, expectedType));
                }
            } else if (results.isAmbiguity()) {
                context2.trace.report(Errors.COMPONENT_FUNCTION_AMBIGUITY.on(reportErrorsOn, componentName, results.getResultingCalls()));
            } else {
                context2.trace.report(Errors.COMPONENT_FUNCTION_MISSING.on(reportErrorsOn, componentName, receiver.getType()));
            }
            if (componentType == null) {
                componentType = ErrorUtils.createErrorType(componentName + "() return type");
            }
            VariableDescriptorImpl variableDescriptor = this.expressionTypingServices.getDescriptorResolver().resolveLocalVariableDescriptorWithType(writableScope, entry, componentType, context2.trace);
            VariableDescriptor olderVariable = writableScope.getLocalVariable(variableDescriptor.getName());
            ExpressionTypingUtils.checkVariableShadowing(context2, variableDescriptor, olderVariable);
            writableScope.addVariableDescriptor(variableDescriptor);
        }
    }

    public static void checkVariableShadowing(@NotNull ExpressionTypingContext context2, @NotNull VariableDescriptor variableDescriptor, VariableDescriptor oldDescriptor) {
        PsiElement declaration;
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/types/expressions/ExpressionTypingUtils", "checkVariableShadowing"));
        }
        if (variableDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variableDescriptor", "org/jetbrains/kotlin/types/expressions/ExpressionTypingUtils", "checkVariableShadowing"));
        }
        if (oldDescriptor != null && ExpressionTypingUtils.isLocal(variableDescriptor.getContainingDeclaration(), oldDescriptor) && (declaration = DescriptorToSourceUtils.descriptorToDeclaration(variableDescriptor)) != null) {
            context2.trace.report(Errors.NAME_SHADOWING.on(declaration, variableDescriptor.getName().asString()));
        }
    }

    @NotNull
    private JetType getExpectedTypeForComponent(ExpressionTypingContext context2, JetMultiDeclarationEntry entry) {
        JetTypeReference entryTypeRef = entry.getTypeReference();
        if (entryTypeRef != null) {
            JetType jetType = this.expressionTypingServices.getTypeResolver().resolveType(context2.scope, entryTypeRef, context2.trace, true);
            if (jetType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/ExpressionTypingUtils", "getExpectedTypeForComponent"));
            }
            return jetType;
        }
        JetType jetType = TypeUtils.NO_EXPECTED_TYPE;
        if (jetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/ExpressionTypingUtils", "getExpectedTypeForComponent"));
        }
        return jetType;
    }

    public static ObservableBindingTrace makeTraceInterceptingTypeMismatch(@NotNull BindingTrace trace, final @NotNull JetElement expressionToWatch, final @NotNull boolean[] mismatchFound) {
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/types/expressions/ExpressionTypingUtils", "makeTraceInterceptingTypeMismatch"));
        }
        if (expressionToWatch == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expressionToWatch", "org/jetbrains/kotlin/types/expressions/ExpressionTypingUtils", "makeTraceInterceptingTypeMismatch"));
        }
        if (mismatchFound == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mismatchFound", "org/jetbrains/kotlin/types/expressions/ExpressionTypingUtils", "makeTraceInterceptingTypeMismatch"));
        }
        return new ObservableBindingTrace(trace){

            @Override
            public void report(@NotNull Diagnostic diagnostic) {
                if (diagnostic == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "diagnostic", "org/jetbrains/kotlin/types/expressions/ExpressionTypingUtils$2", "report"));
                }
                DiagnosticFactory<?> factory = diagnostic.getFactory();
                if ((factory == Errors.TYPE_MISMATCH || factory == Errors.CONSTANT_EXPECTED_TYPE_MISMATCH || factory == Errors.NULL_FOR_NONNULL_TYPE) && diagnostic.getPsiElement() == expressionToWatch) {
                    mismatchFound[0] = true;
                }
                if (Errors.TYPE_INFERENCE_ERRORS.contains(factory) && PsiTreeUtil.isAncestor(expressionToWatch, diagnostic.getPsiElement(), false)) {
                    mismatchFound[0] = true;
                }
                super.report(diagnostic);
            }
        };
    }

    @NotNull
    public static JetTypeInfo getTypeInfoOrNullType(@Nullable JetExpression expression, @NotNull ExpressionTypingContext context2, @NotNull ExpressionTypingInternals facade) {
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/types/expressions/ExpressionTypingUtils", "getTypeInfoOrNullType"));
        }
        if (facade == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facade", "org/jetbrains/kotlin/types/expressions/ExpressionTypingUtils", "getTypeInfoOrNullType"));
        }
        JetTypeInfo jetTypeInfo = expression != null ? facade.getTypeInfo(expression, context2) : JetTypeInfo.create(null, context2.dataFlowInfo);
        if (jetTypeInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/ExpressionTypingUtils", "getTypeInfoOrNullType"));
        }
        return jetTypeInfo;
    }

    public static boolean isBinaryExpressionDependentOnExpectedType(@NotNull JetBinaryExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/ExpressionTypingUtils", "isBinaryExpressionDependentOnExpectedType"));
        }
        IElementType operationType = expression.getOperationReference().getReferencedNameElementType();
        return operationType == JetTokens.IDENTIFIER || OperatorConventions.BINARY_OPERATION_NAMES.containsKey(operationType) || operationType == JetTokens.ELVIS;
    }

    public static boolean isUnaryExpressionDependentOnExpectedType(@NotNull JetUnaryExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/ExpressionTypingUtils", "isUnaryExpressionDependentOnExpectedType"));
        }
        return expression.getOperationReference().getReferencedNameElementType() == JetTokens.EXCLEXCL;
    }

    @NotNull
    public static List<JetType> getValueParametersTypes(@NotNull List<ValueParameterDescriptor> valueParameters) {
        if (valueParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueParameters", "org/jetbrains/kotlin/types/expressions/ExpressionTypingUtils", "getValueParametersTypes"));
        }
        ArrayList<JetType> parameterTypes = new ArrayList<JetType>(valueParameters.size());
        for (ValueParameterDescriptor parameter : valueParameters) {
            parameterTypes.add(parameter.getType());
        }
        ArrayList<JetType> arrayList = parameterTypes;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/ExpressionTypingUtils", "getValueParametersTypes"));
        }
        return arrayList;
    }

    public static boolean isLocal(DeclarationDescriptor containerOfTheCurrentLocality, DeclarationDescriptor candidate) {
        if (candidate instanceof ValueParameterDescriptor) {
            return true;
        }
        DeclarationDescriptor parent = candidate.getContainingDeclaration();
        if (!(parent instanceof FunctionDescriptor)) {
            return false;
        }
        FunctionDescriptor functionDescriptor = (FunctionDescriptor)parent;
        for (DeclarationDescriptor current = containerOfTheCurrentLocality; current != null; current = current.getContainingDeclaration()) {
            if (current != functionDescriptor) continue;
            return true;
        }
        return false;
    }

    public static boolean dependsOnExpectedType(@Nullable JetExpression expression) {
        JetExpression expr = JetPsiUtil.deparenthesize(expression, false);
        if (expr == null) {
            return false;
        }
        if (expr instanceof JetBinaryExpressionWithTypeRHS) {
            return false;
        }
        if (expr instanceof JetBinaryExpression) {
            return ExpressionTypingUtils.isBinaryExpressionDependentOnExpectedType((JetBinaryExpression)expr);
        }
        if (expr instanceof JetUnaryExpression) {
            return ExpressionTypingUtils.isUnaryExpressionDependentOnExpectedType((JetUnaryExpression)expr);
        }
        return true;
    }
}

