/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.util.slicedMap;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.util.slicedMap.DelegatingSlice;
import org.jetbrains.kotlin.util.slicedMap.MutableSlicedMap;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;
import org.jetbrains.kotlin.util.slicedMap.RewritePolicy;
import org.jetbrains.kotlin.util.slicedMap.SlicedMap;
import org.jetbrains.kotlin.util.slicedMap.SlicedMapKey;
import org.jetbrains.kotlin.util.slicedMap.WritableSlice;

public class BasicWritableSlice<K, V>
implements WritableSlice<K, V> {
    private String debugName;
    private final RewritePolicy rewritePolicy;
    private final boolean isCollective;

    public static Void initSliceDebugNames(Class<?> declarationOwner) {
        for (Field field : declarationOwner.getFields()) {
            if (!Modifier.isStatic(field.getModifiers())) continue;
            try {
                Object value = field.get(null);
                if (!(value instanceof BasicWritableSlice)) continue;
                BasicWritableSlice slice = (BasicWritableSlice)value;
                slice.debugName = field.getName();
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException(e);
            }
        }
        return null;
    }

    public BasicWritableSlice(RewritePolicy rewritePolicy) {
        this(rewritePolicy, false);
    }

    public BasicWritableSlice(RewritePolicy rewritePolicy, boolean isCollective) {
        this.rewritePolicy = rewritePolicy;
        this.isCollective = isCollective;
    }

    @Override
    public SlicedMapKey<K, V> makeKey(K key) {
        return new SlicedMapKey(this, key);
    }

    @Override
    public boolean check(K key, V value) {
        assert (value != null) : this + " called with null value";
        return true;
    }

    @Override
    public void afterPut(MutableSlicedMap map, K key, V value) {
    }

    @Override
    public V computeValue(SlicedMap map, K key, V value, boolean valueNotFound) {
        if (valueNotFound) assert (value == null);
        return value;
    }

    @Override
    public RewritePolicy getRewritePolicy() {
        return this.rewritePolicy;
    }

    @Override
    public boolean isCollective() {
        return this.isCollective;
    }

    public void setDebugName(@NotNull String debugName) {
        if (debugName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugName", "org/jetbrains/kotlin/util/slicedMap/BasicWritableSlice", "setDebugName"));
        }
        if (this.debugName != null) {
            throw new IllegalStateException("Debug name already set for " + this);
        }
        this.debugName = debugName;
    }

    public String toString() {
        return this.debugName;
    }

    @Override
    public ReadOnlySlice<K, V> makeRawValueVersion() {
        return new DelegatingSlice<K, V>(this){

            @Override
            public V computeValue(SlicedMap map, K key, V value, boolean valueNotFound) {
                if (valueNotFound) assert (value == null);
                return value;
            }
        };
    }
}

