/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.compiler.backend.js;

import com.google.dart.compiler.backend.js.ast.JsEmpty;
import com.google.dart.compiler.backend.js.ast.JsFor;
import com.google.dart.compiler.backend.js.ast.JsForIn;
import com.google.dart.compiler.backend.js.ast.JsIf;
import com.google.dart.compiler.backend.js.ast.JsLabel;
import com.google.dart.compiler.backend.js.ast.JsStatement;
import com.google.dart.compiler.backend.js.ast.JsVisitor;
import com.google.dart.compiler.backend.js.ast.JsWhile;

public class JsRequiresSemiVisitor
extends JsVisitor {
    private boolean needsSemicolon;

    private JsRequiresSemiVisitor() {
    }

    public static boolean exec(JsStatement lastStatement) {
        JsRequiresSemiVisitor visitor2 = new JsRequiresSemiVisitor();
        visitor2.accept(lastStatement);
        return visitor2.needsSemicolon;
    }

    @Override
    public void visitFor(JsFor x) {
        if (x.getBody() instanceof JsEmpty) {
            this.needsSemicolon = true;
        }
    }

    @Override
    public void visitForIn(JsForIn x) {
        if (x.getBody() instanceof JsEmpty) {
            this.needsSemicolon = true;
        }
    }

    @Override
    public void visitIf(JsIf x) {
        JsStatement thenStmt = x.getThenStatement();
        JsStatement elseStmt = x.getElseStatement();
        JsStatement toCheck = thenStmt;
        if (elseStmt != null) {
            toCheck = elseStmt;
        }
        if (toCheck instanceof JsEmpty) {
            this.needsSemicolon = true;
        } else {
            this.accept(toCheck);
        }
    }

    @Override
    public void visitLabel(JsLabel x) {
        if (x.getStatement() instanceof JsEmpty) {
            this.needsSemicolon = true;
        }
    }

    @Override
    public void visitWhile(JsWhile x) {
        if (x.getBody() instanceof JsEmpty) {
            this.needsSemicolon = true;
        }
    }
}

